/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.restaurant.gui.reports;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import jxl.write.Label;
import jxl.write.Number;
import jxl.write.WritableCell;
import jxl.write.WritableSheet;
import jxl.write.WriteException;
import jxl.write.biff.RowsExceededException;
import ro.atreides.nomenclatura.Sectie;
import ro.atreides.print.PrintLogic;
import ro.atreides.restaurant.base.reports.IncasariEntry;
import ro.atreides.restaurant.logic.RestLogic;
import ro.atreides.users.User;
import ro.atreides.utils.Logger;
import ro.atreides.utils.Utils;
import ro.atreides.utils.excel.ExcelProcessor;
import ro.atreides.utils.excel.ExcelUtils;
import ro.atreides.utils.gui.ComboUtils;
import ro.atreides.utils.gui.DateSelectorInterface;
import ro.atreides.utils.gui.ReportInterface;
import ro.atreides.utils.gui.table.AbstractTM;
import ro.atreides.utils.gui.table.TmInterface;
import ro.atreides.utils.multilang.LangRoAll;
import ro.atreides.utils.reports.AbstractReportPanel;

public class IncasariReport
extends AbstractReportPanel {
    private JLabel _incomesTotalLabel;
    private JLabel _waitersLabel;
    private JComboBox _waitersComboBox;
    private ReportInterface pdfReportInterface;
    private ReportInterface asciiReportInterface;
    private Hashtable printCriteria = new Hashtable();
    private static final String[] columns = new String[]{LangRoAll.operator, LangRoAll.sectie, LangRoAll.produs, LangRoAll.cantitate, LangRoAll.valUnitara, LangRoAll.valTotala, LangRoAll.promotie};
    private static final Class[] types = new Class[]{String.class, String.class, String.class, String.class, String.class, String.class, String.class};
    private static Comparator waiter_sorter = new Comparator(){

        public int compare(Object o1, Object o2) {
            String c1 = ((IncasariEntry)o1).getWaiter();
            String c2 = ((IncasariEntry)o2).getWaiter();
            return c1.compareTo(c2);
        }
    };
    private static Comparator product_sorter = new Comparator(){

        public int compare(Object o1, Object o2) {
            String c1 = ((IncasariEntry)o1).getProduct();
            String c2 = ((IncasariEntry)o2).getProduct();
            return c1.compareTo(c2);
        }
    };
    private static Comparator category_sorter = new Comparator(){

        public int compare(Object o1, Object o2) {
            String c1 = ((IncasariEntry)o1).getCategory();
            String c2 = ((IncasariEntry)o2).getCategory();
            return c1.compareTo(c2);
        }
    };
    private static Comparator quantity_sorter = new Comparator(){

        public int compare(Object o1, Object o2) {
            Double c1 = new Double(((IncasariEntry)o1).getQuantity());
            Double c2 = new Double(((IncasariEntry)o2).getQuantity());
            return c1.compareTo(c2);
        }
    };
    private static Comparator ppu_sorter = new Comparator(){

        public int compare(Object o1, Object o2) {
            Double c1 = new Double(((IncasariEntry)o1).getPpu());
            Double c2 = new Double(((IncasariEntry)o2).getPpu());
            return c1.compareTo(c2);
        }
    };
    private static Comparator totalvalue_sorter = new Comparator(){

        public int compare(Object o1, Object o2) {
            Double c1 = new Double(((IncasariEntry)o1).getTotal());
            Double c2 = new Double(((IncasariEntry)o2).getTotal());
            return c1.compareTo(c2);
        }
    };

    @Override
    public Hashtable buildCriteria(Date startDate, Date stopDate) {
        Hashtable<String, String> result = new Hashtable<String, String>();
        if (ComboUtils.anythingButAllSelected(this._waitersComboBox)) {
            User u = (User)this._waitersComboBox.getSelectedItem();
            result.put(LangRoAll.operator, u.getLogin());
            this.printCriteria.put(LangRoAll.operator, u.getLogin());
        } else {
            this.printCriteria.remove(LangRoAll.operator);
        }
        return result;
    }

    @Override
    public void printPreview() {
        String pdfFile = PrintLogic.getInstance().buildReportPdfText(this.data, this.pdfReportInterface);
        PrintLogic.getInstance().printPreview(pdfFile);
    }

    @Override
    public void printReport() {
        PrintLogic.getInstance().printReport(this, this.pdfReportInterface, this.asciiReportInterface, this.data);
    }

    @Override
    public Vector getResult(Hashtable criteria) {
        return RestLogic.getInstance().getIncasariReport(criteria, this.whatToPrint);
    }

    @Override
    public void writeExcel(File reportFile) {
        try {
            ExcelUtils.writeExcel(reportFile, this.data, new ExcelProcessor(){

                @Override
                public String[] getColumns() {
                    return new String[]{LangRoAll.operator, LangRoAll.sectie, LangRoAll.produs, LangRoAll.cantitate, LangRoAll.pret, LangRoAll.total, LangRoAll.promotie};
                }

                @Override
                public String getSheetName() {
                    return LangRoAll.incasari;
                }

                @Override
                public void processLine(Object o, WritableSheet sheet, int row) {
                    try {
                        IncasariEntry ie = (IncasariEntry)o;
                        Label waiter = new Label(0, row, ie.getWaiter());
                        sheet.addCell((WritableCell)waiter);
                        Label sectie = new Label(1, row, ie.getCategory());
                        sheet.addCell((WritableCell)sectie);
                        Label prod = new Label(2, row, ie.getProduct());
                        sheet.addCell((WritableCell)prod);
                        Number quantity = new Number(3, row, ie.getQuantity());
                        sheet.addCell((WritableCell)quantity);
                        Number valUnit = new Number(4, row, ie.getPpu());
                        sheet.addCell((WritableCell)valUnit);
                        Number totVal = new Number(5, row, ie.getTotal());
                        sheet.addCell((WritableCell)totVal);
                        Label promo = new Label(6, row, ie.getPromotion());
                        sheet.addCell((WritableCell)promo);
                    }
                    catch (RowsExceededException e) {
                        Logger.logException(this, (Exception)((Object)e));
                    }
                    catch (WriteException e) {
                        Logger.logException(this, (Exception)((Object)e));
                    }
                }

                @Override
                public int buildHeader(WritableSheet sheet, int startRow) {
                    return 0;
                }

                @Override
                public void buildTotal(WritableSheet sheet, int row, int firstTableRow, int lastTableRow) {
                }
            }, this.printCriteria);
        }
        catch (WriteException e2) {
            Logger.logException(this, (Exception)((Object)e2));
        }
        catch (IOException e) {
            Logger.logException(this, (Exception)e);
        }
    }

    @Override
    public String getName() {
        return LangRoAll.incasari;
    }

    @Override
    public AbstractTM buildTableModel() {
        AbstractTM model = new AbstractTM(columns, types, new TmInterface(){

            @Override
            public void setValueAt(Object aValue, int rowIndex, int columnIndex, Vector data) {
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return false;
            }

            @Override
            public Object getValueAt(int rowIndex, int columnIndex, Vector data) {
                IncasariEntry ie = (IncasariEntry)data.elementAt(rowIndex);
                if (ie == null) {
                    return null;
                }
                switch (columnIndex) {
                    case 0: {
                        return ie.getWaiter();
                    }
                    case 1: {
                        return ie.getCategory();
                    }
                    case 2: {
                        return ie.getProduct();
                    }
                    case 3: {
                        return Utils.getString3Decimals(ie.getQuantity());
                    }
                    case 4: {
                        return Utils.getString2Decimals(ie.getPpu());
                    }
                    case 5: {
                        return Utils.getString2Decimals(ie.getTotal());
                    }
                    case 6: {
                        return ie.getPromotion();
                    }
                }
                return null;
            }
        });
        return model;
    }

    @Override
    public JPanel buildTotalPanel() {
        JPanel result = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.gridheight = 1;
        c.gridwidth = 1;
        c.fill = 0;
        c.anchor = 17;
        c.insets = new Insets(0, 0, 0, 0);
        c.gridx = 0;
        c.gridy = 0;
        this._incomesTotalLabel = new JLabel(LangRoAll.total);
        result.add((Component)this._incomesTotalLabel, c);
        return result;
    }

    @Override
    public JPanel buildCustomParamsPanel() {
        JPanel result = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.gridheight = 1;
        c.gridwidth = 1;
        c.anchor = 17;
        c.fill = 2;
        c.insets = new Insets(0, 0, 0, 0);
        c.gridx = 0;
        c.gridy = 0;
        this._waitersLabel = new JLabel(LangRoAll.operator);
        result.add((Component)this._waitersLabel, c);
        ++c.gridx;
        c.insets = new Insets(0, 0, 0, 0);
        this._waitersComboBox = new JComboBox();
        result.add((Component)this._waitersComboBox, c);
        return result;
    }

    @Override
    public void refreshTotalPanel() {
        String newTotal = LangRoAll.total + " " + Utils.getString2Decimals(this.getTotalValue(this.data)) + LangRoAll.dinCare;
        String[][] details = this.getDetails();
        for (int i = 0; i < details[0].length; ++i) {
            newTotal = newTotal + details[0][i] + "=" + details[1][i] + " ";
        }
        this._incomesTotalLabel.setText(newTotal);
    }

    @Override
    public void doStuff() {
        Vector waiters = RestLogic.getInstance().getWaiters();
        ComboUtils.replaceItemsForCombo(this._waitersComboBox, waiters);
        this.pdfReportInterface = new ReportInterface(){

            @Override
            public int getColumnCount() {
                return columns.length;
            }

            @Override
            public int getColumnSize(int column) {
                switch (column) {
                    case 0: {
                        return 1;
                    }
                    case 1: {
                        return 1;
                    }
                    case 2: {
                        return 4;
                    }
                    case 3: {
                        return 1;
                    }
                    case 4: {
                        return 1;
                    }
                    case 5: {
                        return 1;
                    }
                    case 6: {
                        return 1;
                    }
                }
                return 1;
            }

            @Override
            public String getColumnName(int column) {
                return columns[column];
            }

            @Override
            public String getTotal(int column) {
                switch (column) {
                    case 0: {
                        return LangRoAll.total;
                    }
                    case 5: {
                        return Utils.getString2Decimals(IncasariReport.this.getTotalValue(IncasariReport.this.data));
                    }
                }
                return "";
            }

            @Override
            public String getReportTitle() {
                return IncasariReport.this.getName();
            }

            @Override
            public Hashtable getCriteria() {
                return IncasariReport.this.printCriteria;
            }

            @Override
            public boolean isLandscape() {
                return false;
            }

            @Override
            public String getCellContent(Object row, int column) {
                IncasariEntry ie = (IncasariEntry)row;
                if (ie == null) {
                    return null;
                }
                switch (column) {
                    case 0: {
                        return ie.getWaiter();
                    }
                    case 1: {
                        return ie.getCategory();
                    }
                    case 2: {
                        return ie.getProduct();
                    }
                    case 3: {
                        return Utils.getString3Decimals(ie.getQuantity());
                    }
                    case 4: {
                        return Utils.getString2Decimals(ie.getPpu());
                    }
                    case 5: {
                        return Utils.getString2Decimals(ie.getTotal());
                    }
                    case 6: {
                        return ie.getPromotion();
                    }
                }
                return null;
            }
        };
        this.asciiReportInterface = new ReportInterface(){

            @Override
            public int getColumnCount() {
                return 1;
            }

            @Override
            public int getColumnSize(int column) {
                return 1;
            }

            @Override
            public String getColumnName(int column) {
                switch (column) {
                    case 0: {
                        return LangRoAll.produs + "|" + LangRoAll.cantitate + "|" + LangRoAll.valoare;
                    }
                }
                return null;
            }

            @Override
            public String getTotal(int column) {
                if (column == 0) {
                    double totalValue = IncasariReport.this.getTotalValue(IncasariReport.this.data);
                    String[][] details = IncasariReport.this.getDetails();
                    String s = "";
                    for (int i = 0; i < details[0].length; ++i) {
                        s = s + details[0][i] + " " + details[1][i] + "\n";
                    }
                    s = s + "\n";
                    s = s + LangRoAll.total + " " + Utils.getString2Decimals(totalValue);
                    return s;
                }
                return "";
            }

            @Override
            public String getReportTitle() {
                return IncasariReport.this.getName();
            }

            @Override
            public Hashtable getCriteria() {
                return IncasariReport.this.printCriteria;
            }

            @Override
            public boolean isLandscape() {
                return false;
            }

            @Override
            public String getCellContent(Object row, int column) {
                if (column == 0) {
                    IncasariEntry se = (IncasariEntry)row;
                    String product = se.getProduct();
                    double quantity = se.getQuantity();
                    String total = Utils.getString2Decimals(se.getTotal());
                    return product + "|" + Utils.getString3Decimals(quantity) + "|" + total;
                }
                return "";
            }
        };
    }

    @Override
    public Comparator getComparatorForColumn(int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return waiter_sorter;
            }
            case 1: {
                return category_sorter;
            }
            case 2: {
                return product_sorter;
            }
            case 3: {
                return quantity_sorter;
            }
            case 4: {
                return ppu_sorter;
            }
            case 5: {
                return totalvalue_sorter;
            }
        }
        return null;
    }

    public String[][] getDetails() {
        RestLogic logic = RestLogic.getInstance();
        Vector categories = logic.getSectii();
        String[][] result = new String[2][categories.size()];
        int i = 0;
        for (Sectie cat : categories) {
            String catString = cat.getName();
            Collection items = this.getItemsForCategory(cat);
            result[0][i] = catString;
            result[1][i] = Utils.getString2Decimals(this.getTotalValue(items));
            ++i;
        }
        return result;
    }

    private double getTotalValue(Collection items) {
        double totalValue = 0.0;
        Iterator i = items.iterator();
        while (i.hasNext()) {
            totalValue += ((IncasariEntry)i.next()).getTotal();
        }
        return totalValue;
    }

    private Collection getItemsForCategory(Sectie cat) {
        Vector<IncasariEntry> result = new Vector<IncasariEntry>();
        for (IncasariEntry element : this.data) {
            if (!element.getCategory().equals(cat.getName())) continue;
            result.add(element);
        }
        return result;
    }

    @Override
    public DateSelectorInterface getDateSelector() {
        return null;
    }
}

