/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.restaurant.gui.reports;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.io.File;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import ro.atreides.nomenclatura.Sectie;
import ro.atreides.print.PrintLogic;
import ro.atreides.restaurant.logic.RestLogic;
import ro.atreides.users.User;
import ro.atreides.utils.Constants;
import ro.atreides.utils.Formatters;
import ro.atreides.utils.Shift;
import ro.atreides.utils.Utils;
import ro.atreides.utils.gui.ComboUtils;
import ro.atreides.utils.gui.DateSelectorInterface;
import ro.atreides.utils.gui.GuiUtils;
import ro.atreides.utils.gui.dialogs.DialogUtils;
import ro.atreides.utils.gui.table.AbstractTM;
import ro.atreides.utils.gui.table.TmInterface;
import ro.atreides.utils.multilang.LangRoAll;
import ro.atreides.utils.reports.AbstractReportPanel;

public class RaportOperatiuni
extends AbstractReportPanel {
    public static final String[] columns = new String[]{Utils.getTranslation(LangRoAll.activitate, new String[0])};
    private JLabel _categoryLabel;
    private JComboBox _categoryComboBox;
    private JComboBox waiters;
    private Hashtable printCriteria = new Hashtable();

    @Override
    public Hashtable buildCriteria(Date startDate, Date stopDate) {
        Hashtable<String, Object> result = new Hashtable<String, Object>();
        Vector<Shift> shifts = RestLogic.getInstance().getShifts();
        Shift lastShift = shifts.lastElement();
        startDate = lastShift.getStart();
        stopDate = lastShift.getStop();
        result.put(Constants.START_KEY, startDate);
        result.put(Constants.STOP_KEY, stopDate);
        this.printCriteria.put(LangRoAll.start, Formatters.DATE_AND_TIME_AND_SECONDS_HUMAN_FORMAT.format(startDate));
        this.printCriteria.put(LangRoAll.stop, Formatters.DATE_AND_TIME_AND_SECONDS_HUMAN_FORMAT.format(stopDate));
        Sectie cat = (Sectie)this._categoryComboBox.getSelectedItem();
        result.put(Constants.SECTIE_KEY, cat);
        this.printCriteria.put(Constants.SECTIE_KEY, cat.getName());
        Object waiter = this.waiters.getSelectedItem();
        if (waiter instanceof User) {
            result.put("user_fo", waiter);
            this.printCriteria.put(Constants.WAITER_KEY, waiter);
        } else {
            this.printCriteria.remove(Constants.WAITER_KEY);
        }
        return result;
    }

    @Override
    public DateSelectorInterface getDateSelector() {
        return null;
    }

    @Override
    public void printReport() {
        PrintLogic.getInstance().print2ColumnText(this.data, 1);
    }

    @Override
    public void printPreview() {
        String pdfFile = PrintLogic.getInstance().preparePrint2ColumnText(this.data);
        PrintLogic.getInstance().printPreview(pdfFile);
    }

    @Override
    public Vector getResult(Hashtable criteria) {
        return RestLogic.getInstance().getRaportActivitate(criteria);
    }

    @Override
    public void writeExcel(File reportFile) {
        DialogUtils.errorDialog(GuiUtils.currentFrame, Utils.getTranslation(LangRoAll.functieNeimplementata), LangRoAll.nuPotContinua);
    }

    @Override
    public String getName() {
        return Utils.getTranslation(LangRoAll.raportOperatiuni, new String[0]);
    }

    @Override
    public AbstractTM buildTableModel() {
        this.tm = new AbstractTM(columns, Utils.getStringClass(columns.length), new TmInterface(){

            @Override
            public void setValueAt(Object aValue, int rowIndex, int columnIndex, Vector data) {
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return false;
            }

            @Override
            public Object getValueAt(int rowIndex, int columnIndex, Vector data) {
                String sve = (String)data.elementAt(rowIndex);
                return sve;
            }
        });
        return this.tm;
    }

    @Override
    public JPanel buildTotalPanel() {
        return null;
    }

    @Override
    public JPanel buildCustomParamsPanel() {
        this._categoryLabel = new JLabel(LangRoAll.sectie);
        this._categoryComboBox = new JComboBox();
        JPanel categPanel = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.gridheight = 1;
        c.gridwidth = 1;
        c.anchor = 17;
        c.fill = 2;
        c.insets = new Insets(0, 0, 0, 0);
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 0.0;
        categPanel.add((Component)this._categoryLabel, c);
        ++c.gridx;
        c.weightx = 1.0;
        categPanel.add((Component)this._categoryComboBox, c);
        ++c.gridy;
        c.gridx = 0;
        c.weightx = 0.0;
        categPanel.add((Component)new JLabel(LangRoAll.operator), c);
        ++c.gridx;
        c.weightx = 1.0;
        this.waiters = new JComboBox();
        categPanel.add((Component)this.waiters, c);
        return categPanel;
    }

    @Override
    public void refreshTotalPanel() {
    }

    @Override
    public void doStuff() {
        ComboUtils.replaceItemsForCombo(this._categoryComboBox, (Collection)RestLogic.getInstance().getSectii(), false);
        ComboUtils.replaceItemsForCombo(this.waiters, RestLogic.getInstance().getWaiters());
    }

    @Override
    public Comparator getComparatorForColumn(int columnIndex) {
        return null;
    }
}

