/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.restaurant.gui.reports;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import jxl.write.WriteException;
import ro.atreides.nomenclatura.Categorie;
import ro.atreides.nomenclatura.NomeclaturaLogic;
import ro.atreides.nomenclatura.Product;
import ro.atreides.nomenclatura.Sectie;
import ro.atreides.print.PrintLogic;
import ro.atreides.restaurant.SalesExcel394Processor;
import ro.atreides.restaurant.SalesExcelProcessor;
import ro.atreides.restaurant.base.reports.SalesEntry;
import ro.atreides.restaurant.gui.achizitii.AchizitiiProdusePanel;
import ro.atreides.restaurant.logic.RestLogic;
import ro.atreides.restaurant.logic.winmentor.WinmentorExportLogic;
import ro.atreides.users.User;
import ro.atreides.utils.Constants;
import ro.atreides.utils.DateUtils;
import ro.atreides.utils.Formatters;
import ro.atreides.utils.Location;
import ro.atreides.utils.Logger;
import ro.atreides.utils.Shift;
import ro.atreides.utils.Utils;
import ro.atreides.utils.excel.ExcelUtils;
import ro.atreides.utils.gui.ComboUtils;
import ro.atreides.utils.gui.JMultilineLabel;
import ro.atreides.utils.gui.ReportInterface;
import ro.atreides.utils.gui.dialogs.DialogUtils;
import ro.atreides.utils.gui.dialogs.FileDialog;
import ro.atreides.utils.gui.table.AbstractTM;
import ro.atreides.utils.gui.table.TmInterface;
import ro.atreides.utils.multilang.LangRoAll;
import ro.atreides.utils.multilanguage.LanguageLogic;
import ro.atreides.utils.plati.TipPlata;
import ro.atreides.utils.plati.TipPlataProvider;
import ro.atreides.utils.reports.AbstractReportPanel;
import ro.atreides.utils.tva.Tva;
import ro.atreides.utils.tva.TvaLogic;

public class SalesReport
extends AbstractReportPanel {
    protected JLabel _categoryLabel;
    protected JLabel _subcategoryLabel;
    protected JLabel _productsLabel;
    protected JLabel _tipLabel;
    protected JLabel tvaLabel;
    protected JLabel grupareLabel;
    protected JLabel ospatarLabel;
    protected JLabel locatieLabel;
    protected JLabel protocolLabel;
    protected JLabel statusLabel;
    protected JComboBox _categoryComboBox;
    protected JComboBox _subCategoryComboBox;
    protected JComboBox _productsComboBox;
    protected JComboBox _tipComboBox;
    protected JComboBox tvaCombo;
    protected JComboBox ture;
    protected JComboBox tipPlata;
    protected JComboBox grupareCombo;
    protected JComboBox ospatarCombo;
    protected JComboBox locatieCombo;
    protected JComboBox protocolCombo;
    protected JComboBox statusCombo;
    protected JMultilineLabel _salesTotalLabel;
    private RestLogic logic;
    private ReportInterface pdfReportInterface;
    private ReportInterface asciiReportInterface;
    private Hashtable printCriteria = new Hashtable();
    private JButton trimiteLaAchizitie;
    private JButton exportCSV;
    private JButton excel394;
    private static final String[] columns = new String[]{LangRoAll.grouping, LangRoAll.sectie, LangRoAll.categorie, LangRoAll.produs, LangRoAll.unitati, LangRoAll.pret, LangRoAll.valoare, LangRoAll.promotie};
    private static final Class[] types = new Class[]{String.class, String.class, String.class, String.class, Double.class, Double.class, Double.class, String.class};
    private static Comparator category_sorter = new Comparator(){

        public int compare(Object o1, Object o2) {
            String c1 = ((SalesEntry)o1).getCategory();
            String c2 = ((SalesEntry)o2).getCategory();
            return c1.compareTo(c2);
        }
    };
    private static Comparator subcategory_sorter = new Comparator(){

        public int compare(Object o1, Object o2) {
            String c1 = ((SalesEntry)o1).getSubcategory();
            String c2 = ((SalesEntry)o2).getSubcategory();
            return c1.compareTo(c2);
        }
    };
    private static Comparator product_sorter = new Comparator(){

        public int compare(Object o1, Object o2) {
            String c1 = ((SalesEntry)o1).getProduct();
            String c2 = ((SalesEntry)o2).getProduct();
            return c1.compareTo(c2);
        }
    };
    private static Comparator quantity_sorter = new Comparator(){

        public int compare(Object o1, Object o2) {
            Double c1 = new Double(((SalesEntry)o1).getQuantity());
            Double c2 = new Double(((SalesEntry)o2).getQuantity());
            return c1.compareTo(c2);
        }
    };
    private static Comparator value_sorter = new Comparator(){

        public int compare(Object o1, Object o2) {
            Double c1 = new Double(((SalesEntry)o1).getTotalValue());
            Double c2 = new Double(((SalesEntry)o2).getTotalValue());
            return c1.compareTo(c2);
        }
    };
    private static Comparator price_sorter = new Comparator(){

        public int compare(Object o1, Object o2) {
            Double c1 = new Double(((SalesEntry)o1).getPrice());
            Double c2 = new Double(((SalesEntry)o2).getPrice());
            return c1.compareTo(c2);
        }
    };
    private static Comparator date_sorter = new Comparator(){

        public int compare(Object o1, Object o2) {
            String c1 = ((SalesEntry)o1).getDateAndTime();
            String c2 = ((SalesEntry)o2).getDateAndTime();
            if (c1 != null) {
                if (c2 != null) {
                    return c1.compareTo(c2);
                }
                return 1;
            }
            if (c2 != null) {
                return -1;
            }
            return 0;
        }
    };
    private static Comparator promotion_sorter = new Comparator(){

        public int compare(Object o1, Object o2) {
            int c1 = ((SalesEntry)o1).getIdPromotion();
            int c2 = ((SalesEntry)o2).getIdPromotion();
            return c1 - c2;
        }
    };

    public SalesReport() {
        this.logic = RestLogic.getInstance();
    }

    protected void buildAddObjects() {
        this._categoryLabel = new JLabel(LangRoAll.sectie);
        this._categoryComboBox = new JComboBox();
        this._subcategoryLabel = new JLabel(LangRoAll.categorie);
        this._subCategoryComboBox = new JComboBox();
        this._productsLabel = new JLabel(LangRoAll.produs);
        this._productsComboBox = new JComboBox();
        this._productsComboBox.setPrototypeDisplayValue("111111111111111111111111111111111");
        this._tipLabel = new JLabel(LangRoAll.finitReteta);
        this._tipComboBox = new JComboBox();
        this.grupareLabel = new JLabel(LangRoAll.grupare);
        this.grupareCombo = new JComboBox();
        this.tvaLabel = new JLabel(LangRoAll.tva);
        this.tvaCombo = new JComboBox();
        this.ture = new JComboBox();
        this.ospatarCombo = new JComboBox();
        this.statusCombo = new JComboBox();
        this.locatieCombo = new JComboBox();
        this.protocolCombo = new JComboBox();
        this.tipPlata = new JComboBox();
    }

    @Override
    public Hashtable buildCriteria(Date startDate, Date stopDate) {
        Hashtable<String, Object> result = new Hashtable<String, Object>();
        result.put(Constants.START_KEY, startDate);
        result.put(Constants.STOP_KEY, stopDate);
        this.printCriteria.put(LangRoAll.start, Formatters.DATE_AND_TIME_AND_SECONDS_HUMAN_FORMAT.format(startDate));
        this.printCriteria.put(LangRoAll.stop, Formatters.DATE_AND_TIME_AND_SECONDS_HUMAN_FORMAT.format(stopDate));
        if (ComboUtils.anythingButAllSelected(this._categoryComboBox)) {
            Sectie cat = (Sectie)this._categoryComboBox.getSelectedItem();
            result.put("category", cat);
            this.printCriteria.put(LangRoAll.sectie, cat.getName());
        } else {
            this.printCriteria.remove(LangRoAll.sectie);
        }
        if (ComboUtils.anythingButAllSelected(this._subCategoryComboBox)) {
            Categorie subcat = (Categorie)this._subCategoryComboBox.getSelectedItem();
            result.put("subcategory", subcat);
            this.printCriteria.put(LangRoAll.categorie, subcat.getName());
        } else {
            this.printCriteria.remove(LangRoAll.categorie);
        }
        if (ComboUtils.anythingButAllSelected(this.tvaCombo)) {
            Tva tvaCat = (Tva)this.tvaCombo.getSelectedItem();
            result.put(LangRoAll.tva, tvaCat);
            this.printCriteria.put(LangRoAll.tva, tvaCat.getId());
        } else {
            this.printCriteria.remove(LangRoAll.tva);
        }
        if (ComboUtils.anythingButAllSelected(this._productsComboBox)) {
            Product p = (Product)this._productsComboBox.getSelectedItem();
            result.put("product", p.getId());
            this.printCriteria.put(LangRoAll.produs, p.getName());
        } else {
            this.printCriteria.remove(LangRoAll.produs);
        }
        String tip = (String)this._tipComboBox.getSelectedItem();
        result.put("tip_produs_key", tip);
        this.printCriteria.put(LangRoAll.tip, tip);
        if (ComboUtils.anythingButAllSelected(this.tipPlata)) {
            TipPlata tp = (TipPlata)this.tipPlata.getSelectedItem();
            result.put("Tip plata", tp.getId());
            this.printCriteria.put("Tip plata", tp.getLabel());
        } else {
            this.printCriteria.remove("Tip plata");
        }
        if (ComboUtils.anythingButAllSelected(this.grupareCombo)) {
            String g = (String)this.grupareCombo.getSelectedItem();
            result.put(Constants.GRUPARE_KEY, g);
            this.printCriteria.put(Constants.GRUPARE_KEY, g);
        } else {
            this.printCriteria.remove(Constants.GRUPARE_KEY);
        }
        if (ComboUtils.anythingButAllSelected(this.ospatarCombo)) {
            User u = (User)this.ospatarCombo.getSelectedItem();
            result.put(Constants.WAITER_KEY, u.getId());
            this.printCriteria.put(Constants.WAITER_KEY, u.getName());
        } else {
            this.printCriteria.remove(Constants.WAITER_KEY);
        }
        if (ComboUtils.anythingButAllSelected(this.locatieCombo)) {
            Location l = (Location)this.locatieCombo.getSelectedItem();
            result.put(Constants.LOCATIE_KEY, l.getId());
            this.printCriteria.put(Constants.LOCATIE_KEY, l.getName());
        } else {
            this.printCriteria.remove(Constants.LOCATIE_KEY);
        }
        String tipProtocol = (String)this.protocolCombo.getSelectedItem();
        if (!tipProtocol.equalsIgnoreCase("All")) {
            if (tipProtocol.equalsIgnoreCase("Normal")) {
                result.put("Tip protocol", "false");
                this.printCriteria.put("Tip protocol", "Normal");
            } else {
                result.put("Tip protocol", "true");
                this.printCriteria.put("Tip protocol", Constants.PROTOCOL_STRING);
            }
        } else {
            this.printCriteria.remove("Tip protocol");
        }
        int status = 3;
        String statusNota = (String)this.statusCombo.getSelectedItem();
        if (statusNota.equalsIgnoreCase("Deschisa")) {
            status = 1;
        } else if (statusNota.equalsIgnoreCase("Inchisa")) {
            status = 2;
        }
        this.printCriteria.put("StatusNota", statusNota);
        result.put("StatusNota", status);
        return result;
    }

    @Override
    public void printPreview() {
        String pdfFile = PrintLogic.getInstance().buildReportPdfText(this.data, this.pdfReportInterface);
        PrintLogic.getInstance().printPreview(pdfFile);
    }

    @Override
    public void printReport() {
        PrintLogic.getInstance().printReport(this, this.pdfReportInterface, this.asciiReportInterface, this.data);
    }

    @Override
    public Vector<SalesEntry> getResult(Hashtable criteria) {
        return this.logic.getSalesReport(criteria, this.whatToPrint);
    }

    @Override
    public void writeExcel(File reportFile) {
        try {
            ExcelUtils.writeExcel(reportFile, this.data, new SalesExcelProcessor(), this.printCriteria);
        }
        catch (WriteException e2) {
            Logger.logException(this, (Exception)((Object)e2));
        }
        catch (IOException e1) {
            Logger.logException(this, (Exception)e1);
        }
    }

    @Override
    public String getName() {
        return LangRoAll.vanzari;
    }

    @Override
    public AbstractTM buildTableModel() {
        AbstractTM model = new AbstractTM(columns, types, new TmInterface(){

            @Override
            public void setValueAt(Object aValue, int rowIndex, int columnIndex, Vector data) {
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return false;
            }

            @Override
            public Object getValueAt(int rowIndex, int columnIndex, Vector data) {
                SalesEntry se = (SalesEntry)data.elementAt(rowIndex);
                if (se == null) {
                    return null;
                }
                switch (columnIndex) {
                    case 0: {
                        return se.getDataOra();
                    }
                    case 1: {
                        return se.getCategory();
                    }
                    case 2: {
                        return se.getSubcategory();
                    }
                    case 3: {
                        return se.getProduct();
                    }
                    case 4: {
                        return new Double(se.getQuantity());
                    }
                    case 5: {
                        return new Double(se.getPrice());
                    }
                    case 6: {
                        return new Double(se.getTotalValue());
                    }
                    case 7: {
                        return se.getPromotion();
                    }
                }
                return null;
            }
        });
        return model;
    }

    @Override
    public void exportToXml() {
        String inputFile = FileDialog.getSaveDialogLocation(this, LangRoAll.alegetiFisierulDestinatie, "xml");
        if (inputFile != null) {
            this.logic.exportSalesToXml(this.printCriteria, this.tm.getData(), inputFile, 0.0, 0, System.currentTimeMillis(), "");
            DialogUtils.okDialog(this, LangRoAll.operatieExecutata, LangRoAll.succes);
        }
    }

    @Override
    public boolean showXmlButton() {
        return true;
    }

    @Override
    public JPanel buildTotalPanel() {
        JPanel result = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.gridheight = 1;
        c.gridwidth = 1;
        c.fill = 0;
        c.anchor = 17;
        c.insets = new Insets(0, 0, 0, 0);
        c.gridx = 0;
        c.gridy = 0;
        this._salesTotalLabel = new JMultilineLabel();
        this._salesTotalLabel.setText(LangRoAll.total);
        result.add((Component)this._salesTotalLabel, c);
        final SalesReport parent = this;
        ++c.gridx;
        this.trimiteLaAchizitie = new JButton(LangRoAll.trimiteLaAchizitie);
        this.trimiteLaAchizitie.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                AchizitiiProdusePanel app = SalesReport.this.logic.getAchizitiiPanel();
                if (app == null) {
                    DialogUtils.errorDialog(parent, LangRoAll.nuAvetiAccesLaAchizitii, LangRoAll.nuPotContinua);
                    return;
                }
                for (int i = 0; i < SalesReport.this.data.size(); ++i) {
                    SalesEntry salesEntry = (SalesEntry)SalesReport.this.data.elementAt(i);
                    int idProduct = salesEntry.getIdProduct();
                    if (!SalesReport.this.logic.isReteta(idProduct)) continue;
                    app.addEntry(idProduct, salesEntry.getQuantity());
                }
                DialogUtils.okDialog(parent, LangRoAll.exportInEcranAchizitii, LangRoAll.succes);
            }
        });
        result.add((Component)this.trimiteLaAchizitie, c);
        ++c.gridx;
        this.exportCSV = new JButton("Export");
        this.exportCSV.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                JPopupMenu menu = new JPopupMenu();
                JMenuItem exportWinmentor = new JMenuItem("Export WinMentor");
                exportWinmentor.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent ev) {
                        if (DialogUtils.confirmDialog(parent, "Exportam datele pentru WinMentor", LangRoAll.confirmare)) {
                            Date start = (Date)SalesReport.this.criteria.get(Constants.START_KEY);
                            Date stop = (Date)SalesReport.this.criteria.get(Constants.STOP_KEY);
                            String grupare = (String)SalesReport.this.criteria.get(Constants.GRUPARE_KEY);
                            if (grupare == null || !grupare.equalsIgnoreCase("Dupa data")) {
                                DialogUtils.errorDialog(parent, "Datele trebuie sa fie grupate dupa data !", LangRoAll.nuPotContinua);
                                return;
                            }
                            Hashtable<String, Object> result = new Hashtable<String, Object>();
                            Date startDay = DateUtils.getStartOfDay(start);
                            Date endDay = DateUtils.getEndOfDay(stop);
                            result.put(Constants.START_KEY, startDay);
                            result.put(Constants.STOP_KEY, endDay);
                            result.put(Constants.GRUPARE_KEY, "Dupa data");
                            Vector<SalesEntry> correctSales = RestLogic.getInstance().getSalesReport(result, 2);
                            String saveDir = WinmentorExportLogic.getInstance().exportDateWinMentorSales(parent, start, stop, correctSales);
                            if (saveDir != null) {
                                DialogUtils.okDialog(parent, "Datele au fost salvate la " + saveDir, LangRoAll.succes);
                            } else {
                                DialogUtils.errorDialog(parent, "Export esuat", LangRoAll.eroare);
                            }
                        }
                    }
                });
                menu.add(exportWinmentor);
                JMenuItem exportCSV = new JMenuItem("Export CSV");
                exportCSV.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        String inputFile = FileDialog.getSaveDialogLocation(parent, LangRoAll.alegetiFisierulDestinatie, "csv");
                        if (inputFile != null) {
                            boolean ok = SalesReport.this.logic.exportSalesToCSV(SalesReport.this.tm.getData(), inputFile);
                            if (ok) {
                                DialogUtils.okDialog(parent, LangRoAll.operatieExecutata, LangRoAll.succes);
                            } else {
                                DialogUtils.errorDialog(parent, LangRoAll.eroareLaScriere, LangRoAll.eroare);
                            }
                        }
                    }
                });
                menu.add(exportCSV);
                menu.show(e.getComponent(), e.getX(), e.getY());
            }
        });
        result.add((Component)this.exportCSV, c);
        ++c.gridx;
        this.excel394 = new JButton("Excel 394");
        this.excel394.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SalesReport.this.excel394();
            }
        });
        result.add((Component)this.excel394, c);
        return result;
    }

    @Override
    public JPanel buildCustomParamsPanel() {
        this.buildAddObjects();
        JPanel categPanel = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.gridheight = 1;
        c.gridwidth = 1;
        c.anchor = 10;
        c.fill = 2;
        c.insets = new Insets(2, 2, 2, 2);
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 0.0;
        categPanel.add((Component)new JLabel(LangRoAll.tura), c);
        ++c.gridx;
        c.weightx = 1.0;
        categPanel.add((Component)this.ture, c);
        ++c.gridy;
        c.gridx = 0;
        c.weightx = 0.0;
        categPanel.add((Component)this._categoryLabel, c);
        ++c.gridx;
        c.weightx = 1.0;
        categPanel.add((Component)this._categoryComboBox, c);
        c.gridx = 0;
        ++c.gridy;
        c.weightx = 0.0;
        categPanel.add((Component)this._subcategoryLabel, c);
        ++c.gridx;
        c.weightx = 1.0;
        categPanel.add((Component)this._subCategoryComboBox, c);
        c.gridx = 0;
        ++c.gridy;
        c.weightx = 0.0;
        categPanel.add((Component)this._productsLabel, c);
        ++c.gridx;
        c.weightx = 1.0;
        categPanel.add((Component)this._productsComboBox, c);
        c.gridx = 0;
        ++c.gridy;
        c.weightx = 0.0;
        this.ospatarLabel = new JLabel(LangRoAll.operator);
        categPanel.add((Component)this.ospatarLabel, c);
        ++c.gridx;
        c.weightx = 1.0;
        categPanel.add((Component)this.ospatarCombo, c);
        c.gridx = 0;
        ++c.gridy;
        c.weightx = 0.0;
        this.statusLabel = new JLabel(LangRoAll.status);
        categPanel.add((Component)this.statusLabel, c);
        ++c.gridx;
        c.weightx = 1.0;
        categPanel.add((Component)this.statusCombo, c);
        c.gridx = 2;
        c.gridy = 0;
        c.weightx = 0.0;
        this.locatieLabel = new JLabel(LangRoAll.locatie);
        categPanel.add((Component)this.locatieLabel, c);
        ++c.gridx;
        c.weightx = 1.0;
        categPanel.add((Component)this.locatieCombo, c);
        c.gridx = 2;
        ++c.gridy;
        c.weightx = 0.0;
        this.protocolLabel = new JLabel(LangRoAll.protocol);
        categPanel.add((Component)this.protocolLabel, c);
        ++c.gridx;
        c.weightx = 1.0;
        categPanel.add((Component)this.protocolCombo, c);
        c.gridx = 2;
        ++c.gridy;
        c.weightx = 0.0;
        categPanel.add((Component)this._tipLabel, c);
        ++c.gridx;
        c.weightx = 1.0;
        categPanel.add((Component)this._tipComboBox, c);
        ++c.gridy;
        c.gridx = 2;
        c.weightx = 0.0;
        categPanel.add((Component)new JLabel(LangRoAll.modPlata), c);
        ++c.gridx;
        c.weightx = 1.0;
        categPanel.add((Component)this.tipPlata, c);
        c.gridx = 2;
        ++c.gridy;
        c.weightx = 0.0;
        categPanel.add((Component)this.grupareLabel, c);
        ++c.gridx;
        c.weightx = 1.0;
        categPanel.add((Component)this.grupareCombo, c);
        c.gridx = 2;
        ++c.gridy;
        c.weightx = 0.0;
        categPanel.add((Component)this.tvaLabel, c);
        ++c.gridx;
        c.weightx = 1.0;
        categPanel.add((Component)this.tvaCombo, c);
        return categPanel;
    }

    @Override
    public void refreshTotalPanel() {
        String newLabel = LangRoAll.valoareTotala + ": " + Utils.getString2Decimals(this.getTotalValue()) + "\n" + " " + this.getString(this.getDetails());
        this._salesTotalLabel.setText(newLabel);
    }

    @Override
    public void doStuff() {
        this.pdfReportInterface = new ReportInterface(){

            @Override
            public int getColumnCount() {
                return columns.length;
            }

            @Override
            public int getColumnSize(int column) {
                switch (column) {
                    case 0: {
                        return 1;
                    }
                    case 1: {
                        return 1;
                    }
                    case 2: {
                        return 2;
                    }
                    case 3: {
                        return 3;
                    }
                    case 4: {
                        return 1;
                    }
                    case 5: {
                        return 1;
                    }
                    case 6: {
                        return 1;
                    }
                    case 7: {
                        return 1;
                    }
                }
                return 1;
            }

            @Override
            public String getColumnName(int column) {
                return columns[column];
            }

            @Override
            public String getTotal(int column) {
                switch (column) {
                    case 0: {
                        return LangRoAll.total;
                    }
                    case 6: {
                        return Utils.getString2Decimals(SalesReport.this.getTotalValue());
                    }
                    case 7: {
                        return Utils.getString2Decimals(SalesReport.this.getTotalDiscountValue());
                    }
                }
                return "";
            }

            @Override
            public String getReportTitle() {
                return SalesReport.this.getName();
            }

            @Override
            public Hashtable getCriteria() {
                return SalesReport.this.printCriteria;
            }

            @Override
            public boolean isLandscape() {
                return false;
            }

            @Override
            public String getCellContent(Object row, int column) {
                SalesEntry ie = (SalesEntry)row;
                if (ie == null) {
                    return null;
                }
                switch (column) {
                    case 0: {
                        return ie.getDataOra();
                    }
                    case 1: {
                        return ie.getCategory();
                    }
                    case 2: {
                        return ie.getSubcategory();
                    }
                    case 3: {
                        return ie.getProduct();
                    }
                    case 4: {
                        return Utils.getString3Decimals(ie.getQuantity());
                    }
                    case 5: {
                        return Utils.getString2Decimals(ie.getPrice());
                    }
                    case 6: {
                        return Utils.getString2Decimals(ie.getTotalValue());
                    }
                    case 7: {
                        return ie.getPromotion();
                    }
                }
                return null;
            }
        };
        this.asciiReportInterface = new ReportInterface(){

            @Override
            public int getColumnCount() {
                return 1;
            }

            @Override
            public int getColumnSize(int column) {
                return 1;
            }

            @Override
            public String getColumnName(int column) {
                switch (column) {
                    case 0: {
                        return LangRoAll.produs + "|" + LangRoAll.cantitate + "|" + LangRoAll.valoare;
                    }
                }
                return null;
            }

            @Override
            public String getTotal(int column) {
                if (column == 0) {
                    double totalValue = SalesReport.this.getTotalValue();
                    String[][] details = SalesReport.this.getDetails();
                    String s = "";
                    for (int i = 0; i < details[0].length; ++i) {
                        s = s + details[0][i] + " " + details[1][i] + "\n";
                    }
                    s = s + "\n";
                    s = s + LangRoAll.total.toUpperCase() + Utils.getString2Decimals(totalValue);
                    return s;
                }
                return "";
            }

            @Override
            public String getReportTitle() {
                return SalesReport.this.getName();
            }

            @Override
            public Hashtable getCriteria() {
                return SalesReport.this.printCriteria;
            }

            @Override
            public boolean isLandscape() {
                return false;
            }

            @Override
            public String getCellContent(Object row, int column) {
                if (column == 0) {
                    SalesEntry se = (SalesEntry)row;
                    String product = se.getProduct();
                    double quantity = se.getQuantity();
                    String total = Utils.getString2Decimals(se.getTotalValue());
                    return product + "|" + Utils.getString3Decimals(quantity) + "|" + total;
                }
                return "";
            }
        };
        ComboUtils.replaceItemsForCombo(this.ture, RestLogic.getInstance().getShifts());
        this.ture.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                if (ComboUtils.anythingButAllSelected(SalesReport.this.ture)) {
                    Shift s = (Shift)SalesReport.this.ture.getSelectedItem();
                    SalesReport.this.dateSelector.selectPeriod();
                    SalesReport.this.dateSelector.setStartDate(s.getStart());
                    SalesReport.this.dateSelector.setStopDate(s.getStop());
                } else {
                    SalesReport.this.dateSelector.setStartDate(DateUtils.getStartOfDay(new Date()));
                    SalesReport.this.dateSelector.setStopDate(DateUtils.getEndOfDay(new Date()));
                    SalesReport.this.dateSelector.selectDay();
                }
            }
        });
        ComboUtils.replaceItemsForCombo(this.tipPlata, TipPlataProvider.getInstance().getTipPlata());
        this._tipComboBox.addItem("All");
        this._tipComboBox.addItem("Produs finit");
        this._tipComboBox.addItem("Produs reteta");
        this.grupareCombo.addItem("All");
        this.grupareCombo.addItem("Dupa data");
        this.grupareCombo.addItem("Dupa ora");
        this.grupareCombo.addItem("Dupa comanda");
        ComboUtils.replaceItemsForCombo(this.ospatarCombo, RestLogic.getInstance().getWaiters());
        ComboUtils.replaceItemsForCombo(this.locatieCombo, RestLogic.getInstance().getLocations());
        this.protocolCombo.addItem("All");
        this.protocolCombo.addItem(Constants.PROTOCOL_STRING);
        this.protocolCombo.addItem("Normal");
        ComboUtils.replaceItemsForCombo(this._categoryComboBox, RestLogic.getInstance().getSectii());
        ComboUtils.replaceItemsForCombo(this._subCategoryComboBox, NomeclaturaLogic.getInstance().getCategoriiNaturalOrder(-1));
        this.rebuildAllProducts();
        this._categoryComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (ComboUtils.anythingButAllSelected(SalesReport.this._categoryComboBox)) {
                    Sectie cat = (Sectie)SalesReport.this._categoryComboBox.getSelectedItem();
                    Vector subcats = NomeclaturaLogic.getInstance().getCategoriiNaturalOrder(cat.getId());
                    ComboUtils.replaceItemsForCombo(SalesReport.this._subCategoryComboBox, subcats);
                } else {
                    ComboUtils.replaceItemsForCombo(SalesReport.this._subCategoryComboBox, NomeclaturaLogic.getInstance().getCategoriiNaturalOrder(-1));
                }
            }
        });
        this._subCategoryComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (ComboUtils.anythingButAllSelected(SalesReport.this._subCategoryComboBox)) {
                    Categorie subcat = (Categorie)SalesReport.this._subCategoryComboBox.getSelectedItem();
                    Vector products = NomeclaturaLogic.getInstance().getProductsForCategorie(subcat);
                    ComboUtils.replaceItemsForCombo(SalesReport.this._productsComboBox, products);
                } else {
                    SalesReport.this.rebuildAllProducts();
                }
            }
        });
        this.statusCombo.addItem("Inchisa");
        this.statusCombo.addItem("Deschisa");
        this.statusCombo.addItem(Constants.STATUS_NOTA_TOATE);
        this.statusCombo.setSelectedItem("Inchisa");
        ComboUtils.replaceItemsForCombo(this.tvaCombo, TvaLogic.getInstance().getTvas(), true);
    }

    private void rebuildAllProducts() {
        Vector<Product> all = NomeclaturaLogic.getInstance().getAllProducts(1);
        Collections.sort(all, new Comparator(){

            public int compare(Object o1, Object o2) {
                String c1 = ((Product)o1).getName();
                String c2 = ((Product)o2).getName();
                return c1.compareToIgnoreCase(c2);
            }
        });
        ComboUtils.replaceItemsForCombo(this._productsComboBox, all);
    }

    @Override
    public Comparator getComparatorForColumn(int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return date_sorter;
            }
            case 1: {
                return category_sorter;
            }
            case 2: {
                return subcategory_sorter;
            }
            case 3: {
                return product_sorter;
            }
            case 4: {
                return quantity_sorter;
            }
            case 5: {
                return price_sorter;
            }
            case 6: {
                return value_sorter;
            }
            case 7: {
                return promotion_sorter;
            }
        }
        return null;
    }

    public String[][] getDetails() {
        double protocol = 0.0;
        int j = 0;
        Hashtable<Integer, String> promotions = new Hashtable<Integer, String>();
        for (SalesEntry element : this.data) {
            int id = element.getIdPromotion();
            if (id != -1) {
                Integer key = new Integer(id);
                String promoValue = (String)promotions.get(key);
                if (promoValue == null) {
                    promoValue = "0";
                }
                double diff = -(element.getDiscount() * element.getQuantity());
                String newPromoValue = Utils.parseDouble(promoValue) + diff + "";
                promotions.put(key, newPromoValue);
                continue;
            }
            if (element.getPrice() == 0.0) {
                protocol += element.getDiscount() * element.getQuantity();
            }
            ++j;
        }
        String[][] result = new String[2][promotions.size() + 2];
        double discount = 0.0;
        int i = 0;
        for (Integer element : promotions.keySet()) {
            SalesEntry s = null;
            for (SalesEntry s1 : this.data) {
                if (s1.getIdPromotion() != element.intValue()) continue;
                s = s1;
                break;
            }
            String promoName = s.getPromotion();
            String pv = (String)promotions.get(element);
            double promoValue = Utils.parseDouble(pv);
            result[0][i] = promoName;
            result[1][i] = Utils.getString2Decimals(promoValue);
            discount += promoValue;
            ++i;
        }
        result[0][i] = LanguageLogic.restaurant_total_discount;
        result[1][i] = Utils.getString2Decimals(discount);
        result[0][i + 1] = LangRoAll.protocol;
        result[1][i + 1] = Utils.getString2Decimals(protocol);
        return result;
    }

    private double getTotalValue() {
        double totalValue = 0.0;
        Iterator i = this.data.iterator();
        while (i.hasNext()) {
            totalValue += ((SalesEntry)i.next()).getTotalValue();
        }
        return totalValue;
    }

    private double getTotalDiscountValue() {
        double totalValue = 0.0;
        for (SalesEntry se : this.data) {
            totalValue += se.getDiscount() * se.getQuantity();
        }
        return totalValue;
    }

    private String getString(String[][] details) {
        String result = "";
        for (int i = 0; i < details[0].length; ++i) {
            result = result + details[0][i] + "=" + details[1][i] + " ";
        }
        return result;
    }

    private void excel394() {
        String inputFile;
        if (this.verifyData() && (inputFile = FileDialog.getSaveDialogLocation(this, LangRoAll.alegetiFisierulDestinatie, "xls")) != null) {
            File f = new File(inputFile);
            try {
                Vector entries = new Vector(this.data);
                Collections.sort(entries, new Comparator<SalesEntry>(){

                    @Override
                    public int compare(SalesEntry o1, SalesEntry o2) {
                        if (o1.equals(o2)) {
                            return 0;
                        }
                        String thisCui = o1.getCui() == null ? "" : o1.getCui();
                        String thatCui = o2.getCui() == null ? "" : o2.getCui();
                        int result = thatCui.compareTo(thisCui);
                        if (result == 0) {
                            result = Double.compare(o2.getCotaTva(), o1.getCotaTva());
                        }
                        return result;
                    }
                });
                ExcelUtils.writeExcel(f, entries, new SalesExcel394Processor(), this.printCriteria);
            }
            catch (WriteException e2) {
                Logger.logException(this, (Exception)((Object)e2));
            }
            catch (IOException e1) {
                Logger.logException(this, (Exception)e1);
            }
        }
    }
}

