/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.restaurant.gui.reports;

import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.io.IOException;
import java.util.Comparator;
import java.util.Date;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JDialog;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import jxl.write.Label;
import jxl.write.Number;
import jxl.write.WritableCell;
import jxl.write.WritableSheet;
import jxl.write.WriteException;
import jxl.write.biff.RowsExceededException;
import ro.atreides.print.PrintLogic;
import ro.atreides.restaurant.base.reports.VanzareNedescarcata;
import ro.atreides.restaurant.gui.reports.DetaliiVanzareNedescarcata;
import ro.atreides.restaurant.logic.RestLogic;
import ro.atreides.utils.CleanupRequired;
import ro.atreides.utils.Constants;
import ro.atreides.utils.Logger;
import ro.atreides.utils.Utils;
import ro.atreides.utils.excel.ExcelProcessor;
import ro.atreides.utils.excel.ExcelUtils;
import ro.atreides.utils.gui.GuiUtils;
import ro.atreides.utils.gui.ReportInterface;
import ro.atreides.utils.gui.dialogs.DialogUtils;
import ro.atreides.utils.gui.table.AbstractTM;
import ro.atreides.utils.gui.table.TmInterface;
import ro.atreides.utils.multilang.LangRoAll;
import ro.atreides.utils.reports.AbstractReportPanel;

public class VanzariNedescarcateReport
extends AbstractReportPanel
implements CleanupRequired {
    public static final String[] columns = new String[]{LangRoAll.sectie, LangRoAll.produs, LangRoAll.cantitate};
    private Hashtable printCriteria = new Hashtable();
    private ReportInterface reportInterface;

    @Override
    public Hashtable buildCriteria(Date startDate, Date stopDate) {
        Hashtable<String, Date> result = new Hashtable<String, Date>();
        result.put(Constants.START_KEY, startDate);
        result.put(Constants.STOP_KEY, stopDate);
        return result;
    }

    @Override
    public void printReport() {
        PrintLogic.getInstance().printReport(this, this.reportInterface, this.data);
    }

    @Override
    public void printPreview() {
        String pdfFile = PrintLogic.getInstance().buildReportPdfText(this.data, this.reportInterface);
        PrintLogic.getInstance().printPreview(pdfFile);
    }

    @Override
    public Vector getResult(Hashtable criteria) {
        return RestLogic.getInstance().getVanzariNedescarcate(criteria);
    }

    @Override
    public void writeExcel(File reportFile) {
        try {
            ExcelUtils.writeExcel(reportFile, this.data, new ExcelProcessor(){

                @Override
                public void processLine(Object o, WritableSheet sheet, int row) {
                    VanzareNedescarcata sqv = (VanzareNedescarcata)VanzariNedescarcateReport.this.data.elementAt(row);
                    try {
                        Label label = new Label(0, row, sqv.getSectie());
                        sheet.addCell((WritableCell)label);
                        label = new Label(1, row, sqv.getProdus());
                        sheet.addCell((WritableCell)label);
                        sheet.addCell((WritableCell)new Number(2, row, sqv.getCantitate()));
                    }
                    catch (RowsExceededException e) {
                        Logger.logException(this, (Exception)((Object)e));
                    }
                    catch (WriteException e) {
                        Logger.logException(this, (Exception)((Object)e));
                    }
                }

                @Override
                public String[] getColumns() {
                    return columns;
                }

                @Override
                public String getSheetName() {
                    return VanzariNedescarcateReport.this.getName();
                }

                @Override
                public int buildHeader(WritableSheet sheet, int startRow) {
                    return 0;
                }

                @Override
                public void buildTotal(WritableSheet sheet, int row, int firstTableRow, int lastTableRow) {
                }
            }, this.printCriteria);
        }
        catch (WriteException e) {
            Logger.logException(this, (Exception)((Object)e));
        }
        catch (IOException e) {
            Logger.logException(this, (Exception)e);
        }
    }

    @Override
    public String getName() {
        return "Vanzari nedescarcate";
    }

    @Override
    public AbstractTM buildTableModel() {
        this.tm = new AbstractTM(columns, Utils.getStringClass(columns.length), new TmInterface(){

            @Override
            public void setValueAt(Object aValue, int rowIndex, int columnIndex, Vector data) {
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return false;
            }

            @Override
            public Object getValueAt(int rowIndex, int columnIndex, Vector data) {
                VanzareNedescarcata s = (VanzareNedescarcata)data.elementAt(rowIndex);
                switch (columnIndex) {
                    case 0: {
                        return s.getSectie();
                    }
                    case 1: {
                        return s.getProdus();
                    }
                    case 2: {
                        return Utils.getString3Decimals(s.getCantitate());
                    }
                }
                return null;
            }
        });
        return this.tm;
    }

    @Override
    public JPanel buildTotalPanel() {
        return null;
    }

    @Override
    public JPanel buildCustomParamsPanel() {
        return null;
    }

    @Override
    public void refreshTotalPanel() {
    }

    @Override
    public void doStuff() {
        this.reportInterface = new ReportInterface(){

            @Override
            public int getColumnCount() {
                return columns.length;
            }

            @Override
            public int getColumnSize(int column) {
                return 1;
            }

            @Override
            public String getColumnName(int column) {
                return columns[column];
            }

            @Override
            public String getTotal(int column) {
                return "";
            }

            @Override
            public String getReportTitle() {
                return VanzariNedescarcateReport.this.getName();
            }

            @Override
            public Hashtable getCriteria() {
                return VanzariNedescarcateReport.this.printCriteria;
            }

            @Override
            public boolean isLandscape() {
                return false;
            }

            @Override
            public String getCellContent(Object row, int column) {
                VanzareNedescarcata sqv = (VanzareNedescarcata)row;
                switch (column) {
                    case 0: {
                        return sqv.getSectie();
                    }
                    case 1: {
                        return sqv.getProdus();
                    }
                    case 2: {
                        return Utils.getString3Decimals(sqv.getCantitate());
                    }
                }
                return null;
            }
        };
        this.table.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }

            @Override
            public void mousePressed(MouseEvent e) {
                Point p;
                JTable t = (JTable)e.getSource();
                int selRow = t.rowAtPoint(p = e.getPoint());
                if (selRow == -1) {
                    return;
                }
                final VanzareNedescarcata doc = (VanzareNedescarcata)VanzariNedescarcateReport.this.tm.getData().get(selRow);
                final JPopupMenu popup = new JPopupMenu();
                JMenuItem detalii = new JMenuItem(LangRoAll.detalii);
                popup.add(detalii);
                popup.setInvoker(VanzariNedescarcateReport.this.table);
                detalii.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent ev) {
                        DetaliiVanzareNedescarcata dia = new DetaliiVanzareNedescarcata(doc.getIdProduct(), doc.getIdSectie());
                        dia.doStuff();
                        JDialog dialog = DialogUtils.getJDialog(dia, GuiUtils.currentFrame, "Nedescarcate " + doc.getSectie() + " - " + doc.getProdus(), 1.1);
                        dialog.setVisible(true);
                        popup.setVisible(false);
                    }
                });
                popup.show(e.getComponent(), e.getX(), e.getY());
            }

            @Override
            public void mouseReleased(MouseEvent e) {
            }
        });
    }

    @Override
    public Comparator getComparatorForColumn(int columnIndex) {
        return null;
    }

    @Override
    public void cleanup() {
    }
}

