/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.restaurant.gui.reports;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.io.File;
import java.io.IOException;
import java.util.Comparator;
import java.util.Date;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JLabel;
import javax.swing.JPanel;
import jxl.write.Label;
import jxl.write.Number;
import jxl.write.WritableCell;
import jxl.write.WritableSheet;
import jxl.write.WriteException;
import jxl.write.biff.RowsExceededException;
import ro.atreides.nomenclatura.Sectie;
import ro.atreides.print.PrintLogic;
import ro.atreides.restaurant.VanzariPeZileEntry;
import ro.atreides.restaurant.logic.RestLogic;
import ro.atreides.utils.Constants;
import ro.atreides.utils.Formatters;
import ro.atreides.utils.Logger;
import ro.atreides.utils.Utils;
import ro.atreides.utils.excel.ExcelProcessor;
import ro.atreides.utils.excel.ExcelUtils;
import ro.atreides.utils.gui.ReportInterface;
import ro.atreides.utils.gui.table.AbstractTM;
import ro.atreides.utils.gui.table.TmInterface;
import ro.atreides.utils.multilang.LangRoAll;
import ro.atreides.utils.reports.AbstractReportPanel;

public class VanzariPeZileReport
extends AbstractReportPanel {
    private Hashtable printCriteria = new Hashtable();
    private ReportInterface reportInterface;
    private String[] columns = new String[1];
    private RestLogic logic;
    private JLabel totalLabel;
    private JLabel[] sectiiLabels;
    private Vector sectii;
    private double[] totaluri;

    @Override
    public Hashtable buildCriteria(Date startDate, Date stopDate) {
        Hashtable<String, Date> result = new Hashtable<String, Date>();
        result.put(Constants.START_KEY, startDate);
        result.put(Constants.STOP_KEY, stopDate);
        this.printCriteria.put(LangRoAll.start, Formatters.DATE_AND_TIME_AND_SECONDS_HUMAN_FORMAT.format(startDate));
        this.printCriteria.put(LangRoAll.stop, Formatters.DATE_AND_TIME_AND_SECONDS_HUMAN_FORMAT.format(stopDate));
        return result;
    }

    @Override
    public JPanel buildCustomParamsPanel() {
        return null;
    }

    @Override
    public AbstractTM buildTableModel() {
        TmInterface inter = new TmInterface(){

            @Override
            public void setValueAt(Object aValue, int rowIndex, int columnIndex, Vector data) {
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return false;
            }

            @Override
            public Object getValueAt(int rowIndex, int columnIndex, Vector data) {
                VanzariPeZileEntry ve = (VanzariPeZileEntry)data.elementAt(rowIndex);
                switch (columnIndex) {
                    case 0: {
                        return ve.getData();
                    }
                    case 1: {
                        return Utils.getString2Decimals(ve.getTotal());
                    }
                }
                if (columnIndex - 2 < ve.getTotalPeSectii().size()) {
                    return Utils.getString2Decimals((Double)ve.getTotalPeSectii().elementAt(columnIndex - 2));
                }
                return 0;
            }
        };
        this.logic = RestLogic.getInstance();
        this.sectii = this.logic.getSectii();
        this.sectiiLabels = new JLabel[this.sectii.size()];
        this.columns = new String[2 + this.sectii.size()];
        this.columns[0] = LangRoAll.data;
        this.columns[1] = LangRoAll.total;
        for (int i = 0; i < this.sectii.size(); ++i) {
            Sectie s = (Sectie)this.sectii.elementAt(i);
            this.columns[i + 2] = s.getName();
        }
        this.tm = new AbstractTM(this.columns, Utils.getStringClass(this.columns.length), inter);
        return this.tm;
    }

    @Override
    public JPanel buildTotalPanel() {
        JPanel result = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.insets = new Insets(2, 2, 2, 2);
        c.gridheight = 1;
        c.gridwidth = 1;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.anchor = 10;
        c.fill = 2;
        c.gridy = 0;
        c.gridx = 0;
        result.add((Component)new JLabel("Total general"), c);
        ++c.gridx;
        this.totalLabel = new JLabel("");
        result.add((Component)this.totalLabel, c);
        for (int i = 0; i < this.sectii.size(); ++i) {
            Sectie o = (Sectie)this.sectii.elementAt(i);
            ++c.gridx;
            result.add((Component)new JLabel(LangRoAll.total + o.getName()), c);
            ++c.gridx;
            this.sectiiLabels[i] = new JLabel("");
            result.add((Component)this.sectiiLabels[i], c);
        }
        return result;
    }

    @Override
    public String getName() {
        return "Vanzari pe zile";
    }

    @Override
    public Vector getResult(Hashtable criteria) {
        return RestLogic.getInstance().getVanzariPeZile(criteria);
    }

    @Override
    public void printPreview() {
        String pdfFile = PrintLogic.getInstance().buildReportPdfText(this.data, this.reportInterface);
        PrintLogic.getInstance().printPreview(pdfFile);
    }

    @Override
    public void printReport() {
        PrintLogic.getInstance().printReport(this, this.reportInterface, this.data);
    }

    @Override
    public void refreshTotalPanel() {
        this.totaluri = new double[this.sectii.size()];
        for (int i = 0; i < this.data.size(); ++i) {
            VanzariPeZileEntry entry = (VanzariPeZileEntry)this.data.elementAt(i);
            for (int j = 0; j < this.sectii.size(); ++j) {
                if (entry.getTotalPeSectii().size() <= j) continue;
                int n = j;
                this.totaluri[n] = this.totaluri[n] + (Double)entry.getTotalPeSectii().elementAt(j);
            }
        }
    }

    @Override
    public void writeExcel(File reportFile) {
        try {
            ExcelUtils.writeExcel(reportFile, this.data, new ExcelProcessor(){

                @Override
                public void processLine(Object o, WritableSheet sheet, int row) {
                    VanzariPeZileEntry entry = (VanzariPeZileEntry)o;
                    try {
                        Label label = new Label(0, row, entry.getData());
                        sheet.addCell((WritableCell)label);
                        sheet.addCell((WritableCell)new Number(1, row, entry.getTotal()));
                        for (int i = 0; i < entry.getTotalPeSectii().size(); ++i) {
                            Double f = (Double)entry.getTotalPeSectii().elementAt(i);
                            sheet.addCell((WritableCell)new Number(i + 2, row, f.doubleValue()));
                        }
                    }
                    catch (RowsExceededException e) {
                        Logger.logException(this, (Exception)((Object)e));
                    }
                    catch (WriteException e) {
                        Logger.logException(this, (Exception)((Object)e));
                    }
                }

                @Override
                public String[] getColumns() {
                    return VanzariPeZileReport.this.columns;
                }

                @Override
                public String getSheetName() {
                    return VanzariPeZileReport.this.getName();
                }

                @Override
                public int buildHeader(WritableSheet sheet, int startRow) {
                    return 0;
                }

                @Override
                public void buildTotal(WritableSheet sheet, int row, int firstTableRow, int lastTableRow) {
                }
            }, this.printCriteria);
        }
        catch (WriteException e) {
            Logger.logException(this, (Exception)((Object)e));
        }
        catch (IOException e) {
            Logger.logException(this, (Exception)e);
        }
    }

    @Override
    public void doStuff() {
        this.reportInterface = new ReportInterface(){

            @Override
            public int getColumnCount() {
                return VanzariPeZileReport.this.columns.length;
            }

            @Override
            public int getColumnSize(int column) {
                return 1;
            }

            @Override
            public String getColumnName(int column) {
                return VanzariPeZileReport.this.columns[column];
            }

            @Override
            public String getTotal(int column) {
                switch (column) {
                    case 0: {
                        return LangRoAll.total;
                    }
                    case 1: {
                        return VanzariPeZileReport.this.totalLabel.getText();
                    }
                }
                return VanzariPeZileReport.this.sectiiLabels[column].getText();
            }

            @Override
            public String getReportTitle() {
                return VanzariPeZileReport.this.getName();
            }

            @Override
            public Hashtable getCriteria() {
                return VanzariPeZileReport.this.printCriteria;
            }

            @Override
            public boolean isLandscape() {
                return false;
            }

            @Override
            public String getCellContent(Object row, int column) {
                VanzariPeZileEntry ve = (VanzariPeZileEntry)row;
                switch (column) {
                    case 0: {
                        return ve.getData();
                    }
                    case 1: {
                        return Utils.getString2Decimals(ve.getTotal());
                    }
                }
                return Utils.getString2Decimals((Double)ve.getTotalPeSectii().elementAt(column - 2));
            }
        };
    }

    @Override
    public Comparator getComparatorForColumn(int columnIndex) {
        return null;
    }
}

