/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.restaurant.gui.restaurant;

import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.JButton;
import ro.atreides.restaurant.VpConfig;
import ro.atreides.restaurant.gui.touch2.TouchMain2;
import ro.atreides.restaurant.gui.touch2.TouchOrder2;
import ro.atreides.restaurant.logic.RestLogic;
import ro.atreides.users.UsersLogic;
import ro.atreides.utils.gui.GuiUtils;
import ro.atreides.utils.gui.dialogs.DialogUtils;
import ro.atreides.utils.multilang.LangRoAll;

public class RestaurantOrderPanel
extends TouchOrder2 {
    public RestaurantOrderPanel(RestLogic logic, TouchMain2 main, VpConfig config, Vector sectii, boolean autoMarcaj, boolean deleteAllPlateau) {
        super(logic, main, config, sectii, autoMarcaj, deleteAllPlateau);
    }

    @Override
    protected JButton getVerificaNotaButton() {
        this.mare = new JButton();
        this.mare.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                int maxClients = RestLogic.getInstance().getMaxClientsForOrder(RestaurantOrderPanel.this.order, RestaurantOrderPanel.this.preSales);
                ++maxClients;
                Vector<String> options = new Vector<String>();
                options.add("<html><center>Produse<br>Neasociate</center></html>");
                for (int i = 1; i <= maxClients; ++i) {
                    options.add("" + i);
                }
                String s = (String)DialogUtils.getItemChooserDialog(options, 5, true);
                if (s != null) {
                    if (s.equalsIgnoreCase("<html><center>Produse<br>Neasociate</center></html>")) {
                        RestaurantOrderPanel.this.clientFilter1 = 0;
                    } else {
                        RestaurantOrderPanel.this.clientFilter1 = Integer.parseInt(s);
                    }
                } else {
                    RestaurantOrderPanel.this.clientFilter1 = -1;
                }
                RestaurantOrderPanel.this.setScaunButtonText();
                if (RestaurantOrderPanel.this.order != null) {
                    RestaurantOrderPanel.this.refreshOrderSales();
                }
                RestaurantOrderPanel.this.updateOrderTotal();
                RestaurantOrderPanel.this.refreshPreOrderSales();
                RestaurantOrderPanel.this.updateTotalPreorder();
                if (RestaurantOrderPanel.this.preSales.size() > 0) {
                    RestaurantOrderPanel.this.tabs.setSelectedIndex(0);
                }
            }
        });
        this.setScaunButtonText();
        return this.mare;
    }

    @Override
    protected boolean nota(boolean gotoMese, ActionEvent e) {
        if (this.order != null) {
            boolean f = true;
            double maxValNota = VpConfig.getInstance().notaMaxValue;
            if (maxValNota > 0.0 && RestLogic.computeTotalForSales(this.orderTm.getAllSales()) >= maxValNota && !DialogUtils.confirmDialog(GuiUtils.currentFrame, "Valoare nota > " + maxValNota + " . Sunteti sigur ", LangRoAll.confirmare)) {
                return false;
            }
            boolean noteSeparate = DialogUtils.confirmDialog(this, "Doriti note separate", "Note separate");
            this.logic.laPlataOrder(this.order, this.table, this.forcedPrinter, noteSeparate, -1);
            if (this.config.bonFiscalAtNota) {
                if (this.logic.cashRegisterLikesPlati(this.order)) {
                    this.logic.printBonFiscalSeparat(this.order, f);
                } else {
                    DialogUtils.errorDialog(this, LangRoAll.casaMarcatUnModPlata, LangRoAll.nuPotContinua);
                    return false;
                }
            }
            if (!this.config.allowMarcajAfterNota) {
                this.marcaj.setEnabled(false);
            }
            this.incasat.setEnabled(true);
            if (gotoMese) {
                this.main.nota(this.order);
                if (this.config.logoutAtNota || UsersLogic.getInstance().isTeam(this.waiter.getId())) {
                    this.logout();
                }
            } else {
                this.setFields(this.table, this.waiter);
            }
            return true;
        }
        return false;
    }

    @Override
    protected void setScaunButtonText() {
        String s = "";
        if (this.clientFilter1 == -1) {
            s = "<html><center>" + LangRoAll.scaun + "<br>" + LangRoAll.toate + "</center></html>";
            this.mare.setForeground(Color.BLACK);
        } else if (this.clientFilter1 == 0) {
            s = "<html><center>Produse<br>Neasociate</center></html>";
            this.mare.setForeground(Color.RED);
        } else {
            s = "<html><center>" + LangRoAll.scaun + "<br>" + this.clientFilter1 + "</center></html>";
            this.mare.setForeground(Color.RED);
        }
        this.mare.setText(s);
    }
}

