/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.restaurant.gui.retail;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JTabbedPane;
import ro.atreides.restaurant.base.Table;
import ro.atreides.restaurant.gui.GuiUtilsRest;
import ro.atreides.restaurant.gui.retail.RetailPanel;
import ro.atreides.restaurant.logic.RestLogic;
import ro.atreides.users.User;
import ro.atreides.utils.CleanupRequired;
import ro.atreides.utils.Order;
import ro.atreides.utils.ReflectedJPanel;
import ro.atreides.utils.multilang.LangRoAll;

public class RetailMain
extends ReflectedJPanel
implements CleanupRequired {
    private RestLogic logic;
    private JButton verificaPret;
    private JButton comandaNoua;
    private JButton administrare;
    private JTabbedPane comenzi;

    private void display() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.insets = new Insets(2, 2, 2, 2);
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.gridheight = 1;
        c.gridwidth = 1;
        c.anchor = 10;
        c.fill = 1;
        this.verificaPret = new JButton("Verifica pret");
        this.verificaPret.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
            }
        });
        this.add((Component)this.verificaPret, c);
        ++c.gridx;
        this.comandaNoua = new JButton("Comanda noua");
        this.comandaNoua.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                Table t = RetailMain.this.logic.getFirstFreeTable(new Vector());
                User u = (User)RetailMain.this.logic.getWaiters().get(0);
                Order o = RetailMain.this.logic.newOrder(t.getId(), u.getId());
                RetailPanel rp = RetailMain.this.addRetailPanel(o, RetailMain.this.comenzi, t);
                RetailMain.this.comenzi.setSelectedComponent(rp);
            }
        });
        this.add((Component)this.comandaNoua, c);
        ++c.gridx;
        this.administrare = new JButton(LangRoAll.administrare);
        this.administrare.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                GuiUtilsRest.doAdminLogin(RestLogic.getInstance());
            }
        });
        this.add((Component)this.administrare, c);
        ++c.gridy;
        c.weighty = 1.0;
        c.gridx = 0;
        c.gridwidth = 3;
        this.comenzi = new JTabbedPane();
        this.buildComenziDeschise(this.comenzi);
        this.add((Component)this.comenzi, c);
    }

    private RetailPanel addRetailPanel(Order o, JTabbedPane whereTo, Table t) {
        RetailPanel rp = new RetailPanel(this, o, this.logic, t);
        whereTo.addTab(rp.getName(), rp);
        return rp;
    }

    private void buildComenziDeschise(JTabbedPane comenzi) {
        Vector<Table> tables = this.logic.getTables();
        for (Table element : tables) {
            Order o = this.logic.getOpenOrderAtTable(element);
            if (o == null) continue;
            this.addRetailPanel(o, comenzi, element);
        }
    }

    @Override
    public void doStuff() {
        this.logic = RestLogic.getInstance();
        this.display();
    }

    @Override
    public void cleanup() {
    }

    public void removeRetailPanel(RetailPanel toRemove) {
        this.comenzi.remove(toRemove);
    }
}

