/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.restaurant.gui.retail;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Vector;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTree;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.ExpandVetoException;
import javax.swing.tree.TreePath;
import ro.atreides.clienti.ClientLogic;
import ro.atreides.nomenclatura.Categorie;
import ro.atreides.nomenclatura.NomeclaturaLogic;
import ro.atreides.nomenclatura.Product;
import ro.atreides.nomenclatura.Sectie;
import ro.atreides.restaurant.base.Table;
import ro.atreides.restaurant.gui.retail.BcrProductFinder;
import ro.atreides.restaurant.gui.retail.ProductFoundInterface;
import ro.atreides.restaurant.gui.retail.RetailMain;
import ro.atreides.restaurant.gui.retail.RetailTable;
import ro.atreides.restaurant.logic.RestLogic;
import ro.atreides.utils.CleanupRequired;
import ro.atreides.utils.EventListener;
import ro.atreides.utils.Order;
import ro.atreides.utils.gui.ComboUtils;
import ro.atreides.utils.multilang.LangRoAll;

public class RetailPanel
extends JPanel
implements CleanupRequired {
    private Order order;
    private JTree _productsList;
    private TreePath oldPath;
    private RestLogic logic;
    private static DefaultMutableTreeNode _rootNode;
    private JTextArea detaliiTextArea;
    private RetailTable rt;
    private Table t;
    private RetailMain parent;

    public RetailPanel(RetailMain parent, Order o, RestLogic logic, Table t) {
        this.order = o;
        this.logic = logic;
        this.t = t;
        this.parent = parent;
        this.display();
    }

    private JPanel getDetaliiPanel() {
        JPanel result = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.insets = new Insets(2, 2, 2, 2);
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.gridheight = 1;
        c.gridwidth = 1;
        c.anchor = 10;
        c.fill = 1;
        final JComboBox clienti = new JComboBox();
        ComboUtils.replaceItemsForCombo(clienti, ClientLogic.getInstance().getAllClientsSorted());
        ClientLogic.getInstance().addListener(new EventListener(){

            @Override
            public void dataChanged() {
                ComboUtils.replaceItemsForCombo(clienti, ClientLogic.getInstance().getAllClientsSorted());
            }

            @Override
            public String getName() {
                return "RetailPanel_clientiCombo_PF";
            }
        }, 41);
        ClientLogic.getInstance().addListener(new EventListener(){

            @Override
            public void dataChanged() {
                ComboUtils.replaceItemsForCombo(clienti, ClientLogic.getInstance().getAllClientsSorted());
            }

            @Override
            public String getName() {
                return "RetailPanel_clientiCombo_PJ";
            }
        }, 42);
        result.add((Component)new JLabel(LangRoAll.client), c);
        ++c.gridx;
        result.add(clienti, c);
        ++c.gridy;
        c.gridx = 0;
        result.add((Component)new JLabel(LangRoAll.detalii), c);
        ++c.gridx;
        this.detaliiTextArea = new JTextArea(3, 20);
        this.detaliiTextArea.setText(this.order.getDetalii());
        result.add((Component)this.detaliiTextArea, c);
        return result;
    }

    private JPanel getTreePanel() {
        JPanel result = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.insets = new Insets(2, 2, 2, 2);
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.gridheight = 1;
        c.gridwidth = 1;
        c.anchor = 10;
        c.fill = 1;
        this.buildProductList();
        result.add((Component)new JScrollPane(this._productsList), c);
        return result;
    }

    private void display() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.insets = new Insets(2, 2, 2, 2);
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.gridheight = 1;
        c.gridwidth = 1;
        c.anchor = 10;
        c.fill = 1;
        BcrProductFinder bcrPanel = new BcrProductFinder(new ProductFoundInterface(){

            @Override
            public void foundProduct(Product product, double price) {
                if (product != null && !RetailPanel.this.order.isLaPlata()) {
                    RetailPanel.this.addProduct(product, 1.0, price);
                }
            }
        });
        this.add((Component)bcrPanel, c);
        ++c.gridx;
        JPanel detaliiPanel = this.getDetaliiPanel();
        this.add((Component)detaliiPanel, c);
        c.weighty = 1.0;
        ++c.gridy;
        c.gridx = 0;
        JPanel treePanel = this.getTreePanel();
        this.add((Component)treePanel, c);
        ++c.gridx;
        this.rt = new RetailTable(this.logic, this.order, this.t, this);
        this.rt.doStuff();
        this.add((Component)this.rt, c);
    }

    @Override
    public void cleanup() {
    }

    @Override
    public String getName() {
        return this.order.getId() + "";
    }

    private void addNodes(DefaultMutableTreeNode rootTableNode) {
        Vector<Sectie> categories = NomeclaturaLogic.getInstance().getAllSectii();
        for (Sectie cat : categories) {
            Vector subcat = NomeclaturaLogic.getInstance().getCategoriiNaturalOrder(cat.getId());
            for (Categorie sc : subcat) {
                DefaultMutableTreeNode node = new DefaultMutableTreeNode(sc);
                Vector products = NomeclaturaLogic.getInstance().getProductsForCategorie(sc);
                for (Product p : products) {
                    DefaultMutableTreeNode dp = new DefaultMutableTreeNode(p);
                    node.add(dp);
                }
                if (products.size() <= 0) continue;
                rootTableNode.add(node);
            }
        }
    }

    private void buildProductList() {
        if (_rootNode == null) {
            _rootNode = new DefaultMutableTreeNode();
            this.addNodes(_rootNode);
        }
        this._productsList = new JTree(_rootNode);
        this._productsList.getSelectionModel().setSelectionMode(1);
        this._productsList.setRootVisible(false);
        this._productsList.setToggleClickCount(1);
        this._productsList.setShowsRootHandles(false);
        this._productsList.addTreeWillExpandListener(new TreeWillExpandListener(){

            @Override
            public void treeWillCollapse(TreeExpansionEvent event) throws ExpandVetoException {
            }

            @Override
            public void treeWillExpand(TreeExpansionEvent event) throws ExpandVetoException {
                if (RetailPanel.this.oldPath != null) {
                    RetailPanel.this._productsList.collapsePath(RetailPanel.this.oldPath);
                }
                RetailPanel.this.oldPath = event.getPath();
                RetailPanel.this._productsList.scrollPathToVisible(event.getPath());
            }
        });
        this._productsList.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (RetailPanel.this.order == null || !RetailPanel.this.order.isLaPlata()) {
                    int clickCount;
                    DefaultMutableTreeNode lastSelectedNode;
                    JTree originator = (JTree)e.getComponent();
                    int selRow = originator.getRowForLocation(e.getX(), e.getY());
                    TreePath selPath = originator.getPathForRow(selRow);
                    if (selRow != -1 && (lastSelectedNode = (DefaultMutableTreeNode)selPath.getLastPathComponent()).isLeaf() && (clickCount = e.getClickCount()) >= 2 && clickCount % 2 == 0) {
                        Product p = (Product)lastSelectedNode.getUserObject();
                        double price = RetailPanel.this.logic.getPriceForProductCommit(p.getId());
                        RetailPanel.this.addProduct(p, 1.0, price);
                    }
                }
            }
        });
    }

    private void addProduct(Product produsCurent, double cantitateNoua, double price) {
        this.rt.addProduct(produsCurent, cantitateNoua, "", -1, "", price);
    }

    public void inchideComanda() {
        this.parent.removeRetailPanel(this);
    }

    public String getDetalii() {
        return this.detaliiTextArea.getText();
    }
}

