/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.restaurant.gui.shop;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JTabbedPane;
import ro.atreides.clienti.ClientLogic;
import ro.atreides.nomenclatura.gui.CategoriesPanel;
import ro.atreides.nomenclatura.gui.SectiiPanel;
import ro.atreides.promo.PromotionLogic;
import ro.atreides.restaurant.VpConfig;
import ro.atreides.restaurant.gui.LocationsPanel;
import ro.atreides.restaurant.gui.TablesNoPanel;
import ro.atreides.restaurant.gui.admin.prices.PricesReport;
import ro.atreides.stocks.gui.StockInput;
import ro.atreides.utils.CleanupRequired;
import ro.atreides.utils.Constants;
import ro.atreides.utils.ReflectedJPanel;
import ro.atreides.utils.Unit;
import ro.atreides.utils.gui.GuiUtils;
import ro.atreides.utils.gui.dialogs.DialogUtils;
import ro.atreides.utils.gui.table.DoubleClicked;
import ro.atreides.utils.gui.table.SwitchToList;
import ro.atreides.utils.multilang.LangRoAll;
import ro.atreides.utils.plati.TipPlata;
import ro.atreides.utils.plati.TipPlataPanel;
import ro.atreides.utils.tva.Tva;
import ro.atreides.utils.tva.TvaPanel;
import ro.atreides.utils.units.UnitsLogic;
import ro.atreides.utils.units.gui.UnitsPanel;

public class ShopLiteModificationsPanel
extends ReflectedJPanel
implements CleanupRequired {
    private JTabbedPane _tabbedPane = null;
    private SectiiPanel sectiiPanel;
    private CategoriesPanel subcategoriesPanel = null;
    private TipPlataPanel tipPlataPanel;
    private TvaPanel tvaPanel;
    private UnitsPanel unitsPanel;
    private TablesNoPanel tablesPanel;
    private LocationsPanel locationsPanel;

    @Override
    public void doStuff() {
        this.init();
        this.display();
    }

    @Override
    public void cleanup() {
        this.subcategoriesPanel.cleanup();
    }

    private void init() {
        this._tabbedPane = new JTabbedPane();
        final PricesReport pricesReport = new PricesReport(false);
        pricesReport.doStuff();
        this._tabbedPane.add("Produse si preturi", pricesReport);
        final StockInput _stockInputPanel = new StockInput(false);
        _stockInputPanel.setViewPanel(pricesReport);
        this._tabbedPane.add("Adauga produs", _stockInputPanel);
        pricesReport.setAction(new DoubleClicked(){

            @Override
            public void doubleClicked(Object o) {
            }

            @Override
            public void doubleClicked(Object o, Object entry, int selRow) {
                _stockInputPanel.setObjectToEdit(o, entry, selRow);
                ShopLiteModificationsPanel.this._tabbedPane.setSelectedComponent(_stockInputPanel);
            }
        });
        _stockInputPanel.setAction(new SwitchToList(){

            @Override
            public void doAction() {
                ShopLiteModificationsPanel.this._tabbedPane.setSelectedComponent(pricesReport);
            }
        });
        this.subcategoriesPanel = new CategoriesPanel(false, true, false, true);
        this.subcategoriesPanel.doStuff();
        this._tabbedPane.add("Categorii", this.subcategoriesPanel);
        this.sectiiPanel = new SectiiPanel(false);
        this.sectiiPanel.doStuff();
        this._tabbedPane.add("Sectii", this.sectiiPanel);
        boolean showPromo = VpConfig.getInstance().shopTipPlataShowPromoFields;
        this.tipPlataPanel = new TipPlataPanel(false, showPromo);
        this.tipPlataPanel.setPromoInterface(PromotionLogic.getInstance());
        this.tipPlataPanel.setConturiInterface(ClientLogic.getInstance());
        this.tipPlataPanel.doStuff();
        this.tipPlataPanel.setAction(new DoubleClicked(){

            @Override
            public void doubleClicked(Object o) {
                TipPlata tip = (TipPlata)o;
                ShopLiteModificationsPanel.this.tipPlataPanel.setTipPlata(tip);
            }

            @Override
            public void doubleClicked(Object o, Object entry, int selRow) {
            }
        });
        this._tabbedPane.add("Tipuri de plata", this.tipPlataPanel);
        this.tvaPanel = new TvaPanel();
        this.tvaPanel.doStuff();
        this.tvaPanel.setAction(new DoubleClicked(){

            @Override
            public void doubleClicked(Object o) {
                Tva tva = (Tva)o;
                ShopLiteModificationsPanel.this.tvaPanel.setTvaToEdit(tva);
            }

            @Override
            public void doubleClicked(Object o, Object entry, int selRow) {
            }
        });
        this._tabbedPane.add(LangRoAll.tva, this.tvaPanel);
        this.unitsPanel = new UnitsPanel();
        this.unitsPanel.doStuff();
        this.unitsPanel.setAction(new DoubleClicked(){

            @Override
            public void doubleClicked(Object o) {
                if (DialogUtils.confirmDialog(GuiUtils.currentFrame, LangRoAll.unitateMasuraStergem, LangRoAll.confirmare)) {
                    UnitsLogic.getInstance().deleteUnit((Unit)o);
                    ShopLiteModificationsPanel.this.unitsPanel.refreshTable();
                }
            }

            @Override
            public void doubleClicked(Object o, Object entry, int selRow) {
            }
        });
        this._tabbedPane.add(LangRoAll.unitati, this.unitsPanel);
        this.tablesPanel = new TablesNoPanel();
        this.tablesPanel.doStuff();
        this._tabbedPane.add("Comenzi", this.tablesPanel);
        this.locationsPanel = new LocationsPanel();
        this.locationsPanel.doStuff();
        this._tabbedPane.add(LangRoAll.locatii, this.locationsPanel);
        int max = this._tabbedPane.getTabCount();
        for (int i = 0; i < max; ++i) {
            ReflectedJPanel panel = (ReflectedJPanel)this._tabbedPane.getComponentAt(i);
            panel.setUserLogInterface(this.userLogInterface);
            this._tabbedPane.setBackgroundAt(i, Constants.BO_TAB_LEVEL_TWO_COLOR);
        }
    }

    private void display() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.gridheight = 1;
        c.gridwidth = 1;
        c.fill = 1;
        c.anchor = 10;
        c.insets = new Insets(0, 0, 0, 0);
        this.add((Component)this._tabbedPane, c);
    }
}

