/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.restaurant.gui.touch;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;
import ro.atreides.restaurant.VpConfig;
import ro.atreides.restaurant.base.Table;
import ro.atreides.restaurant.gui.GuiUtilsRest;
import ro.atreides.restaurant.gui.ReprintDialog;
import ro.atreides.restaurant.gui.touch.TouchMain;
import ro.atreides.restaurant.logic.RestLogic;
import ro.atreides.users.User;
import ro.atreides.users.UsersLogic;
import ro.atreides.utils.CleanupRequired;
import ro.atreides.utils.EventListener;
import ro.atreides.utils.Location;
import ro.atreides.utils.Logger;
import ro.atreides.utils.Order;
import ro.atreides.utils.Utils;
import ro.atreides.utils.gui.BackgroundedJPanel;
import ro.atreides.utils.gui.DatePanel;
import ro.atreides.utils.gui.FilledRectangle;
import ro.atreides.utils.gui.GuiUtils;
import ro.atreides.utils.gui.TransparentButton;
import ro.atreides.utils.gui.dialogs.DialogUtils;
import ro.atreides.utils.multilang.LangRoAll;

public class LocationPanel
extends JPanel
implements CleanupRequired {
    public static final Color FIDEL_COLOR = Color.ORANGE;
    public static final Color LAPLATA_COLOR = Color.RED;
    public static final Color PROTOCOL_COLOR = Color.GREEN;
    public static final Color BUSY_COLOR = Color.YELLOW;
    public static final Color FREE_COLOR = Color.WHITE;
    private Collection locations;
    private Hashtable locationsPanels = new Hashtable();
    private Hashtable meseButtons = new Hashtable();
    private Hashtable locationsButtons = new Hashtable();
    private JPanel right;
    private GridBagConstraints rightConstrains;
    private RestLogic logic;
    private TouchMain parent;
    private JLabel waiterName;
    private Insets insets = new Insets(7, 7, 7, 7);
    private EventListener waitersListener;
    private int locatieCurenta;
    private long lastRefresh;

    public LocationPanel(RestLogic logic, TouchMain parent, Vector locations) {
        this.logic = logic;
        this.parent = parent;
        this.init(locations);
        if (VpConfig.getInstance().refreshLocation) {
            Thread refreshTread = new Thread(){

                @Override
                public void run() {
                    while (true) {
                        if (LocationPanel.this.lastRefresh + (long)(VpConfig.getInstance().refreshLocationSeconds * 1000) < System.currentTimeMillis() && LocationPanel.this.locatieCurenta > 0) {
                            LocationPanel.this.refreshLocatie(LocationPanel.this.locatieCurenta);
                        }
                        try {
                            Thread.sleep(1000L);
                        }
                        catch (InterruptedException interruptedException) {
                        }
                    }
                }
            };
            refreshTread.setName("LocationRefreshThread");
            refreshTread.start();
        }
    }

    private void init(Vector locationNames) {
        this.locations = this.logic.getLocationsByLocationNames(locationNames);
        if (this.locations.size() == 0) {
            this.locations = this.logic.getLocations();
        }
        for (Location element : this.locations) {
            JPanel p = this.getLocationPanel(element);
            this.locationsPanels.put(element.getId(), p);
        }
        this.display();
    }

    @Override
    public void cleanup() {
        this.logic.removeListener(this.waitersListener);
    }

    private void display() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 1;
        c.anchor = 10;
        c.insets = new Insets(2, 2, 2, 2);
        c.weightx = 0.0;
        c.weighty = 1.0;
        c.gridx = 0;
        c.gridy = 0;
        JPanel upper = this.getLeftPanel();
        this.add((Component)upper, c);
        c.gridy = 1;
        c.weighty = 0.0;
        JPanel legenda = this.getLegenda();
        this.add((Component)legenda, c);
        c.gridx = 1;
        c.gridy = 0;
        c.gridheight = 2;
        c.weightx = 1.0;
        c.weighty = 1.0;
        this.right = new JPanel(new GridBagLayout());
        this.rightConstrains = this.getRightConstraints();
        int defaultLocId = -1;
        Iterator iter = this.locationsPanels.keySet().iterator();
        if (iter.hasNext()) {
            Integer element = (Integer)iter.next();
            defaultLocId = element;
        }
        this.switchLocation(defaultLocId);
        this.add((Component)this.right, c);
    }

    private GridBagConstraints getRightConstraints() {
        GridBagConstraints c1 = new GridBagConstraints();
        c1.fill = 1;
        c1.anchor = 10;
        c1.insets = this.insets;
        c1.weightx = 1.0;
        c1.weighty = 1.0;
        c1.gridx = 0;
        c1.gridy = 0;
        return c1;
    }

    private JPanel getLocationPanel(Location loc) {
        BackgroundedJPanel result = new BackgroundedJPanel(new GridBagLayout());
        result.setBorder(new TitledBorder(loc.getName()));
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 1;
        c.anchor = 10;
        c.insets = this.insets;
        c.weightx = 1.0;
        c.weighty = 1.0;
        int gridWidth = 5;
        c.gridy = -1;
        c.gridx = 0;
        Vector<Table> tablesForThisLocation = this.logic.getTablesByLocation(loc.getId());
        Iterator iter = tablesForThisLocation.iterator();
        while (iter.hasNext()) {
            if (c.gridx % 5 == 0) {
                ++c.gridy;
                c.gridx = 0;
            }
            final Table element = (Table)iter.next();
            TransparentButton btn = new TransparentButton("<html><center><br>&nbsp;" + element.getLabel() + "<br>&nbsp;</center></html>");
            btn.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    LocationPanel.this.parent.tableSelected(element);
                }
            });
            this.meseButtons.put(element, btn);
            Order o = this.logic.getOpenOrderAtTable(element);
            if (o != null) {
                this.tableStatusChanged(element, o);
            } else {
                this.tableStatusChanged(element, null);
            }
            result.add((Component)btn, c);
            ++c.gridx;
        }
        return result;
    }

    private JPanel getLeftPanel() {
        JPanel result = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        result.setBorder(new TitledBorder(LangRoAll.actiuni));
        c.fill = 1;
        c.anchor = 10;
        c.insets = new Insets(3, 2, 3, 2);
        c.weightx = 0.0;
        c.weighty = 1.0;
        c.gridheight = 1;
        c.gridx = 0;
        c.gridy = 0;
        c.weighty = 0.0;
        DatePanel dp = new DatePanel();
        result.add((Component)dp, c);
        ++c.gridy;
        c.weighty = 1.0;
        this.waiterName = new JLabel(LangRoAll.neautentificat);
        this.waiterName.setForeground(Color.RED);
        this.waiterName.setFont(new Font(null, 1, VpConfig.getInstance().touchSelectorFontSize));
        result.add((Component)this.waiterName, c);
        ++c.gridy;
        for (final Location element : this.locations) {
            TransparentButton loc = new TransparentButton("<html><center>" + element.getName() + "<br></center></html>");
            this.locationsButtons.put(loc, element.getName());
            loc.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    LocationPanel.this.switchLocation(element.getId());
                }
            });
            result.add((Component)loc, c);
            ++c.gridy;
        }
        result.add((Component)new JLabel(""), c);
        ++c.gridy;
        TransparentButton logout = new TransparentButton("<html><center>Logout<br></center></html>");
        logout.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LocationPanel.this.parent.logout();
            }
        });
        result.add((Component)logout, c);
        result.add((Component)new JLabel(""), c);
        ++c.gridy;
        final LocationPanel panel = this;
        TransparentButton note2 = new TransparentButton("<html><center>Retiparire note<br></center></html>");
        note2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Vector orders;
                User supervizor = null;
                if (VpConfig.getInstance().passwordForReprint) {
                    supervizor = UsersLogic.getInstance().requestAdminLogin(GuiUtils.currentFrame, VpConfig.getInstance().allowPasswords, true);
                }
                if (!(supervizor == null && VpConfig.getInstance().passwordForReprint || (orders = LocationPanel.this.logic.getReprintableOrders()).size() <= 0)) {
                    ReprintDialog dia = new ReprintDialog(5, orders);
                    Order o = dia.getSelected();
                    Table t = dia.getTable();
                    if (o == null) {
                        return;
                    }
                    if (DialogUtils.confirmDialog(LocationPanel.this.parent, LangRoAll.tiparimNota, "Nota de plata")) {
                        LocationPanel.this.logic.reprintNota(o, t, null);
                    }
                    if (DialogUtils.confirmDialog(LocationPanel.this.parent, LangRoAll.tiparimBonFiscal, LangRoAll.bonFiscal)) {
                        LocationPanel.this.logic.printBonFiscalSeparat(o, true);
                    }
                }
            }
        });
        result.add((Component)note2, c);
        ++c.gridy;
        if (VpConfig.getInstance().showXButton) {
            TransparentButton xButton = new TransparentButton("<html><center>X<br></center></html>");
            xButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    User supervizor = UsersLogic.getInstance().requestAdminLogin(GuiUtils.currentFrame, VpConfig.getInstance().allowPasswords, true);
                    if (supervizor != null) {
                        boolean canPrint = false;
                        if (supervizor != null) {
                            if (UsersLogic.getInstance().isUserInGroup(supervizor.getId(), "group_bo_users") || VpConfig.getInstance().touch2AllowXReportByWaiters) {
                                canPrint = true;
                            }
                            if (canPrint) {
                                try {
                                    int idLocatie = RestLogic.getIdLocatieForXZReports(LocationPanel.this.logic.getLocations());
                                    LocationPanel.this.logic.printX(1, supervizor, idLocatie);
                                }
                                catch (SQLException e1) {
                                    Logger.logException(this, (Exception)e1);
                                }
                            } else {
                                DialogUtils.errorDialog(LocationPanel.this.parent, LangRoAll.nuAvetiDreptTiparireRaport, LangRoAll.nuPotContinua);
                            }
                        }
                    } else {
                        DialogUtils.errorDialog(LocationPanel.this.parent, LangRoAll.utilizatorSauParolaIncorecta, LangRoAll.nuPotContinua);
                    }
                }
            });
            result.add((Component)xButton, c);
            ++c.gridy;
        }
        if (VpConfig.getInstance().showSearaButton) {
            TransparentButton searaButton = new TransparentButton("<html><center>Seara<br></center></html>");
            searaButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    User supervizor = UsersLogic.getInstance().requestAdminLogin(GuiUtils.currentFrame, VpConfig.getInstance().allowPasswords, true);
                    boolean canPrint = false;
                    if (supervizor != null) {
                        if (UsersLogic.getInstance().isUserInGroup(supervizor.getId(), "group_bo_users") || VpConfig.getInstance().touch2AllowSearaReportByWaiters) {
                            canPrint = true;
                        }
                    } else {
                        DialogUtils.errorDialog(LocationPanel.this.parent, LangRoAll.utilizatorSauParolaIncorecta, LangRoAll.nuPotContinua);
                        return;
                    }
                    if (canPrint) {
                        GuiUtilsRest.searaButtonPressed(panel, LocationPanel.this.logic, 1, supervizor);
                    } else {
                        DialogUtils.errorDialog(LocationPanel.this.parent, LangRoAll.nuAvetiDreptTiparireRaport, LangRoAll.nuPotContinua);
                    }
                }
            });
            result.add((Component)searaButton, c);
            ++c.gridy;
        }
        if (VpConfig.getInstance().showAdminButton) {
            TransparentButton admin = new TransparentButton("<html><center>Administrare<br></center></html>");
            admin.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    GuiUtilsRest.doAdminLogin(RestLogic.getInstance());
                }
            });
            result.add((Component)admin, c);
            ++c.gridy;
        }
        TransparentButton exit = new TransparentButton("<html><center>Exit<br></center></html>");
        exit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (DialogUtils.confirmDialog(panel, LangRoAll.doritiSaInchidetiProgramul, LangRoAll.confirmare)) {
                    Utils.systemExit();
                }
            }
        });
        result.add((Component)exit, c);
        return result;
    }

    private JPanel getLegenda() {
        JPanel result = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        result.setBorder(new TitledBorder(LangRoAll.legenda));
        c.fill = 2;
        c.anchor = 10;
        c.insets = new Insets(3, 2, 3, 2);
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.gridx = 0;
        c.gridy = 0;
        int width = 10;
        int height = 10;
        c.gridy = 0;
        c.gridx = 0;
        FilledRectangle plata = new FilledRectangle(width, height, LAPLATA_COLOR);
        result.add((Component)plata, c);
        c.gridx = 1;
        result.add((Component)new JLabel(LangRoAll.laPlata), c);
        ++c.gridy;
        c.gridx = 0;
        FilledRectangle fidel = new FilledRectangle(width, height, FIDEL_COLOR);
        result.add((Component)fidel, c);
        c.gridx = 1;
        result.add((Component)new JLabel(LangRoAll.clientiFideli), c);
        ++c.gridy;
        c.gridx = 0;
        FilledRectangle busy = new FilledRectangle(width, height, BUSY_COLOR);
        result.add((Component)busy, c);
        c.gridx = 1;
        result.add((Component)new JLabel(LangRoAll.clienti), c);
        ++c.gridy;
        c.gridx = 0;
        FilledRectangle protocol = new FilledRectangle(width, height, PROTOCOL_COLOR);
        result.add((Component)protocol, c);
        c.gridx = 1;
        result.add((Component)new JLabel(LangRoAll.protocol), c);
        return result;
    }

    private void switchLocation(int idLocatie) {
        JPanel p = (JPanel)this.locationsPanels.get(idLocatie);
        this.right.removeAll();
        this.right.add((Component)p, this.rightConstrains);
        this.right.setVisible(false);
        this.refreshLocatie(idLocatie);
        this.right.setVisible(true);
        this.locatieCurenta = idLocatie;
    }

    private synchronized void refreshLocatie(int idLocatie) {
        Vector<Table> tables = this.logic.getTablesByLocation(idLocatie);
        for (Table element : tables) {
            this.tableStatusChanged(element, this.logic.getOpenOrderAtTable(element));
        }
        this.lastRefresh = System.currentTimeMillis();
    }

    public void tableStatusChanged(Table t, Order o) {
        JButton btn = (JButton)this.meseButtons.get(t);
        if (btn == null) {
            return;
        }
        if (o != null) {
            Color c = null;
            c = o.isLaPlata() ? LAPLATA_COLOR : (o.isProtocol() ? PROTOCOL_COLOR : (o.isClientFidel() ? FIDEL_COLOR : BUSY_COLOR));
            btn.setBackground(c);
            User w = UsersLogic.getInstance().getUserById(o.getUser());
            String waiter = "";
            if (w != null) {
                waiter = "<br>" + w.getLogin();
            }
            btn.setText("<html><center>" + t.getLabel() + waiter + "</center></html>");
            btn.setVisible(false);
            btn.setVisible(true);
        } else {
            btn.setBackground(FREE_COLOR);
            btn.setText("<html><center>" + t.getLabel() + "<br></center></html>");
            btn.setVisible(false);
            btn.setVisible(true);
        }
    }

    public void waiterChanged(User newWaiter, User oldUser) {
        if (newWaiter != null) {
            this.waiterName.setText(newWaiter.getLogin());
            this.logic.alertProductie(newWaiter);
            UsersLogic.getInstance().addUserLogCommit(newWaiter.getId(), LangRoAll.login);
        } else {
            this.waiterName.setText(LangRoAll.neautentificat);
            if (oldUser != null) {
                UsersLogic.getInstance().addUserLogCommit(oldUser.getId(), LangRoAll.logout);
            }
        }
    }
}

