/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.restaurant.gui.touch;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.net.MalformedURLException;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JScrollPane;
import javax.swing.border.TitledBorder;
import ro.atreides.restaurant.VpConfig;
import ro.atreides.restaurant.gui.touch.TouchMain;
import ro.atreides.restaurant.logic.RestLogic;
import ro.atreides.users.User;
import ro.atreides.users.UsersLogic;
import ro.atreides.utils.Logger;
import ro.atreides.utils.Utils;
import ro.atreides.utils.gui.keypad.KeypadListener;
import ro.atreides.utils.gui.keypad.VirtualKeypad;
import ro.atreides.utils.multilang.LangRoAll;

public class WaitersSelection
extends JPanel {
    private TouchMain parent;
    private JPasswordField password = new JPasswordField(5);
    private JLabel ospatar = new JLabel("");
    private String parola = "";
    private String codAutentificare = "";
    private int retries = 0;
    private JPanel waitersPanel;
    public static final int MAX_RETRIES = 3;
    private Insets insets = new Insets(4, 4, 4, 4);
    private JPanel rightPanel;
    private boolean controllerMode;

    public WaitersSelection(TouchMain parent, boolean controllerMode) {
        this.parent = parent;
        this.controllerMode = controllerMode;
        this.display();
    }

    private void display() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 10;
        c.insets = this.insets;
        c.weighty = 1.0;
        c.gridwidth = 1;
        c.gridy = 0;
        c.fill = 1;
        c.weightx = 1.0;
        c.gridx = 0;
        this.add((Component)this.getWaitersPanel(), c);
        c.fill = 3;
        c.weightx = 0.0;
        c.gridx = 1;
        this.rightPanel = this.getRightPanel();
        this.add((Component)this.rightPanel, c);
        this.waitersPanel.requestFocus();
    }

    private JPanel getRightPanel() {
        JPanel result = new JPanel(new GridBagLayout());
        result.setBorder(new TitledBorder(LangRoAll.selectie));
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 3;
        c.insets = this.insets;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.gridx = 0;
        c.gridy = 0;
        c.anchor = 17;
        result.add((Component)new JLabel("Ospatar"), c);
        c.gridx = 1;
        this.ospatar = new JLabel("");
        c.anchor = 13;
        result.add((Component)this.ospatar, c);
        c.gridx = 0;
        ++c.gridy;
        c.anchor = 17;
        result.add((Component)new JLabel(LangRoAll.parola), c);
        c.gridx = 1;
        c.anchor = 13;
        this.password.setEditable(false);
        result.add((Component)this.password, c);
        c.gridx = 0;
        ++c.gridy;
        c.gridwidth = 2;
        c.anchor = 10;
        result.add((Component)this.getKeyPad(), c);
        c.gridx = 0;
        ++c.gridy;
        c.gridwidth = 2;
        c.anchor = 15;
        JButton renunta = new JButton(LangRoAll.renunta);
        renunta.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                WaitersSelection.this.ospatar.setText("");
                WaitersSelection.this.setParola("");
                WaitersSelection.this.codAutentificare = "";
                WaitersSelection.this.parent.waiterSelected(null, null);
            }
        });
        result.add((Component)renunta, c);
        return result;
    }

    private JScrollPane getWaitersPanel() {
        this.waitersPanel = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        this.waitersPanel.setBorder(new TitledBorder("Ospatari"));
        c.fill = 1;
        c.anchor = 10;
        c.insets = this.insets;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.gridx = 0;
        c.gridy = 0;
        Vector waiters = RestLogic.getInstance().getWaiters();
        for (User element : waiters) {
            JPanel btn = this.getButtonPanel(element);
            this.waitersPanel.add((Component)btn, c);
            ++c.gridx;
            if (c.gridx != VpConfig.getInstance().waitersPerLine) continue;
            c.gridx = 0;
            ++c.gridy;
        }
        this.waitersPanel.addKeyListener(new KeyListener(){

            @Override
            public void keyPressed(KeyEvent e) {
            }

            @Override
            public void keyReleased(KeyEvent e) {
            }

            @Override
            public void keyTyped(KeyEvent e) {
                WaitersSelection.this.codAutentificare = WaitersSelection.this.codAutentificare + String.valueOf(e.getKeyChar());
                if (WaitersSelection.this.codAutentificare.length() == VpConfig.getInstance().codAutentificareLength) {
                    WaitersSelection.this.tryLogin(true, WaitersSelection.this.controllerMode);
                    WaitersSelection.this.codAutentificare = "";
                }
            }
        });
        this.waitersPanel.setFocusable(true);
        return new JScrollPane(this.waitersPanel);
    }

    public void focus() {
        this.waitersPanel.requestFocus();
    }

    private void setWaiter(User element) {
        this.ospatar.setText(element.getLogin());
        boolean passwordNeeded = VpConfig.getInstance().requestPasswordForWaitersSelection;
        if (!passwordNeeded || this.controllerMode) {
            this.tryLogin(passwordNeeded, this.controllerMode);
        }
    }

    private JPanel getButtonPanel(final User element) {
        JPanel result = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 0;
        c.anchor = 10;
        c.insets = this.insets;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.gridx = 0;
        c.gridy = 0;
        ImageIcon img = null;
        try {
            img = Utils.getImageFromDisk(element.getLogin() + ".gif");
        }
        catch (MalformedURLException e2) {
            Logger.logException(this, (Exception)e2);
            img = null;
        }
        if (img == null) {
            img = Utils.getImageResource("nobody.gif");
        }
        JButton btn = new JButton(img);
        btn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                WaitersSelection.this.setWaiter(element);
            }
        });
        result.add((Component)btn, c);
        ++c.gridy;
        result.add((Component)new JLabel(element.getLogin()), c);
        return result;
    }

    private JPanel getKeyPad() {
        VirtualKeypad kp = new VirtualKeypad(VpConfig.getInstance().touchSelectorFontSize);
        kp.addKeypadListener(new KeypadListener(){

            @Override
            public void keypadPressed(int digit) {
                String p = WaitersSelection.this.parola + digit;
                WaitersSelection.this.setParola(p);
            }

            @Override
            public void okPressed() {
                WaitersSelection.this.tryLogin(true, WaitersSelection.this.controllerMode);
            }

            @Override
            public void backspace() {
                if (WaitersSelection.this.parola.length() > 0) {
                    String p = WaitersSelection.this.parola.substring(0, WaitersSelection.this.parola.length() - 1);
                    WaitersSelection.this.setParola(p);
                }
            }

            @Override
            public void enterPressed() {
            }

            @Override
            public void decimalPressed() {
            }
        });
        return kp;
    }

    private void tryLogin(boolean passwordRequested, boolean controllerMode) {
        UsersLogic ul = UsersLogic.getInstance();
        String user = this.ospatar.getText();
        boolean allowPasswords = VpConfig.getInstance().allowPasswords;
        if (controllerMode) {
            passwordRequested = false;
            allowPasswords = true;
        }
        User u = UsersLogic.getInstance().verifyWaiterLogin(user, this.parola, this.codAutentificare, allowPasswords, passwordRequested);
        User boUser = UsersLogic.getInstance().verifyAdminLogin(user, this.parola, this.codAutentificare, allowPasswords, passwordRequested);
        this.setParola("");
        if (u != null || boUser != null) {
            this.ospatar.setText("");
            this.parent.waiterSelected(u, boUser);
        } else {
            ++this.retries;
            if (this.retries >= 3) {
                this.retries = 0;
                this.ospatar.setText("");
                this.setParola("");
                this.parent.waiterSelected(null, null);
            }
        }
    }

    private void setParola(String newPass) {
        this.parola = newPass;
        this.password.setText(this.parola);
    }
}

