/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.restaurant.gui.touch2;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Vector;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;
import org.tigris.gef.base.Editor;
import ro.atreides.gef.DiagramPanel;
import ro.atreides.gef.DmiInterface;
import ro.atreides.gef.data.DataInterfaceImpl;
import ro.atreides.gef.utils.FigAdder;
import ro.atreides.gef.utils.xml.XmlUtils;
import ro.atreides.restaurant.VpConfig;
import ro.atreides.restaurant.base.Table;
import ro.atreides.restaurant.gui.GuiUtilsRest;
import ro.atreides.restaurant.gui.ReprintDialog;
import ro.atreides.restaurant.gui.touch2.TouchMain2;
import ro.atreides.restaurant.logic.ColorChooserInterface;
import ro.atreides.restaurant.logic.RestLogic;
import ro.atreides.users.User;
import ro.atreides.users.UsersLogic;
import ro.atreides.utils.CleanupRequired;
import ro.atreides.utils.Location;
import ro.atreides.utils.Logger;
import ro.atreides.utils.Order;
import ro.atreides.utils.PointerLaFunctieInterface;
import ro.atreides.utils.TextUtils;
import ro.atreides.utils.Utils;
import ro.atreides.utils.gui.DatePanel;
import ro.atreides.utils.gui.FilledRectangle;
import ro.atreides.utils.gui.GuiUtils;
import ro.atreides.utils.gui.TransparentButton;
import ro.atreides.utils.gui.Validators;
import ro.atreides.utils.gui.dialogs.CardInputDialog;
import ro.atreides.utils.gui.dialogs.DialogUtils;
import ro.atreides.utils.multilang.LangRoAll;

public class LocationPanel2
extends JPanel
implements CleanupRequired,
ColorChooserInterface {
    public static final Color FIDEL_COLOR = Color.ORANGE;
    public static final Color LAPLATA_COLOR = Color.RED;
    public static final Color PROTOCOL_COLOR = Color.GREEN;
    public static final Color BUSY_COLOR = Color.YELLOW;
    public static final Color FREE_COLOR = Color.WHITE;
    private Collection locations;
    private JPanel right;
    private GridBagConstraints rightConstrains;
    private TouchMain2 parent;
    private JLabel waiterName;
    private User waiterLoggedIn;
    private Insets insets = new Insets(7, 7, 7, 7);
    private int locatieCurenta;
    private long lastRefresh;
    private boolean editMode = false;
    private static final String locatiiFile = "locatii.xml";
    DiagramPanel currentDiagram = null;
    int idDiagram = -1;
    int diagramLevel = -1;
    private static final int LEVEL_LOCATII = 1;
    private static final int LEVEL_MESE = 2;
    private DmiInterface tableInterf;
    private TransparentButton plan;
    private TransparentButton fullScreenButton;
    private RestLogic logic;
    private int whatToPrint = 1;
    private static final String fullScreenOn = "<html><center>" + LangRoAll.peTotEcranul + "<br></center></html>";
    private static final String fullScreenOff = "<html><center>" + LangRoAll.modFereastra + "<br></center></html>";

    public LocationPanel2(RestLogic logic, TouchMain2 parent, Vector locations) {
        this.logic = logic;
        this.parent = parent;
        this.init(locations);
        if (VpConfig.getInstance().refreshLocation) {
            Thread refreshTread = new Thread(){

                @Override
                public void run() {
                    try {
                        Thread.sleep(15000L);
                    }
                    catch (InterruptedException e) {
                        // empty catch block
                    }
                    while (true) {
                        if (LocationPanel2.this.lastRefresh + (long)(VpConfig.getInstance().refreshLocationSeconds * 1000) < System.currentTimeMillis() && LocationPanel2.this.locatieCurenta > 0) {
                            LocationPanel2.this.refreshLocatie(LocationPanel2.this.locatieCurenta);
                        }
                        try {
                            Thread.sleep(1000L);
                        }
                        catch (InterruptedException interruptedException) {
                        }
                    }
                }
            };
            refreshTread.setName("LocationRefreshThread");
            refreshTread.start();
        }
    }

    private void init(Vector locationNames) {
        this.logic = RestLogic.getInstance();
        this.locations = this.logic.getLocationsByLocationNames(locationNames);
        if (this.locations.size() == 0) {
            this.locations = this.logic.getLocations();
        }
        this.tableInterf = new DmiInterface(){

            @Override
            public void buttonPush(String numeMasa) {
                Table t = LocationPanel2.this.logic.getTableByLocatieAndName(LocationPanel2.this.locatieCurenta, numeMasa);
                LocationPanel2.this.parent.tableSelected(t);
            }

            @Override
            public boolean canDelete(String numeMasa) {
                Table t = LocationPanel2.this.logic.getTableByLocatieAndName(LocationPanel2.this.locatieCurenta, numeMasa);
                if (t != null) {
                    Order o = LocationPanel2.this.logic.getOpenOrderAtTable(t);
                    if (o == null) {
                        LocationPanel2.this.logic.deleteTable(t);
                        return true;
                    }
                    return false;
                }
                return true;
            }

            @Override
            public boolean add(String numeTable, int tip, int locuri, boolean virtuala, String detalii) {
                if (!Validators.correctString(numeTable)) {
                    return false;
                }
                String xmlEscaped = TextUtils.escapeForXMLStripQuote(numeTable);
                if (!numeTable.equalsIgnoreCase(xmlEscaped)) {
                    return false;
                }
                if (LocationPanel2.this.logic.getTableByLocatieAndName(LocationPanel2.this.locatieCurenta, numeTable) == null) {
                    LocationPanel2.this.logic.newTable(numeTable, locuri, virtuala, detalii, LocationPanel2.this.locatieCurenta);
                    return true;
                }
                return false;
            }

            @Override
            public boolean canModify(String oldName, String newName, int newNrLocuri, boolean virtuala, String detalii) {
                if (!Validators.correctString(newName)) {
                    return false;
                }
                String xmlEscaped = TextUtils.escapeForXMLStripQuote(newName);
                if (!newName.equalsIgnoreCase(xmlEscaped)) {
                    return false;
                }
                if (!newName.equals(oldName) && LocationPanel2.this.logic.getTableByLocatieAndName(LocationPanel2.this.locatieCurenta, newName) != null) {
                    return false;
                }
                Table t = LocationPanel2.this.logic.getTableByLocatieAndName(LocationPanel2.this.locatieCurenta, oldName);
                if (t != null) {
                    t.setLabel(newName);
                    LocationPanel2.this.logic.updateTable(newName, newNrLocuri, virtuala, detalii, t.getId());
                    return true;
                }
                return false;
            }

            @Override
            public JFrame getMainFrame() {
                return GuiUtils.currentFrame;
            }
        };
        this.display();
    }

    @Override
    public void cleanup() {
    }

    private void display() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 1;
        c.anchor = 10;
        c.insets = new Insets(2, 2, 2, 2);
        c.weightx = 0.0;
        c.weighty = 1.0;
        c.gridx = 0;
        c.gridy = 0;
        JPanel upper = this.getLeftPanel();
        this.add((Component)upper, c);
        c.gridy = 1;
        c.weighty = 0.0;
        JPanel legenda = new JPanel();
        if (VpConfig.getInstance().showLegendaPanel) {
            legenda = this.getLegenda();
        }
        this.add((Component)legenda, c);
        c.gridx = 1;
        c.gridy = 0;
        c.gridheight = 2;
        c.weightx = 1.0;
        c.weighty = 1.0;
        this.right = new JPanel(new GridBagLayout());
        this.rightConstrains = this.getRightConstraints();
        this.add((Component)this.right, c);
        this.plan.doClick();
    }

    private GridBagConstraints getRightConstraints() {
        GridBagConstraints c1 = new GridBagConstraints();
        c1.fill = 1;
        c1.anchor = 10;
        c1.insets = this.insets;
        c1.weightx = 1.0;
        c1.weighty = 1.0;
        c1.gridx = 0;
        c1.gridy = 0;
        return c1;
    }

    public void tableStatusChanged(Table t, Order o) {
        this.logic.tableStatusChangedCommit(t, o, this.currentDiagram, this);
    }

    @Override
    public Color[] getColorOrderAndUser(Order o, User u) {
        Color borderColor = null;
        borderColor = o.isLaPlata() ? LAPLATA_COLOR : (o.isProtocol() ? PROTOCOL_COLOR : (o.isClientFidel() ? FIDEL_COLOR : BUSY_COLOR));
        Color fillColor = LocationPanel2.getColorForUser(u);
        if (VpConfig.getInstance().touch2SwitchColors) {
            Color sw = borderColor;
            borderColor = fillColor;
            fillColor = sw;
        }
        Color[] result = new Color[]{fillColor, borderColor};
        return result;
    }

    public static Color getColorForUser(User u) {
        Color fillColor = Color.WHITE;
        switch (u.getId() % 9) {
            case 0: {
                fillColor = Color.YELLOW;
                break;
            }
            case 1: {
                fillColor = Color.BLUE;
                break;
            }
            case 2: {
                fillColor = Color.CYAN;
                break;
            }
            case 3: {
                fillColor = Color.GREEN;
                break;
            }
            case 4: {
                fillColor = Color.LIGHT_GRAY;
                break;
            }
            case 5: {
                fillColor = Color.MAGENTA;
                break;
            }
            case 6: {
                fillColor = Color.ORANGE;
                break;
            }
            case 7: {
                fillColor = Color.PINK;
                break;
            }
            case 8: {
                fillColor = Color.RED;
                break;
            }
        }
        return fillColor;
    }

    private void loadLocatiiDiagram(boolean edit) {
        final LocationPanel2 locationPanel2 = this;
        DmiInterface locatiiInterface = new DmiInterface(){

            @Override
            public void buttonPush(String numeLocatie) {
                Location l = LocationPanel2.this.logic.getLocationByName(numeLocatie);
                if (!LocationPanel2.this.locations.contains(l)) {
                    DialogUtils.errorDialog(LocationPanel2.this.parent, LangRoAll.nuAvetiAccesLaAceastaLocatie, LangRoAll.nuPotContinua);
                    return;
                }
                DiagramPanel locationPanel = new DiagramPanel(numeLocatie, LocationPanel2.this.tableInterf);
                String tablesFile = numeLocatie + ".xml";
                int id = LocationPanel2.this.logic.saveDiagramToDiskFromDb(tablesFile);
                if (id == -1) {
                    LocationPanel2.this.logic.generateRandomTableDiagram(tablesFile, l.getId());
                    id = LocationPanel2.this.logic.addDiagramToDb(tablesFile, "");
                }
                Editor editor = locationPanel.getEditor();
                Vector figures = XmlUtils.getFigures(tablesFile, new DataInterfaceImpl(locationPanel.getGraph(), LocationPanel2.this.tableInterf));
                FigAdder.addFigs(editor, figures);
                locationPanel.setEditable(false);
                LocationPanel2.this.currentDiagram = locationPanel;
                LocationPanel2.this.diagramLevel = 2;
                LocationPanel2.this.idDiagram = id;
                LocationPanel2.this.logic.refreshTablesForLocation(locationPanel2, l, LocationPanel2.this.currentDiagram);
                LocationPanel2.this.currentDiagram.setAllMasaFontSize(VpConfig.getInstance().touch2TablesFontSize);
                LocationPanel2.this.switchLocation(locationPanel, l.getId());
            }

            @Override
            public boolean canDelete(String nume) {
                Location l = LocationPanel2.this.logic.getLocationByName(nume);
                if (l != null) {
                    Vector<Table> tables = LocationPanel2.this.logic.getTablesByLocation(l.getId());
                    if (l.getTip() == 2) {
                        return false;
                    }
                    return tables.size() == 0;
                }
                return true;
            }

            @Override
            public boolean add(String nume, int tip, int locuri, boolean virtuala, String detalii) {
                if (!Validators.correctString(nume)) {
                    return false;
                }
                String xmlEscaped = TextUtils.escapeForXMLStripQuote(nume);
                if (!nume.equalsIgnoreCase(xmlEscaped)) {
                    return false;
                }
                Location l = LocationPanel2.this.logic.getLocationByName(nume);
                if (l != null) {
                    return false;
                }
                LocationPanel2.this.logic.addLocation(nume, tip, nume);
                DialogUtils.okDialog(LocationPanel2.this.parent, LangRoAll.configuratiDescarcareStoculuiLocatieNoua, LangRoAll.atentie);
                DialogUtils.okDialog(LocationPanel2.this.parent, LangRoAll.configuratiNotelePlataLocatieNoua, LangRoAll.atentie);
                return true;
            }

            @Override
            public boolean canModify(String oldName, String newName, int newNrLocuri, boolean virtuala, String detalii) {
                if (!Validators.correctString(newName)) {
                    return false;
                }
                String xmlEscaped = TextUtils.escapeForXMLStripQuote(newName);
                if (!newName.equalsIgnoreCase(xmlEscaped)) {
                    return false;
                }
                Location l = LocationPanel2.this.logic.getLocationByName(newName);
                if (!newName.equals(oldName) && l != null) {
                    return false;
                }
                l = LocationPanel2.this.logic.getLocationByName(oldName);
                if (l != null) {
                    LocationPanel2.this.logic.updateLocation(newName, oldName, l.getId());
                    return true;
                }
                return false;
            }

            @Override
            public JFrame getMainFrame() {
                return GuiUtils.currentFrame;
            }
        };
        DiagramPanel diagramPanel = new DiagramPanel(LangRoAll.locatii, locatiiInterface);
        int id = this.logic.saveDiagramToDiskFromDb(locatiiFile);
        if (id == -1) {
            this.logic.generateRandomLocatiiDiagram(locatiiFile);
            id = this.logic.addDiagramToDb(locatiiFile, "");
        }
        Editor editor = diagramPanel.getEditor();
        Vector figures = XmlUtils.getFigures(locatiiFile, new DataInterfaceImpl(diagramPanel.getGraph(), locatiiInterface));
        FigAdder.addFigs(editor, figures);
        diagramPanel.setEditable(edit);
        this.reloadPlan(diagramPanel);
        this.currentDiagram = diagramPanel;
        this.currentDiagram.setAllMasaFontSize(VpConfig.getInstance().touch2TablesFontSize);
        this.idDiagram = id;
        this.diagramLevel = 1;
    }

    private void switchMode() {
        switch (this.whatToPrint) {
            case 1: {
                this.whatToPrint = 2;
                break;
            }
            case 2: {
                this.whatToPrint = 3;
                break;
            }
            case 3: {
                this.whatToPrint = 1;
            }
        }
        this.updateWaiterFont();
    }

    private void updateWaiterFont() {
        Font f = this.waiterName.getFont();
        Font f1 = null;
        switch (this.whatToPrint) {
            case 1: {
                f1 = new Font(f.getName(), 1, f.getSize());
                break;
            }
            case 2: {
                f1 = new Font(f.getName(), 0, f.getSize());
                break;
            }
            case 3: {
                f1 = new Font(f.getName(), 2, f.getSize());
                break;
            }
        }
        this.waiterName.setFont(f1);
    }

    private JPanel getLeftPanel() {
        TransparentButton xButton;
        JPanel result = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        result.setBorder(new TitledBorder(LangRoAll.actiuni));
        c.fill = 1;
        c.anchor = 10;
        c.insets = new Insets(3, 2, 3, 2);
        c.weightx = 0.0;
        c.weighty = 1.0;
        c.gridheight = 1;
        c.gridx = 0;
        c.gridy = 0;
        c.weighty = 0.0;
        DatePanel dp = new DatePanel();
        result.add((Component)dp, c);
        ++c.gridy;
        c.weighty = 1.0;
        this.waiterName = new JLabel(LangRoAll.neautentificat);
        this.waiterName.setFocusable(true);
        this.waiterName.setForeground(Color.RED);
        this.waiterName.setFont(new Font(null, 1, VpConfig.getInstance().touchSelectorFontSize));
        if (VpConfig.getInstance().piratMode) {
            this.whatToPrint = 2;
            this.updateWaiterFont();
            GuiUtilsRest.addPiratGuiMouseListenerForLabels(this.waiterName, new PointerLaFunctieInterface(){

                @Override
                public void doStuff() {
                    LocationPanel2.this.switchMode();
                    LocationPanel2.this.parent.requestFocus();
                }
            });
        }
        result.add((Component)this.waiterName, c);
        ++c.gridy;
        final LocationPanel2 panel = this;
        ++c.gridy;
        this.plan = new TransparentButton("<html><center>" + LangRoAll.plan + "<br></center></html>");
        this.plan.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LocationPanel2.this.loadLocatiiDiagram(false);
            }
        });
        result.add((Component)this.plan, c);
        ++c.gridy;
        final String modificaString = "<html><center>" + LangRoAll.modifica + "<br></center></html>";
        final String salveazaString = "<html><center>" + LangRoAll.salveaza + "<br></center></html>";
        final TransparentButton modifica = new TransparentButton(modificaString);
        modifica.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!LocationPanel2.this.editMode) {
                    User supervizor = null;
                    if (VpConfig.getInstance().passwordForAranjareMese) {
                        supervizor = UsersLogic.getInstance().requestAdminLogin(GuiUtils.currentFrame, VpConfig.getInstance().allowPasswords, true);
                    }
                    if (supervizor != null || !VpConfig.getInstance().passwordForAranjareMese) {
                        LocationPanel2.this.currentDiagram.setEditable(true);
                        LocationPanel2.this.plan.setEnabled(false);
                        modifica.setText(salveazaString);
                        modifica.setForeground(Color.RED);
                        LocationPanel2.this.editMode = true;
                    }
                } else {
                    Editor editor = LocationPanel2.this.currentDiagram.getEditor();
                    String file = "";
                    if (LocationPanel2.this.diagramLevel == 1) {
                        file = LocationPanel2.locatiiFile;
                    } else if (LocationPanel2.this.diagramLevel == 2) {
                        file = LocationPanel2.this.currentDiagram.getDiagramName() + ".xml";
                    }
                    if (XmlUtils.saveFigures(file, editor)) {
                        LocationPanel2.this.logic.updateDiagramToDb(LocationPanel2.this.idDiagram, file, "");
                        LocationPanel2.this.currentDiagram.setEditable(false);
                        modifica.setText(modificaString);
                        modifica.setForeground(Color.BLACK);
                        LocationPanel2.this.editMode = false;
                        LocationPanel2.this.plan.setEnabled(true);
                    }
                }
            }
        });
        result.add((Component)modifica, c);
        result.add((Component)new JLabel(""), c);
        ++c.gridy;
        TransparentButton logout = new TransparentButton("<html><center>" + LangRoAll.logout + "<br></center></html>");
        logout.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LocationPanel2.this.parent.logout();
            }
        });
        result.add((Component)logout, c);
        result.add((Component)new JLabel(""), c);
        ++c.gridy;
        if (VpConfig.getInstance().showRetiparireNoteButton) {
            TransparentButton note2 = new TransparentButton("<html><center>" + LangRoAll.retiparireNote + "<br></center></html>");
            note2.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Vector orders;
                    User supervizor = null;
                    if (VpConfig.getInstance().passwordForReprint) {
                        supervizor = UsersLogic.getInstance().requestAdminLogin(GuiUtils.currentFrame, VpConfig.getInstance().allowPasswords, true);
                    }
                    if (!(supervizor == null && VpConfig.getInstance().passwordForReprint || (orders = LocationPanel2.this.logic.getReprintableOrders()).size() <= 0)) {
                        ReprintDialog dia = new ReprintDialog(5, orders);
                        Order o = dia.getSelected();
                        Table t = dia.getTable();
                        if (o == null) {
                            return;
                        }
                        if (DialogUtils.confirmDialog(LocationPanel2.this.parent, LangRoAll.tiparimNota, LangRoAll.confirmare)) {
                            LocationPanel2.this.logic.reprintNota(o, t, null);
                        }
                        if (DialogUtils.confirmDialog(LocationPanel2.this.parent, LangRoAll.tiparimBonFiscal, LangRoAll.confirmare)) {
                            LocationPanel2.this.logic.printBonFiscalSeparat(o, true);
                        }
                    }
                }
            });
            result.add((Component)note2, c);
            ++c.gridy;
        }
        if (VpConfig.getInstance().showXButton && VpConfig.getInstance().zUserNewPrintingSystem) {
            TransparentButton xnouButton = new TransparentButton("<html><center>X nou<br></center></html>");
            xnouButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    User user = UsersLogic.getInstance().requestLogin(GuiUtils.currentFrame, VpConfig.getInstance().allowPasswords, true);
                    boolean isAdmin = false;
                    boolean isWaiter = false;
                    if (user != null) {
                        boolean canPrint = false;
                        if (user != null) {
                            if (UsersLogic.getInstance().isUserInGroup(user.getId(), "group_bo_users")) {
                                isAdmin = true;
                            }
                            if (!isAdmin && VpConfig.getInstance().touch2AllowXReportByWaiters) {
                                isWaiter = true;
                            }
                            if (isWaiter || isAdmin) {
                                canPrint = true;
                            }
                        }
                        if (canPrint) {
                            try {
                                int w1 = LocationPanel2.this.whatToPrint;
                                if (VpConfig.getInstance().piratMode && VpConfig.getInstance().dualModeAllowFullXReport) {
                                    w1 = 1;
                                }
                                LocationPanel2.this.logic.printXnou(w1, user, panel, isAdmin, isWaiter);
                                if (VpConfig.getInstance().piratMode) {
                                    LocationPanel2.this.whatToPrint = 2;
                                    LocationPanel2.this.updateWaiterFont();
                                }
                            }
                            catch (SQLException e1) {
                                Logger.logException(this, (Exception)e1);
                            }
                        } else {
                            DialogUtils.errorDialog(LocationPanel2.this.parent, LangRoAll.nuAvetiDreptTiparireRaport, LangRoAll.nuPotContinua);
                        }
                    } else {
                        DialogUtils.errorDialog(LocationPanel2.this.parent, LangRoAll.utilizatorSauParolaIncorecta, LangRoAll.nuPotContinua);
                    }
                }
            });
            result.add((Component)xnouButton, c);
            ++c.gridy;
        }
        if (VpConfig.getInstance().showXButton && !VpConfig.getInstance().zUserNewPrintingSystem) {
            xButton = new TransparentButton("<html><center>X<br></center></html>");
            xButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    User supervizor = UsersLogic.getInstance().requestLogin(GuiUtils.currentFrame, VpConfig.getInstance().allowPasswords, true);
                    if (supervizor != null) {
                        boolean canPrint = false;
                        if (supervizor != null && (UsersLogic.getInstance().isUserInGroup(supervizor.getId(), "group_bo_users") || VpConfig.getInstance().touch2AllowXReportByWaiters)) {
                            canPrint = true;
                        }
                        if (canPrint) {
                            try {
                                int w1 = LocationPanel2.this.whatToPrint;
                                if (VpConfig.getInstance().piratMode && VpConfig.getInstance().dualModeAllowFullXReport) {
                                    w1 = 1;
                                }
                                int idLocatie = RestLogic.getIdLocatieForXZReports(LocationPanel2.this.logic.getLocations());
                                LocationPanel2.this.logic.printX(w1, supervizor, idLocatie);
                                if (VpConfig.getInstance().piratMode) {
                                    LocationPanel2.this.whatToPrint = 2;
                                    LocationPanel2.this.updateWaiterFont();
                                }
                            }
                            catch (SQLException e1) {
                                Logger.logException(this, (Exception)e1);
                            }
                        } else {
                            DialogUtils.errorDialog(LocationPanel2.this.parent, LangRoAll.nuAvetiDreptTiparireRaport, LangRoAll.nuPotContinua);
                        }
                    } else {
                        DialogUtils.errorDialog(LocationPanel2.this.parent, LangRoAll.utilizatorSauParolaIncorecta, LangRoAll.nuPotContinua);
                    }
                }
            });
            result.add((Component)xButton, c);
            ++c.gridy;
        }
        if (VpConfig.getInstance().showX2Button) {
            xButton = new TransparentButton("<html><center>" + LangRoAll.ajutor + "<br></center></html>");
            xButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    CardInputDialog dialog = new CardInputDialog(GuiUtils.currentFrame, true, VpConfig.getInstance().codAutentificareLength, LangRoAll.nuPotContinua, LangRoAll.functieNeimplementata);
                    dialog.setVisible(true);
                    User user = UsersLogic.getInstance().getUser("", "", dialog.getCodAutentificare(), VpConfig.getInstance().allowPasswords, true);
                    if (user != null) {
                        boolean canPrint = false;
                        if (user != null) {
                            if (UsersLogic.getInstance().isUserInGroup(user.getId(), "group_bo_users") || VpConfig.getInstance().touch2AllowXReportByWaiters) {
                                canPrint = true;
                            }
                        } else {
                            canPrint = true;
                        }
                        if (canPrint) {
                            try {
                                int idLocatie = RestLogic.getIdLocatieForXZReports(LocationPanel2.this.logic.getLocations());
                                LocationPanel2.this.logic.printX(LocationPanel2.this.whatToPrint, user, idLocatie);
                                if (VpConfig.getInstance().piratMode) {
                                    LocationPanel2.this.whatToPrint = 2;
                                    LocationPanel2.this.updateWaiterFont();
                                }
                            }
                            catch (SQLException e1) {
                                Logger.logException(this, (Exception)e1);
                            }
                        } else {
                            DialogUtils.errorDialog(LocationPanel2.this.parent, LangRoAll.nuAvetiDreptTiparireRaport, LangRoAll.nuPotContinua);
                        }
                    }
                }
            });
            result.add((Component)xButton, c);
            ++c.gridy;
        }
        if (VpConfig.getInstance().showSearaButton) {
            TransparentButton searaButton = new TransparentButton("<html><center>" + LangRoAll.seara + "<br></center></html>");
            searaButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    User supervizor = UsersLogic.getInstance().requestLogin(GuiUtils.currentFrame, VpConfig.getInstance().allowPasswords, true);
                    boolean canPrint = false;
                    if (supervizor != null) {
                        if (UsersLogic.getInstance().isUserInGroup(supervizor.getId(), "group_bo_users") || VpConfig.getInstance().touch2AllowSearaReportByWaiters) {
                            canPrint = true;
                        }
                    } else {
                        DialogUtils.okFocusEaterDialog(LangRoAll.utilizatorSauParolaIncorecta, LangRoAll.nuPotContinua);
                        return;
                    }
                    if (canPrint) {
                        GuiUtilsRest.searaButtonPressed(panel, LocationPanel2.this.logic, LocationPanel2.this.whatToPrint, supervizor);
                        if (VpConfig.getInstance().piratMode) {
                            LocationPanel2.this.whatToPrint = 2;
                            LocationPanel2.this.updateWaiterFont();
                        }
                    } else {
                        DialogUtils.okFocusEaterDialog(LangRoAll.nuAvetiDreptTiparireRaport, LangRoAll.nuPotContinua);
                    }
                }
            });
            result.add((Component)searaButton, c);
            ++c.gridy;
        }
        if (VpConfig.getInstance().showAdminButton) {
            TransparentButton admin = new TransparentButton("<html><center>" + LangRoAll.administrare + "<br></center></html>");
            admin.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (VpConfig.getInstance().touch2InhibitAdminButton) {
                        DialogUtils.errorDialog(LocationPanel2.this.parent, LangRoAll.achizitionatiModululDeGestiune, LangRoAll.nuPotContinua);
                    } else {
                        GuiUtilsRest.doAdminLogin(LocationPanel2.this.logic);
                    }
                }
            });
            result.add((Component)admin, c);
            ++c.gridy;
        }
        if (VpConfig.getInstance().touch2ShowFullScreenButton) {
            this.fullScreenButton = new TransparentButton(fullScreenOn);
            this.fullScreenButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    LocationPanel2.this.switchFullScreen();
                }
            });
            result.add((Component)this.fullScreenButton, c);
            ++c.gridy;
        }
        TransparentButton exit = new TransparentButton("<html><center>" + LangRoAll.exit + "<br></center></html>");
        exit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                User supervizor = null;
                if (VpConfig.getInstance().touch2PasswordForExit) {
                    supervizor = UsersLogic.getInstance().requestAdminLogin(GuiUtils.currentFrame, VpConfig.getInstance().allowPasswords, true);
                }
                if ((supervizor != null || !VpConfig.getInstance().touch2PasswordForExit) && DialogUtils.confirmDialog(panel, LangRoAll.doritiSaInchidetiProgramul, LangRoAll.confirmare)) {
                    Utils.systemExit();
                }
            }
        });
        result.add((Component)exit, c);
        return result;
    }

    private void switchFullScreen() {
        if (this.fullScreenButton.getText().equalsIgnoreCase(fullScreenOn)) {
            GuiUtilsRest.switchToFullScreen();
            this.fullScreenButton.setText(fullScreenOff);
        } else {
            User supervizor = null;
            if (VpConfig.getInstance().touch2PasswordForExitFullScreen) {
                supervizor = UsersLogic.getInstance().requestAdminLogin(GuiUtils.currentFrame, VpConfig.getInstance().allowPasswords, true);
            }
            if (supervizor != null || !VpConfig.getInstance().touch2PasswordForExitFullScreen) {
                GuiUtilsRest.switchToWindowMode();
                this.fullScreenButton.setText(fullScreenOn);
            }
        }
    }

    protected JPanel getLegenda() {
        JPanel result = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        result.setBorder(new TitledBorder(LangRoAll.legenda));
        c.fill = 2;
        c.anchor = 10;
        c.insets = new Insets(3, 2, 3, 2);
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.gridx = 0;
        c.gridy = 0;
        int width = 10;
        int height = 10;
        c.gridy = 0;
        c.gridx = 0;
        FilledRectangle plata = new FilledRectangle(width, height, LAPLATA_COLOR);
        result.add((Component)plata, c);
        c.gridx = 1;
        result.add((Component)new JLabel(LangRoAll.laPlata), c);
        ++c.gridy;
        c.gridx = 0;
        FilledRectangle fidel = new FilledRectangle(width, height, FIDEL_COLOR);
        result.add((Component)fidel, c);
        c.gridx = 1;
        result.add((Component)new JLabel(LangRoAll.clientiFideli), c);
        ++c.gridy;
        c.gridx = 0;
        FilledRectangle busy = new FilledRectangle(width, height, BUSY_COLOR);
        result.add((Component)busy, c);
        c.gridx = 1;
        result.add((Component)new JLabel(LangRoAll.clienti), c);
        ++c.gridy;
        c.gridx = 0;
        FilledRectangle protocol = new FilledRectangle(width, height, PROTOCOL_COLOR);
        result.add((Component)protocol, c);
        c.gridx = 1;
        result.add((Component)new JLabel(LangRoAll.protocol), c);
        return result;
    }

    private void reloadPlan(JPanel newPlan) {
        this.right.setVisible(false);
        this.right.removeAll();
        this.right.add((Component)newPlan, this.rightConstrains);
        this.right.setVisible(true);
    }

    void switchLocation(JPanel panel, int idLocatie) {
        Location l = this.logic.getLocationById(idLocatie);
        this.parent.setWaitersPanelType(l.getTip());
        this.right.removeAll();
        this.right.add((Component)panel, this.rightConstrains);
        this.right.setVisible(false);
        this.refreshLocatie(idLocatie);
        this.right.setVisible(true);
        this.locatieCurenta = idLocatie;
    }

    private synchronized void refreshLocatie(int idLocatie) {
        this.logic.refreshLocations(idLocatie, this.currentDiagram, this);
        this.lastRefresh = System.currentTimeMillis();
    }

    public synchronized void refreshLocatieCurenta() {
        this.refreshLocatie(this.locatieCurenta);
    }

    public void waiterChanged(User newWaiter, User oldUser) {
        if (newWaiter != null) {
            this.waiterName.setText(newWaiter.getLogin());
            this.logic.alertProductie(newWaiter);
            UsersLogic.getInstance().addUserLogCommit(newWaiter.getId(), LangRoAll.login);
            this.waiterLoggedIn = newWaiter;
        } else {
            this.waiterName.setText(LangRoAll.neautentificat);
            this.waiterLoggedIn = null;
            if (oldUser != null) {
                UsersLogic.getInstance().addUserLogCommit(oldUser.getId(), LangRoAll.logout);
            }
        }
    }
}

