/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.restaurant.gui.touch2;

import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import ro.atreides.restaurant.gui.touch2.TipPlataPanelInterface;
import ro.atreides.restaurant.logic.OrderEvent;
import ro.atreides.restaurant.logic.RestLogic;
import ro.atreides.utils.Utils;
import ro.atreides.utils.gui.Validators;
import ro.atreides.utils.gui.dialogs.DialogUtils;
import ro.atreides.utils.multilang.LangRoAll;
import ro.atreides.utils.plati.Plata;
import ro.atreides.utils.plati.TipPlata;

public class TipPlataPanelNew
extends JPanel {
    private JButton[] buttons;
    private Hashtable<Integer, JLabel> platiLabel = new Hashtable();
    private JLabel restText = new JLabel();

    public TipPlataPanelNew(final TipPlataPanelInterface platiInterface, Vector<TipPlata> allowedTipPlata, final Component panel) {
        boolean showLabels = platiInterface.showLabels();
        int insetsMargin = platiInterface.getMargins();
        this.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 17;
        c.fill = 0;
        c.weighty = 1.0;
        c.gridheight = 1;
        c.gridwidth = 1;
        c.insets = new Insets(2, 2, 2, 2);
        this.buttons = new JButton[allowedTipPlata.size()];
        if (allowedTipPlata.size() > 0) {
            ++c.gridx;
            if (showLabels) {
                this.add((Component)new JLabel(" "), c);
            }
            Font font = new Font(null, 0, platiInterface.getFontSize());
            int i = 0;
            Iterator<TipPlata> iter = allowedTipPlata.iterator();
            while (iter.hasNext()) {
                ++c.gridx;
                final TipPlata tipPlata2 = iter.next();
                JLabel _plata = new JLabel();
                _plata.setText("");
                _plata.setFont(font);
                if (showLabels) {
                    this.add((Component)_plata, c);
                }
                ++c.gridx;
                JButton modPlata = new JButton(tipPlata2.getLabel());
                modPlata.setFont(font);
                modPlata.setFocusable(false);
                modPlata.setMargin(new Insets(insetsMargin, insetsMargin, insetsMargin, insetsMargin));
                this.buttons[i] = modPlata;
                this.platiLabel.put(new Integer(tipPlata2.getId()), _plata);
                modPlata.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        if (platiInterface.canEditSuma()) {
                            platiInterface.editSuma(tipPlata2, panel);
                        } else {
                            DialogUtils.errorDialog(panel, LangRoAll.comandaGoala, LangRoAll.nuPotContinua);
                        }
                    }
                });
                this.add((Component)modPlata, c);
                ++i;
            }
            ++c.gridx;
            if (showLabels) {
                this.add((Component)new JLabel("Rest"), c);
            }
            ++c.gridx;
            this.restText = new JLabel("");
            if (showLabels) {
                this.add((Component)this.restText, c);
            }
        }
    }

    public void updatePlatiLabels(Vector<Plata> plati, double totalOrder) {
        JLabel label;
        double platit = 0.0;
        for (Integer idPlata : this.platiLabel.keySet()) {
            label = this.platiLabel.get(idPlata);
            label.setText("");
        }
        for (Plata plata : plati) {
            label = this.platiLabel.get(plata.getIdTipPlata());
            if (label != null) {
                String s = label.getText();
                if (Validators.correctDouble(s)) {
                    double totalPartial = Utils.parseDouble(s);
                    label.setText(Utils.getString2Decimals(totalPartial += plata.getSuma()));
                } else {
                    label.setText(Utils.getString2Decimals(plata.getSuma()));
                }
            }
            platit += plata.getSuma();
        }
    }

    public void setRestText(Double rest) {
        if (rest != null) {
            this.restText.setText(Utils.getString2Decimals(rest));
            RestLogic.getInstance().pushOrderEventToReceivers(new OrderEvent(OrderEvent.OrderEventTypes.REST, (double)rest));
        } else {
            this.restText.setText("");
        }
    }

    public void cleanPlatiLabel() {
        for (JLabel label : this.platiLabel.values()) {
            label.setText("");
        }
        this.setRestText(null);
    }
}

