/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.restaurant.gui.touch2;

import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.util.Vector;
import javax.swing.JPanel;
import ro.atreides.restaurant.VpConfig;
import ro.atreides.restaurant.base.Table;
import ro.atreides.restaurant.gui.touch2.LocationPanel2;
import ro.atreides.restaurant.gui.touch2.TouchOrder2;
import ro.atreides.restaurant.logic.RestLogic;
import ro.atreides.users.User;
import ro.atreides.users.UsersLogic;
import ro.atreides.users.WaiterSelection2Interface;
import ro.atreides.users.gui.WaitersSelection2;
import ro.atreides.utils.CleanupRequired;
import ro.atreides.utils.DateUtils;
import ro.atreides.utils.Location;
import ro.atreides.utils.Order;
import ro.atreides.utils.ReflectedJPanel;
import ro.atreides.utils.gui.dialogs.DialogUtils;
import ro.atreides.utils.multilang.LangRoAll;

public class TouchMain2
extends ReflectedJPanel
implements CleanupRequired,
WaiterSelection2Interface {
    protected RestLogic logic = RestLogic.getInstance();
    private User currentUser;
    private Table table;
    protected LocationPanel2 locationPanel;
    private WaitersSelection2 waitersPanel;
    protected TouchOrder2 orderPanel;
    public static Vector locations;
    public static Vector<String> sectii;
    public static boolean controllerMode;
    public static boolean autoMarcaj;
    public static boolean deleteAllPlateau;
    public static boolean showActiuniPanel;
    public static boolean showDetaliiPanel;
    public static boolean showNotaBottomRight;
    public static boolean showCodBareTextField;
    public static boolean showTransferIntreMagaziiButton;
    public static boolean cumulateSales;

    protected void setOrderPanel() {
        this.orderPanel = new TouchOrder2(this.logic, this, VpConfig.getInstance(), sectii, autoMarcaj, deleteAllPlateau);
        RestLogic.getInstance().addScaleConsumer(this.orderPanel);
    }

    protected void setLocationPanel() {
        this.locationPanel = new LocationPanel2(this.logic, this, locations);
    }

    @Override
    public void doStuff() {
        this.setLocationPanel();
        this.setOrderPanel();
        this.waitersPanel = new WaitersSelection2(this, controllerMode, VpConfig.getInstance().requestPasswordForWaitersSelection, VpConfig.getInstance().allowPasswords, VpConfig.getInstance().waitersPerLine, VpConfig.getInstance().codAutentificareLength, VpConfig.getInstance().touchSelectorFontSize);
        this.setLayout(new GridBagLayout());
        this.gotoLocationPanel();
        final int logoutSeconds = VpConfig.getInstance().touch2LogoutSeconds;
        if (logoutSeconds > 0) {
            new Thread(){

                @Override
                public void run() {
                    EventQueue eq = Toolkit.getDefaultToolkit().getSystemEventQueue();
                    long last = System.currentTimeMillis();
                    while (true) {
                        if (TouchMain2.this.currentUser != null) {
                            AWTEvent lastEvent = eq.peekEvent();
                            if (lastEvent == null) {
                                long now = DateUtils.now();
                                if (last + (long)(logoutSeconds * 1000) < now) {
                                    last = now;
                                    TouchMain2.this.orderPanel.golestePreorder();
                                    TouchMain2.this.logout(TouchMain2.this.orderPanel.getOrder());
                                }
                            } else {
                                last = DateUtils.now();
                            }
                        }
                        try {
                            Thread.sleep(100L);
                        }
                        catch (InterruptedException e) {
                        }
                    }
                }
            }.start();
        }
    }

    private void gotoLocationPanel() {
        this.switchPanel(this.locationPanel);
        if (VpConfig.getInstance().quickUserSwitchEnabled) {
            this.orderPanel.unregisterQuickUserSwitchListener();
        }
    }

    @Override
    public void cleanup() {
        this.locationPanel.cleanup();
    }

    private void switchPanel(JPanel newPanel) {
        this.setVisible(false);
        this.removeAll();
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 1;
        c.anchor = 10;
        c.insets = new Insets(7, 7, 7, 7);
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.gridx = 0;
        c.gridy = 0;
        this.add((Component)newPanel, c);
        this.setVisible(true);
    }

    public Order getOpenOrderAtTable(Table t) {
        return this.logic.getOpenOrderAtTable(t);
    }

    public void tableSelected(Table t) {
        this.table = t;
        Order o = this.getOpenOrderAtTable(t);
        if (o != null) {
            RestLogic.getInstance().switchAfisajClientOrderCommit(o.getId());
        } else {
            RestLogic.getInstance().switchAfisajClientOrderCommit(-1);
        }
        if (controllerMode && o != null) {
            int tipLocatie = this.waitersPanel.getTipLocatie();
            this.currentUser = UsersLogic.getInstance().getUserById(o.getUser());
            if (tipLocatie == 2 && UsersLogic.getInstance().isUserInGroup(this.currentUser.getId(), "group_receptioneri") || tipLocatie == 1 && UsersLogic.getInstance().isUserInGroup(this.currentUser.getId(), "group_fo_users")) {
                this.gotoOrderPanel(t, this.currentUser, o);
            }
        } else if (this.currentUser == null) {
            this.gotoWaitersSelection();
        } else {
            int tipLocatie = this.waitersPanel.getTipLocatie();
            if (tipLocatie == 2 && UsersLogic.getInstance().isUserInGroup(this.currentUser.getId(), "group_receptioneri") || tipLocatie == 1 && UsersLogic.getInstance().isUserInGroup(this.currentUser.getId(), "group_fo_users")) {
                if (o == null || o.getUser() == this.currentUser.getId() || tipLocatie == 2) {
                    this.gotoOrderPanel(t, this.currentUser, o);
                } else if (UsersLogic.getInstance().isTeam(o.getUser()) && UsersLogic.getInstance().isTeamMember(this.currentUser.getId(), o.getUser())) {
                    int idOwner = o.getUser();
                    User owner = UsersLogic.getInstance().getUserById(idOwner);
                    this.gotoOrderPanel(t, owner, o);
                }
            }
        }
    }

    private void gotoWaitersSelection() {
        this.waitersPanel.refreshButtons();
        this.switchPanel(this.waitersPanel);
        this.waitersPanel.registerListener();
        if (VpConfig.getInstance().quickUserSwitchEnabled) {
            this.orderPanel.unregisterQuickUserSwitchListener();
        }
        this.waitersPanel.focus();
    }

    private void gotoOrderPanel(Table t, User loginUser, Order o) {
        if (VpConfig.getInstance().quickUserSwitchEnabled) {
            if (!t.getLabel().toLowerCase().startsWith(loginUser.getLogin().toLowerCase())) {
                this.logout();
                this.currentUser = null;
                this.locationPanel.waiterChanged(this.currentUser, this.currentUser);
                this.gotoLocationPanel();
                return;
            }
            this.orderPanel.setTable(t, loginUser, o);
            this.switchPanel(this.orderPanel);
            this.orderPanel.registerQuickUserSwitchListener();
        } else {
            this.orderPanel.setTable(t, loginUser, o);
            this.switchPanel(this.orderPanel);
        }
    }

    public void setWaitersPanelType(int tip) {
        this.waitersPanel.setTipLocatie(tip);
    }

    public void logout() {
        User oldUser = this.currentUser;
        this.logic.alertProductie(this.currentUser);
        this.currentUser = null;
        this.locationPanel.waiterChanged(this.currentUser, oldUser);
    }

    @Override
    public void waiterSelected(User loginUser) {
        if (loginUser != null) {
            UsersLogic ul = UsersLogic.getInstance();
            boolean isWaiter = ul.isUserInGroup(loginUser.getId(), "group_fo_users");
            boolean isAdmin = ul.isUserInGroup(loginUser.getId(), "group_bo_users");
            boolean isReceptionist = ul.isUserInGroup(loginUser.getId(), "group_receptioneri");
            Table t = this.table;
            Location location = this.logic.getLocationById(t.getIdLocatie());
            if (location.getTip() == 2) {
                Order o = this.getOpenOrderAtTable(t);
                Integer tableOwner = null;
                if (o != null) {
                    tableOwner = o.getUser();
                }
                this.currentUser = loginUser;
                this.locationPanel.waiterChanged(this.currentUser, this.currentUser);
                if (o == null) {
                    if (isReceptionist) {
                        this.gotoOrderPanel(t, loginUser, o);
                    } else if (isAdmin) {
                        DialogUtils.errorDialog(this, LangRoAll.nuPutetiDeschideMese, LangRoAll.nuPotContinua);
                        this.gotoLocationPanel();
                    } else {
                        this.gotoLocationPanel();
                    }
                } else if (isReceptionist) {
                    this.gotoOrderPanel(t, loginUser, o);
                } else if (isAdmin) {
                    User tableUser;
                    this.currentUser = tableUser = UsersLogic.getInstance().getUserById(tableOwner);
                    this.locationPanel.waiterChanged(this.currentUser, this.currentUser);
                    this.gotoOrderPanel(t, tableUser, o);
                } else {
                    this.gotoLocationPanel();
                }
            } else if (location.getTip() == 1) {
                Order o = this.logic.getOpenOrderAtTable(t);
                Integer tableOwnerId = null;
                if (o != null) {
                    tableOwnerId = o.getUser();
                }
                User tableOwner = null;
                if (tableOwnerId != null) {
                    tableOwner = UsersLogic.getInstance().getUserById(tableOwnerId);
                }
                if (isWaiter) {
                    if (o == null) {
                        this.locationPanel.waiterChanged(loginUser, this.currentUser);
                        this.currentUser = loginUser;
                        this.gotoOrderPanel(t, loginUser, o);
                    } else if (tableOwnerId != null && tableOwnerId.equals(loginUser.getId())) {
                        this.locationPanel.waiterChanged(loginUser, this.currentUser);
                        this.currentUser = loginUser;
                        this.gotoOrderPanel(t, loginUser, o);
                    } else if (UsersLogic.getInstance().isTeam(tableOwnerId) && UsersLogic.getInstance().isTeamMember(loginUser.getId(), tableOwnerId)) {
                        this.locationPanel.waiterChanged(tableOwner, this.currentUser);
                        this.currentUser = tableOwner;
                        this.gotoOrderPanel(t, tableOwner, o);
                    } else if (isAdmin) {
                        this.locationPanel.waiterChanged(tableOwner, this.currentUser);
                        this.currentUser = tableOwner;
                        this.gotoOrderPanel(t, tableOwner, o);
                    } else {
                        this.gotoLocationPanel();
                    }
                } else if (isAdmin) {
                    if (tableOwnerId == null) {
                        DialogUtils.errorDialog(this, LangRoAll.nuPutetiDeschideMese, LangRoAll.nuPotContinua);
                        this.gotoLocationPanel();
                    } else {
                        this.locationPanel.waiterChanged(tableOwner, this.currentUser);
                        this.currentUser = tableOwner;
                        this.gotoOrderPanel(t, tableOwner, o);
                    }
                }
            }
        } else {
            this.currentUser = null;
            this.locationPanel.waiterChanged(this.currentUser, this.currentUser);
            this.gotoLocationPanel();
        }
    }

    public void logout(Order o) {
        this.logout();
        this.plan(o);
    }

    public void plan(Order o) {
        if (o != null) {
            this.locationPanel.tableStatusChanged(this.table, o);
        } else {
            this.locationPanel.tableStatusChanged(this.table, null);
        }
        this.gotoLocationPanel();
        this.locationPanel.refreshLocatieCurenta();
    }

    public void nota(Order o) {
        this.locationPanel.tableStatusChanged(this.table, o);
        this.gotoLocationPanel();
    }

    public User getCurrentUser() {
        return this.currentUser;
    }
}

