/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.restaurant.gui.touch2;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FocusTraversalPolicy;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.border.TitledBorder;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;
import ro.atreides.clienti.ClientLogic;
import ro.atreides.clienti.ClientPersJuridica;
import ro.atreides.clienti.ValoareContClient;
import ro.atreides.clienti.gui.ClientEditDialog;
import ro.atreides.clienti.gui.ClientEditPanelProvider;
import ro.atreides.clienti.gui.ClientSelectDialog;
import ro.atreides.clienti.gui.PersFizicaAddEditPanel;
import ro.atreides.clienti.gui.PersFizicaAddEditPanelShort;
import ro.atreides.clienti.gui.PersJuridicaAddEditPanel;
import ro.atreides.nomenclatura.Categorie;
import ro.atreides.nomenclatura.NomeclaturaLogic;
import ro.atreides.nomenclatura.Product;
import ro.atreides.nomenclatura.ProductWithColorFromCategory;
import ro.atreides.nomenclatura.Sectie;
import ro.atreides.print.AbstractPrinter;
import ro.atreides.print.PrintLogic;
import ro.atreides.promo.ClientPromotieView;
import ro.atreides.promo.Promotion;
import ro.atreides.promo.PromotionLogic;
import ro.atreides.promo.gui.PromotiiDialog;
import ro.atreides.restaurant.VpConfig;
import ro.atreides.restaurant.base.Meniu;
import ro.atreides.restaurant.base.OptiuneMeniu;
import ro.atreides.restaurant.base.OptiuneProdus;
import ro.atreides.restaurant.base.OrdineServire;
import ro.atreides.restaurant.base.Sale;
import ro.atreides.restaurant.base.ScreenSaleInterface;
import ro.atreides.restaurant.base.Table;
import ro.atreides.restaurant.gui.GuiUtilsRest;
import ro.atreides.restaurant.gui.OrdineServireDialog;
import ro.atreides.restaurant.gui.ProdusDialog;
import ro.atreides.restaurant.gui.SeparaProduseDialog;
import ro.atreides.restaurant.gui.TransferDialog;
import ro.atreides.restaurant.gui.meniuri.MeniuriDialog;
import ro.atreides.restaurant.gui.orders.MouseOrderTableModel;
import ro.atreides.restaurant.gui.touch2.ComandaColorProvider;
import ro.atreides.restaurant.gui.touch2.ComandaTableModel;
import ro.atreides.restaurant.gui.touch2.OrderTableModel;
import ro.atreides.restaurant.gui.touch2.PreorderTableModel;
import ro.atreides.restaurant.gui.touch2.TipPlataPanelInterface;
import ro.atreides.restaurant.gui.touch2.TipPlataPanelNew;
import ro.atreides.restaurant.gui.touch2.TouchMain2;
import ro.atreides.restaurant.logic.AddSaleInterface;
import ro.atreides.restaurant.logic.OrderEvent;
import ro.atreides.restaurant.logic.RestLogic;
import ro.atreides.restaurant.logic.VanzariXmlHandler;
import ro.atreides.restaurant.modules.scale.ScaleMessageConsumer;
import ro.atreides.users.User;
import ro.atreides.users.UsersLogic;
import ro.atreides.utils.Client;
import ro.atreides.utils.EventGenerator;
import ro.atreides.utils.FloatUtils;
import ro.atreides.utils.Location;
import ro.atreides.utils.Logger;
import ro.atreides.utils.ObjectEventListener;
import ro.atreides.utils.Order;
import ro.atreides.utils.TipCont;
import ro.atreides.utils.UpdateSaleBeforeMarcaj;
import ro.atreides.utils.Utils;
import ro.atreides.utils.config.Config;
import ro.atreides.utils.gui.GuiUtils;
import ro.atreides.utils.gui.SimpleDateSelector;
import ro.atreides.utils.gui.Validators;
import ro.atreides.utils.gui.dialogs.CardInputDialog;
import ro.atreides.utils.gui.dialogs.DialogUtils;
import ro.atreides.utils.gui.dialogs.FileDialog;
import ro.atreides.utils.gui.dialogs.LoginDialog;
import ro.atreides.utils.gui.dialogs.OkCancelDialog;
import ro.atreides.utils.gui.keypad.VirtualKeypad2;
import ro.atreides.utils.gui.selector.DataProvider2;
import ro.atreides.utils.gui.selector.Selector2;
import ro.atreides.utils.gui.table.AbstractListPanel;
import ro.atreides.utils.gui.table.AbstractTM;
import ro.atreides.utils.gui.table.ColumnSizeProvider;
import ro.atreides.utils.gui.table.CustomCellRenderer;
import ro.atreides.utils.gui.table.TmInterface;
import ro.atreides.utils.gui.xcombo.FilterableComboBoxModel;
import ro.atreides.utils.gui.xcombo.XComboBox;
import ro.atreides.utils.multilang.LangRoAll;
import ro.atreides.utils.plati.Plata;
import ro.atreides.utils.plati.TipPlata;
import ro.atreides.utils.plati.TipPlataChooser;
import ro.atreides.utils.plati.TipPlataProvider;
import ro.atreides.utils.users.gui.ChooseUserDialog;

public class TouchOrder2
extends JPanel
implements ScaleMessageConsumer {
    public static final String PRODUSE_NEASOCIATE = "<html><center>Produse<br>Neasociate</center></html>";
    protected static final String TOUCH_2_TIPURI_DE_PLATA = "touch2TipuriDePlata";
    protected static final String X_COMBO_SEARCH_IN_PRODUCT = "XComboSearchInProduct";
    protected static final String TOUCH_2_TIP_PLATA_FONT_SIZE = "touch2TipPlataFontSize";
    protected static final String TOUCH3_SOYAL_FIDELITATE = "touch3_soyal_fidelitate";
    protected boolean readFromCantar = false;
    protected Insets insets = new Insets(1, 1, 1, 1);
    protected RestLogic logic;
    protected TouchMain2 main;
    protected VpConfig config;
    protected JButton marcaj;
    protected JButton incasat;
    protected JButton platouButton;
    protected JButton servireButton;
    protected JButton nota;
    protected JButton productsAddButton;
    protected JButton freeButton0;
    protected Vector<String> sectii;
    private JTextField productsQuantity;
    private JTextField productsPrice;
    private JTextField availableQuantity;
    private JPanel quickTablePanel;
    protected Order order;
    protected Table table;
    protected Table transferSource;
    protected User waiter;
    private int platouId = 0;
    protected int idServire = -1;
    protected boolean platou;
    protected JLabel promoText;
    protected JLabel clientText;
    protected JLabel ospatarText;
    protected JLabel tableText;
    protected JLabel protocolText;
    protected JLabel totalOrder;
    protected JLabel totalPreorder;
    private XComboBox produseCombo;
    protected ComandaTableModel orderTm;
    protected ComandaTableModel preorderTm;
    protected final String transferString = "<html><center>" + LangRoAll.transfera + "</center></html>";
    protected final String transferStringStop = "<html><center><strong><font color=\"red\">" + LangRoAll.aici + "</font></strong></center></html>";
    private final String platouString = "<html><center>" + LangRoAll.platouStart + "</center></html>";
    private final String platouStringStop = "<html><center><strong><font color=\"red\">" + LangRoAll.platouGata + "</font></strong></center></html>";
    protected VirtualKeypad2 kp;
    private int scroolWidth = 500;
    private int scroolHeight = 200;
    protected JTable preorderJTable;
    protected JTable orderJTable;
    protected JTabbedPane tabs;
    protected AbstractPrinter forcedPrinter = null;
    protected static final int CHECK_ORDER_ALL_OK = 1;
    protected static final int CHECK_ORDER_DIFFERENT_WAITERS = 2;
    protected static final int CHECK_ORDER_SAME_WAITER_DIFFERENT_ORDERS = 3;
    protected boolean marcajAtPrecomandaAdd = false;
    protected boolean insideMenu = false;
    protected boolean deleteAllPlateau = true;
    protected boolean showTransferButton = true;
    protected boolean showNumarPersoaneButton = true;
    protected boolean showSchimbaOspatarButton = true;
    protected JButton plan;
    protected JButton optiuni;
    protected JButton meniu;
    protected JButton logout;
    protected JButton free1;
    protected JButton free2;
    protected JButton mare;
    protected int clientFilter1 = -1;
    protected Vector<Sale> preSales = new Vector();
    protected TipPlataPanelNew platiPanel;
    protected boolean productSecundarChosen = false;
    protected Selector2 produseRelatedSelector = null;
    protected Selector2 produsePrincipaleSelector;
    protected boolean refreshOrderSalesAtClient = false;
    protected boolean showMarcajButton = true;
    protected boolean showSelector = true;
    protected boolean showCodBareTextField = true;
    protected boolean showDetaliiPanel = true;
    protected boolean showNotaBottomRight = false;
    protected boolean showActiuniPanel = true;
    protected boolean showTransferIntreMagaziiButton = false;
    protected boolean cumulateSales = true;
    protected long lastProductAddTime = System.currentTimeMillis();
    private ObjectEventListener loginWithCardEvent;

    public TouchOrder2(RestLogic logic, TouchMain2 main, VpConfig config, Vector sectii, boolean autoMarcaj, boolean deleteAllPlateau) {
        this(logic, main, config, sectii, autoMarcaj, deleteAllPlateau, true, true, true, true, false, true, false, true);
    }

    public TouchOrder2(RestLogic logic, TouchMain2 main, VpConfig config, Vector sectii, boolean autoMarcaj, boolean deleteAllPlateau, boolean showMarcajButton, boolean showSelector, boolean showCodBareTextField, boolean showDetaliiPanel, boolean showNotaBottomRight, boolean showActiuniPanel, boolean showTransferIntreMagaziiButton, boolean cumulateSales) {
        this.logic = logic;
        this.main = main;
        this.config = config;
        this.sectii = sectii;
        this.marcajAtPrecomandaAdd = autoMarcaj;
        this.deleteAllPlateau = deleteAllPlateau;
        this.showMarcajButton = showMarcajButton;
        this.showSelector = showSelector;
        this.showCodBareTextField = showCodBareTextField;
        this.showDetaliiPanel = showDetaliiPanel;
        this.showNotaBottomRight = showNotaBottomRight;
        this.showActiuniPanel = showActiuniPanel;
        this.showTransferIntreMagaziiButton = showTransferIntreMagaziiButton;
        this.cumulateSales = cumulateSales;
        this.display();
    }

    public User getWaiter() {
        return this.waiter;
    }

    public Order getOrder() {
        return this.order;
    }

    protected void display() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 1;
        c.anchor = 10;
        c.insets = this.insets;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 2;
        this.add((Component)this.getDetaliiPanel(), c);
        c.gridx = 0;
        ++c.gridy;
        c.gridwidth = 1;
        this.tabs = new JTabbedPane();
        this.tabs.add((Component)this.getPrecomandaPanel(), LangRoAll.precomanda);
        this.tabs.add((Component)this.getComandaPanel(), LangRoAll.comanda);
        this.add((Component)this.tabs, c);
        ++c.gridx;
        c.weightx = 0.0;
        this.add((Component)this.getButtonsPanel(), c);
        ++c.gridy;
        c.gridx = 0;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.gridwidth = 2;
        if (this.config.touch2ShowProductsFilter) {
            JPanel productSearch = this.getProductSearchPanel();
            this.add((Component)productSearch, c);
            ++c.gridy;
        }
        JPanel selector = this.getSelectorPanel();
        this.add((Component)selector, c);
        ++c.gridy;
        c.weighty = 1.0;
        this.add((Component)new JLabel(""), c);
        if (VpConfig.getInstance().touch2ShowQuickTableBar) {
            c.weighty = 0.0;
            ++c.gridy;
            this.add((Component)this.getQuickTablePanel(), c);
        }
    }

    protected JPanel getQuickTablePanel() {
        this.quickTablePanel = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 2;
        c.anchor = 10;
        c.insets = this.insets;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.gridx = 0;
        c.gridy = 0;
        this.refreshQuickTable();
        return this.quickTablePanel;
    }

    private void tryQuickUserSwitchWithCard(String codAutentificare) {
        Logger.logDebug(this, "QuickUserSwitch CodAutentificare : " + codAutentificare);
        TouchOrder2 panel = this;
        EventGenerator backgroundCardReader = RestLogic.getInstance().getAccesInterface();
        if (backgroundCardReader != null) {
            if (codAutentificare.length() < VpConfig.getInstance().codAutentificareLength) {
                return;
            }
            UsersLogic ul = UsersLogic.getInstance();
            User login = ul.getUserByCodAutentificare(codAutentificare);
            if (login != null) {
                Logger.logDebug(this, "QuickUserSwitch User identificat : " + login);
                int idLocatie = this.table.getIdLocatie();
                Vector<Table> tables = RestLogic.getInstance().getTablesByLocationSortedByName(idLocatie);
                for (Table table1 : tables) {
                    if (!table1.getLabel().toLowerCase().startsWith(login.getLogin().toLowerCase())) continue;
                    Order orderAtTable = RestLogic.getInstance().getOpenOrderAtTable(table1);
                    if (orderAtTable != null) {
                        User userAtTable = UsersLogic.getInstance().getUserById(orderAtTable.getUser());
                        if (userAtTable.getId() == login.getId()) {
                            this.logout.setText("<html>" + LangRoAll.logout + "<br><font color=\"red\">" + login.getLogin() + "</font></html>");
                            Logger.logDebug(this, "QuickUserSwitch Table for user : " + table1);
                            this.setTable(table1, userAtTable, orderAtTable);
                            break;
                        }
                        DialogUtils.errorDialog(panel, LangRoAll.comandaDejaDeschisaDeAlt, LangRoAll.nuPotContinua);
                        return;
                    }
                    this.logout.setText("<html>" + LangRoAll.logout + "<br><font color=\"red\">" + login.getLogin() + "</font></html>");
                    Logger.logDebug(this, "QuickUserSwitch Table for user : " + table1);
                    this.setTable(table1, login, null);
                    break;
                }
            }
        }
    }

    public void registerQuickUserSwitchListener() {
        if (this.loginWithCardEvent == null) {
            final StringBuffer card = new StringBuffer();
            EventGenerator backgroundCardReader = RestLogic.getInstance().getAccesInterface();
            if (backgroundCardReader != null) {
                this.loginWithCardEvent = new ObjectEventListener(){

                    @Override
                    public void dataChanged(Object o) {
                        card.setLength(0);
                        card.append(o);
                        String cardS = card.toString();
                        TouchOrder2.this.tryQuickUserSwitchWithCard(cardS);
                    }

                    @Override
                    public String getName() {
                        return "Touch2QuickUserSwitchListener";
                    }
                };
                backgroundCardReader.addObjectListener(this.loginWithCardEvent, 701);
            }
        }
    }

    public void unregisterQuickUserSwitchListener() {
        EventGenerator backgroundCardReader = RestLogic.getInstance().getAccesInterface();
        if (backgroundCardReader != null && this.loginWithCardEvent != null) {
            backgroundCardReader.removeObjectListener(this.loginWithCardEvent);
        }
        this.loginWithCardEvent = null;
    }

    protected void refreshQuickTable() {
        final TouchOrder2 panel = this;
        if (this.table != null && this.quickTablePanel != null) {
            int idLocatie = this.table.getIdLocatie();
            Vector<Table> tables = RestLogic.getInstance().getTablesByLocationSortedByName(idLocatie);
            if (VpConfig.getInstance().touch2QuickTableBarNameAsDetalii) {
                this.logic.updateQuickTableNames(tables);
            }
            this.quickTablePanel.removeAll();
            GridBagConstraints c = new GridBagConstraints();
            c.fill = 2;
            c.anchor = 10;
            c.insets = this.insets;
            c.gridx = 0;
            c.gridy = 0;
            for (int i = 0; i < tables.size(); ++i) {
                final Table table1 = tables.elementAt(i);
                JButton btn = new JButton(table1.getLabel());
                Font font = new Font(null, 1, VpConfig.getInstance().touch2TotalFontSize);
                btn.setFont(font);
                if (table1.equals(this.table)) {
                    btn.setBackground(Color.GREEN);
                    btn.setForeground(Color.RED);
                }
                btn.addActionListener(new ActionListener(){

                    /*
                     * Enabled aggressive block sorting
                     */
                    @Override
                    public void actionPerformed(ActionEvent ev) {
                        if (TouchOrder2.this.preSales.size() > 0) {
                            DialogUtils.errorDialog(panel, LangRoAll.existaProdNemarcate, LangRoAll.marcatiSauStergeti);
                            TouchOrder2.this.selectAllClientIndex();
                            TouchOrder2.this.tabs.setSelectedIndex(0);
                            return;
                        }
                        Order orderAtTable = RestLogic.getInstance().getOpenOrderAtTable(table1);
                        if (orderAtTable == null) {
                            TouchOrder2.this.setTable(table1, TouchOrder2.this.waiter, null);
                            return;
                        }
                        User userAtTable = UsersLogic.getInstance().getUserById(orderAtTable.getUser());
                        if (userAtTable.getId() == TouchOrder2.this.waiter.getId()) {
                            TouchOrder2.this.setTable(table1, userAtTable, orderAtTable);
                            return;
                        }
                        DialogUtils.errorDialog(panel, LangRoAll.comandaDejaDeschisaDeAlt, LangRoAll.nuPotContinua);
                    }
                });
                btn.setFocusable(false);
                this.quickTablePanel.add((Component)btn, c);
                ++c.gridx;
                if (c.gridx < VpConfig.getInstance().touch2ShowQuickTableItemsPerLine - 1) continue;
                ++c.gridy;
                c.gridx = 0;
            }
            this.quickTablePanel.repaint();
            this.quickTablePanel.setFocusable(false);
        }
    }

    protected void setScaunButtonText() {
        String s = LangRoAll.verificareNota;
        this.mare.setText(s);
    }

    protected void selectAllClientIndex() {
        this.clientFilter1 = -1;
        this.setScaunButtonText();
        if (this.order != null) {
            this.refreshOrderSales();
        }
        this.updateOrderTotal();
        this.refreshPreOrderSales();
        this.updateTotalPreorder();
        this.scrollOrderJTable();
        if (this.preSales.size() > 0) {
            this.tabs.setSelectedIndex(0);
        }
    }

    protected int getClientIndexForAdaugare(int clientFilter) {
        if (clientFilter > 0) {
            return clientFilter;
        }
        return 0;
    }

    protected JPanel getProductSearchPanel() {
        this.productsQuantity = new JTextField(5);
        this.productsPrice = new JTextField(10);
        this.availableQuantity = new JTextField(10);
        JPanel result = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 2;
        c.anchor = 10;
        c.insets = this.insets;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.gridx = 0;
        c.gridy = 0;
        JLabel produseLabel = new JLabel(LangRoAll.produs);
        result.add((Component)produseLabel, c);
        c.weightx = 1.0;
        ++c.gridx;
        boolean xComboSearchInProduct = Config.getInstance().getBoolean(X_COMBO_SEARCH_IN_PRODUCT);
        this.produseCombo = new XComboBox(new FilterableComboBoxModel(NomeclaturaLogic.getInstance().getPowerSearchProducts(-1)), xComboSearchInProduct);
        this.produseCombo.setPrototypeDisplayValue("111111111111111111111111111111111");
        this.produseCombo.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
                TouchOrder2.this.produseCombo.selectAllText();
            }

            @Override
            public void focusLost(FocusEvent e) {
            }
        });
        result.add((Component)this.produseCombo, c);
        c.weightx = 0.0;
        if (VpConfig.getInstance().touch2ShowProductsFilterQuantity) {
            ++c.gridx;
            JLabel availableQuantityLabel = new JLabel(LangRoAll.totalDispBlocat);
            result.add((Component)availableQuantityLabel, c);
            ++c.gridx;
            result.add((Component)this.availableQuantity, c);
            this.availableQuantity.setEditable(false);
            ++c.gridx;
            JLabel productsQuantityLabel = new JLabel(LangRoAll.cantitate);
            result.add((Component)productsQuantityLabel, c);
            ++c.gridx;
            this.productsQuantity.addFocusListener(new FocusListener(){

                @Override
                public void focusGained(FocusEvent e) {
                    Utils.setSelectionForTextField(TouchOrder2.this.productsQuantity);
                }

                @Override
                public void focusLost(FocusEvent e) {
                }
            });
            result.add((Component)this.productsQuantity, c);
        }
        ++c.gridx;
        JLabel productsPriceLabel = new JLabel(LangRoAll.pret);
        result.add((Component)productsPriceLabel, c);
        ++c.gridx;
        this.productsPrice.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
                Utils.setSelectionForTextField(TouchOrder2.this.productsPrice);
            }

            @Override
            public void focusLost(FocusEvent e) {
            }
        });
        if (!VpConfig.getInstance().touch2ProductsFilterPriceEnabled) {
            this.productsPrice.setEditable(false);
        }
        result.add((Component)this.productsPrice, c);
        ++c.gridx;
        this.productsAddButton = new JButton(LangRoAll.adauga);
        this.productsAddButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                String pr;
                Product p = (Product)TouchOrder2.this.produseCombo.getSelectedItem();
                if (p == null) {
                    TouchOrder2.this.produseCombo.requestFocus();
                    return;
                }
                String pq = TouchOrder2.this.productsQuantity.getText();
                if (!Validators.correctDouble(pq)) {
                    TouchOrder2.this.productsQuantity.setText("1");
                    TouchOrder2.this.productsQuantity.requestFocus();
                }
                if (!Validators.correctDouble(pr = TouchOrder2.this.productsPrice.getText())) {
                    TouchOrder2.this.productsPrice.setText("");
                    TouchOrder2.this.productsPrice.requestFocus();
                }
                double price = Utils.parseDouble(pr);
                double q = Utils.parseDouble(pq);
                TouchOrder2.this.addLaPrecomanda(p, q, price, GuiUtils.currentFrame, "");
                TouchOrder2.this.productsPrice.setText("");
                TouchOrder2.this.productsQuantity.setText("1");
                TouchOrder2.this.produseCombo.clearAllText();
                TouchOrder2.this.produseCombo.requestFocus();
            }
        });
        this.productsAddButton.setMnemonic(65);
        result.add((Component)this.productsAddButton, c);
        FocusTraversalPolicy focus = new FocusTraversalPolicy(){

            @Override
            public Component getComponentAfter(Container aContainer, Component aComponent) {
                if (GuiUtils.isXComboBox(aComponent)) {
                    TouchOrder2.this.updateProductPriceField();
                    TouchOrder2.this.updateAvailableQuantity();
                    if (VpConfig.getInstance().touch2ShowProductsFilterQuantity) {
                        return TouchOrder2.this.productsQuantity;
                    }
                    if (VpConfig.getInstance().touch2ProductsFilterPriceEnabled) {
                        return TouchOrder2.this.productsPrice;
                    }
                    return TouchOrder2.this.productsAddButton;
                }
                if (aComponent.equals(TouchOrder2.this.productsQuantity)) {
                    if (VpConfig.getInstance().touch2ProductsFilterPriceEnabled) {
                        return TouchOrder2.this.productsPrice;
                    }
                    return TouchOrder2.this.productsAddButton;
                }
                if (aComponent.equals(TouchOrder2.this.productsPrice)) {
                    return TouchOrder2.this.productsAddButton;
                }
                if (aComponent.equals(TouchOrder2.this.productsAddButton)) {
                    TouchOrder2.this.updateProductName();
                    return TouchOrder2.this.produseCombo;
                }
                return this.getDefaultComponent(aContainer);
            }

            @Override
            public Component getComponentBefore(Container aContainer, Component aComponent) {
                return null;
            }

            @Override
            public Component getDefaultComponent(Container aContainer) {
                return TouchOrder2.this.produseCombo;
            }

            @Override
            public Component getFirstComponent(Container aContainer) {
                return TouchOrder2.this.produseCombo;
            }

            @Override
            public Component getLastComponent(Container aContainer) {
                return TouchOrder2.this.productsAddButton;
            }
        };
        result.setFocusCycleRoot(true);
        result.setFocusTraversalPolicy(focus);
        this.productsQuantity.setText("1");
        return result;
    }

    private void updateProductName() {
        Utils.setSelectionForTextField(this.productsPrice);
    }

    private void updateProductPriceField() {
        Product p = (Product)this.produseCombo.getSelectedItem();
        if (p != null) {
            this.productsPrice.setText(Utils.getString2Decimals(RestLogic.getInstance().getPriceForProductCommit(p.getId())));
        }
    }

    private void updateAvailableQuantity() {
        Product p = (Product)this.produseCombo.getSelectedItem();
        if (p != null) {
            String avai = RestLogic.getInstance().getStringDisponibilForMagazieAndStock(p.getId(), -1);
            this.availableQuantity.setText(avai);
        }
    }

    protected JPanel getDetaliiPanel() {
        JPanel result = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 2;
        c.anchor = 10;
        c.insets = this.insets;
        c.weightx = 1.0;
        c.weighty = 0.0;
        Font font = new Font(null, 1, VpConfig.getInstance().touch2ClientFontSize);
        c.gridx = 0;
        c.gridy = 0;
        this.ospatarText = new JLabel();
        this.add((Component)this.ospatarText, c);
        this.ospatarText.setForeground(Color.RED);
        this.ospatarText.setFont(font);
        result.add((Component)this.ospatarText, c);
        ++c.gridx;
        this.tableText = new JLabel();
        this.add((Component)this.tableText, c);
        this.tableText.setForeground(Color.RED);
        this.tableText.setFont(font);
        result.add((Component)this.tableText, c);
        ++c.gridx;
        this.promoText = new JLabel();
        this.add((Component)this.promoText, c);
        this.promoText.setForeground(Color.RED);
        this.promoText.setFont(font);
        result.add((Component)this.promoText, c);
        ++c.gridx;
        this.clientText = new JLabel();
        this.add((Component)this.clientText, c);
        this.clientText.setForeground(Color.RED);
        this.clientText.setFont(font);
        result.add((Component)this.clientText, c);
        return result;
    }

    private JPanel getPrecomandaPanel() {
        this.preorderTm = new PreorderTableModel();
        this.preorderJTable = new JTable(this.preorderTm);
        this.preorderJTable.setFocusable(false);
        ComandaColorProvider touchColor = new ComandaColorProvider(this.preorderTm);
        CustomCellRenderer cellRender = new CustomCellRenderer(touchColor, this.preorderTm);
        GuiUtils.updateJTableColumnSize(this.preorderJTable, this.getPreOrderColumnSizeProvider());
        GuiUtils.updateJTableRowSize(this.preorderJTable, this.config.touchTableFontSize);
        TableColumnModel colModel = this.preorderJTable.getColumnModel();
        Enumeration<TableColumn> enum1 = colModel.getColumns();
        while (enum1.hasMoreElements()) {
            TableColumn column = enum1.nextElement();
            column.setCellRenderer(cellRender);
        }
        if (!VpConfig.getInstance().showServireFields) {
            colModel.getColumn(0).setMaxWidth(0);
        }
        JScrollPane preorderScroll = new JScrollPane(this.preorderJTable);
        preorderScroll.setPreferredSize(new Dimension(this.scroolWidth, this.scroolHeight));
        this.preorderJTable.addMouseListener(this.getPreorderMouseListener());
        int touch2TotalFontSize = VpConfig.getInstance().touch2TotalFontSize;
        Font font = new Font(null, 0, touch2TotalFontSize);
        JLabel t1 = new JLabel(LangRoAll.total);
        t1.setForeground(Color.RED);
        t1.setFont(font);
        this.totalPreorder = new JLabel("");
        this.totalPreorder.setForeground(Color.RED);
        this.totalPreorder.setFont(font);
        return this.displayPreorderPanel(t1, preorderScroll);
    }

    protected JPanel displayPreorderPanel(JLabel t1, JScrollPane preorderScroll) {
        JPanel result = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 1;
        c.anchor = 10;
        c.insets = this.insets;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 2;
        result.add((Component)preorderScroll, c);
        ++c.gridy;
        c.weighty = 0.0;
        c.gridwidth = 1;
        c.gridx = 0;
        result.add((Component)t1, c);
        ++c.gridx;
        result.add((Component)this.totalPreorder, c);
        result.setFocusable(false);
        return result;
    }

    protected MouseAdapter getPreorderMouseListener() {
        return new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                Point p;
                JTable t = (JTable)e.getSource();
                int selRow = t.rowAtPoint(p = e.getPoint());
                if (selRow == -1) {
                    return;
                }
                Sale s = TouchOrder2.this.preorderTm.getEntryAtRow(selRow);
                int selCol = t.columnAtPoint(p);
                switch (selCol) {
                    case 0: {
                        Vector<OrdineServire> os = TouchOrder2.this.logic.getOrdineServire(-1);
                        if (os.size() <= 0) break;
                        OrdineServireDialog dia = new OrdineServireDialog(5, os);
                        int idServire = dia.getIdServire();
                        s.setIdServire(idServire);
                        TouchOrder2.this.preorderTm.fireTableRowsUpdated(selRow, selRow);
                        break;
                    }
                    case 1: {
                        if (TouchOrder2.this.config.touch2ModPreparareLiber) {
                            String s1 = s.getModPreparare();
                            if (s1 == null) {
                                s1 = "";
                            }
                            String modPreparare = DialogUtils.inputDialog(GuiUtils.currentFrame, s1, LangRoAll.detaliiProdus);
                            s.setModPreparare(modPreparare);
                        } else {
                            String mp = GuiUtilsRest.chooseModPreparare(s.getIdProduct(), s.getProductName(), s.getModPreparare());
                            s.setModPreparare(mp);
                        }
                        TouchOrder2.this.preorderTm.fireTableRowsUpdated(selRow, selRow);
                        break;
                    }
                    case 2: {
                        double toRemain;
                        double toDelete = s.getCantitateNoua();
                        if (TouchOrder2.this.kp.getValue() > 0.0) {
                            toDelete = TouchOrder2.this.kp.getValue();
                            TouchOrder2.this.kp.reset();
                        }
                        if ((toRemain = s.getCantitateNoua() - toDelete) < 0.0) {
                            toRemain = 0.0;
                        }
                        s.setCantitateNoua(toRemain);
                        TouchOrder2.this.removeZeroQuantityPresales();
                        TouchOrder2.this.refreshPreOrderSales();
                        TouchOrder2.this.updateTotalPreorder();
                        Hashtable<Sale, Double> toRemove = new Hashtable<Sale, Double>();
                        toRemove.put(s, toDelete);
                        RestLogic.getInstance().pushOrderEventToReceivers(new OrderEvent(OrderEvent.OrderEventTypes.SALE_DELETED, toRemove));
                        break;
                    }
                    case 3: {
                        User supervizor = null;
                        if (TouchOrder2.this.config.passwordForPret) {
                            supervizor = UsersLogic.getInstance().requestAdminLogin(GuiUtils.currentFrame, VpConfig.getInstance().allowPasswords, true);
                        }
                        if (supervizor == null && TouchOrder2.this.config.passwordForPret) break;
                        String newPrice = TouchOrder2.this.kp.getValueS();
                        if (Validators.correctDouble(newPrice)) {
                            double price = TouchOrder2.this.kp.getValue();
                            s.setPrice(price);
                            s.setPpuOriginal(price);
                            TouchOrder2.this.updateTotalPreorder();
                        } else {
                            double originalPrice = TouchOrder2.this.logic.getPriceForProductCommit(s.getIdProduct());
                            s.setPrice(originalPrice);
                            s.setPpuOriginal(originalPrice);
                            TouchOrder2.this.updateTotalPreorder();
                        }
                        TouchOrder2.this.kp.reset();
                        break;
                    }
                }
            }
        };
    }

    protected void removeZeroQuantityPresales() {
        Vector<Sale> s1 = new Vector<Sale>();
        for (Sale sale : this.preSales) {
            if (!(sale.getCantitateNoua() > 0.0)) continue;
            s1.add(sale);
        }
        this.preSales.clear();
        this.preSales.addAll(s1);
    }

    protected void updateTotalPreorder() {
        double total = this.preorderTm.getTotal();
        this.totalPreorder.setText(Utils.getString2Decimals(total));
    }

    protected MouseAdapter getOrderMouseListener(final Component panel) {
        return new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                Point p;
                JTable t = (JTable)e.getSource();
                int selRow = t.rowAtPoint(p = e.getPoint());
                if (selRow == -1) {
                    return;
                }
                Sale s = TouchOrder2.this.orderTm.getEntryAtRow(selRow);
                int selCol = t.columnAtPoint(p);
                switch (selCol) {
                    case 0: {
                        Vector<OrdineServire> os = TouchOrder2.this.logic.getOrdineServire(-1);
                        if (os.size() <= 0) break;
                        OrdineServireDialog dia = new OrdineServireDialog(5, os);
                        int idServire = dia.getIdServire();
                        s.setIdServire(idServire);
                        TouchOrder2.this.logic.setServireToSale(s);
                        break;
                    }
                    case 2: {
                        double existenta;
                        if (TouchOrder2.this.order != null && (TouchOrder2.this.order.isLaPlata() || TouchOrder2.this.order.isIncasat()) && !TouchOrder2.this.config.allowStergereAfterNota) {
                            DialogUtils.errorDialog(panel, LangRoAll.nuPutetiEfectuaReturDupaNota, LangRoAll.nuPotContinua);
                            return;
                        }
                        if (!TouchOrder2.this.config.allowRetur) break;
                        double deSters = existenta = s.getCantitateMarcata();
                        double deRamas = 0.0;
                        if (TouchOrder2.this.kp.getValue() > 0.0) {
                            if (VpConfig.getInstance().returModifyMode) {
                                deRamas = TouchOrder2.this.kp.getValue();
                                deSters = deRamas > existenta ? existenta : existenta - deRamas;
                                if (deRamas <= existenta) {
                                    TouchOrder2.this.kp.reset();
                                }
                            } else {
                                deSters = TouchOrder2.this.kp.getValue();
                                TouchOrder2.this.kp.reset();
                            }
                        }
                        if (deSters > existenta) {
                            deSters = existenta;
                        }
                        if (s.getIdPlatou() > 0 && TouchOrder2.this.deleteAllPlateau) {
                            TouchOrder2.this.deleteAllPlateau(deSters, panel, s);
                        } else {
                            TouchOrder2.this.deleteSingleProduct(deSters, panel, s, selRow);
                        }
                        Hashtable<Sale, Double> toRemove = new Hashtable<Sale, Double>();
                        toRemove.put(s, deSters);
                        RestLogic.getInstance().pushOrderEventToReceivers(new OrderEvent(OrderEvent.OrderEventTypes.SALE_RETUR, toRemove));
                        if (!(deRamas > existenta)) break;
                        Product produs = NomeclaturaLogic.getInstance().getProductById(s.getIdProduct());
                        TouchOrder2.this.addLaPrecomanda(produs, deRamas, panel);
                    }
                }
            }
        };
    }

    protected DefaultTableCellRenderer getOrderCellRenderer() {
        ComandaColorProvider touchColor = new ComandaColorProvider(this.orderTm);
        CustomCellRenderer cellRender = new CustomCellRenderer(touchColor, this.orderTm);
        return cellRender;
    }

    protected ColumnSizeProvider getOrderColumnSizeProvider() {
        ColumnSizeProvider preorderColumnSize = new ColumnSizeProvider(){

            @Override
            public int getColumnSize(int column) {
                switch (column) {
                    case 1: {
                        return 7;
                    }
                }
                return 1;
            }
        };
        return preorderColumnSize;
    }

    protected ColumnSizeProvider getPreOrderColumnSizeProvider() {
        ColumnSizeProvider preorderColumnSize = new ColumnSizeProvider(){

            @Override
            public int getColumnSize(int column) {
                switch (column) {
                    case 1: {
                        return 7;
                    }
                }
                return 1;
            }
        };
        return preorderColumnSize;
    }

    private JPanel getComandaPanel() {
        TouchOrder2 panel = this;
        this.orderTm = new OrderTableModel();
        this.orderJTable = new JTable(this.orderTm);
        this.orderJTable.setFocusable(false);
        this.orderJTable.addMouseListener(this.getOrderMouseListener(panel));
        DefaultTableCellRenderer cellRender = this.getOrderCellRenderer();
        GuiUtils.updateJTableColumnSize(this.orderJTable, this.getOrderColumnSizeProvider());
        GuiUtils.updateJTableRowSize(this.orderJTable, this.config.touchTableFontSize);
        TableColumnModel colModel = this.orderJTable.getColumnModel();
        Enumeration<TableColumn> enum1 = colModel.getColumns();
        while (enum1.hasMoreElements()) {
            TableColumn column = enum1.nextElement();
            column.setCellRenderer(cellRender);
        }
        if (!VpConfig.getInstance().showServireFields) {
            colModel.getColumn(0).setMaxWidth(0);
        }
        JScrollPane scroll = new JScrollPane(this.orderJTable);
        scroll.setPreferredSize(new Dimension(this.scroolWidth, this.scroolHeight));
        Font font = new Font(null, 0, VpConfig.getInstance().touch2TotalFontSize);
        JLabel t1 = new JLabel(LangRoAll.total);
        t1.setForeground(Color.RED);
        t1.setFont(font);
        this.totalOrder = new JLabel("");
        this.totalOrder.setForeground(Color.RED);
        this.totalOrder.setFont(font);
        TipPlataPanelInterface platiInterface = this.buildPlatiInterface();
        Vector<TipPlata> allowed = this.getAllowedTipPlata(platiInterface);
        this.platiPanel = new TipPlataPanelNew(platiInterface, allowed, panel);
        return this.displayOrderPanel(scroll, t1, this.platiPanel);
    }

    protected TipPlataPanelInterface buildPlatiInterface() {
        TouchOrder2 panel = this;
        return new TipPlataPanelInterface(){

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void editSuma(TipPlata tipPlata2, Component panel) {
                12 platiInterface = this;
                Vector<Plata> existingPlati = platiInterface.getExistingPlati();
                for (Plata plata : existingPlati) {
                    if (Validators.correctString(plata.getEcrMapping()) == Validators.correctString(tipPlata2.getEcrMapping())) continue;
                    String err = Utils.getTranslation(LangRoAll.tipDePlataIncompatibil, tipPlata2.getLabel(), plata.getTipPlata());
                    DialogUtils.errorDialog(panel, err, LangRoAll.nuPotContinua);
                    return;
                }
                User supervizor = null;
                if (tipPlata2.isRequestPassword()) {
                    supervizor = UsersLogic.getInstance().requestAdminLogin(GuiUtils.currentFrame, VpConfig.getInstance().allowPasswords, true);
                    try {
                        Thread.sleep(500L);
                    }
                    catch (InterruptedException e1) {
                        // empty catch block
                    }
                }
                if (!tipPlata2.isRequestPassword() || supervizor != null) {
                    int idClient = platiInterface.getIdClient(false);
                    int idTipCont = tipPlata2.getIdTipCont();
                    if (idTipCont != -1) {
                        idClient = platiInterface.getIdClient(true);
                        Vector<ValoareContClient> contValues = ClientLogic.getInstance().getConturiClient(idClient, idTipCont);
                        if (idClient <= 0) {
                            DialogUtils.errorDialog(GuiUtils.currentFrame, LangRoAll.alegetiUnClient, LangRoAll.nuPotContinua);
                            return;
                        }
                        if (contValues.size() <= 0) {
                            DialogUtils.errorDialog(GuiUtils.currentFrame, LangRoAll.contInexistentPtClient, LangRoAll.nuPotContinua);
                            return;
                        }
                        double val = contValues.get(0).getValoare();
                        if (val < 0.0 && !VpConfig.getInstance().incarcareContAllowStartOnMinus) {
                            DialogUtils.errorDialog(GuiUtils.currentFrame, LangRoAll.soldPeMinus, LangRoAll.nuPotContinua);
                            return;
                        }
                    }
                    double value = platiInterface.getValueForPlata(tipPlata2);
                    String comment = "";
                    boolean commentSet = false;
                    while (tipPlata2.isRequestComment() && !commentSet && !Utils.isValueZero(value)) {
                        String s;
                        if (VpConfig.getInstance().tipPlataDetaliiKeypad) {
                            s = DialogUtils.virtualKeyboardInputDialog(GuiUtils.currentFrame, LangRoAll.detalii, 3.0, VpConfig.getInstance().touchSelectorFontSize, false);
                            commentSet = true;
                            comment = s;
                            continue;
                        }
                        s = DialogUtils.inputDialog(panel, "", LangRoAll.detalii);
                        if (!Validators.correctString(s)) continue;
                        commentSet = true;
                        comment = s;
                    }
                    if (!Utils.isValueZero(value) && idTipCont != -1) {
                        Vector<ValoareContClient> contValues = ClientLogic.getInstance().getConturiClient(idClient, idTipCont);
                        if (contValues.size() <= 0) {
                            DialogUtils.errorDialog(GuiUtils.currentFrame, LangRoAll.contInexistentPtClient, LangRoAll.nuPotContinua);
                            return;
                        }
                        double valoareActualaCont = contValues.get(0).getValoare();
                        double canPayValue = valoareActualaCont + -VpConfig.getInstance().incarcareContAllowFinishValue;
                        if (value > canPayValue) {
                            String translation = Utils.getTranslation(LangRoAll.valoareMaximaPlatibila, Utils.getString2Decimals(canPayValue));
                            DialogUtils.errorDialog(panel, translation, LangRoAll.nuPotContinua);
                            return;
                        }
                    }
                    platiInterface.addPlataToOrder(tipPlata2, value, comment);
                    platiInterface.afterEditSuma();
                }
            }

            @Override
            public int getMargins() {
                return 1;
            }

            @Override
            public boolean showLabels() {
                return true;
            }

            @Override
            public int getFontSize() {
                return Config.getInstance().getInt(TouchOrder2.TOUCH_2_TIP_PLATA_FONT_SIZE, 10);
            }

            @Override
            public boolean allowTipPlata(TipPlata tp) {
                return TouchOrder2.this.isTipPlataAllowed(tp, TouchOrder2.TOUCH_2_TIPURI_DE_PLATA);
            }

            @Override
            public void afterEditSuma() {
                TouchOrder2.this.kp.reset();
                TouchOrder2.this.updateOrderTotal();
            }

            @Override
            public boolean canEditSuma() {
                return TouchOrder2.this.order != null;
            }

            @Override
            public int getIdClient(boolean contAsociat) {
                if (contAsociat && VpConfig.getInstance().hotelRestaurantAskForRoomNumber) {
                    CardInputDialog dialog = new CardInputDialog((Frame)GuiUtils.currentFrame, true, VpConfig.getInstance().hotelCodCamereLength);
                    dialog.setVisible(true);
                    TouchOrder2.this.main.requestFocus();
                    String cod = dialog.getCodAutentificare();
                    if (Validators.correctString(cod)) {
                        Table destination = TouchOrder2.this.logic.getTableByCodAutentificare(cod);
                        if (destination != null) {
                            Order orderCamera;
                            String locatie = TouchOrder2.this.logic.getLocationById(destination.getIdLocatie()).getName();
                            if (DialogUtils.confirmDialog(TouchOrder2.this.main, Utils.getTranslation(LangRoAll.atiAlesCamera, locatie, destination.getLabel()), LangRoAll.confirmare) && (orderCamera = TouchOrder2.this.logic.getOpenOrderAtTable(destination)) != null) {
                                int idClient = orderCamera.getIdClient();
                                if (idClient > 0) {
                                    TouchOrder2.this.logic.setClientForOrder(TouchOrder2.this.order, idClient, "");
                                    TouchOrder2.this.setClientText();
                                }
                                return idClient;
                            }
                        } else {
                            DialogUtils.errorDialog(TouchOrder2.this.main, LangRoAll.operatieEsuata, LangRoAll.operatieEsuata);
                        }
                    } else {
                        DialogUtils.errorDialog(TouchOrder2.this.main, LangRoAll.codIncorect, LangRoAll.nuPotContinua);
                    }
                } else if (TouchOrder2.this.order != null) {
                    return TouchOrder2.this.order.getIdClient();
                }
                return -1;
            }

            @Override
            public Vector<Plata> getExistingPlati() {
                if (TouchOrder2.this.order != null) {
                    Vector<Plata> existingPlati = TouchOrder2.this.logic.getPlatiForOrder(TouchOrder2.this.order.getId(), TouchOrder2.this.clientFilter1);
                    return existingPlati;
                }
                return new Vector<Plata>();
            }

            @Override
            public void addPlataToOrder(TipPlata tipPlata2, double value, String comment) {
                if (TouchOrder2.this.order != null) {
                    int clientIndex = TouchOrder2.this.getClientIndexForAdaugare(TouchOrder2.this.clientFilter1);
                    Plata plata = new Plata(tipPlata2.getId(), value, tipPlata2.getEcrMapping(), tipPlata2.getLabel(), comment, clientIndex);
                    TouchOrder2.this.logic.addPlataToOrder(TouchOrder2.this.order, plata);
                    Logger.logDebug(this, "Adaugat plata " + plata + " la order " + TouchOrder2.this.order);
                    RestLogic.getInstance().pushOrderEventToReceivers(new OrderEvent(OrderEvent.OrderEventTypes.PAYMENT, plata));
                }
            }

            @Override
            public double getValueForPlata(TipPlata tipPlata2) {
                if (TouchOrder2.this.order != null) {
                    double rest;
                    double value;
                    if (tipPlata2.getIdPromo() > 0) {
                        TouchOrder2.this.logic.setClientAndPromotionForOrder(TouchOrder2.this.getOrder(), TouchOrder2.this.getOrder().getIdClient(), tipPlata2.getIdPromo());
                        TouchOrder2.this.setPromotionText();
                        TouchOrder2.this.logic.recomputePrices(TouchOrder2.this.order);
                        TouchOrder2.this.refreshOrderSales();
                        TouchOrder2.this.updateOrderTotal();
                    }
                    double total1 = RestLogic.getInstance().getTotal(TouchOrder2.this.order, TouchOrder2.this.clientFilter1);
                    double total = FloatUtils.roundFloat(total1, 2);
                    double valoareCuRest = value = FloatUtils.roundFloat(TouchOrder2.this.logic.getSumaForPlataNoPlataSkip(TouchOrder2.this.order, tipPlata2.getId(), total, TouchOrder2.this.clientFilter1), 2);
                    String valueS = TouchOrder2.this.kp.getValueS();
                    if (Validators.correctDouble(valueS)) {
                        valoareCuRest = TouchOrder2.this.kp.getValue();
                    }
                    if ((rest = valoareCuRest - value) != -total) {
                        TouchOrder2.this.platiPanel.setRestText(rest);
                    } else {
                        TouchOrder2.this.platiPanel.setRestText(null);
                    }
                    if (valoareCuRest > value && !tipPlata2.isDocumentDePlata()) {
                        valoareCuRest = value;
                    }
                    return valoareCuRest;
                }
                return 0.0;
            }
        };
    }

    private Vector<TipPlata> getAllowedTipPlata(TipPlataPanelInterface platiInterface) {
        Vector<TipPlata> _vTipPlata = TipPlataProvider.getInstance().getTipPlata();
        Vector<TipPlata> allowedTipPlata = new Vector<TipPlata>();
        for (TipPlata tipPlata2 : _vTipPlata) {
            if (!platiInterface.allowTipPlata(tipPlata2)) continue;
            allowedTipPlata.add(tipPlata2);
        }
        return allowedTipPlata;
    }

    protected boolean isTipPlataAllowed(TipPlata toFilter, String configName) {
        String configs = Config.getInstance().getString(configName);
        if (Validators.correctString(configs)) {
            Vector split = Utils.splitString(configs, ',');
            for (String s : split) {
                if (!s.equalsIgnoreCase(toFilter.getLabel())) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    protected JPanel displayOrderPanel(JScrollPane scroll, JLabel totalLabel, JPanel platiPanel) {
        JPanel result = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 1;
        c.anchor = 10;
        c.insets = this.insets;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 3;
        result.add((Component)scroll, c);
        c.gridwidth = 1;
        c.weighty = 0.0;
        ++c.gridy;
        c.gridx = 0;
        result.add((Component)totalLabel, c);
        ++c.gridx;
        result.add((Component)this.totalOrder, c);
        ++c.gridx;
        result.add((Component)platiPanel, c);
        result.setFocusable(false);
        return result;
    }

    protected JPanel getSelectorPanel() {
        DataProvider2 fullDataProvider = new DataProvider2(){

            @Override
            public int getLinesPerPage(int level) {
                switch (level) {
                    case 0: {
                        return TouchOrder2.this.config.selector2Level1LinesPerPage;
                    }
                    case 1: {
                        return TouchOrder2.this.config.selector2Level2LinesPerPage;
                    }
                    case 2: {
                        return TouchOrder2.this.config.selector2Level3LinesPerPage;
                    }
                }
                return 0;
            }

            @Override
            public int getItemsPerLine(int level) {
                switch (level) {
                    case 0: {
                        return TouchOrder2.this.config.selector2Level1ItemsPerLine;
                    }
                    case 1: {
                        return TouchOrder2.this.config.selector2Level2ItemsPerLine;
                    }
                    case 2: {
                        return TouchOrder2.this.config.selector2Level3ItemsPerLine;
                    }
                }
                return 0;
            }

            @Override
            public int getFontSize(int level) {
                switch (level) {
                    case 0: {
                        return TouchOrder2.this.config.selector2Level1FontSize;
                    }
                    case 1: {
                        return TouchOrder2.this.config.selector2Level2FontSize;
                    }
                    case 2: {
                        return TouchOrder2.this.config.selector2Level3FontSize;
                    }
                }
                return 0;
            }

            @Override
            public int getFontStyle(int level) {
                return 1;
            }

            @Override
            public int getMaxLevels() {
                return 3;
            }

            @Override
            public String getTitle(int level) {
                switch (level) {
                    case 0: {
                        return LangRoAll.sectii;
                    }
                    case 1: {
                        return LangRoAll.categorii;
                    }
                    case 2: {
                        return LangRoAll.produse;
                    }
                }
                return "";
            }

            @Override
            public Vector getData(int level, Object selection) {
                switch (level) {
                    case 0: {
                        return TouchOrder2.this.getSectiiRow();
                    }
                    case 1: {
                        return TouchOrder2.this.getSubcategoriesRow(selection);
                    }
                    case 2: {
                        return TouchOrder2.this.getProductsRow(selection);
                    }
                    case 3: {
                        TouchOrder2.this.productChosen(selection, GuiUtils.currentFrame);
                        return null;
                    }
                }
                return new Vector();
            }

            @Override
            public int getMinBtnHeight(int level) {
                switch (level) {
                    case 0: {
                        return TouchOrder2.this.config.selector2Level1MinHeight;
                    }
                    case 1: {
                        return TouchOrder2.this.config.selector2Level2MinHeight;
                    }
                    case 2: {
                        return TouchOrder2.this.config.selector2Level3MinHeight;
                    }
                }
                return 0;
            }

            @Override
            public int getMinBtnWidth(int level) {
                switch (level) {
                    case 0: {
                        return TouchOrder2.this.config.selector2Level1MinWidth;
                    }
                    case 1: {
                        return TouchOrder2.this.config.selector2Level2MinWidth;
                    }
                    case 2: {
                        return TouchOrder2.this.config.selector2Level3MinWidth;
                    }
                }
                return 0;
            }
        };
        this.produsePrincipaleSelector = new Selector2(fullDataProvider);
        return this.produsePrincipaleSelector;
    }

    protected synchronized void productChosen(Object selection, Component panel) {
        if (VpConfig.getInstance().touchProductSelectionDelayMillis > 0) {
            if (this.lastProductAddTime + 500L > System.currentTimeMillis()) {
                return;
            }
            this.lastProductAddTime = System.currentTimeMillis();
        }
        double cantitateCurenta = 1.0;
        Product p = (Product)selection;
        if (this.kp.getValue() > 0.0) {
            cantitateCurenta = this.kp.getValue();
        }
        this.addLaPrecomanda(p, cantitateCurenta, panel);
        this.kp.reset();
    }

    protected void addLaPrecomanda(Product p, double quantity, Component panel) {
        double price = this.logic.getPriceForProductCommit(p.getId());
        if (price >= 0.0) {
            this.addLaPrecomanda(p, quantity, price, panel, "");
        }
    }

    protected void addLaPrecomanda(Product p, double quantity, double pret, Component panel, String modPreparare) {
        this.addLaPrecomanda(p, quantity, pret, panel, modPreparare, System.currentTimeMillis());
    }

    protected void addLaPrecomanda(Product p, double quantity, double pret, Component panel, String modPreparare, long now) {
        if (VpConfig.getInstance().qtyCheckingsEnabled && p.isExportCantar() && Utils.isInteger(quantity) && !DialogUtils.confirmDialog(this, "ATENTIE ! Confirmati cantitatea : " + quantity, LangRoAll.confirmare)) {
            return;
        }
        if (VpConfig.getInstance().qtyCheckingsEnabled && !p.isExportCantar() && !Utils.isInteger(quantity)) {
            DialogUtils.errorDialog(this, "Produs necantaribil !! Verificati cantitatea : " + quantity, LangRoAll.confirmare);
            return;
        }
        int checkAlreadyOpenStatus = this.checkNotaAlreadyOpened();
        switch (checkAlreadyOpenStatus) {
            case 2: {
                DialogUtils.errorDialog(panel, LangRoAll.comandaDejaDeschisaDeAlt + " " + LangRoAll.iesitiPePlan, LangRoAll.nuPotContinua);
                return;
            }
            case 3: {
                DialogUtils.errorDialog(panel, LangRoAll.masaDejaDeschisaDeTine + " " + LangRoAll.iesitiPePlan, LangRoAll.nuPotContinua);
                return;
            }
        }
        int idPlatou = -1;
        if (this.platou) {
            idPlatou = this.platouId;
        }
        int idPromotie = -1;
        int clientIndex = this.getClientIndexForAdaugare(this.clientFilter1);
        Sale newSale = this.logic.buildSale(p, 0.0, quantity, modPreparare, -1, idPlatou, idPromotie, -1, this.idServire, now, pret, "", clientIndex);
        this.preSales.add(newSale);
        this.tabs.setSelectedIndex(0);
        this.preorderJTable.changeSelection(this.preorderTm.getRowCount() - 1, 0, false, false);
        this.refreshPreOrderSales();
        this.updateTotalPreorder();
        RestLogic.getInstance().pushOrderEventToReceivers(new OrderEvent(OrderEvent.OrderEventTypes.SALE_ADDED, newSale));
        if (this.marcajAtPrecomandaAdd) {
            this.marcaj.doClick();
        }
        if (this.produseRelatedSelector != null && !this.productSecundarChosen) {
            this.produseRelatedSelector.refreshAll(p);
        }
        this.productSecundarChosen = false;
        if (VpConfig.getInstance().recomputePricesBeforeMarcaj) {
            Vector sales = this.preorderTm.getAllSales();
            RestLogic.getInstance().recomputePricesBeforeMarcaj(this.order, sales, new UpdateSaleBeforeMarcaj());
        }
    }

    protected Vector getProductsRow(Object selection) {
        return this.getProductsForRow(selection, 0);
    }

    protected Vector getProductsForRow(Object selection, int uzIntern) {
        Vector<ProductWithColorFromCategory> result = new Vector<ProductWithColorFromCategory>();
        if (selection != null) {
            if (selection instanceof Categorie) {
                Categorie sc = (Categorie)selection;
                Vector products = NomeclaturaLogic.getInstance().getProductsForCategorie(sc);
                if (VpConfig.getInstance().selector2Level3ColorAsLevel2Button) {
                    Color categoryColor = sc.getColor();
                    for (int i = 0; i < products.size(); ++i) {
                        ProductWithColorFromCategory productWithColorFromCategory = new ProductWithColorFromCategory((Product)products.elementAt(i), categoryColor);
                        result.add(productWithColorFromCategory);
                    }
                } else {
                    result.addAll(products);
                }
                if (products.size() == 0) {
                    Logger.logDebug(this, "getProductsRow returned 0 for selection \"" + selection + "\"");
                }
            } else {
                Logger.logDebug(this, "getProductsRow class cast, received \"" + selection + "\"");
            }
        } else {
            Logger.logDebug(this, "getProductsRow selection is null");
        }
        return result;
    }

    protected Vector getSubcategoriesRow(Object selection) {
        Vector subcats = new Vector();
        if (selection != null) {
            if (selection instanceof Sectie) {
                Sectie c = (Sectie)selection;
                subcats = NomeclaturaLogic.getInstance().getCategoriiForcedOrder(c.getId());
                if (subcats.size() == 0) {
                    Logger.logDebug(this, "getSubcategoriesRow returned 0 for selection \"" + selection + "\"");
                }
            } else {
                Logger.logDebug(this, "getSubcategoriesRow class cast, received \"" + selection + "\"");
            }
        } else {
            subcats = this.sectii != null && this.sectii.size() > 0 ? NomeclaturaLogic.getInstance().getCategoriiForcedOrder(this.sectii) : NomeclaturaLogic.getInstance().getCategoriiForcedOrder(-1);
        }
        return subcats;
    }

    protected Vector getSectiiRow() {
        if (this.sectii.size() > 0) {
            return this.logic.getSectiiInSet(this.sectii);
        }
        return this.logic.getSectii();
    }

    protected JButton getServireButton() {
        JButton servireButton = new JButton("<html><center>" + LangRoAll.servire + "<br>&nbsp;</center></html>");
        servireButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Vector<OrdineServire> os = TouchOrder2.this.logic.getOrdineServire(-1);
                if (os.size() > 0) {
                    OrdineServireDialog dia = new OrdineServireDialog(5, os);
                    TouchOrder2.this.idServire = dia.getIdServire();
                    dia.dispose();
                    TouchOrder2.this.setServireButtonText();
                }
            }
        });
        return servireButton;
    }

    protected JButton getCantarButton() {
        JButton cantarButton = new JButton("<html><center>" + LangRoAll.cantar + "<br>&nbsp;</center></html>");
        cantarButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TouchOrder2.this.readFromCantar = true;
            }
        });
        return cantarButton;
    }

    protected JButton getPlatouButton() {
        JButton platouButton = new JButton(this.platouString);
        platouButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (TouchOrder2.this.platou) {
                    TouchOrder2.this.platou = false;
                } else {
                    TouchOrder2.this.platou = true;
                    if (TouchOrder2.this.platouId == -1) {
                        TouchOrder2.this.platouId = TouchOrder2.this.logic.getMaxPlatouIdForOrder(TouchOrder2.this.order);
                    }
                    TouchOrder2.this.platouId++;
                }
                TouchOrder2.this.setPlatouButtonText();
            }
        });
        return platouButton;
    }

    protected JButton getFreeButton0() {
        return null;
    }

    protected JButton getFreeButton1() {
        return null;
    }

    protected JButton getFreeButton2() {
        return null;
    }

    protected int checkNotaAlreadyOpened() {
        Order o = this.logic.getOpenOrderAtTable(this.table);
        if (o != null) {
            if (this.order != null) {
                if (o.getId() != this.order.getId()) {
                    if (this.waiter.getId() != o.getUser()) {
                        return 2;
                    }
                    return 3;
                }
                return 1;
            }
            if (this.waiter.getId() != o.getUser()) {
                return 2;
            }
            return 3;
        }
        return 1;
    }

    protected void marcaj(boolean triggeredByNota, Component panel, boolean stayPut) {
        Vector<Sale> toAdd;
        Sectie sectie;
        int i;
        if (this.tabs.getSelectedIndex() > 0 && this.preSales.size() > 0) {
            DialogUtils.errorDialog(this, Utils.getTranslation(LangRoAll.verificatiComanda, new String[0]), LangRoAll.verifica);
            this.selectAllClientIndex();
            this.tabs.setSelectedIndex(0);
            return;
        }
        int checkAlreadyOpenStatus = this.checkNotaAlreadyOpened();
        switch (checkAlreadyOpenStatus) {
            case 2: {
                DialogUtils.errorDialog(panel, LangRoAll.comandaDejaDeschisaDeAlt + " " + LangRoAll.iesitiPePlan, LangRoAll.nuPotContinua);
                return;
            }
            case 3: {
                DialogUtils.errorDialog(panel, LangRoAll.masaDejaDeschisaDeTine + " " + LangRoAll.iesitiPePlan, LangRoAll.nuPotContinua);
                return;
            }
        }
        this.createOrderIfNull();
        if ((this.order.isLaPlata() || this.order.isIncasat()) && !VpConfig.getInstance().allowMarcajAfterNota && this.preSales.size() > 0) {
            DialogUtils.errorDialog(panel, LangRoAll.nuPutetiMarcaDupaNota, LangRoAll.eroare);
            return;
        }
        if (this.forcedPrinter == null && VpConfig.getInstance().touch2PrintDialogForMarcaj) {
            this.forcedPrinter = PrintLogic.getInstance().printerSelectionDialog();
        }
        RestLogic.getInstance().switchAfisajClientOrderCommit(this.order.getId());
        if (this.platou && !this.insideMenu) {
            this.platouButton.doClick();
        }
        boolean proto = false;
        if (this.order.isProtocol()) {
            proto = true;
        }
        Vector categories = this.logic.getSectii();
        int idRevenueGenerator = this.order.getUser();
        if (VpConfig.getInstance().multipleUsersPerOrder) {
            User user = UsersLogic.getInstance().requestLogin(GuiUtils.currentFrame, VpConfig.getInstance().allowPasswords, true);
            if (user != null) {
                if (UsersLogic.getInstance().isUserInGroup(user.getId(), "group_fo_users")) {
                    idRevenueGenerator = user.getId();
                }
            } else {
                DialogUtils.errorDialog(panel, LangRoAll.utilizatorSauParolaIncorecta, LangRoAll.nuPotContinua);
                return;
            }
        }
        Vector<Sectie> notEmptySectii = new Vector<Sectie>();
        Vector allSales = this.preorderTm.getAllSales();
        if (VpConfig.getInstance().recomputePricesBeforeMarcaj) {
            this.logic.recomputePricesBeforeMarcaj(this.order, allSales, new UpdateSaleBeforeMarcaj());
        }
        for (i = 0; i < categories.size(); ++i) {
            sectie = (Sectie)categories.elementAt(i);
            toAdd = this.logic.getTemporarySalesForCategory(sectie, allSales);
            if (toAdd.size() <= 0) continue;
            notEmptySectii.add(sectie);
        }
        for (i = 0; i < notEmptySectii.size(); ++i) {
            sectie = (Sectie)notEmptySectii.elementAt(i);
            toAdd = this.logic.getTemporarySalesForCategory(sectie, allSales);
            boolean cutter = true;
            if (VpConfig.getInstance().touch2PrintCutLastBonOnly) {
                cutter = i == notEmptySectii.size() - 1;
            }
            this.logic.productsSold(toAdd, this.order, this.table, sectie, proto, this.forcedPrinter, idRevenueGenerator, cutter);
            RestLogic.getInstance().pushOrderEventToReceivers(new OrderEvent(OrderEvent.OrderEventTypes.SALE_SAVED, toAdd));
        }
        this.recomputePrices();
        this.removePresalesForClientIndex(this.clientFilter1);
        this.idServire = -1;
        if (!stayPut && VpConfig.getInstance().logoutAtMarcaj) {
            this.logout();
        } else {
            this.tabs.setSelectedIndex(1);
        }
        if (!triggeredByNota) {
            this.forcedPrinter = null;
        }
        this.selectAllClientIndex();
        if (this.preSales.size() > 0) {
            DialogUtils.errorDialog(this, LangRoAll.existaProdNemarcate, LangRoAll.marcatiSauStergeti);
            this.selectAllClientIndex();
            this.tabs.setSelectedIndex(0);
        }
    }

    protected void recomputePrices() {
        this.logic.recomputePrices(this.order);
        this.refreshOrderSales();
        this.updateOrderTotal();
    }

    protected void removePresalesForClientIndex(int clientIndex) {
        Vector<Sale> toKeep = new Vector<Sale>();
        for (Sale sale : this.preSales) {
            if (clientIndex == -1 || sale.getClientIndex() == clientIndex) continue;
            toKeep.add(sale);
        }
        this.preSales.clear();
        this.preSales.addAll(toKeep);
    }

    protected JTabbedPane getTabs() {
        this.tabs = new JTabbedPane();
        this.tabs.add((Component)this.getPrecomandaPanel(), LangRoAll.precomanda);
        this.tabs.add((Component)this.getComandaPanel(), LangRoAll.comanda);
        this.tabs.setFocusable(false);
        return this.tabs;
    }

    protected boolean checkBeforeIncasat(Component parent) {
        if (RestLogic.getInstance().needPlatiCheckingAtIncasat(this.order) && !this.logic.isTotalOrderEqualWithTotalPlati(this.order)) {
            DialogUtils.errorDialog(parent, LangRoAll.tipurileDePlataNuAcopera, LangRoAll.nuPotContinua);
            return false;
        }
        return true;
    }

    protected void initButtons() {
        final TouchOrder2 parent = this;
        this.freeButton0 = this.getFreeButton0();
        this.marcaj = new JButton("<html><center>" + LangRoAll.marcaj + "<br>&nbsp;</center></html>");
        this.marcaj.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TouchOrder2.this.marcaj(false, parent, false);
            }
        });
        this.mare = this.getVerificaNotaButton();
        this.nota = new JButton("<html><center>" + LangRoAll.nota + "<br>&nbsp;</center></html>");
        this.nota.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                TouchOrder2.this.notaClicked(parent, ev);
            }
        });
        this.incasat = new JButton("<html><center>" + LangRoAll.incasat + "<br>&nbsp;</center></html>");
        this.incasat.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!TouchOrder2.this.checkBeforeIncasat(parent)) {
                    return;
                }
                boolean f = true;
                if (VpConfig.getInstance().bonFiscalAtNota) {
                    f = false;
                } else {
                    switch (TouchOrder2.this.logic.fiscalStatus) {
                        case 2: {
                            f = false;
                            break;
                        }
                        case 3: {
                            f = true;
                            break;
                        }
                    }
                }
                f = TouchOrder2.this.logic.getFinRespectWithDocumentPlata(TouchOrder2.this.order, f);
                TouchOrder2.this.incasat(f);
                if (TouchOrder2.this.config.logoutAtIncasat || UsersLogic.getInstance().isTeam(TouchOrder2.this.waiter.getId())) {
                    TouchOrder2.this.logout();
                } else if (TouchOrder2.this.config.touch3IncasatGotoMese) {
                    TouchOrder2.this.main.nota(TouchOrder2.this.order);
                } else {
                    TouchOrder2.this.setFields(TouchOrder2.this.table, TouchOrder2.this.waiter);
                }
            }
        });
        this.incasat.setEnabled(false);
        this.plan = new JButton("<html><center>" + this.getMeseName() + "<br>&nbsp;</center></html>");
        this.plan.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (TouchOrder2.this.preSales.size() > 0) {
                    DialogUtils.errorDialog(parent, LangRoAll.existaProdNemarcate, LangRoAll.marcatiSauStergeti);
                    TouchOrder2.this.selectAllClientIndex();
                    TouchOrder2.this.tabs.setSelectedIndex(0);
                } else {
                    TouchOrder2.this.goToMese();
                }
            }
        });
        this.platouButton = this.getPlatouButton();
        this.servireButton = this.getServireButton();
        this.optiuni = new JButton("<html><center>" + LangRoAll.optiuni + "<br>&nbsp;</center></html>");
        this.optiuni.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JPopupMenu popup = TouchOrder2.this.buildOptiuniPopup();
                popup.show(TouchOrder2.this.optiuni, 0, 50);
            }
        });
        this.meniu = this.getMeniuButton();
        this.logout = new JButton("<html><center>" + LangRoAll.logout + "<br>&nbsp;</center></html>");
        this.logout.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (TouchOrder2.this.preSales.size() > 0) {
                    DialogUtils.errorDialog(parent, LangRoAll.existaProdNemarcate, LangRoAll.marcatiSauStergeti);
                    TouchOrder2.this.selectAllClientIndex();
                    TouchOrder2.this.tabs.setSelectedIndex(0);
                    return;
                }
                TouchOrder2.this.logout();
            }
        });
        this.free1 = this.getFreeButton1();
        this.free2 = this.getFreeButton2();
    }

    protected JButton getVerificaNotaButton() {
        this.mare = new JButton("<html><center>" + LangRoAll.verifica + "<br>" + LangRoAll.nota + "</center></html>");
        this.mare.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                AbstractListPanel panel = new AbstractListPanel(){

                    @Override
                    public AbstractTM buildTableModel() {
                        this.tm = new AbstractTM(this.buildColumns(), this.buildTypes(), new TmInterface(){

                            @Override
                            public Object getValueAt(int rowIndex, int columnIndex, Vector data) {
                                Sale o = (Sale)data.elementAt(rowIndex);
                                String s1 = "";
                                switch (columnIndex) {
                                    case 0: {
                                        s1 = o.getProductName();
                                        String mp = o.getModPreparare();
                                        if (!Validators.correctString(mp)) break;
                                        s1 = s1 + " (" + mp + ")";
                                        break;
                                    }
                                    case 1: {
                                        s1 = s1 + o.getQuantity();
                                        break;
                                    }
                                    case 2: {
                                        s1 = s1 + Utils.getString2Decimals(o.getTotal());
                                        break;
                                    }
                                }
                                String s = "<html><font size=\"+" + TouchOrder2.this.config.mouseProductsIncreaseSize + "\">" + s1 + "</font></html>";
                                return s;
                            }

                            @Override
                            public boolean isCellEditable(int rowIndex, int columnIndex) {
                                return false;
                            }

                            @Override
                            public void setValueAt(Object aValue, int rowIndex, int columnIndex, Vector data) {
                            }
                        });
                        return this.tm;
                    }

                    @Override
                    public JPanel getBottomPanel() {
                        return null;
                    }

                    @Override
                    public Vector buildData() {
                        return TouchOrder2.this.orderTm.getAllSales();
                    }

                    @Override
                    public String[] buildColumns() {
                        return MouseOrderTableModel._columnNames;
                    }

                    @Override
                    public Class[] buildTypes() {
                        return MouseOrderTableModel._columnTypes;
                    }

                    @Override
                    public void doStuff() {
                        this.display();
                        GuiUtils.updateJTableRowSize(this.table, TouchOrder2.this.config.touchTableFontSize);
                    }
                };
                panel.doStuff();
                JDialog dialog = DialogUtils.getJDialog(panel, GuiUtils.currentFrame, LangRoAll.verificareNota, 1.1);
                dialog.setVisible(true);
            }
        });
        return this.mare;
    }

    protected void notaClicked(Component parent, ActionEvent ev) {
        boolean duplicat;
        int nrPersoaneSetat;
        boolean proceed;
        if (this.tabs.getSelectedIndex() > 0 && this.preSales.size() > 0) {
            DialogUtils.errorDialog(parent, LangRoAll.existaProdNemarcate, LangRoAll.marcatiSauStergeti);
            this.selectAllClientIndex();
            this.tabs.setSelectedIndex(0);
            return;
        }
        if (this.config.checkNota && !(proceed = DialogUtils.confirmDialog(parent, Utils.getTranslation(LangRoAll.atiVerificatNota, new String[0]), LangRoAll.confirmare))) {
            return;
        }
        if (this.forcedPrinter == null && VpConfig.getInstance().touch2PrintDialogForNota) {
            this.forcedPrinter = PrintLogic.getInstance().printerSelectionDialog();
        }
        if (this.config.notaTriggersBon) {
            this.marcaj(true, parent, false);
        } else if (this.preSales.size() > 0) {
            DialogUtils.errorDialog(parent, LangRoAll.existaProdNemarcate, LangRoAll.marcatiSauStergeti);
            this.selectAllClientIndex();
            this.tabs.setSelectedIndex(0);
            return;
        }
        if (this.order == null) {
            return;
        }
        int totalRows = this.orderTm.getRowCount();
        int maxItems = this.config.ecrMaxItems;
        if (maxItems > 0 && totalRows > maxItems && !DialogUtils.confirmDialog(parent, LangRoAll.maxProducts1 + maxItems + LangRoAll.maxProducts2, LangRoAll.atentie)) {
            return;
        }
        if (RestLogic.getInstance().needPlatiCheckingAtNota(this.order)) {
            this.logic.recomputePrices(this.order);
            if (!this.logic.isTotalOrderEqualWithTotalPlati(this.order)) {
                DialogUtils.errorDialog(parent, LangRoAll.tipurileDePlataNuAcopera, LangRoAll.nuPotContinua);
                return;
            }
        }
        if ((nrPersoaneSetat = this.logic.getNrPersoaneForOrder(this.order.getId())) == -1 && !this.order.isLaPlata()) {
            boolean requestNrPersoaneAtNota = this.config.requestNrPersoaneAtNota;
            if (requestNrPersoaneAtNota) {
                if (this.orderTm.getRowCount() > 0) {
                    DialogUtils.errorDialog(parent, LangRoAll.nuAtiAlesNrPers, LangRoAll.nuPotContinua);
                    return;
                }
                this.logic.setNrPersoaneToOrder(this.order, 0);
            } else if (this.orderTm.getRowCount() > 0) {
                this.logic.setNrPersoaneToOrder(this.order, 1);
            } else {
                this.logic.setNrPersoaneToOrder(this.order, 0);
            }
        }
        if (this.config.touch2RequestClientBeforeNota && this.order.getIdClient() <= 0) {
            DialogUtils.errorDialog(parent, LangRoAll.alegetiUnClient, LangRoAll.nuPotContinua);
            return;
        }
        if (this.config.touch2RequestDetaliiBeforeNota && !Validators.correctString(this.order.getDetalii())) {
            DialogUtils.errorDialog(parent, this.getDetaliiLipsaString(), LangRoAll.nuPotContinua);
            return;
        }
        if (this.config.requestClientFollowUp) {
            if (this.order.getIdClient() > 0) {
                SimpleDateSelector date = new SimpleDateSelector(this.config.requestClientFollowUpWithTime);
                OkCancelDialog dia = new OkCancelDialog(date, GuiUtils.currentFrame, Utils.getTranslation(LangRoAll.alegetiData, new String[0]), 2.0, false);
                dia.setVisible(true);
                Date d = date.getDates()[0];
                if (dia.isOK()) {
                    String scop = DialogUtils.inputDialog(parent, this.config.requestClientFollowUpSuggestions, Utils.getTranslation(LangRoAll.scopulVizitei, new String[0]));
                    ClientLogic.getInstance().addClientFollowup(this.order.getIdClient(), scop, d);
                }
            } else {
                DialogUtils.errorDialog(parent, LangRoAll.alegetiUnClient, LangRoAll.nuPotContinua);
                return;
            }
        }
        boolean bl = duplicat = this.order != null && (this.order.isLaPlata() || this.order.isIncasat());
        if (duplicat) {
            if (this.config.allowNoteDuplicate) {
                if (!DialogUtils.confirmDialog(parent, LangRoAll.tiparimNotaDuplicat, LangRoAll.confirmare)) {
                    return;
                }
            } else {
                return;
            }
        }
        this.idServire = -1;
        this.nota(this.config.touch3NotaGotoMese, ev);
        if (!this.config.touch3NotaGotoMese) {
            this.tabs.setSelectedIndex(1);
        }
        if (this.config.notaTriggersIncasat) {
            this.incasat.doClick();
        }
        this.forcedPrinter = null;
    }

    protected void pushMeniuAddedEvent(Meniu selectedMenu) {
        RestLogic.getInstance().pushOrderEventToReceivers(new OrderEvent(OrderEvent.OrderEventTypes.MENU_ADDED, selectedMenu));
    }

    protected JButton getMeniuButton() {
        JButton meniu = new JButton("<html><center>" + LangRoAll.meniu + "<br>&nbsp;</center></html>");
        meniu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                Vector<Meniu> meniuri;
                double cantitateCurenta = 1.0;
                if (TouchOrder2.this.kp.getValue() > 0.0) {
                    cantitateCurenta = TouchOrder2.this.kp.getValue();
                }
                if ((meniuri = TouchOrder2.this.logic.getAllMeniuriActive()).size() > 0) {
                    Meniu selected = null;
                    MeniuriDialog dia = new MeniuriDialog(3, meniuri);
                    selected = dia.getMeniu();
                    if (selected != null) {
                        TouchOrder2.this.insideMenu = true;
                        TouchOrder2.this.platouButton.doClick();
                        TouchOrder2.this.platouButton.setEnabled(false);
                        TouchOrder2.this.pushMeniuAddedEvent(selected);
                        Vector optiuniMeniu = TouchOrder2.this.logic.getOptiuniForMenu(selected.getId());
                        for (int i = 0; i < optiuniMeniu.size(); ++i) {
                            OptiuneMeniu optiuneMeniu = (OptiuneMeniu)optiuniMeniu.elementAt(i);
                            Vector produse = TouchOrder2.this.logic.getOptiuniProdusFrontOffice(selected.getId(), optiuneMeniu.getIdOptiune());
                            ProdusDialog dia2 = new ProdusDialog(2, produse);
                            OptiuneProdus optiuneProdus = dia2.getP();
                            if (optiuneProdus == null) continue;
                            int idProdus = optiuneProdus.getIdProdus();
                            Product pr = NomeclaturaLogic.getInstance().getProductById(idProdus);
                            TouchOrder2.this.addLaPrecomanda(pr, cantitateCurenta * optiuneProdus.getCantitate(), optiuneProdus.getPret(), GuiUtils.currentFrame, "");
                        }
                        TouchOrder2.this.kp.reset();
                        TouchOrder2.this.insideMenu = false;
                        TouchOrder2.this.platouButton.setEnabled(true);
                        TouchOrder2.this.platouButton.doClick();
                    }
                }
            }
        });
        return meniu;
    }

    protected JPanel getButtonsPanel() {
        this.initButtons();
        JPanel result = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        result.setBorder(new TitledBorder(LangRoAll.actiuni));
        c.fill = 1;
        c.anchor = 10;
        c.insets = this.insets;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.gridx = 0;
        c.gridy = 0;
        c.gridheight = 5;
        this.kp = new VirtualKeypad2(VpConfig.getInstance().touchSelectorFontSize, true);
        result.add((Component)this.kp, c);
        c.gridheight = 1;
        c.gridx = 1;
        c.gridy = 0;
        if (this.freeButton0 != null) {
            result.add(this.freeButton0);
            ++c.gridy;
        }
        result.add((Component)this.marcaj, c);
        ++c.gridy;
        result.add((Component)this.mare, c);
        ++c.gridy;
        result.add((Component)this.nota, c);
        ++c.gridy;
        result.add((Component)this.incasat, c);
        ++c.gridy;
        result.add((Component)this.plan, c);
        c.gridy = 0;
        c.gridx = 2;
        result.add((Component)this.platouButton, c);
        ++c.gridy;
        result.add((Component)this.servireButton, c);
        ++c.gridy;
        result.add((Component)this.optiuni, c);
        if (this.free1 != null) {
            ++c.gridy;
            result.add((Component)this.free1, c);
        }
        if (this.free2 != null) {
            ++c.gridy;
            result.add((Component)this.free2, c);
        }
        ++c.gridy;
        result.add((Component)this.logout, c);
        if (VpConfig.getInstance().showMeniuButton) {
            ++c.gridy;
            result.add((Component)this.meniu, c);
        }
        return result;
    }

    protected String getDetaliiLipsaString() {
        return LangRoAll.nuAtiCompletatDetalii;
    }

    public String getMeseName() {
        return LangRoAll.mese;
    }

    public void golestePreorder() {
        this.preorderTm.clear();
        this.preSales.clear();
        this.refreshPreOrderSales();
        this.updateTotalPreorder();
    }

    protected void scrollOrderJTable() {
        this.orderJTable.changeSelection(this.orderJTable.getRowCount() - 1, 0, false, false);
    }

    protected boolean printBonFiscalAlimentareCont(Component panel, int idProdus, double suma, Table table, int idUser, int idClient) {
        Vector<TipPlata> tipuriPlata1 = TipPlataProvider.getInstance().getTipPlata();
        Vector<TipPlata> iesPeCasa = new Vector<TipPlata>();
        for (TipPlata tipPlata2 : tipuriPlata1) {
            if (!Validators.correctString(tipPlata2.getEcrMapping())) continue;
            iesPeCasa.add(tipPlata2);
        }
        TipPlata tp = null;
        boolean somethingToDo = true;
        if (iesPeCasa.size() > 0) {
            TipPlataChooser tpc = new TipPlataChooser(4, iesPeCasa);
            tp = tpc.getSelected();
        }
        if (tp == null) {
            DialogUtils.errorDialog(panel, Utils.getTranslation(LangRoAll.tipPlataNesetatPlataNeefectuata, new String[0]), LangRoAll.nuPotContinua);
            somethingToDo = false;
        }
        if (somethingToDo) {
            RestLogic.getInstance().printBonFiscalAlimentareCont(idProdus, suma, table, idUser, idClient, tp);
        }
        return somethingToDo;
    }

    protected ActionListener buildActionListenerForFidelitateButton(final Component parent) {
        ActionListener result = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                User supervizor = null;
                if (TouchOrder2.this.config.passwordForFidelitate) {
                    supervizor = UsersLogic.getInstance().requestAdminLogin(GuiUtils.currentFrame, VpConfig.getInstance().allowPasswords, true);
                }
                if (supervizor != null || !TouchOrder2.this.config.passwordForFidelitate) {
                    CardInputDialog dialog;
                    final StringBuffer card = new StringBuffer();
                    EventGenerator soyal = TouchOrder2.this.logic.getAccesInterface();
                    if (soyal != null) {
                        dialog = new CardInputDialog((Frame)GuiUtils.currentFrame, true, VpConfig.getInstance().codFidelitateLength);
                        TouchOrder2.this.main.requestFocus();
                        ObjectEventListener l = new ObjectEventListener(){

                            @Override
                            public void dataChanged(Object o) {
                                card.append(o);
                                dialog.dispose();
                            }

                            @Override
                            public String getName() {
                                return TouchOrder2.TOUCH3_SOYAL_FIDELITATE;
                            }
                        };
                        soyal.addObjectListener(l, 701);
                        dialog.setVisible(true);
                        soyal.removeObjectListener(l);
                    } else {
                        dialog = new CardInputDialog((Frame)GuiUtils.currentFrame, true, VpConfig.getInstance().codFidelitateLength);
                        dialog.setVisible(true);
                        TouchOrder2.this.main.requestFocus();
                        card.append(dialog.getCodAutentificare());
                    }
                    String cardS = card.toString();
                    Vector<ClientPromotieView> clientiPromotii = PromotionLogic.getInstance().getPromotiiClientForCard(cardS);
                    if (clientiPromotii.size() > 0) {
                        TouchOrder2.this.createOrderIfNull();
                        ClientPromotieView cpv = clientiPromotii.get(0);
                        TouchOrder2.this.setFidelitate(parent, cpv);
                    } else if (DialogUtils.confirmDialog(parent, "Adaugam client nou", LangRoAll.confirmare)) {
                        ClientEditPanelProvider provider = new ClientEditPanelProvider(){

                            @Override
                            public PersFizicaAddEditPanel getPfPanel() {
                                return new PersFizicaAddEditPanelShort();
                            }

                            @Override
                            public PersJuridicaAddEditPanel getPjPanel() {
                                return new PersJuridicaAddEditPanel();
                            }
                        };
                        ClientEditDialog cDia = new ClientEditDialog(GuiUtils.currentFrame, ClientLogic.getInstance(), null, false, provider);
                        int clientId = cDia.getClientId();
                        if (clientId <= 0) {
                            return;
                        }
                        Vector<Promotion> promotii = PromotionLogic.getInstance().getFidelitatePromotions();
                        if (promotii.size() <= 0) {
                            DialogUtils.errorDialog(parent, Utils.getTranslation(LangRoAll.definitiCelPutinOPromotie, new String[0]), LangRoAll.nuPotContinua);
                            return;
                        }
                        PromotiiDialog dialog2 = new PromotiiDialog(4, promotii);
                        int idPromotie = promotii.get(0).getId();
                        if (promotii.size() > 0) {
                            idPromotie = dialog2.getSelected();
                        }
                        PromotionLogic.getInstance().addPromotionClient(clientId, idPromotie, cardS, cardS);
                        TouchOrder2.this.createOrderIfNull();
                        clientiPromotii = PromotionLogic.getInstance().getPromotiiClientForCard(cardS);
                        ClientPromotieView cpv = clientiPromotii.get(0);
                        TouchOrder2.this.setFidelitate(parent, cpv);
                    }
                }
                if (TouchOrder2.this.refreshOrderSalesAtClient) {
                    int idClient;
                    if (TouchOrder2.this.order != null) {
                        TouchOrder2.this.logic.deleteSalesForOrder(TouchOrder2.this.order);
                    }
                    TouchOrder2.this.createOrderIfNull();
                    if (TouchOrder2.this.order != null && (idClient = TouchOrder2.this.order.getIdClient()) > 0) {
                        TouchOrder2.this.logic.copySalesToCurrentOrderFromCont(idClient, TouchOrder2.this.order);
                    }
                    TouchOrder2.this.refreshOrderSales();
                    TouchOrder2.this.updateOrderTotal();
                    TouchOrder2.this.changeTabs(TouchOrder2.this.order);
                }
            }
        };
        return result;
    }

    protected void setFidelitate(Component parent, ClientPromotieView cpv) {
        double totalOrder1 = this.logic.getTotal(this.order);
        Vector premii = this.logic.getPremiiForClient(cpv.getIdClient(), totalOrder1);
        if (premii.size() > 0) {
            String message = Utils.getStringForJDialogList(LangRoAll.premiiPosibile, "", premii);
            DialogUtils.okDialog(parent, message, LangRoAll.premiiPosibile);
        }
        if (!this.order.isLaPlata() && !this.order.isIncasat()) {
            this.order.setIdPromotie(cpv.getIdPromotie());
            this.order.setIdClient(cpv.getIdClient());
            this.logic.setClientAndPromotionForOrder(this.order, cpv.getIdClient(), cpv.getIdPromotie());
            this.setPromotionText();
            this.setClientText();
        }
    }

    protected JPopupMenu buildOptiuniPopup() {
        final TouchOrder2 parent = this;
        Font bonItemFont = new Font(null, 1, this.config.touchKeypadFontSize + 6);
        JPopupMenu popup = new JPopupMenu();
        try {
            int optiuneButton;
            Location loc;
            JMenuItem btn;
            if (VpConfig.getInstance().showProtocolButton) {
                JMenuItem protocol = new JMenuItem(LangRoAll.protocol);
                protocol.setFont(bonItemFont);
                popup.add(protocol);
                protocol.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent ev) {
                        User supervizor = null;
                        if (TouchOrder2.this.config.passwordForProtocol) {
                            supervizor = UsersLogic.getInstance().requestAdminLogin(GuiUtils.currentFrame, VpConfig.getInstance().allowPasswords, true);
                        }
                        if (supervizor != null || !TouchOrder2.this.config.passwordForProtocol) {
                            TouchOrder2.this.createOrderIfNull();
                            if (!TouchOrder2.this.order.isLaPlata() && !TouchOrder2.this.order.isIncasat()) {
                                boolean isProtocol = TouchOrder2.this.order.isProtocol();
                                boolean newState = !isProtocol;
                                TouchOrder2.this.logic.setProtocolForOrder(TouchOrder2.this.order, newState);
                                TouchOrder2.this.order.setProtocol(newState);
                                TouchOrder2.this.setPromotionText();
                                TouchOrder2.this.recomputePrices();
                            }
                        }
                    }
                });
            }
            if (VpConfig.getInstance().showTipsButton) {
                JMenuItem tips = new JMenuItem(LangRoAll.tips);
                tips.setFont(bonItemFont);
                popup.add(tips);
                tips.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        if (TouchOrder2.this.order != null) {
                            double proposedTips = TouchOrder2.this.logic.computeTipsForOrder(TouchOrder2.this.order);
                            if (proposedTips >= 0.0) {
                                String value = DialogUtils.inputDialog(parent, Utils.getString2Decimals(proposedTips), LangRoAll.totalTips);
                                if (Validators.correctDouble(value)) {
                                    double totalTips = Utils.parseDouble(value);
                                    TouchOrder2.this.logic.setTipsToOrder1(TouchOrder2.this.order, totalTips, null);
                                    Vector<Sale> s = TouchOrder2.this.logic.getSales(TouchOrder2.this.order.getId(), TouchOrder2.this.cumulateSales, -1, new ScreenSaleInterface(), TouchOrder2.this.clientFilter1);
                                    TouchOrder2.this.orderTm.updateTable(s);
                                    TouchOrder2.this.updateOrderTotal();
                                } else {
                                    DialogUtils.errorDialog(parent, LangRoAll.valoareIncorecta, LangRoAll.nuPotContinua);
                                }
                            } else if (proposedTips == -1.0) {
                                DialogUtils.errorDialog(parent, LangRoAll.completatiCodProdusTips, LangRoAll.nuPotContinua);
                            } else if (proposedTips == -2.0) {
                                DialogUtils.errorDialog(parent, LangRoAll.codProdusTipsIncorect, LangRoAll.nuPotContinua);
                            }
                        } else {
                            DialogUtils.errorDialog(parent, LangRoAll.comandaGoala, LangRoAll.nuPotContinua);
                        }
                    }
                });
            }
            if (this.logic.getCashRegister().numerarInputReady()) {
                JMenuItem btn2 = new JMenuItem(LangRoAll.incarcaCasa);
                popup.add(btn2);
                btn2.setFont(bonItemFont);
                btn2.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent ev) {
                        String s = DialogUtils.inputDialog(parent, "0", LangRoAll.valoareIncarcaCasa);
                        if (!Validators.correctDouble(s)) {
                            DialogUtils.errorDialog(parent, LangRoAll.valoareIncorecta, LangRoAll.nuPotContinua);
                            return;
                        }
                        double value = Utils.parseDouble(s);
                        TouchOrder2.this.logic.introduNumerar(value);
                    }
                });
            }
            JMenuItem forceTotal = new JMenuItem(LangRoAll.totalCasaMarcat);
            popup.add(forceTotal);
            forceTotal.setFont(bonItemFont);
            forceTotal.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ev) {
                    TouchOrder2.this.logic.forceEcrTotal();
                }
            });
            JMenuItem recomputePrices = new JMenuItem(LangRoAll.recalculeazaNota);
            popup.add(recomputePrices);
            recomputePrices.setFont(bonItemFont);
            recomputePrices.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ev) {
                    TouchOrder2.this.recomputePrices();
                }
            });
            if (VpConfig.getInstance().showProformaButton) {
                btn = new JMenuItem(LangRoAll.proforma);
                popup.add(btn);
                btn.setFont(bonItemFont);
                btn.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent ev) {
                        User supervizor = null;
                        if (TouchOrder2.this.config.passwordForProforma) {
                            supervizor = UsersLogic.getInstance().requestAdminLogin(GuiUtils.currentFrame, VpConfig.getInstance().allowPasswords, true);
                        }
                        if (supervizor != null || !TouchOrder2.this.config.passwordForProforma) {
                            TouchOrder2.this.logic.notaProforma(TouchOrder2.this.order, TouchOrder2.this.table, null);
                        }
                    }
                });
            }
            if (VpConfig.getInstance().showIntermediaraButton) {
                btn = new JMenuItem(LangRoAll.intermediara);
                popup.add(btn);
                btn.setFont(bonItemFont);
                btn.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent ev) {
                        User supervizor = null;
                        if (TouchOrder2.this.config.passwordForIntermediara) {
                            supervizor = UsersLogic.getInstance().requestAdminLogin(GuiUtils.currentFrame, VpConfig.getInstance().allowPasswords, true);
                        }
                        if (supervizor != null || !TouchOrder2.this.config.passwordForIntermediara) {
                            TouchOrder2.this.logic.notaIntermediara(TouchOrder2.this.order, TouchOrder2.this.table, null);
                        }
                    }
                });
            }
            if (VpConfig.getInstance().showFacturaButton) {
                btn = new JMenuItem(LangRoAll.factura);
                popup.add(btn);
                btn.setFont(bonItemFont);
                btn.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        if (TouchOrder2.this.order != null) {
                            if (TouchOrder2.this.order.getIdClient() > 0) {
                                GuiUtilsRest.facturareDinComanda(TouchOrder2.this.order, TouchOrder2.this.waiter, parent, -1);
                            } else {
                                DialogUtils.errorDialog(parent, LangRoAll.alegetiUnClient, LangRoAll.nuPotContinua);
                            }
                        } else {
                            DialogUtils.errorDialog(parent, LangRoAll.comandaGoala, LangRoAll.nuPotContinua);
                        }
                    }
                });
            }
            if (VpConfig.getInstance().showClientButton) {
                JMenuItem client = new JMenuItem(LangRoAll.client);
                client.setFont(bonItemFont);
                popup.add(client);
                final ClientEditPanelProvider provider = new ClientEditPanelProvider(){

                    @Override
                    public PersFizicaAddEditPanel getPfPanel() {
                        return new PersFizicaAddEditPanel();
                    }

                    @Override
                    public PersJuridicaAddEditPanel getPjPanel() {
                        return new PersJuridicaAddEditPanel();
                    }
                };
                client.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        double totalOrder1;
                        Vector premii;
                        TouchOrder2.this.createOrderIfNull();
                        ClientSelectDialog dia = new ClientSelectDialog(GuiUtils.currentFrame);
                        int sel = dia.getSelected();
                        Client c = dia.getSelectedClient();
                        if (sel != -1) {
                            if (dia.isMustEdit() || TouchOrder2.this.config.showClientEditDialogAtClientSelection) {
                                ClientEditDialog cDia = new ClientEditDialog(GuiUtils.currentFrame, ClientLogic.getInstance(), c, c instanceof ClientPersJuridica, provider);
                            }
                        } else if (dia.isMustAdd()) {
                            boolean pf = DialogUtils.confirmDialog(parent, LangRoAll.adaugamPersFizica, LangRoAll.persFizicaJuridica);
                            ClientEditDialog cDia = new ClientEditDialog(GuiUtils.currentFrame, ClientLogic.getInstance(), null, !pf, provider);
                            sel = cDia.getClientId();
                        }
                        TouchOrder2.this.logic.setClientForOrder(TouchOrder2.this.order, sel, dia.getSelectedAdresa());
                        TouchOrder2.this.setClientText();
                        if (sel != -1 && (premii = TouchOrder2.this.logic.getPremiiForClient(sel, totalOrder1 = TouchOrder2.this.logic.getTotal(TouchOrder2.this.order))).size() > 0) {
                            String message = Utils.getStringForJDialogList(LangRoAll.premiiPosibile, "", premii);
                            DialogUtils.okDialog(parent, message, LangRoAll.premiiPosibile);
                        }
                    }
                });
            }
            if (VpConfig.getInstance().showFidelitateButton) {
                JMenuItem fidelitate = new JMenuItem(LangRoAll.fidelitate);
                fidelitate.setFont(bonItemFont);
                popup.add(fidelitate);
                fidelitate.addActionListener(this.buildActionListenerForFidelitateButton(parent));
            }
            if (VpConfig.getInstance().showPromoButton) {
                JMenuItem promotie = new JMenuItem(LangRoAll.promotie);
                promotie.setFont(bonItemFont);
                popup.add(promotie);
                promotie.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        User supervizor = null;
                        if (TouchOrder2.this.config.passwordForPromo) {
                            supervizor = UsersLogic.getInstance().requestAdminLogin(GuiUtils.currentFrame, VpConfig.getInstance().allowPasswords, true);
                        }
                        if (supervizor != null || !TouchOrder2.this.config.passwordForPromo) {
                            Vector<Promotion> promotii;
                            TouchOrder2.this.createOrderIfNull();
                            if (!TouchOrder2.this.order.isLaPlata() && !TouchOrder2.this.order.isIncasat() && (promotii = PromotionLogic.getInstance().getFidelitatePromotions()).size() > 0) {
                                PromotiiDialog dialog = new PromotiiDialog(4, promotii);
                                int idPromotie = dialog.getSelected();
                                TouchOrder2.this.logic.setPromotionForOrder(TouchOrder2.this.order, idPromotie);
                                TouchOrder2.this.order.setIdPromotie(idPromotie);
                                TouchOrder2.this.setPromotionText();
                            }
                        }
                    }
                });
            }
            JMenuItem imparteNota = new JMenuItem(LangRoAll.imparteNota);
            imparteNota.setFont(bonItemFont);
            if (VpConfig.getInstance().imparteNotaEnabled) {
                popup.add(imparteNota);
                imparteNota.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent ev) {
                        if (TouchOrder2.this.order != null) {
                            User supervizor = null;
                            if (TouchOrder2.this.config.passwordForSeparaProduse) {
                                supervizor = UsersLogic.getInstance().requestAdminLogin(GuiUtils.currentFrame, VpConfig.getInstance().allowPasswords, true);
                            }
                            if (!(supervizor == null && TouchOrder2.this.config.passwordForSeparaProduse || TouchOrder2.this.order == null)) {
                                SeparaProduseDialog dialog = new SeparaProduseDialog(TouchOrder2.this.logic, TouchOrder2.this.table);
                                TouchOrder2.this.refreshOrderSales();
                                TouchOrder2.this.updateOrderTotal();
                                TouchOrder2.this.changeTabs(TouchOrder2.this.order);
                                TouchOrder2.this.scrollOrderJTable();
                            }
                        }
                    }
                });
            }
            if (this.showTransferButton) {
                JMenuItem transfer = new JMenuItem(this.transferSource == null ? this.transferString : this.transferStringStop);
                transfer.setFont(bonItemFont);
                popup.add(transfer);
                transfer.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        if (TouchOrder2.this.preSales.size() > 0) {
                            DialogUtils.errorDialog(parent, LangRoAll.existaProdNemarcate, LangRoAll.marcatiSauStergeti);
                            TouchOrder2.this.selectAllClientIndex();
                            TouchOrder2.this.tabs.setSelectedIndex(0);
                            return;
                        }
                        String locatiePerimate = TouchOrder2.this.config.locatiePerimate;
                        int idLocatiePerimate = -1;
                        Location perimate = TouchOrder2.this.logic.getLocationByName(locatiePerimate);
                        if (perimate != null) {
                            idLocatiePerimate = perimate.getId();
                        }
                        if (TouchOrder2.this.transferSource == null) {
                            if (TouchOrder2.this.table.getIdLocatie() != idLocatiePerimate || idLocatiePerimate == -1) {
                                User supervizor = null;
                                if (TouchOrder2.this.config.passwordForTransfer) {
                                    supervizor = UsersLogic.getInstance().requestAdminLogin(GuiUtils.currentFrame, VpConfig.getInstance().allowPasswords, true);
                                }
                                if (TouchOrder2.this.order != null && (TouchOrder2.this.order.isLaPlata() || TouchOrder2.this.order.isIncasat()) && !TouchOrder2.this.config.allowTransferAfterNota) {
                                    DialogUtils.errorDialog(parent, LangRoAll.nuPutetiEfectuaTransferDupaNota, LangRoAll.nuPotContinua);
                                    return;
                                }
                                if (!(supervizor == null && TouchOrder2.this.config.passwordForTransfer || TouchOrder2.this.order == null)) {
                                    TouchOrder2.this.transferSource = TouchOrder2.this.table;
                                    TouchOrder2.this.goToMese();
                                }
                            } else {
                                DialogUtils.errorDialog(parent, "Produsele nu se pot transfera din aceasta locatie", LangRoAll.nuPotContinua);
                            }
                        } else {
                            if (TouchOrder2.this.table.getId().equals(TouchOrder2.this.transferSource.getId())) {
                                DialogUtils.errorDialog(parent, LangRoAll.acceasiMasa, LangRoAll.nuPotContinua);
                                return;
                            }
                            TouchOrder2.this.createOrderIfNull();
                            Order sourceOrder = TouchOrder2.this.logic.getOpenOrderAtTable(TouchOrder2.this.transferSource);
                            if (sourceOrder != null && (sourceOrder.isLaPlata() || sourceOrder.isIncasat()) && !TouchOrder2.this.config.allowTransferAfterNota) {
                                DialogUtils.errorDialog(parent, LangRoAll.masa + " " + TouchOrder2.this.transferSource.getLabel() + " " + LangRoAll.laPlata, LangRoAll.nuPotContinua);
                                return;
                            }
                            if (TouchOrder2.this.order != null && (TouchOrder2.this.order.isLaPlata() || TouchOrder2.this.order.isIncasat()) && !TouchOrder2.this.config.allowTransferAfterNota) {
                                DialogUtils.errorDialog(parent, LangRoAll.masa + " " + TouchOrder2.this.table.getLabel() + " " + LangRoAll.laPlata, LangRoAll.nuPotContinua);
                                return;
                            }
                            new TransferDialog(TouchOrder2.this.logic, TouchOrder2.this.transferSource, TouchOrder2.this.table);
                            TouchOrder2.this.transferSource = null;
                            TouchOrder2.this.refreshOrderSales();
                            TouchOrder2.this.updateOrderTotal();
                            TouchOrder2.this.changeTabs(TouchOrder2.this.order);
                            TouchOrder2.this.scrollOrderJTable();
                        }
                    }
                });
            }
            if (this.showNumarPersoaneButton) {
                JMenuItem numarPersoane = new JMenuItem(LangRoAll.numarPersoane);
                numarPersoane.setFont(bonItemFont);
                popup.add(numarPersoane);
                numarPersoane.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent ev) {
                        if (TouchOrder2.this.order == null) {
                            return;
                        }
                        if (TouchOrder2.this.orderTm.getRowCount() == 0) {
                            DialogUtils.errorDialog(parent, LangRoAll.comandaGoala, LangRoAll.nuPotContinua);
                            return;
                        }
                        String kpS = TouchOrder2.this.kp.getValueS();
                        if (Validators.correctInteger(kpS)) {
                            int nrPers = (int)TouchOrder2.this.kp.getValue();
                            TouchOrder2.this.logic.setNrPersoaneToOrder(TouchOrder2.this.order, nrPers);
                            TouchOrder2.this.kp.reset();
                        }
                    }
                });
            }
            if (VpConfig.getInstance().showIncarcaContButtons) {
                Vector<TipCont> conturi = ClientLogic.getInstance().getAllConturi();
                for (int i = 0; i < conturi.size(); ++i) {
                    final TipCont tipCont = conturi.elementAt(i);
                    JMenuItem contButton = new JMenuItem(LangRoAll.incarca + " " + tipCont.getLabel());
                    contButton.setFont(bonItemFont);
                    popup.add(contButton);
                    contButton.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent ev) {
                            TouchOrder2.this.incarcaCont(parent, tipCont, null);
                        }
                    });
                    contButton.setFocusable(false);
                }
            }
            if (VpConfig.getInstance().touch2BonFiscalLiberShowButton) {
                String property = VpConfig.getInstance().touch2BonFiscalLiberOptions;
                Vector options = Utils.splitString(property, '|');
                for (int i = 0; i < options.size(); ++i) {
                    Product p;
                    String idS = (String)options.elementAt(i);
                    if (!Validators.correctInteger(idS) || (p = NomeclaturaLogic.getInstance().getProductByCod(Integer.parseInt(idS))) == null) continue;
                    JMenuItem contButton = new JMenuItem(LangRoAll.bonFiscal + " " + p.getName());
                    contButton.setFont(bonItemFont);
                    popup.add(contButton);
                    double pret = this.logic.getPriceForProductCommit(p.getId());
                    final String pretS = Utils.getString2Decimals(pret);
                    contButton.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent ev) {
                            String valoare = DialogUtils.inputDialog(parent, pretS, LangRoAll.valoare);
                            if (Validators.correctDouble(valoare)) {
                                double val = Utils.parseDouble(valoare);
                                RestLogic.getInstance().printBonFiscalLiber(p, val, TouchOrder2.this.waiter);
                            } else {
                                DialogUtils.errorDialog(parent, LangRoAll.valoareIncorecta, LangRoAll.nuPotContinua);
                            }
                        }
                    });
                    contButton.setFocusable(false);
                }
            }
            if ((loc = this.logic.getLocationById(this.table.getIdLocatie())).getTip() == 2 && VpConfig.getInstance().showHotelButtons) {
                JMenuItem asociereCard = new JMenuItem(LangRoAll.asociereCard);
                asociereCard.setFont(bonItemFont);
                popup.add(asociereCard);
                asociereCard.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        User supervizor = null;
                        if (TouchOrder2.this.config.hotelPasswordForAsociereCard) {
                            supervizor = UsersLogic.getInstance().requestAdminLogin(GuiUtils.currentFrame, VpConfig.getInstance().allowPasswords, true);
                        }
                        if (supervizor != null || !TouchOrder2.this.config.hotelPasswordForAsociereCard) {
                            CardInputDialog dialog = new CardInputDialog((Frame)GuiUtils.currentFrame, true, VpConfig.getInstance().hotelCodCamereLength);
                            dialog.setVisible(true);
                            TouchOrder2.this.main.requestFocus();
                            String cod = dialog.getCodAutentificare();
                            if (Validators.correctString(cod)) {
                                TouchOrder2.this.logic.asociereCardToTable(TouchOrder2.this.table.getId(), cod);
                            } else {
                                DialogUtils.errorDialog(parent, LangRoAll.codIncorect, LangRoAll.nuPotContinua);
                            }
                        }
                    }
                });
            } else if (loc.getTip() == 1) {
                if (this.showSchimbaOspatarButton) {
                    JMenuItem schimbaOspatar = new JMenuItem(LangRoAll.schimbaOspatar);
                    schimbaOspatar.setFont(bonItemFont);
                    popup.add(schimbaOspatar);
                    schimbaOspatar.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent ev) {
                            if (TouchOrder2.this.order == null) {
                                return;
                            }
                            if (!DialogUtils.confirmDialog(parent, LangRoAll.schimbamOspatarul, LangRoAll.confirmare)) {
                                return;
                            }
                            Vector users = TouchOrder2.this.logic.getWaiters();
                            User supervizor = null;
                            if (TouchOrder2.this.config.passwordForSchimbareOspatar) {
                                supervizor = UsersLogic.getInstance().requestAdminLogin(GuiUtils.currentFrame, VpConfig.getInstance().allowPasswords, true);
                            }
                            if (!(supervizor == null && TouchOrder2.this.config.passwordForSchimbareOspatar || !VpConfig.getInstance().allowSchimbareOspatarAfterNota && (TouchOrder2.this.order.isLaPlata() || TouchOrder2.this.order.isIncasat()) || users.size() <= 0)) {
                                ChooseUserDialog dialog1 = new ChooseUserDialog(4, users);
                                int idUser = dialog1.getSelected();
                                TouchOrder2.this.logic.setUserToOrder(idUser, TouchOrder2.this.order);
                                TouchOrder2.this.goToMese();
                            }
                        }
                    });
                }
                if (this.logic.isHotelEnabled()) {
                    JMenuItem printAsocieri = new JMenuItem(LangRoAll.printCoduriCamere);
                    printAsocieri.setFont(bonItemFont);
                    popup.add(printAsocieri);
                    printAsocieri.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            User supervizor = UsersLogic.getInstance().requestAdminLogin(GuiUtils.currentFrame, VpConfig.getInstance().allowPasswords, true);
                            if (supervizor != null) {
                                TouchOrder2.this.logic.printCoduriForTables();
                            }
                        }
                    });
                }
                if (this.logic.isHotelEnabled()) {
                    JMenuItem plataLaCazare = new JMenuItem(LangRoAll.plataLaCazare);
                    plataLaCazare.setFont(bonItemFont);
                    popup.add(plataLaCazare);
                    plataLaCazare.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            if (TouchOrder2.this.order == null) {
                                return;
                            }
                            if (TouchOrder2.this.orderTm.getRowCount() == 0) {
                                DialogUtils.errorDialog(parent, LangRoAll.comandaGoala, LangRoAll.nuPotContinua);
                                return;
                            }
                            if (TouchOrder2.this.preSales.size() > 0) {
                                DialogUtils.errorDialog(parent, LangRoAll.existaProdNemarcate, LangRoAll.marcatiSauStergeti);
                                TouchOrder2.this.selectAllClientIndex();
                                TouchOrder2.this.tabs.setSelectedIndex(0);
                                return;
                            }
                            User supervizor = null;
                            if (TouchOrder2.this.config.hotelPasswordForTransferLaCamera) {
                                supervizor = UsersLogic.getInstance().requestAdminLogin(GuiUtils.currentFrame, VpConfig.getInstance().allowPasswords, true);
                            }
                            if (supervizor != null || !TouchOrder2.this.config.hotelPasswordForTransferLaCamera) {
                                CardInputDialog dialog = new CardInputDialog((Frame)GuiUtils.currentFrame, true, VpConfig.getInstance().hotelCodCamereLength);
                                dialog.setVisible(true);
                                TouchOrder2.this.main.requestFocus();
                                String cod = dialog.getCodAutentificare();
                                if (Validators.correctString(cod)) {
                                    Table destination = TouchOrder2.this.logic.getTableByCodAutentificare(cod);
                                    if (destination != null) {
                                        String locatie = TouchOrder2.this.logic.getLocationById(destination.getIdLocatie()).getName();
                                        if (DialogUtils.confirmDialog(parent, LangRoAll.transferamNotaLa + " \"" + locatie + "-" + destination.getLabel() + "\"", LangRoAll.confirmare)) {
                                            boolean allOk = TouchOrder2.this.logic.transferMasaLaHotel(parent, TouchOrder2.this.orderTm.getTotal(), destination, TouchOrder2.this.order, null);
                                            if (allOk) {
                                                if (!TouchOrder2.this.order.isLaPlata() && !TouchOrder2.this.order.isIncasat()) {
                                                    TouchOrder2.this.nota.doClick();
                                                }
                                                TouchOrder2.this.incasat.doClick();
                                            }
                                        } else {
                                            DialogUtils.errorDialog(parent, LangRoAll.operatieEsuata, LangRoAll.operatieEsuata);
                                        }
                                    } else {
                                        DialogUtils.errorDialog(parent, LangRoAll.codIncorect, LangRoAll.nuPotContinua);
                                    }
                                }
                            }
                        }
                    });
                }
            }
            if (VpConfig.getInstance().showDetaliiNota) {
                JMenuItem detaliiNota = this.getDetaliiNotaMenuItem(parent);
                detaliiNota.setFont(bonItemFont);
                popup.add(detaliiNota);
            }
            if (VpConfig.getInstance().keysShowIncarcaVanzariButton) {
                JMenuItem item = new JMenuItem(Utils.getTranslation(LangRoAll.incarcaVanzariDinXml, new String[0]));
                item.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent ev) {
                        if (TouchOrder2.this.waiter == null) {
                            return;
                        }
                        String absolutePath = FileDialog.getLoadDialogLocation(parent, Utils.getTranslation(LangRoAll.selectatiFisierul, new String[0]), "xml");
                        if (absolutePath != null) {
                            TouchOrder2.this.createOrderIfNull();
                            VanzariXmlHandler handler = new VanzariXmlHandler(parent, new AddSaleInterface(){

                                @Override
                                public void saleAdded(Product p, String quantity, double price) {
                                    double q = Utils.parseDouble(quantity);
                                    TouchOrder2.this.addLaPrecomanda(p, q, price, parent, "");
                                }
                            });
                            try {
                                Utils.importXml((DefaultHandler)handler, absolutePath);
                            }
                            catch (IOException e) {
                                Logger.logException(this, (Exception)e);
                            }
                            catch (SAXException e) {
                                Logger.logException(this, (Exception)e);
                            }
                        }
                    }
                });
                item.setFont(bonItemFont);
                popup.add(item);
            }
            if (VpConfig.getInstance().touchOrder2ShowTotalIncasari) {
                JMenuItem item = new JMenuItem(Utils.getTranslation(LangRoAll.totalIncasari, new String[0]));
                item.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent ev) {
                        double total = RestLogic.getInstance().getTotalIncasariZiuaInCurs();
                        DialogUtils.okDialog(parent, Utils.getString2Decimals(total), LangRoAll.total);
                    }
                });
                item.setFont(bonItemFont);
                popup.add(item);
            }
            if (VpConfig.getInstance().bonFiscalPrintCodFiscal) {
                JMenuItem item = new JMenuItem(Utils.getTranslation(LangRoAll.codFiscal, new String[0]));
                item.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent ev) {
                        if (TouchOrder2.this.order != null) {
                            GuiUtilsRest.setCodFiscalToOrder(parent, TouchOrder2.this.order);
                        }
                    }
                });
                item.setFont(bonItemFont);
                popup.add(item);
            }
            if ((optiuneButton = VpConfig.getInstance().showReducereValoricaButton) == 1 || optiuneButton == 2) {
                JMenuItem item = new JMenuItem(Utils.getTranslation(LangRoAll.reducereValorica));
                item.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        User supervizor = null;
                        if (optiuneButton == 1 && (supervizor = UsersLogic.getInstance().requestAdminLogin(GuiUtils.currentFrame, VpConfig.getInstance().allowPasswords, true)) == null) {
                            return;
                        }
                        String reducereValorica = DialogUtils.inputDialog(parent, "", LangRoAll.reducereValorica);
                        if (reducereValorica != null && Validators.correctDouble(reducereValorica)) {
                            double reducereValoricaFloat = Utils.parseDouble(reducereValorica);
                            RestLogic.getInstance().applyAndSetReducereValoricaToOrder(TouchOrder2.this.order, reducereValoricaFloat);
                            TouchOrder2.this.order.setReducereValorica(reducereValoricaFloat);
                        } else {
                            DialogUtils.errorDialog(parent, "Introduceti o valoare corecta", LangRoAll.nuPotContinua);
                        }
                        TouchOrder2.this.refreshOrderSales();
                        TouchOrder2.this.updateOrderTotal();
                    }
                });
                item.setFont(bonItemFont);
                popup.add(item);
            }
        }
        catch (Exception e) {
            Logger.logException(this, e);
        }
        return popup;
    }

    protected void incarcaCont(Component parent, TipCont tipCont, Double valueDinTouch) {
        if (this.order == null) {
            return;
        }
        if (this.order.getIdClient() == -1) {
            DialogUtils.errorDialog(parent, LangRoAll.alegetiUnClient, LangRoAll.nuPotContinua);
            return;
        }
        User supervizor = null;
        if (this.config.passwordForIncarcareCont) {
            supervizor = UsersLogic.getInstance().requestAdminLogin(GuiUtils.currentFrame, VpConfig.getInstance().allowPasswords, true);
            DialogUtils.okFocusEaterDialog(Utils.getTranslation(LangRoAll.alegetiSumaDeIncarcat, new String[0]), LangRoAll.confirmare);
        }
        if (supervizor != null || !this.config.passwordForIncarcareCont) {
            String valueS = "";
            if (tipCont.getProdusFictiv() > 0) {
                double value = this.logic.getPriceForProductCommit(tipCont.getProdusFictiv());
                valueS = Utils.getString2Decimals(value);
            }
            String input = DialogUtils.inputDialog(parent, valueS, LangRoAll.valoare);
            try {
                boolean printBF;
                if (!Validators.correctDouble(input)) {
                    return;
                }
                double sum = Utils.parseDouble(input);
                if (sum <= 0.0) {
                    DialogUtils.errorDialog(parent, Utils.getTranslation(LangRoAll.sumaGresita, new String[0]), LangRoAll.nuPotContinua);
                    return;
                }
                boolean somethingToDo = false;
                somethingToDo = tipCont.getProdusFictiv() > 0 ? ((printBF = true) ? this.printBonFiscalAlimentareCont(parent, tipCont.getProdusFictiv(), sum, this.table, this.waiter.getId(), this.order.getIdClient()) : true) : true;
                if (somethingToDo) {
                    ClientLogic.getInstance().adaugaTranzactieClient(tipCont.getId(), this.order.getIdClient(), sum, LangRoAll.alimentareCont);
                }
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            Thread.sleep(500L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        TouchOrder2.this.setClientText();
                    }
                });
            }
            catch (NumberFormatException e) {
                Logger.logException(this, (Exception)e);
            }
        }
    }

    protected JMenuItem getDetaliiNotaMenuItem(final Component parent) {
        JMenuItem detaliiNota = new JMenuItem(LangRoAll.detaliiNota);
        detaliiNota.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                Order orderAtTable;
                String detalii;
                TouchOrder2.this.createOrderIfNull();
                String fost = TouchOrder2.this.order.getDetalii();
                if (fost == null) {
                    fost = "";
                }
                if ((detalii = DialogUtils.inputDialog(parent, fost, LangRoAll.detaliiNota)) != null) {
                    TouchOrder2.this.order.setDetalii(detalii);
                    TouchOrder2.this.logic.setDetalii(TouchOrder2.this.order);
                }
                if ((orderAtTable = RestLogic.getInstance().getOpenOrderAtTable(TouchOrder2.this.table)) != null) {
                    User userAtTable = UsersLogic.getInstance().getUserById(orderAtTable.getUser());
                    TouchOrder2.this.setTable(TouchOrder2.this.table, userAtTable, orderAtTable);
                } else {
                    TouchOrder2.this.setTable(TouchOrder2.this.table, TouchOrder2.this.waiter, null);
                }
            }
        });
        return detaliiNota;
    }

    public void setTable(Table t, User w, Order o) {
        this.order = o;
        this.waiter = w;
        this.table = t;
        this.platou = false;
        this.platouId = -1;
        if (o != null) {
            this.platouId = this.logic.getMaxPlatouIdForOrder(o);
        }
        this.setPlatouButtonText();
        this.changeTabs(this.order);
        this.setFields(t, w);
        this.scrollOrderJTable();
        if (VpConfig.getInstance().touch2ShowQuickTableBar) {
            this.refreshQuickTable();
        }
        this.selectAllClientIndex();
    }

    protected void changeTabs(Order o) {
        if (o != null) {
            this.tabs.setSelectedIndex(1);
        } else {
            this.tabs.setSelectedIndex(0);
        }
    }

    protected void setFields(Table t, User w) {
        this.platiPanel.cleanPlatiLabel();
        this.tableText.setText(t.getLabel());
        this.ospatarText.setText(w.getLogin());
        this.table = t;
        this.waiter = w;
        if (this.order != null) {
            if (this.order.isLaPlata() || this.order.isIncasat()) {
                this.incasat.setEnabled(true);
                if (!this.config.allowMarcajAfterNota) {
                    this.marcaj.setEnabled(false);
                }
            } else {
                this.incasat.setEnabled(false);
                this.marcaj.setEnabled(true);
            }
            this.refreshOrderSales();
        } else {
            this.incasat.setEnabled(false);
            this.marcaj.setEnabled(true);
            this.orderTm.clear();
        }
        this.updateOrderTotal();
        this.setPromotionText();
        this.setClientText();
        if (VpConfig.getInstance().touch2Selector2RedrawAtTableOpen) {
            this.produsePrincipaleSelector.refreshAll(null);
        }
    }

    protected void refreshPreOrderSales() {
        Vector<Sale> s1 = new Vector<Sale>();
        block3: for (Sale sale : this.preSales) {
            switch (this.clientFilter1) {
                case -1: {
                    s1.add(sale);
                    continue block3;
                }
            }
            if (sale.getClientIndex() != this.clientFilter1) continue;
            s1.add(sale);
        }
        this.preorderTm.updateTable(s1);
        this.preorderTm.fireTableDataChanged();
    }

    protected void refreshOrderSales() {
        Vector<Sale> sales = this.logic.getSales(this.order.getId(), this.cumulateSales, -1, new ScreenSaleInterface(), this.clientFilter1);
        this.orderTm.updateTable(sales);
    }

    protected void updateOrderTotal() {
        String newTotal = Utils.getString2Decimals(this.orderTm.getTotal());
        this.totalOrder.setText(newTotal);
        if (this.order != null) {
            Vector<Plata> plati = this.logic.getPlatiForOrder(this.order.getId(), this.clientFilter1);
            double total = RestLogic.getInstance().getTotal(this.order, this.clientFilter1);
            this.platiPanel.updatePlatiLabels(plati, total);
        }
    }

    protected void setPromotionText() {
        if (this.order != null) {
            Promotion promo = PromotionLogic.getInstance().getPromotionById(this.order.getIdPromotie());
            if (promo != null) {
                String promoName = promo.getLabel();
                this.promoText.setText(promoName);
            } else {
                this.promoText.setText("");
            }
        } else {
            this.promoText.setText("");
        }
        if (this.order != null && this.order.isProtocol()) {
            this.promoText.setText(LangRoAll.protocol);
        }
    }

    protected void setClientText() {
        if (this.order != null) {
            Client c = ClientLogic.getInstance().getClientById(this.order.getIdClient());
            if (c != null) {
                this.clientText.setText(c.toString() + " " + ClientLogic.getInstance().getDetaliiConturi(c.getId()));
            } else {
                this.clientText.setText("");
            }
        } else {
            this.clientText.setText("");
        }
    }

    protected void goToMese() {
        this.idServire = -1;
        if (TouchMain2.controllerMode) {
            this.logout();
        } else if (UsersLogic.getInstance().isTeam(this.waiter.getId())) {
            this.logout();
        } else {
            this.main.plan(this.order);
        }
    }

    protected void logout() {
        this.idServire = -1;
        this.transferSource = null;
        this.main.logout(this.order);
    }

    protected void incasat(boolean f) {
        boolean ok = false;
        if (this.config.passwordForIncasat) {
            User supervizor = UsersLogic.getInstance().requestAdminLogin(GuiUtils.currentFrame, VpConfig.getInstance().allowPasswords, true);
            if (supervizor != null) {
                ok = true;
            }
        } else {
            ok = true;
        }
        if (!ok) {
            return;
        }
        if (!this.config.bonFiscalAtNota) {
            if (this.logic.cashRegisterLikesPlati(this.order)) {
                this.logic.printBonFiscalSeparat(this.order, f);
            } else {
                DialogUtils.errorDialog(this, LangRoAll.casaMarcatUnModPlata, LangRoAll.nuPotContinua);
                return;
            }
        }
        this.logic.closeOrder(this.order);
        this.marcaj.setEnabled(true);
        this.incasat.setEnabled(false);
        this.order = null;
        this.idServire = -1;
        this.platiPanel.cleanPlatiLabel();
        RestLogic.getInstance().switchAfisajClientOrderCommit(-1);
        RestLogic.getInstance().pushOrderEventToReceivers(new OrderEvent(OrderEvent.OrderEventTypes.CLOSE, null));
        this.refreshQuickTable();
    }

    protected boolean nota(boolean gotoMese, ActionEvent e) {
        if (this.order != null) {
            double maxValNota = VpConfig.getInstance().notaMaxValue;
            if (maxValNota > 0.0 && RestLogic.computeTotalForSales(this.orderTm.getAllSales()) >= maxValNota && !DialogUtils.confirmDialog(GuiUtils.currentFrame, Utils.getTranslation(LangRoAll.valoareNotaPreaMare, maxValNota + ""), LangRoAll.confirmare)) {
                return false;
            }
            boolean f = true;
            if (this.config.bonFiscalAtNota) {
                switch (this.logic.fiscalStatus) {
                    case 2: {
                        f = false;
                        break;
                    }
                    case 3: {
                        f = true;
                        break;
                    }
                }
            }
            f = this.logic.getFinRespectWithDocumentPlata(this.order, f);
            this.logic.laPlataOrder(this.order, this.table, this.forcedPrinter);
            if (this.config.bonFiscalAtNota) {
                if (this.logic.cashRegisterLikesPlati(this.order)) {
                    this.logic.printBonFiscalSeparat(this.order, f);
                } else {
                    DialogUtils.errorDialog(this, LangRoAll.casaMarcatUnModPlata, LangRoAll.nuPotContinua);
                    return false;
                }
            }
            if (!this.config.allowMarcajAfterNota) {
                this.marcaj.setEnabled(false);
            }
            this.incasat.setEnabled(true);
            if (gotoMese) {
                this.main.nota(this.order);
                if (this.config.logoutAtNota || UsersLogic.getInstance().isTeam(this.waiter.getId())) {
                    this.logout();
                }
            } else {
                this.setFields(this.table, this.waiter);
            }
            return true;
        }
        return false;
    }

    protected void setServireButtonText() {
        if (this.idServire != -1) {
            String servire = this.logic.getOrdineServireName(this.idServire);
            this.servireButton.setText("<html>" + LangRoAll.servire + " <strong><font color=\"red\">" + servire + "</font></strong></html>");
        } else {
            this.servireButton.setText("<html>" + LangRoAll.servire + "</br>&nbsp;</html>");
        }
    }

    protected void setPlatouButtonText() {
        if (this.platou) {
            this.platouButton.setText(this.platouStringStop);
        } else {
            this.platouButton.setText(this.platouString);
        }
    }

    protected Order createOrderIfNull() {
        if (this.order == null) {
            this.order = this.logic.newOrder(this.table.getId(), this.waiter.getId());
            RestLogic.getInstance().pushOrderEventToReceivers(new OrderEvent(OrderEvent.OrderEventTypes.OPEN, null));
        }
        return this.order;
    }

    protected void deleteSingleProduct(double toDelete, Component panel, Sale s, int selRow) {
        User supervizor = null;
        if (this.config.passwordForStergereRetur) {
            String previousTitle = LoginDialog.title;
            LoginDialog.title = "-" + Utils.getString3Decimals(toDelete) + " " + s.getProductName() + "?";
            supervizor = UsersLogic.getInstance().requestAdminLogin(GuiUtils.currentFrame, VpConfig.getInstance().allowPasswords, true);
            LoginDialog.title = previousTitle;
        }
        if (supervizor != null || !this.config.passwordForStergereRetur) {
            if (!DialogUtils.confirmDialog(panel, LangRoAll.retur + " " + Utils.getString3Decimals(toDelete) + " \"" + s.getProductName() + "\"", LangRoAll.confirmare)) {
                return;
            }
            User u = supervizor != null ? supervizor : this.waiter;
            this.logic.decrementSale(this.order, s, u, "", toDelete, this.table, null);
            if (s.getCantitateMarcata() == 0.0) {
                this.orderTm.removeTempSale(s, selRow);
            }
            this.orderTm.fireTableDataChanged();
            this.updateOrderTotal();
        } else {
            DialogUtils.errorDialog(panel, LangRoAll.utilizatorSauParolaIncorecta, LangRoAll.nuPotContinua);
        }
    }

    protected void deleteAllPlateau(double toDelete, Component panel, Sale s) {
        User supervizor = null;
        if (this.config.passwordForStergereRetur) {
            String previousTitle = LoginDialog.title;
            LoginDialog.title = "-" + Utils.getString3Decimals(toDelete) + " " + LangRoAll.platou + "?";
            supervizor = UsersLogic.getInstance().requestAdminLogin(GuiUtils.currentFrame, VpConfig.getInstance().allowPasswords, true);
            LoginDialog.title = previousTitle;
        }
        if (supervizor != null || !this.config.passwordForStergereRetur) {
            if (!DialogUtils.confirmDialog(panel, LangRoAll.retur + " " + Utils.getString3Decimals(toDelete) + " \"" + LangRoAll.platou + "\"", LangRoAll.confirmare)) {
                return;
            }
            User u = supervizor != null ? supervizor : this.waiter;
            int idPlatou = s.getIdPlatou();
            for (int i = 0; i < this.orderTm.getAllSales().size(); ++i) {
                Sale sale = (Sale)this.orderTm.getAllSales().elementAt(i);
                if (sale.getIdPlatou() != idPlatou) continue;
                this.logic.decrementSale(this.order, sale, u, "", toDelete, this.table, null);
            }
            this.refreshOrderSales();
            this.orderTm.fireTableDataChanged();
            this.updateOrderTotal();
        } else {
            DialogUtils.errorDialog(panel, LangRoAll.utilizatorSauParolaIncorecta, LangRoAll.nuPotContinua);
        }
    }

    @Override
    public void readQuantity(double f) {
        if (this.readFromCantar || !VpConfig.getInstance().scaleUseCantarButton) {
            this.kp.setNumber(f);
            this.readFromCantar = false;
        }
    }

    protected Selector2 getProduseRelatedPanel() {
        DataProvider2 fullDataProvider = new DataProvider2(){

            @Override
            public int getLinesPerPage(int level) {
                switch (level) {
                    case 0: {
                        return TouchOrder2.this.config.selector2Level3LinesPerPage;
                    }
                }
                return 0;
            }

            @Override
            public int getItemsPerLine(int level) {
                switch (level) {
                    case 0: {
                        return TouchOrder2.this.config.selector2Level3ItemsPerLine;
                    }
                }
                return 0;
            }

            @Override
            public int getFontSize(int level) {
                switch (level) {
                    case 0: {
                        return TouchOrder2.this.config.selector2Level3FontSize;
                    }
                }
                return 0;
            }

            @Override
            public int getFontStyle(int level) {
                return 0;
            }

            @Override
            public int getMaxLevels() {
                return 1;
            }

            @Override
            public String getTitle(int level) {
                switch (level) {
                    case 0: {
                        return LangRoAll.produse;
                    }
                }
                return "";
            }

            @Override
            public Vector getData(int level, Object selection) {
                switch (level) {
                    case 0: {
                        if (selection != null) {
                            return NomeclaturaLogic.getInstance().getProduseRelated((Product)selection);
                        }
                        return new Vector();
                    }
                    case 1: {
                        TouchOrder2.this.productSecundarChosen = true;
                        TouchOrder2.this.productChosen(selection, GuiUtils.currentFrame);
                        return null;
                    }
                }
                return new Vector();
            }

            @Override
            public int getMinBtnHeight(int level) {
                switch (level) {
                    case 0: {
                        return TouchOrder2.this.config.selector2Level1MinHeight;
                    }
                    case 1: {
                        return TouchOrder2.this.config.selector2Level2MinHeight;
                    }
                    case 2: {
                        return TouchOrder2.this.config.selector2Level3MinHeight;
                    }
                }
                return 0;
            }

            @Override
            public int getMinBtnWidth(int level) {
                switch (level) {
                    case 0: {
                        return TouchOrder2.this.config.selector2Level1MinWidth;
                    }
                    case 1: {
                        return TouchOrder2.this.config.selector2Level2MinWidth;
                    }
                    case 2: {
                        return TouchOrder2.this.config.selector2Level3MinWidth;
                    }
                }
                return 0;
            }
        };
        Selector2 sel = new Selector2(fullDataProvider, false);
        return sel;
    }
}

