/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.restaurant.gui.touch6;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import ro.atreides.clienti.ClientLogic;
import ro.atreides.clienti.ValoareContClient;
import ro.atreides.nomenclatura.NomeclaturaLogic;
import ro.atreides.nomenclatura.Product;
import ro.atreides.productie.ProductieLogic;
import ro.atreides.productie.gui.QuickSmallProductiePanel;
import ro.atreides.restaurant.VpConfig;
import ro.atreides.restaurant.base.Meniu;
import ro.atreides.restaurant.base.OptiuneMeniu;
import ro.atreides.restaurant.base.OptiuneProdus;
import ro.atreides.restaurant.base.Sale;
import ro.atreides.restaurant.base.Table;
import ro.atreides.restaurant.gui.GuiUtilsRest;
import ro.atreides.restaurant.gui.meniuri.MeniuriChoosePanel;
import ro.atreides.restaurant.gui.meniuri.MeniuriChooserBean;
import ro.atreides.restaurant.gui.meniuri.MeniuriDialog;
import ro.atreides.restaurant.gui.touch2.TouchOrder2;
import ro.atreides.restaurant.gui.touch6.TouchMain6;
import ro.atreides.restaurant.logic.RestLogic;
import ro.atreides.users.User;
import ro.atreides.users.UsersLogic;
import ro.atreides.utils.Client;
import ro.atreides.utils.Logger;
import ro.atreides.utils.TipCont;
import ro.atreides.utils.Utils;
import ro.atreides.utils.config.Config;
import ro.atreides.utils.gui.GuiUtils;
import ro.atreides.utils.gui.JMultilineLabel;
import ro.atreides.utils.gui.Validators;
import ro.atreides.utils.gui.dialogs.DialogUtils;
import ro.atreides.utils.gui.keypad.VirtualKeypad3;
import ro.atreides.utils.gui.selector.DataProvider2;
import ro.atreides.utils.gui.selector.Selector2;
import ro.atreides.utils.gui.table.ColumnSizeProvider;
import ro.atreides.utils.licensing.LicenseManager;
import ro.atreides.utils.multilang.LangRoAll;
import ro.atreides.utils.plati.Plata;

public class TouchOrder6
extends TouchOrder2 {
    private QuickSmallProductiePanel qspp;
    private Font font;
    private JPanel detaliiPanel;
    private JTextField codBareField;
    private JMultilineLabel clientText;
    private JLabel discountLabel;
    private JLabel necesarLabel;
    private JLabel totalLabel;
    private JButton clientButton;
    private JButton incarcareContButton;
    private JButton clearTextField;
    private Object syncObject;
    private Client lastAuthenticatedClient;

    public TouchOrder6(RestLogic logic, TouchMain6 main, VpConfig config, Vector sectii, boolean autoMarcaj, boolean deleteAllPlateau, boolean showMarcajButton, boolean showSelector, boolean showCodBareTextField, boolean showDetaliiPanel, boolean showNotaBottomRight, boolean showActiuniPanel, boolean showTransferIntreMagaziiButton, boolean cumulateSales) {
        super(logic, main, config, sectii, autoMarcaj, deleteAllPlateau, showMarcajButton, showSelector, showCodBareTextField, showDetaliiPanel, showNotaBottomRight, showActiuniPanel, showTransferIntreMagaziiButton, cumulateSales);
        this.font = new Font(null, 1, VpConfig.getInstance().touch2TotalFontSize);
        this.syncObject = new Object();
        this.logic = logic;
        this.main = main;
        this.config = config;
        this.sectii = sectii;
        this.marcajAtPrecomandaAdd = autoMarcaj;
        this.deleteAllPlateau = deleteAllPlateau;
        this.showTransferButton = false;
        this.showNumarPersoaneButton = false;
        this.showSchimbaOspatarButton = false;
        this.totalPreorder.setFont(this.font);
        this.totalOrder.setFont(this.font);
    }

    @Override
    protected ColumnSizeProvider getPreOrderColumnSizeProvider() {
        return new ColumnSizeProvider(){

            @Override
            public int getColumnSize(int column) {
                switch (column) {
                    case 1: {
                        return 3;
                    }
                }
                return 1;
            }
        };
    }

    @Override
    protected ColumnSizeProvider getOrderColumnSizeProvider() {
        return new ColumnSizeProvider(){

            @Override
            public int getColumnSize(int column) {
                switch (column) {
                    case 1: {
                        return 3;
                    }
                }
                return 1;
            }
        };
    }

    @Override
    protected void addLaPrecomanda(Product p, double quantity, double pret, Component panel, String modPreparare, long now) {
        super.addLaPrecomanda(p, quantity, pret, panel, modPreparare, now);
        this.codBareField.setText("");
        this.codBareField.requestFocus();
    }

    private JPanel getRightPanel() {
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 2;
        c.anchor = 18;
        c.insets = this.insets;
        c.weightx = 1.0;
        c.weighty = 0.0;
        JPanel result = new JPanel(new GridBagLayout());
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 2;
        c.gridheight = 1;
        JPanel buttonsPanel = this.getButtonsPanel();
        buttonsPanel.setFocusable(false);
        if (this.showActiuniPanel) {
            result.add((Component)buttonsPanel, c);
            ++c.gridy;
        }
        Insets buttonMargins = new Insets(5, 5, 5, 5);
        Insets buttonInsets = new Insets(5, 5, 5, 5);
        this.kp = new VirtualKeypad3(VpConfig.getInstance().touchSelectorFontSize, true, buttonMargins, buttonInsets, 1);
        Dimension d = new Dimension(200, 500);
        this.kp.setMaximumSize(d);
        this.kp.setPreferredSize(d);
        c.gridx = 0;
        c.gridwidth = 1;
        if (this.showNotaBottomRight || this.showTransferIntreMagaziiButton) {
            c.gridheight = 3;
            if (this.showNotaBottomRight && this.showTransferIntreMagaziiButton) {
                ++c.gridheight;
            }
        }
        JPanel selector = this.getSelectorPanel();
        selector.setFocusable(false);
        if (this.showSelector) {
            result.add((Component)selector, c);
        }
        ++c.gridx;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.gridheight = 1;
        c.weightx = 0.2;
        this.kp.setFocusable(false);
        result.add((Component)this.kp, c);
        c.weightx = 1.0;
        c.gridx = 0;
        ++c.gridy;
        c.weighty = 0.0;
        c.gridheight = 1;
        c.gridwidth = 1;
        c.fill = 1;
        c.anchor = 14;
        if (VpConfig.getInstance().touch6ShowProductiePanel && LicenseManager.getInstance().isGuiPanelLicenced(QuickSmallProductiePanel.class.getName())) {
            int fontSize = Config.getInstance().getInt("productieFontSize", 20);
            ProductieLogic pl = ProductieLogic.getInstance();
            Vector readIds = pl.getReadIds();
            if (readIds.size() > 1) {
                this.qspp = new QuickSmallProductiePanel(fontSize, ProductieLogic.getInstance(), pl.getReadIds(), pl.getWriteIds(), ProductieLogic.waiterInterface);
                this.qspp.setBorder(new TitledBorder("In lucru"));
                d = new Dimension(600, 200);
                this.qspp.setMinimumSize(d);
                this.qspp.setPreferredSize(d);
                this.qspp.setMaximumSize(d);
                result.add((Component)this.qspp, c);
            } else {
                result.add((Component)new JLabel(), c);
            }
        } else if (VpConfig.getInstance().showProduseRelatedPanel) {
            this.produseRelatedSelector = this.getProduseRelatedPanel();
            this.produseRelatedSelector.setBorder(new TitledBorder(LangRoAll.produseRelated));
            d = new Dimension(600, 200);
            this.produseRelatedSelector.setPreferredSize(d);
            result.add((Component)this.produseRelatedSelector, c);
        } else {
            result.add((Component)new JLabel(), c);
        }
        c.gridx = 0;
        c.anchor = 18;
        ++c.gridy;
        c.weighty = 0.0;
        c.weightx = 1.0;
        c.fill = 2;
        int cellSpan = 2;
        if (VpConfig.getInstance().touch2ShowQuickTableBar && (this.showNotaBottomRight || this.showTransferIntreMagaziiButton)) {
            cellSpan = 1;
        }
        if (VpConfig.getInstance().touch2ShowQuickTableBar) {
            JPanel quickTablePanel = this.getQuickTablePanel();
            quickTablePanel.setFocusable(false);
            c.gridwidth = cellSpan;
            c.gridy += 2;
            result.add((Component)quickTablePanel, c);
            c.gridy -= 2;
        }
        final TouchOrder6 panel = this;
        Font font = new Font(null, 1, VpConfig.getInstance().touch2TotalFontSize);
        if (this.showNotaBottomRight) {
            ++c.gridx;
            result.add((Component)this.nota, c);
            this.nota.setFocusable(false);
            this.nota.setFont(font);
            if (VpConfig.getInstance().quickUserSwitchEnabled) {
                ++c.gridy;
                result.add((Component)this.logout, c);
                this.logout.setFocusable(false);
                this.logout.setFont(font);
            }
        } else if (this.showTransferIntreMagaziiButton) {
            ++c.gridx;
            JButton bonTransfer = new JButton("<html><center>" + LangRoAll.transfera + "<br>&nbsp;</center></html>");
            bonTransfer.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    double totalF;
                    Vector sales = TouchOrder6.this.orderTm.getAllSales();
                    if (GuiUtilsRest.bonTransfer(panel, false, 1, sales, totalF = TouchOrder6.this.orderTm.getTotal(), TouchOrder6.this.waiter)) {
                        for (Sale s : sales) {
                            TouchOrder6.this.logic.decrementSale(TouchOrder6.this.order, s, TouchOrder6.this.waiter, "", s.getCantitateMarcata(), TouchOrder6.this.table, null, false);
                        }
                        TouchOrder6.this.orderTm.clear();
                        TouchOrder6.this.orderTm.fireTableDataChanged();
                        TouchOrder6.this.updateOrderTotal();
                    }
                }
            });
            result.add((Component)bonTransfer, c);
            bonTransfer.setFocusable(false);
            bonTransfer.setFont(font);
            if (VpConfig.getInstance().quickUserSwitchEnabled) {
                ++c.gridy;
                result.add((Component)this.logout, c);
                this.logout.setFocusable(false);
                this.logout.setFont(font);
            }
        }
        c.gridwidth = 2;
        ++c.gridy;
        c.gridx = 0;
        c.weighty = 1.0;
        c.fill = 1;
        JLabel spacer = new JLabel();
        result.add((Component)spacer, c);
        return result;
    }

    @Override
    protected void setPromotionText() {
        if (this.order != null) {
            Client c = ClientLogic.getInstance().getClientById(this.order.getIdClient());
            if (c != null) {
                String reducere = Utils.getString2Decimals(RestLogic.getInstance().getAvailableDiscountBeforeNota(c));
                String detaliiCont = ClientLogic.getInstance().getDetaliiConturi(c.getId());
                this.promoText.setText("DISCOUNT " + reducere + " " + detaliiCont);
            } else {
                this.promoText.setText("");
            }
        } else {
            this.promoText.setText("");
        }
        if (this.order != null && this.order.isProtocol()) {
            this.promoText.setText(LangRoAll.protocol);
        }
    }

    @Override
    protected JPanel getDetaliiPanel() {
        JPanel result = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 2;
        c.anchor = 10;
        c.insets = this.insets;
        c.weightx = 1.0;
        c.weighty = 0.0;
        Font font = new Font(null, 1, VpConfig.getInstance().touch2ClientFontSize);
        c.gridx = 0;
        c.gridy = 0;
        this.ospatarText = new JLabel();
        this.ospatarText.setForeground(Color.BLACK);
        this.ospatarText.setFont(font);
        this.tableText = new JLabel();
        this.tableText.setForeground(Color.black);
        this.tableText.setFont(font);
        ++c.gridy;
        c.gridx = 0;
        c.weighty = 1.0;
        c.fill = 1;
        this.clientText = new JMultilineLabel();
        this.clientText.setForeground(Color.RED);
        this.clientText.setFont(font);
        result.add((Component)this.clientText, c);
        c.gridx = 0;
        ++c.gridy;
        this.promoText = new JLabel();
        result.add((Component)this.promoText, c);
        this.promoText.setForeground(Color.RED);
        this.promoText.setFont(font);
        result.add((Component)this.promoText, c);
        result.setBorder(new EtchedBorder());
        return result;
    }

    @Override
    protected void setClientText() {
        if (this.order != null) {
            Client c = ClientLogic.getInstance().getClientById(this.order.getIdClient());
            if (c != null) {
                this.clientText.setText(c.toString());
            } else {
                this.clientText.setText("");
            }
        } else {
            this.clientText.setText("");
        }
        this.setPromotionText();
    }

    protected void marcaj(boolean triggeredByNota, Component panel) {
        super.marcaj(triggeredByNota, panel, false);
        if (this.qspp != null) {
            this.qspp.refreshData();
        }
    }

    @Override
    protected void setFields(Table t, User w) {
        super.setFields(t, w);
        if (this.qspp != null) {
            this.qspp.setUser(w.getId(), w.getLogin());
            this.qspp.refreshData();
        }
        this.codBareField.requestFocus();
        if (VpConfig.getInstance().showClientButton && !VpConfig.getInstance().touch6DontShowClientDialog) {
            new Thread(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        Thread.sleep(500L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    Object object = TouchOrder6.this.syncObject;
                    synchronized (object) {
                        if (TouchOrder6.this.order == null || TouchOrder6.this.order.getIdClient() <= 0) {
                            TouchOrder6.this.clientButton.doClick();
                        }
                    }
                }
            }.start();
        }
    }

    @Override
    protected JPanel getSelectorPanel() {
        DataProvider2 fullDataProvider = new DataProvider2(){

            @Override
            public int getLinesPerPage(int level) {
                switch (level) {
                    case 0: {
                        return ((TouchOrder6)TouchOrder6.this).config.selector2Level2LinesPerPage;
                    }
                    case 1: {
                        return ((TouchOrder6)TouchOrder6.this).config.selector2Level3LinesPerPage;
                    }
                }
                return 0;
            }

            @Override
            public int getItemsPerLine(int level) {
                switch (level) {
                    case 0: {
                        return ((TouchOrder6)TouchOrder6.this).config.selector2Level2ItemsPerLine;
                    }
                    case 1: {
                        return ((TouchOrder6)TouchOrder6.this).config.selector2Level3ItemsPerLine;
                    }
                }
                return 0;
            }

            @Override
            public int getFontSize(int level) {
                switch (level) {
                    case 0: {
                        return ((TouchOrder6)TouchOrder6.this).config.selector2Level2FontSize;
                    }
                    case 1: {
                        return ((TouchOrder6)TouchOrder6.this).config.selector2Level3FontSize;
                    }
                }
                return 0;
            }

            @Override
            public int getFontStyle(int level) {
                return 1;
            }

            @Override
            public int getMaxLevels() {
                return 2;
            }

            @Override
            public String getTitle(int level) {
                switch (level) {
                    case 0: {
                        return LangRoAll.categorii;
                    }
                    case 1: {
                        return LangRoAll.produse;
                    }
                }
                return "";
            }

            @Override
            public Vector getData(int level, Object selection) {
                switch (level) {
                    case 0: {
                        return TouchOrder6.this.getSubcategoriesRow(selection);
                    }
                    case 1: {
                        return TouchOrder6.this.getProductsRow(selection);
                    }
                    case 2: {
                        TouchOrder6.this.productChosen(selection, GuiUtils.currentFrame);
                        return null;
                    }
                }
                return new Vector();
            }

            @Override
            public int getMinBtnHeight(int level) {
                switch (level) {
                    case 0: {
                        return ((TouchOrder6)TouchOrder6.this).config.selector2Level1MinHeight;
                    }
                    case 1: {
                        return ((TouchOrder6)TouchOrder6.this).config.selector2Level2MinHeight;
                    }
                    case 2: {
                        return ((TouchOrder6)TouchOrder6.this).config.selector2Level3MinHeight;
                    }
                }
                return 0;
            }

            @Override
            public int getMinBtnWidth(int level) {
                switch (level) {
                    case 0: {
                        return ((TouchOrder6)TouchOrder6.this).config.selector2Level1MinWidth;
                    }
                    case 1: {
                        return ((TouchOrder6)TouchOrder6.this).config.selector2Level2MinWidth;
                    }
                    case 2: {
                        return ((TouchOrder6)TouchOrder6.this).config.selector2Level3MinWidth;
                    }
                }
                return 0;
            }
        };
        this.produsePrincipaleSelector = new Selector2(fullDataProvider);
        return this.produsePrincipaleSelector;
    }

    @Override
    protected void display() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 1;
        c.anchor = 10;
        c.insets = this.insets;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.weighty = 1.0;
        JPanel rightPanel = this.getRightPanel();
        rightPanel.setFocusable(false);
        JSplitPane splitPane = new JSplitPane(1, this.buildLeftPanel(), rightPanel);
        splitPane.setDividerLocation(0.4);
        this.add((Component)splitPane, c);
        splitPane.setFocusable(false);
        this.setFocusable(false);
        this.codBareField.requestFocusInWindow();
        this.codBareField.requestDefaultFocus();
    }

    private JPanel buildLeftPanel() {
        JPanel result = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        result.setBorder(new TitledBorder(LangRoAll.actiuni));
        c.fill = 1;
        c.anchor = 10;
        c.insets = this.insets;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.gridx = 0;
        c.gridy = 0;
        c.fill = 2;
        this.detaliiPanel = this.getDetaliiPanel();
        if (this.showDetaliiPanel) {
            this.detaliiPanel.setMinimumSize(new Dimension(350, 90));
            result.add((Component)this.detaliiPanel, c);
        }
        c.gridx = 0;
        ++c.gridy;
        this.codBareField = new JTextField();
        this.codBareField.addKeyListener(new KeyListener(){

            @Override
            public void keyPressed(KeyEvent e) {
                System.out.println("keycode " + e.getKeyCode() + " keychar \"" + e.getKeyChar() + "\"");
                Logger.logDebugVerbose(this, "keycode " + e.getKeyCode() + " keychar \"" + e.getKeyChar() + "\"");
            }

            @Override
            public void keyReleased(KeyEvent e) {
                TouchOrder6.this.handleKey(e.getKeyCode());
            }

            @Override
            public void keyTyped(KeyEvent e) {
            }
        });
        this.codBareField.setFocusable(true);
        this.codBareField.setFocusCycleRoot(true);
        if (this.showCodBareTextField) {
            result.add((Component)this.codBareField, c);
            this.codBareField.addFocusListener(new FocusAdapter(){

                @Override
                public void focusGained(FocusEvent e) {
                    TouchOrder6.this.codBareField.setBackground(Color.CYAN);
                }

                @Override
                public void focusLost(FocusEvent e) {
                    TouchOrder6.this.codBareField.setBackground(Color.RED);
                }
            });
            ++c.gridx;
            c.fill = 0;
            c.weightx = 0.0;
            this.clearTextField = new JButton("<-");
            this.clearTextField.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    TouchOrder6.this.codBareField.setText("");
                    TouchOrder6.this.codBareField.requestFocus();
                }
            });
            result.add((Component)this.clearTextField, c);
        }
        c.weightx = 1.0;
        c.gridwidth = 2;
        c.fill = 1;
        c.weighty = 1.0;
        ++c.gridy;
        c.gridx = 0;
        JTabbedPane tabs1 = this.getTabs();
        this.tabs.setFocusable(false);
        result.add((Component)tabs1, c);
        result.setMinimumSize(new Dimension(350, 750));
        return result;
    }

    protected void handleKey(int keyCode) {
        switch (keyCode) {
            case 10: {
                String barcode = this.codBareField.getText().trim();
                if (Validators.correctString(barcode)) {
                    Product p = NomeclaturaLogic.getInstance().getProductByCodBare(barcode);
                    if (p == null) {
                        String message = Utils.getTranslation(LangRoAll.produsNegasit, new String[0]) + " " + barcode;
                        DialogUtils.errorDialog(this, message, LangRoAll.atentie);
                        this.codBareField.setText("");
                        this.codBareField.requestFocus();
                        UsersLogic.getInstance().addUserLogCommit(this.waiter.getId(), message + " in comanda " + this.order.getId());
                    }
                    if (p != null) {
                        double q1 = 1.0;
                        String valueS = this.kp.getValueS();
                        if (Validators.correctDouble(valueS)) {
                            q1 = Utils.parseDouble(valueS);
                        }
                        this.addLaPrecomanda(p, q1, this);
                    }
                }
                this.codBareField.setText("");
                this.codBareField.requestFocus();
                this.kp.reset();
                break;
            }
        }
    }

    @Override
    protected JPanel getButtonsPanel() {
        this.initButtons();
        JPanel result = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        result.setBorder(new TitledBorder(LangRoAll.actiuni));
        c.fill = 1;
        c.anchor = 10;
        c.insets = this.insets;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.gridx = 0;
        c.gridy = 0;
        if (VpConfig.getInstance().showClientButton) {
            this.clientButton = new JButton(LangRoAll.client);
            final ActionListener clientButtonListener = this.buildActionListenerForFidelitateButton(this);
            this.clientButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    clientButtonListener.actionPerformed(e);
                    TouchOrder6.this.codBareField.requestFocus();
                }
            });
            result.add((Component)this.clientButton, c);
            ++c.gridx;
            this.clientButton.setFocusable(false);
        }
        if (VpConfig.getInstance().showMeniuButton) {
            result.add((Component)this.meniu, c);
            ++c.gridx;
            this.meniu.setFocusable(false);
        }
        if (VpConfig.getInstance().showPlatouButton) {
            result.add((Component)this.platouButton, c);
            ++c.gridx;
            this.platouButton.setFocusable(false);
        }
        if (VpConfig.getInstance().showServireFields) {
            result.add((Component)this.servireButton, c);
            ++c.gridx;
            this.servireButton.setFocusable(false);
        }
        if (VpConfig.getInstance().scaleUseCantarButton) {
            JButton cantarButton = this.getCantarButton();
            result.add((Component)cantarButton, c);
            ++c.gridx;
            cantarButton.setFocusable(false);
        }
        final TouchOrder6 panel = this;
        if (VpConfig.getInstance().showIncarcaContButtons) {
            this.incarcareContButton = new JButton(LangRoAll.incarca);
            this.incarcareContButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Vector<TipCont> tipConts = ClientLogic.getInstance().getAllConturi();
                    Double incarcaDinTouch = null;
                    if (Validators.correctDouble(TouchOrder6.this.kp.getValueS())) {
                        incarcaDinTouch = TouchOrder6.this.kp.getValue();
                        TouchOrder6.this.kp.reset();
                    }
                    TouchOrder6.this.incarcaCont(panel, tipConts.get(0), incarcaDinTouch);
                }
            });
            result.add((Component)this.incarcareContButton, c);
            ++c.gridx;
            this.incarcareContButton.setFocusable(false);
        }
        if (this.showMarcajButton) {
            result.add((Component)this.marcaj, c);
            this.marcaj.setFocusable(false);
        }
        if (VpConfig.getInstance().showNotaButton) {
            ++c.gridx;
            result.add((Component)this.nota, c);
            this.nota.setFocusable(false);
        }
        if (VpConfig.getInstance().showOptiuniButton) {
            ++c.gridx;
            result.add((Component)this.optiuni, c);
            this.optiuni.setFocusable(false);
        }
        if (VpConfig.getInstance().showMeseButton) {
            ++c.gridx;
            result.add((Component)this.plan, c);
            this.plan.setFocusable(false);
        }
        if (VpConfig.getInstance().showLogoutButton) {
            ++c.gridx;
            result.add((Component)this.logout, c);
            this.logout.setFocusable(false);
        }
        result.setFocusable(false);
        return result;
    }

    @Override
    protected JButton getMeniuButton() {
        JButton meniu = new JButton("<html><center>" + LangRoAll.meniu + "<br>&nbsp;</center></html>");
        meniu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                Vector<Meniu> meniuri;
                int cantitateCurenta = 1;
                if (TouchOrder6.this.kp.getValue() > 0.0) {
                    if (!Validators.correctInteger(TouchOrder6.this.kp.getValueS())) {
                        TouchOrder6.this.kp.setNumber(1.0);
                    } else {
                        cantitateCurenta = (int)TouchOrder6.this.kp.getValue();
                    }
                }
                if ((meniuri = TouchOrder6.this.logic.getAllMeniuriActive()).size() > 0) {
                    Meniu selected = null;
                    if (meniuri.size() == 1) {
                        selected = meniuri.get(0);
                    } else {
                        MeniuriDialog dia = new MeniuriDialog(3, meniuri);
                        selected = dia.getMeniu();
                    }
                    if (selected != null) {
                        TouchOrder6.this.pushMeniuAddedEvent(selected);
                        Map<Object, Object> beans = Collections.synchronizedMap(new LinkedHashMap());
                        Vector optiuniMeniu = TouchOrder6.this.logic.getOptiuniForMenu(selected.getId());
                        for (int i = 0; i < optiuniMeniu.size(); ++i) {
                            OptiuneMeniu optiuneMeniu = (OptiuneMeniu)optiuniMeniu.elementAt(i);
                            Vector<MeniuriChooserBean> bs = new Vector<MeniuriChooserBean>();
                            Vector produse = TouchOrder6.this.logic.getOptiuniProdusFrontOffice(selected.getId(), optiuneMeniu.getIdOptiune());
                            for (OptiuneProdus optiuneProdus : produse) {
                                MeniuriChooserBean mcb = new MeniuriChooserBean();
                                mcb.setIdProduct(optiuneProdus.getIdProdus());
                                mcb.setNumeProdus(optiuneProdus.getProduct());
                                mcb.setOptiuni("");
                                mcb.setOp(optiuneProdus);
                                bs.add(mcb);
                            }
                            beans.put(optiuneMeniu.getNumeOptiune(), bs);
                        }
                        boolean stop = false;
                        while (!stop) {
                            TouchOrder6.this.insideMenu = true;
                            TouchOrder6.this.platouButton.doClick();
                            MeniuriChoosePanel mcp = new MeniuriChoosePanel(beans, cantitateCurenta);
                            mcp.display();
                            JDialog dia2 = DialogUtils.getJDialog(mcp, GuiUtils.currentFrame, "Meniu: " + selected.getLabel(), 1.1);
                            mcp.setParent(dia2);
                            dia2.setVisible(true);
                            cantitateCurenta = mcp.getQuantity();
                            if (!mcp.isCancel()) {
                                boolean diff;
                                beans = mcp.getProducts();
                                boolean forceAllMenuOptions = VpConfig.getInstance().forceAllMenuOptions;
                                boolean bl = diff = optiuniMeniu.size() != TouchOrder6.this.getSelectedBeansNo(beans);
                                if (forceAllMenuOptions && diff) {
                                    DialogUtils.errorDialog(GuiUtils.currentFrame, "Ati omis optiuni din meniu!", LangRoAll.eroare);
                                    TouchOrder6.this.kp.reset();
                                    TouchOrder6.this.platouButton.setEnabled(true);
                                    TouchOrder6.this.platouButton.doClick();
                                    TouchOrder6.this.insideMenu = false;
                                    return;
                                }
                                Set<Object> keys = beans.keySet();
                                for (String string : keys) {
                                    Vector mcbs = (Vector)beans.get(string);
                                    MeniuriChooserBean selectedMCB = null;
                                    for (MeniuriChooserBean mcb : mcbs) {
                                        if (!mcb.isSelected()) continue;
                                        selectedMCB = mcb;
                                        break;
                                    }
                                    if (selectedMCB == null) continue;
                                    int idProdus = selectedMCB.getIdProduct();
                                    Product pr = NomeclaturaLogic.getInstance().getProductById(idProdus);
                                    OptiuneProdus op = selectedMCB.getOp();
                                    TouchOrder6.this.addLaPrecomanda(pr, (double)cantitateCurenta * op.getCantitate(), op.getPret(), GuiUtils.currentFrame, selectedMCB.getOptiuni());
                                }
                                if (mcp.isSaveAndQuit()) {
                                    stop = true;
                                }
                            } else {
                                stop = true;
                            }
                            TouchOrder6.this.kp.reset();
                            TouchOrder6.this.insideMenu = false;
                            TouchOrder6.this.platouButton.setEnabled(true);
                            TouchOrder6.this.platouButton.doClick();
                        }
                    }
                }
            }
        });
        return meniu;
    }

    private int getSelectedBeansNo(Map<String, Vector<MeniuriChooserBean>> beans) {
        int selectedNo = 0;
        Set<String> keys = beans.keySet();
        for (String key : keys) {
            Vector<MeniuriChooserBean> mcbs = beans.get(key);
            for (MeniuriChooserBean mcb : mcbs) {
                if (!mcb.isSelected()) continue;
                ++selectedNo;
            }
        }
        return selectedNo;
    }

    @Override
    protected JPanel displayOrderPanel(JScrollPane scroll, JLabel totalLabel1, JPanel platiPanel) {
        JPanel result = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.insets = this.insets;
        c.weightx = 1.0;
        c.weighty = 0.0;
        Font font = new Font(null, 0, VpConfig.getInstance().touch2TotalFontSize);
        c.fill = 2;
        c.anchor = 13;
        c.gridwidth = 1;
        c.gridx = 0;
        c.gridy = 0;
        this.totalLabel = new JLabel();
        this.totalLabel.setForeground(Color.RED);
        this.totalLabel.setFont(font);
        result.add((Component)this.totalLabel, c);
        ++c.gridx;
        this.discountLabel = new JLabel();
        this.discountLabel.setForeground(Color.RED);
        this.discountLabel.setFont(font);
        result.add((Component)this.discountLabel, c);
        ++c.gridy;
        c.gridx = 0;
        this.necesarLabel = new JLabel();
        this.necesarLabel.setForeground(Color.RED);
        this.necesarLabel.setFont(font);
        c.gridwidth = 2;
        result.add((Component)this.necesarLabel, c);
        c.fill = 1;
        c.anchor = 10;
        ++c.gridy;
        c.gridx = 0;
        c.gridwidth = 2;
        c.weighty = 1.0;
        result.add((Component)scroll, c);
        c.fill = 0;
        ++c.gridy;
        c.gridx = 0;
        c.gridwidth = 2;
        c.weighty = 0.0;
        result.add((Component)platiPanel, c);
        return result;
    }

    @Override
    protected void updateOrderTotal() {
        double total1 = this.orderTm.getTotal();
        String newTotal = Utils.getString2Decimals(total1);
        String newDiscount = Utils.getString2Decimals(this.orderTm.getDiscount());
        this.totalLabel.setText("Total " + newTotal);
        this.discountLabel.setText("Discount " + newDiscount);
        if (this.order != null) {
            Vector<ValoareContClient> contValues = ClientLogic.getInstance().getConturiClient(this.order.getIdClient(), -1);
            if (contValues.size() > 0) {
                double valoareActualaCont = contValues.get(0).getValoare();
                double canPayValue = valoareActualaCont + -VpConfig.getInstance().incarcareContAllowFinishValue;
                double dePlata = Math.max(total1 - canPayValue, 0.0);
                this.necesarLabel.setText("Incarca " + Utils.getString2Decimals(dePlata));
            }
            Vector<Plata> plati = this.logic.getPlatiForOrder(this.order.getId(), this.clientFilter1);
            double total = RestLogic.getInstance().getTotal(this.order, this.clientFilter1);
            this.platiPanel.updatePlatiLabels(plati, total);
        }
    }

    @Override
    protected JPanel displayPreorderPanel(JLabel t1, JScrollPane preorderScroll) {
        JPanel result = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 1;
        c.anchor = 10;
        c.insets = this.insets;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.gridx = 0;
        c.gridy = 0;
        result.add((Component)t1, c);
        t1.setFont(this.font);
        ++c.gridx;
        this.totalPreorder.setFont(this.font);
        result.add((Component)this.totalPreorder, c);
        ++c.gridy;
        c.gridx = 0;
        c.weighty = 1.0;
        c.gridwidth = 2;
        result.add((Component)preorderScroll, c);
        return result;
    }
}

