/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.restaurant.gui.touch8;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Date;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JMenuItem;
import ro.atreides.acces.contracte.ContracteLogic;
import ro.atreides.clienti.ClientLogic;
import ro.atreides.clienti.ClientPersJuridica;
import ro.atreides.clienti.gui.ClientEditDialog;
import ro.atreides.clienti.gui.ClientEditPanelProvider;
import ro.atreides.clienti.gui.ClientSelectDialog;
import ro.atreides.clienti.gui.PersFizicaAddEditPanel;
import ro.atreides.clienti.gui.PersJuridicaAddEditPanel;
import ro.atreides.restaurant.VpConfig;
import ro.atreides.restaurant.gui.touch2.TouchMain2;
import ro.atreides.restaurant.gui.touch2.TouchOrder2;
import ro.atreides.restaurant.logic.RestLogic;
import ro.atreides.utils.Client;
import ro.atreides.utils.DateUtils;
import ro.atreides.utils.Formatters;
import ro.atreides.utils.Utils;
import ro.atreides.utils.gui.GuiUtils;
import ro.atreides.utils.gui.dialogs.DialogUtils;
import ro.atreides.utils.multilang.LangRoAll;

public class TouchOrder8
extends TouchOrder2 {
    public TouchOrder8(RestLogic logic, TouchMain2 main, VpConfig config, Vector sectii, boolean autoMarcaj, boolean deleteAllPlateau) {
        super(logic, main, config, sectii, autoMarcaj, deleteAllPlateau);
    }

    @Override
    protected JButton getServireButton() {
        JButton clientButton = new JButton(LangRoAll.client);
        final TouchOrder8 parent = this;
        final ClientEditPanelProvider provider = new ClientEditPanelProvider(){

            @Override
            public PersFizicaAddEditPanel getPfPanel() {
                return new PersFizicaAddEditPanel();
            }

            @Override
            public PersJuridicaAddEditPanel getPjPanel() {
                return new PersJuridicaAddEditPanel();
            }
        };
        clientButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ClientEditDialog cDia;
                TouchOrder8.this.createOrderIfNull();
                ClientSelectDialog dia = new ClientSelectDialog(GuiUtils.currentFrame);
                int sel = dia.getSelected();
                Client c = dia.getSelectedClient();
                if (sel != -1) {
                    if (((TouchOrder8)TouchOrder8.this).config.showClientEditDialogAtClientSelection) {
                        cDia = new ClientEditDialog(GuiUtils.currentFrame, ClientLogic.getInstance(), c, c instanceof ClientPersJuridica, provider);
                    }
                } else if (dia.isMustAdd()) {
                    cDia = new ClientEditDialog(GuiUtils.currentFrame, ClientLogic.getInstance(), null, false, provider);
                    sel = cDia.getClientId();
                }
                if (sel != -1) {
                    TouchOrder8.this.logic.setClientForOrder(TouchOrder8.this.order, sel, dia.getSelectedAdresa());
                    TouchOrder8.this.setClientText();
                    Date stopDate = DateUtils.getEndOfDay(new Date());
                    Date startDate = DateUtils.addDaysToDate(stopDate, -365);
                    startDate = DateUtils.getStartOfDay(startDate);
                    double totalBonCurent = 0.0;
                    if (TouchOrder8.this.order != null) {
                        totalBonCurent = RestLogic.getInstance().getTotal(TouchOrder8.this.order);
                    }
                    double total = RestLogic.getInstance().getTotalIncasariClient(c, startDate, stopDate);
                    int count = RestLogic.getInstance().getCountIncasariClient(c, startDate, stopDate);
                    String perioada = Formatters.DATE_FORMAT_RO.format(startDate) + " - " + Formatters.DATE_FORMAT_RO.format(stopDate);
                    Vector<String> linesForIstoric = new Vector<String>();
                    linesForIstoric.add("TOTAL : " + Utils.getString2DecimalsNoTrunc(totalBonCurent + total));
                    linesForIstoric.add("Numar comenzi : " + count);
                    String text = Utils.getStringForJDialogList("Perioada : " + perioada, "Nici o inregistrare in istoric", linesForIstoric);
                    DialogUtils.okDialog(parent, text, "Istoric comenzi pe 1 an");
                    linesForIstoric.clear();
                    Vector c1 = ContracteLogic.getInstance().getComments(c.getId());
                    for (int i = 0; i < c1.size(); ++i) {
                        String s = (String)c1.elementAt(i);
                        linesForIstoric.add(s);
                    }
                    text = Utils.getStringForJDialogList("", "Nu exista observatii", linesForIstoric);
                    DialogUtils.okDialog(parent, text, "Observatii");
                }
            }
        });
        return clientButton;
    }

    @Override
    protected JMenuItem getDetaliiNotaMenuItem(final Component parent) {
        JMenuItem detaliiNota = new JMenuItem("Observatii client");
        detaliiNota.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                String detalii;
                TouchOrder8.this.createOrderIfNull();
                if (TouchOrder8.this.order.getIdClient() > 0 && (detalii = DialogUtils.inputDialog(parent, "", LangRoAll.detalii)) != null) {
                    String now = Formatters.DATE_AND_TIME_FORMAT.format(new Date());
                    ContracteLogic.getInstance().addComment(now + ": " + detalii, TouchOrder8.this.order.getIdClient());
                }
            }
        });
        return detaliiNota;
    }
}

