/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.restaurant.imports.asscon;

import java.awt.Color;
import java.io.IOException;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Date;
import java.util.Vector;
import ro.atreides.clienti.ClientLogic;
import ro.atreides.clienti.ClientPersJuridica;
import ro.atreides.contabilitate.ContaLogic;
import ro.atreides.contabilitate.NirEntryFull;
import ro.atreides.nomenclatura.Categorie;
import ro.atreides.nomenclatura.NomeclaturaLogic;
import ro.atreides.nomenclatura.Product;
import ro.atreides.nomenclatura.Sectie;
import ro.atreides.restaurant.logic.RestLogic;
import ro.atreides.stocks.Magazie;
import ro.atreides.stocks.Stock;
import ro.atreides.stocks.StockLogic;
import ro.atreides.utils.Client;
import ro.atreides.utils.Logger;
import ro.atreides.utils.Unit;
import ro.atreides.utils.Utils;
import ro.atreides.utils.db.ConnectionPool;
import ro.atreides.utils.dbf.DbfImporter;
import ro.atreides.utils.dbf.DbfImporterInterface;
import ro.atreides.utils.gui.Validators;
import ro.atreides.utils.tva.Tva;
import ro.atreides.utils.tva.TvaLogic;
import ro.atreides.utils.units.UnitsLogic;

public class AssconImporter {
    Tva tva = TvaLogic.getInstance().getTvas().get(0);
    Tva tvaNoi = TvaLogic.getInstance().getTvas().get(0);
    double totalValoare = 0.0;
    double totalTva = 0.0;
    double totalValoareAmanunt = 0.0;
    double totalTvaAmanunt = 0.0;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean importNomenclatorStocuri(String filename) {
        ConnectionPool pool = ConnectionPool.getInstance();
        try {
            DbfImporter.importDbf(filename, new DbfImporterInterface(){

                @Override
                public void importLine(Object[] line) throws SQLException {
                    String denumire = (String)line[0];
                    String um = (String)line[2];
                    String codBare = (String)line[6];
                    double stocWarning = 0.0;
                    Double d = (Double)line[16];
                    if (d != null) {
                        stocWarning = d;
                    }
                    int idUnit = -1;
                    Unit u = UnitsLogic.getInstance().getUnitByNameNoCommit(um);
                    idUnit = u == null ? UnitsLogic.getInstance().addUnitNoCommit(um) : u.getId();
                    Product p = NomeclaturaLogic.getInstance().getProductByCodBareNoCommit(codBare);
                    if (p == null) {
                        int idSectie = -1;
                        Sectie sectie = NomeclaturaLogic.getInstance().getSectieByNameNoCommit("UndefinedS");
                        idSectie = sectie == null ? NomeclaturaLogic.getInstance().addSectieNoCommit("UndefinedS", "", "") : sectie.getId();
                        int idCategorie = -1;
                        Categorie categorie = NomeclaturaLogic.getInstance().getCategoryByNameNoCommit("UndefinedC");
                        if (categorie == null) {
                            categorie = NomeclaturaLogic.getInstance().newCategoryNoCommit(idSectie, "UndefinedC", Color.WHITE.getRGB(), idSectie + "", AssconImporter.this.tva.getId(), false, 0.0);
                        }
                        idCategorie = categorie.getId();
                        int idStock = StockLogic.getInstance().addStockNoCommit(denumire, idUnit, stocWarning, 0.0, 0.0, true);
                        int nextCod = NomeclaturaLogic.getInstance().getNextProductCodeNoCommit();
                        Vector<String> barcodes = new Vector<String>();
                        barcodes.add(codBare);
                        StockLogic.getInstance().addProdusFinitNoCommit(denumire, idStock, idCategorie, nextCod, false, false, null, codBare, barcodes);
                    } else {
                        System.out.println("Codbare: " + codBare + " Product: " + denumire + " already added");
                    }
                }
            });
            pool.commit();
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            Logger.logException("AssconImporter", e);
            try {
                pool.rollBack();
            }
            catch (SQLException e1) {
                Logger.logException("AssconImporter", (Exception)e1);
            }
            boolean bl = false;
            return bl;
        }
        finally {
            pool.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean importStocuri(String filename, int idSocietateaNoastra) {
        final Vector nirItems = new Vector();
        ConnectionPool pool = ConnectionPool.getInstance();
        this.totalTva = 0.0;
        this.totalTvaAmanunt = 0.0;
        this.totalValoare = 0.0;
        this.totalValoareAmanunt = 0.0;
        try {
            DbfImporter.importDbf(filename, new DbfImporterInterface(){

                @Override
                public void importLine(Object[] line) throws SQLException {
                    String denumire = (String)line[0];
                    String gestiune = (String)line[1];
                    int idMagazie = -1;
                    Magazie m = StockLogic.getInstance().getMagazieByNameNoCommit(gestiune);
                    if (m == null) {
                        idMagazie = StockLogic.getInstance().addMagazieNoCommit(gestiune, "", "", "", "", true);
                        m = StockLogic.getInstance().getMagazieByIdNoCommit(idMagazie);
                    }
                    double pretAcz = 0.0;
                    Double d = (Double)line[2];
                    if (d != null) {
                        pretAcz = d;
                    }
                    double pretVz = 0.0;
                    Double d2 = (Double)line[3];
                    if (d2 != null) {
                        pretVz = d2;
                    }
                    double cantitate = 0.0;
                    Double d3 = (Double)line[4];
                    if (d3 != null) {
                        cantitate = d3;
                    }
                    String codBare = (String)line[23];
                    Product p = NomeclaturaLogic.getInstance().getProductByCodBareNoCommit(codBare);
                    if (p != null) {
                        int idStock = RestLogic.getInstance().getIdStockForProductNoCommit(p.getId());
                        StockLogic.getInstance().updatePriceForStockNoCommit(idStock, pretVz);
                        int idSectie = -1;
                        Sectie sectie = NomeclaturaLogic.getInstance().getSectieByNameNoCommit(gestiune);
                        idSectie = sectie == null ? NomeclaturaLogic.getInstance().addSectieNoCommit(gestiune, "", "") : sectie.getId();
                        int idCategorie = -1;
                        Categorie categorie = NomeclaturaLogic.getInstance().getCategoryByNameNoCommit(gestiune);
                        if (categorie == null) {
                            categorie = NomeclaturaLogic.getInstance().newCategoryNoCommit(idSectie, gestiune, Color.WHITE.getRGB(), idSectie + "", AssconImporter.this.tva.getId(), false, 0.0);
                        }
                        idCategorie = categorie.getId();
                        p.setIdCategorie(idCategorie);
                        NomeclaturaLogic.getInstance().updateProductNoCommit(p);
                        if (cantitate > 0.0) {
                            Stock s = StockLogic.getInstance().getStockByIdNoCommit(idStock);
                            Unit unit = UnitsLogic.getInstance().getUnitByIdNoCommit(s.getIdUnit());
                            NirEntryFull toAdd = new NirEntryFull(-1, -1, idStock, denumire, unit.getLabel(), cantitate, pretAcz, -1.0, -1.0, pretVz, AssconImporter.this.tvaNoi.getCota(), unit.getId(), AssconImporter.this.tvaNoi.getCota(), m.getId(), m.getLabel(), 1);
                            toAdd.setNrCrt(nirItems.size() + 1);
                            toAdd.compute();
                            AssconImporter.this.totalValoare += toAdd.getValoareCumparare();
                            AssconImporter.this.totalTva += toAdd.getTvaFurnizorTotal();
                            AssconImporter.this.totalValoareAmanunt += toAdd.getValoareaLaPretAmanuntFaraTva();
                            AssconImporter.this.totalTvaAmanunt += toAdd.getTvaTotalAmanunt();
                            nirItems.add(toAdd);
                        }
                    } else {
                        System.out.println("Product: " + denumire + " codBare: " + codBare + " not found ! This is WRONG !!");
                    }
                }
            });
            Date nirDate = new Date();
            Client furnizor = ClientLogic.getInstance().getClientByNameNoCommit("Inventar");
            Timestamp timeDate = new Timestamp(nirDate.getTime());
            int nrNir = ContaLogic.getInstance().getNextNrNirNoCommit(idSocietateaNoastra, true, -1);
            int idNir = ContaLogic.getInstance().addNirNoCommit(nrNir + "", "", timeDate, furnizor.getId(), nrNir, nirItems, false, new Vector(), true, idSocietateaNoastra, ContaLogic.TIP_DOCUMENT_NIR.Factura.getTip(), StockLogic.COMANDA_TYPE.EFECTUAT, timeDate);
            ContaLogic.getInstance().closeNirNoCommit(idNir, this.totalValoareAmanunt, this.totalTvaAmanunt, this.totalValoareAmanunt + this.totalTvaAmanunt, this.totalValoare, this.totalTva, this.totalValoare + this.totalTva);
            pool.commit();
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            Logger.logException("AssconImporter", e);
            try {
                pool.rollBack();
            }
            catch (SQLException e1) {
                Logger.logException("AssconImporter", (Exception)e1);
            }
            boolean bl = false;
            return bl;
        }
        finally {
            pool.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean importFirme(String filename) {
        ConnectionPool pool = ConnectionPool.getInstance();
        try {
            DbfImporter.importDbf(filename, new DbfImporterInterface(){

                @Override
                public void importLine(Object[] line) throws SQLException {
                    String denumire = Utils.getNotNullStringForDBF(line[0]);
                    String ro = Utils.getNotNullStringForDBF(line[1]);
                    String cui = Utils.getNotNullStringForDBF(line[2]);
                    String j = Utils.getNotNullStringForDBF(line[3]);
                    String localitate = Utils.getNotNullStringForDBF(line[4]);
                    String adresa = "";
                    for (int i = 4; i < 14; ++i) {
                        String s = Utils.getNotNullStringForDBF(line[i]);
                        if (!Validators.correctString(s)) continue;
                        adresa = adresa + s + " ";
                    }
                    String telefon = Utils.getNotNullStringForDBF(line[15]);
                    String email = Utils.getNotNullStringForDBF(line[16]);
                    String persContact = Utils.getNotNullStringForDBF(line[17]);
                    if (Validators.correctString(ro) || Validators.correctString(j) && (j.startsWith("j") || j.startsWith("J")) || cui.length() > 0 && cui.length() <= 10) {
                        String groups = "2";
                        ClientLogic.getInstance().addPersJuridicaNoCommit(denumire, cui, j, adresa, 1, localitate, "", "", "", telefon, "", "", "", email, persContact, 0.0, -1, "", 0, 0.0, groups, "", "", "", "", "");
                    } else {
                        try {
                            ClientLogic.getInstance().addPersFizicaNoCommit(denumire, "", adresa, 1, localitate, -1, -1, -1, telefon, "", "", email, "", "", "", "", new Date(), null, new Date(), "");
                        }
                        catch (IOException e) {
                            Logger.logException(this, (Exception)e);
                        }
                    }
                }
            });
            pool.commit();
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            Logger.logException("AssconImporter", e);
            try {
                pool.rollBack();
            }
            catch (SQLException e1) {
                Logger.logException("AssconImporter", (Exception)e1);
            }
            boolean bl = false;
            return bl;
        }
        finally {
            pool.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean importBanci(String filename) {
        ConnectionPool pool = ConnectionPool.getInstance();
        try {
            DbfImporter.importDbf(filename, new DbfImporterInterface(){

                @Override
                public void importLine(Object[] line) throws SQLException {
                    Vector v;
                    String banca = Utils.getNotNullStringForDBF(line[1]);
                    String cont = Utils.getNotNullStringForDBF(line[2]);
                    String denumire = Utils.getNotNullStringForDBF(line[3]);
                    String cui = Utils.getNotNullStringForDBF(line[0]);
                    Client client = ClientLogic.getInstance().getClientByNameNoCommit(denumire);
                    if (client == null && (v = ClientLogic.getInstance().getPersJuridiceByCodNoCommit(cui)).size() > 0) {
                        client = (Client)v.get(0);
                    }
                    if (client == null) {
                        System.out.println("Client: \"" + denumire + "\", cui: \"" + cui + "\" nu a fost gasit nici dupa denumire nici dupa CUI");
                    } else if (client instanceof ClientPersJuridica) {
                        ClientPersJuridica cpj = (ClientPersJuridica)client;
                        cpj.setBank(banca);
                        cpj.setBankIban(cont);
                        ClientLogic.getInstance().savePersJuridicaShortNoCommitNoGroups(cpj);
                    } else {
                        System.out.println("Client: \"" + denumire + "\", cui: \"" + cui + "\" este de fapt o persoana fizica !!");
                    }
                }
            });
            pool.commit();
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            Logger.logException("AssconImporter", e);
            try {
                pool.rollBack();
            }
            catch (SQLException e1) {
                Logger.logException("AssconImporter", (Exception)e1);
            }
            boolean bl = false;
            return bl;
        }
        finally {
            pool.releaseConnection();
        }
    }
}

