/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.restaurant.imports.nessus;

import java.awt.Color;
import java.io.FileReader;
import java.io.IOException;
import java.io.LineNumberReader;
import java.sql.SQLException;
import java.util.Vector;
import ro.atreides.nomenclatura.Categorie;
import ro.atreides.nomenclatura.NomeclaturaLogic;
import ro.atreides.nomenclatura.Product;
import ro.atreides.nomenclatura.Sectie;
import ro.atreides.restaurant.base.NewRecipeEntry;
import ro.atreides.restaurant.logic.RestLogic;
import ro.atreides.stocks.Stock;
import ro.atreides.stocks.StockLogic;
import ro.atreides.utils.Logger;
import ro.atreides.utils.Unit;
import ro.atreides.utils.Utils;
import ro.atreides.utils.db.ConnectionPool;
import ro.atreides.utils.gui.Validators;
import ro.atreides.utils.tva.Tva;
import ro.atreides.utils.tva.TvaLogic;
import ro.atreides.utils.units.UnitsLogic;

public class NessusImporter {
    Tva tva = TvaLogic.getInstance().getTvas().get(0);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void importNessus(String produseFile, String reteteFile) {
        try {
            this.importProduse(produseFile);
            ConnectionPool.getInstance().commit();
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            try {
                ConnectionPool.getInstance().rollBack();
            }
            catch (SQLException e1) {
                Logger.logException(this, (Exception)e1);
            }
        }
        finally {
            ConnectionPool.getInstance().releaseConnection();
        }
        try {
            NessusRetetaInterface passOne = new NessusRetetaInterface(){

                @Override
                public void processLine(String line) throws SQLException {
                    Vector tokens = Utils.splitString(line, '|');
                    String codReteta = (String)tokens.get(0);
                    String denumire = (String)tokens.get(1);
                    String cantS = (String)tokens.get(2);
                    String um = (String)tokens.get(3);
                    String subretetaS = (String)tokens.get(4);
                    double cant = Utils.parseDouble(cantS);
                    int subreteta = Integer.parseInt(subretetaS);
                    if (subreteta == 0) {
                        Stock s = StockLogic.getInstance().getStockByNameNoCommit(denumire);
                        int idStock = -1;
                        if (s == null) {
                            int idUnit = -1;
                            Unit u = UnitsLogic.getInstance().getUnitByNameNoCommit(um);
                            idUnit = u == null ? UnitsLogic.getInstance().addUnitNoCommit(um) : u.getId();
                            idStock = StockLogic.getInstance().addStockNoCommit(denumire, idUnit, 0.0, 0.0, 0.0, true);
                        } else {
                            idStock = s.getId();
                        }
                        Vector<NewRecipeEntry> items = new Vector<NewRecipeEntry>();
                        NewRecipeEntry iq = new NewRecipeEntry();
                        iq.setIdStock(idStock);
                        iq.setQuantity(cant);
                        items.add(iq);
                        Product p = NomeclaturaLogic.getInstance().getProductByCodBareNoCommit(codReteta);
                        if (p != null) {
                            int idReteta = RestLogic.getInstance().getIdRetetaNoCommit(p.getId());
                            if (idReteta > 0) {
                                RestLogic.getInstance().addItemsToRetetaProductNoCommit(idReteta, items);
                            } else {
                                System.out.println("Gasit reteta la produs neadaugat : " + codReteta + " ingredient : " + denumire);
                            }
                        }
                    }
                }
            };
            NessusRetetaInterface passTwo = new NessusRetetaInterface(){

                @Override
                public void processLine(String line) throws SQLException {
                    Vector tokens = Utils.splitString(line, '|');
                    String codReteta = (String)tokens.get(0);
                    String denumire = (String)tokens.get(1);
                    String cantS = (String)tokens.get(2);
                    String subretetaS = (String)tokens.get(4);
                    double cant = Utils.parseDouble(cantS);
                    int subreteta = Integer.parseInt(subretetaS);
                    if (subreteta != 0) {
                        System.out.println("Line: " + line);
                        Product p = NomeclaturaLogic.getInstance().getProductByCodBareNoCommit(codReteta);
                        if (p != null) {
                            int idReteta = RestLogic.getInstance().getIdRetetaNoCommit(p.getId());
                            if (idReteta > 0) {
                                Product produsContinut = NomeclaturaLogic.getInstance().getProductByCodBareNoCommit(denumire);
                                if (produsContinut != null) {
                                    RestLogic.getInstance().addIngredientToProduct(idReteta, -1, produsContinut.getId(), cant, produsContinut.getName(), p.getName());
                                } else {
                                    System.out.println("Gasit reteta la produs neadaugat : " + codReteta + " ingredient : " + denumire);
                                }
                            } else {
                                System.out.println("Gasit reteta la produs neadaugat : " + codReteta + " ingredient : " + denumire);
                            }
                        }
                    }
                }
            };
            this.importRetetar(reteteFile, passOne);
            this.importRetetar(reteteFile, passTwo);
            ConnectionPool.getInstance().commit();
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            try {
                ConnectionPool.getInstance().rollBack();
            }
            catch (SQLException e1) {
                Logger.logException(this, (Exception)e1);
            }
        }
        finally {
            ConnectionPool.getInstance().releaseConnection();
        }
    }

    private void importRetetar(String inputFile, NessusRetetaInterface inter) throws SQLException {
        try {
            LineNumberReader lnr = new LineNumberReader(new FileReader(inputFile));
            String line = lnr.readLine();
            while (line != null) {
                if (Validators.correctString(line)) {
                    inter.processLine(line);
                }
                line = lnr.readLine();
            }
        }
        catch (IOException e) {
            Logger.logException(this, (Exception)e);
        }
    }

    private void importProduse(String inputFile) throws SQLException {
        try {
            LineNumberReader lnr = new LineNumberReader(new FileReader(inputFile));
            String line = lnr.readLine();
            while (line != null) {
                if (Validators.correctString(line)) {
                    Vector tokens = Utils.splitString(line, '|');
                    String codReteta = (String)tokens.get(0);
                    String denumire = (String)tokens.get(1);
                    String categorie = (String)tokens.get(2);
                    String sectie = (String)tokens.get(3);
                    String pretS = (String)tokens.get(4);
                    int idSectie = -1;
                    Sectie s = NomeclaturaLogic.getInstance().getSectieByNameNoCommit(sectie);
                    idSectie = s == null ? NomeclaturaLogic.getInstance().addSectieNoCommit(sectie, "", "") : s.getId();
                    int idCategorie = -1;
                    Categorie reteteCat = NomeclaturaLogic.getInstance().getCategoryByNameNoCommit(categorie);
                    if (reteteCat == null) {
                        reteteCat = NomeclaturaLogic.getInstance().newCategoryNoCommit(idSectie, categorie, Color.WHITE.getRGB(), idSectie + "", this.tva.getId(), false, 0.0);
                    }
                    idCategorie = reteteCat.getId();
                    double pret = Utils.parseDouble(pretS);
                    int cod = NomeclaturaLogic.getInstance().getNextProductCodeNoCommit();
                    RestLogic.getInstance().newRetetaProductNoCommit(idCategorie, denumire, pret, new Vector(), cod, denumire, denumire, "", "", "", false, true, false, new Vector(), null, codReteta, new Vector<String>());
                }
                line = lnr.readLine();
            }
        }
        catch (IOException e) {
            Logger.logException(this, (Exception)e);
        }
    }

    static interface NessusRetetaInterface {
        public void processLine(String var1) throws SQLException;
    }
}

