/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.restaurant.logic;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Properties;
import java.util.Vector;
import ro.atreides.nomenclatura.Categorie;
import ro.atreides.nomenclatura.NomeclaturaLogic;
import ro.atreides.nomenclatura.Product;
import ro.atreides.restaurant.base.SyncObject;
import ro.atreides.restaurant.logic.RestLogic;
import ro.atreides.stocks.StockLogic;
import ro.atreides.utils.Logger;
import ro.atreides.utils.ObjectEventListener;

public class ProductsSync
extends Thread {
    private PreparedStatement updateProduct;
    private PreparedStatement updateProduseReteta;
    private PreparedStatement addProduseReteta;
    private PreparedStatement addProduct;
    private PreparedStatement selectIdRetetaByCod;
    private PreparedStatement selectIdSubcategorieByCod;
    private PreparedStatement getIdentity;
    private PreparedStatement setPriceForRetetaProduct;
    private PreparedStatement deleteRetetaProduct;
    private PreparedStatement deleteProduct;
    private Connection remote;
    public static final int UPDATED = 1;
    public static final int ADDED = 2;
    public static final int DELETED = 3;
    public static final int SLEEP_SECONDS = 5;
    private Vector updateQueue = new Vector();
    private int port;
    private String host;
    private RestLogic logic;

    public ProductsSync(String host, int port) {
        this.host = host;
        this.port = port;
        this.logic = RestLogic.getInstance();
        ObjectEventListener changeListener = new ObjectEventListener(){

            @Override
            public void dataChanged(Object o) {
                SyncObject obj = new SyncObject(1, o);
                ProductsSync.this.updateQueue.add(obj);
            }

            @Override
            public String getName() {
                return "SaleSync_product_changed";
            }
        };
        this.logic.addObjectListener(changeListener, 100);
        NomeclaturaLogic.getInstance().addObjectListener(changeListener, 100);
        StockLogic.getInstance().addObjectListener(changeListener, 100);
        ObjectEventListener addListener = new ObjectEventListener(){

            @Override
            public void dataChanged(Object o) {
                SyncObject obj = new SyncObject(2, o);
                ProductsSync.this.updateQueue.add(obj);
            }

            @Override
            public String getName() {
                return "SaleSync_product_added";
            }
        };
        this.logic.addObjectListener(addListener, 101);
        StockLogic.getInstance().addObjectListener(addListener, 101);
        ObjectEventListener deletedListener = new ObjectEventListener(){

            @Override
            public void dataChanged(Object o) {
                SyncObject obj = new SyncObject(3, o);
                ProductsSync.this.updateQueue.add(obj);
            }

            @Override
            public String getName() {
                return "SaleSync_product_deleted";
            }
        };
        this.logic.addObjectListener(deletedListener, 106);
        StockLogic.getInstance().addObjectListener(deletedListener, 106);
        this.start();
    }

    private void buildRemoteConnection() throws SQLException, IllegalAccessException, InstantiationException, ClassNotFoundException {
        String url = "jdbc:derby://" + this.host + ":" + this.port + "/db";
        String driver = "org.apache.derby.jdbc.ClientDriver";
        Class.forName(driver).newInstance();
        Properties props = new Properties();
        props.put("user", "user1");
        props.put("password", "user1");
        this.remote = DriverManager.getConnection(url, props);
        this.remote.setAutoCommit(false);
        this.setPriceForRetetaProduct = this.remote.prepareStatement("update produse_reteta set sell_price = ? where id = ?");
        this.updateProduct = this.remote.prepareStatement("update products set label = ?, id_subcategory = ?, short_label = ?, sectie_label = ?, liber1 = ?, liber2 = ?, uz_intern = ? where cod = ?");
        this.updateProduseReteta = this.remote.prepareStatement("update produse_reteta set label = ? where id = ?");
        this.addProduct = this.remote.prepareStatement("insert into products ( label, short_label, sectie_label, liber1, liber2, id_subcategory, cod, status, uz_intern ) values ( ?, ?, ?, ?, ?, ?, ?, ?, ? )");
        this.addProduseReteta = this.remote.prepareStatement("insert into produse_reteta( id_product, label, sell_price, status) values (?, ?, ?, 1 )");
        this.selectIdSubcategorieByCod = this.remote.prepareStatement("select id from subcategories where cod = ?");
        this.selectIdRetetaByCod = this.remote.prepareStatement("select produse_reteta.id from produse_reteta inner join products on produse_reteta.id_product = products.id where cod = ? and products.status = 1");
        this.getIdentity = this.remote.prepareStatement("values IDENTITY_VAL_LOCAL()");
        this.deleteRetetaProduct = this.remote.prepareStatement("update produse_reteta set status = 2 where id_product in (select id from products where cod = ?)");
        this.deleteProduct = this.remote.prepareStatement("update products set status = 2 where cod = ?");
    }

    private int getIndentityLocal() throws SQLException {
        int idColVar = -1;
        ResultSet rs = this.getIdentity.executeQuery();
        while (rs.next()) {
            idColVar = rs.getInt(1);
        }
        rs.close();
        return idColVar;
    }

    private int getIdSubcategorieByCod(int cod) throws SQLException {
        int id = -1;
        this.selectIdSubcategorieByCod.setInt(1, cod);
        ResultSet rs = this.selectIdSubcategorieByCod.executeQuery();
        if (rs.next()) {
            id = rs.getInt(1);
        }
        rs.close();
        return id;
    }

    private int getIdRetetaByCod(int cod) throws SQLException {
        int idReteta = -1;
        this.selectIdRetetaByCod.setInt(1, cod);
        ResultSet rs = this.selectIdRetetaByCod.executeQuery();
        if (rs.next()) {
            idReteta = rs.getInt(1);
        }
        rs.close();
        return idReteta;
    }

    private void processSyncProduct(SyncObject s) throws SQLException {
        switch (s.getOperation()) {
            case 2: {
                Product rp1 = (Product)s.getToUpdate();
                double sellPrice1 = this.logic.getPriceForProductCommit(rp1.getId());
                this.addProdusReteta(rp1, sellPrice1);
                break;
            }
            case 1: {
                Product rp = (Product)s.getToUpdate();
                double sellPrice = this.logic.getPriceForProductCommit(rp.getId());
                this.updateProdusReteta(rp, sellPrice);
                break;
            }
            case 3: {
                Product rp2 = (Product)s.getToUpdate();
                int cod = rp2.getCod();
                this.deleteProdusReteta(cod);
                break;
            }
        }
    }

    private void addProdusReteta(Product p, double sellPrice) throws SQLException {
        Categorie sc = NomeclaturaLogic.getInstance().getCategoryById(p.getIdCategorie());
        int idSubcat = this.getIdSubcategorieByCod(sc.getCod());
        this.addProduct.setString(1, p.getName());
        this.addProduct.setString(2, p.getNumeCasa());
        this.addProduct.setString(3, p.getNumeSectie());
        this.addProduct.setString(4, p.getLiber1());
        this.addProduct.setString(5, p.getLiber2());
        this.addProduct.setInt(6, idSubcat);
        this.addProduct.setInt(7, p.getCod());
        this.addProduct.setInt(8, 1);
        this.addProduct.setInt(9, p.isUzIntern() ? 1 : 0);
        this.addProduct.execute();
        int idProdus = this.getIndentityLocal();
        this.addProduseReteta.setInt(1, idProdus);
        this.addProduseReteta.setString(2, p.getName());
        this.addProduseReteta.setDouble(3, sellPrice);
        this.addProduseReteta.execute();
    }

    private void updateProdusReteta(Product p, double sellPrice) throws SQLException {
        Categorie sc = NomeclaturaLogic.getInstance().getCategoryById(p.getIdCategorie());
        int idSubcat = this.getIdSubcategorieByCod(sc.getCod());
        this.updateProduct.setString(1, p.getName());
        this.updateProduct.setInt(2, idSubcat);
        this.updateProduct.setString(3, p.getNumeCasa());
        this.updateProduct.setString(4, p.getNumeSectie());
        this.updateProduct.setString(5, p.getLiber1());
        this.updateProduct.setString(6, p.getLiber2());
        this.updateProduct.setInt(7, p.isUzIntern() ? 1 : 0);
        this.updateProduct.setInt(8, p.getCod());
        this.updateProduct.execute();
        int idReteta = this.getIdRetetaByCod(p.getCod());
        this.updateProduseReteta.setString(1, p.getName());
        this.updateProduseReteta.setInt(2, idReteta);
        this.updateProduseReteta.execute();
        this.setPriceForRetetaProduct.setDouble(1, sellPrice);
        this.setPriceForRetetaProduct.setInt(2, idReteta);
        this.setPriceForRetetaProduct.execute();
    }

    private void deleteProdusReteta(int codProdus) throws SQLException {
        this.deleteRetetaProduct.setInt(1, codProdus);
        this.deleteRetetaProduct.execute();
        this.deleteProduct.setInt(1, codProdus);
        this.deleteProduct.execute();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        block17: while (true) {
            try {
                block18: while (true) {
                    boolean connected = false;
                    while (!connected) {
                        try {
                            this.buildRemoteConnection();
                            connected = true;
                            Logger.logInfo(this, "Connected");
                        }
                        catch (Exception e) {
                            try {
                                ProductsSync.sleep(5000L);
                            }
                            catch (InterruptedException e1) {}
                        }
                    }
                    while (true) {
                        if (!connected) continue block18;
                        try {
                            if (this.remote.isClosed()) {
                                connected = false;
                                continue block17;
                            }
                        }
                        catch (SQLException e) {
                            Logger.logException(this, (Exception)e);
                            continue block18;
                        }
                        if (this.updateQueue.size() > 0) {
                            SyncObject s = (SyncObject)this.updateQueue.get(0);
                            try {
                                this.processSyncProduct(s);
                                this.remote.commit();
                                this.updateQueue.remove(0);
                            }
                            catch (SQLException e) {
                                Logger.logException(this, (Exception)e);
                                try {
                                    this.remote.rollback();
                                }
                                catch (SQLException e1) {
                                    Logger.logException(this, (Exception)e1);
                                }
                                finally {
                                    connected = false;
                                }
                            }
                            continue;
                        }
                        try {
                            ProductsSync.sleep(5000L);
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                    break;
                }
            }
            catch (Throwable th) {
                Logger.logError((Object)this, th);
                continue;
            }
            break;
        }
    }
}

