/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.restaurant.logic;

import java.awt.Component;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;
import ro.atreides.nomenclatura.NomeclaturaLogic;
import ro.atreides.nomenclatura.Product;
import ro.atreides.restaurant.logic.AddSaleInterface;
import ro.atreides.utils.Utils;
import ro.atreides.utils.gui.dialogs.DialogUtils;

public class VanzariXmlHandler
extends DefaultHandler {
    private AddSaleInterface saleInterface;
    private Component parent;

    public VanzariXmlHandler(Component parent, AddSaleInterface saleInterface) {
        this.saleInterface = saleInterface;
        this.parent = parent;
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if (qName.equalsIgnoreCase("sale")) {
            String codBare = attributes.getValue("codBare");
            String product = attributes.getValue("produs");
            String cantitateS = attributes.getValue("cantitate");
            String pretS = attributes.getValue("pret");
            double price = Utils.parseDouble(pretS);
            Product p = NomeclaturaLogic.getInstance().getProductByCodBare(codBare);
            boolean ok = true;
            if (p == null) {
                DialogUtils.errorDialog(this.parent, "Produsul \"" + product + "\", cu codul \"" + codBare + "\"\n, cantitate \"" + cantitateS + "\"\n nu exista in baza de date locala", "Nu pot adauga");
            } else {
                if (!p.getName().equalsIgnoreCase(product)) {
                    ok = DialogUtils.confirmDialog(this.parent, "Codul \"" + codBare + "\" are denumire locala \"" + p.getName() + "\"" + " si denumire importata \"" + product + "\" ,\n cantitate = \"" + cantitateS + "\" .\nAdaugam", "Atentie!");
                }
                if (ok) {
                    this.saleInterface.saleAdded(p, cantitateS, price);
                }
            }
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
    }
}

