/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.restaurant.logic.exports;

import java.io.File;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import ro.atreides.clienti.ClientLogic;
import ro.atreides.promo.Promotion;
import ro.atreides.promo.PromotionLogic;
import ro.atreides.restaurant.base.BonFiscalNumber;
import ro.atreides.restaurant.base.Table;
import ro.atreides.restaurant.base.reports.SalesEntry;
import ro.atreides.restaurant.logic.DataSyncServerLogic;
import ro.atreides.restaurant.logic.RestLogic;
import ro.atreides.restaurant.logic.exports.DataSyncBean;
import ro.atreides.restaurant.logic.exports.DataSyncChannel;
import ro.atreides.restaurant.modules.fidelitybo.FidelityLogic;
import ro.atreides.users.User;
import ro.atreides.users.UsersLogic;
import ro.atreides.utils.Client;
import ro.atreides.utils.DateUtils;
import ro.atreides.utils.FileUtils;
import ro.atreides.utils.Logger;
import ro.atreides.utils.Order;
import ro.atreides.utils.Utils;
import ro.atreides.utils.db.DatabaseManager;
import ro.atreides.utils.gui.Validators;

public class DataSyncClientLogic
implements Runnable {
    private static final int NEW = 1;
    private static final int CORRECT_IPS = 0;
    private static final int DATA_COMPLETED = 2;
    private static final int SENT = 3;
    private static final int ERROR = 4;
    private static final int ERRCODE_NO_ERROR = 0;
    private static final int ERRCODE_PERMANENT_ERROR = 1;
    private static Hashtable<String, DataSyncChannel> channels;
    private String location = "";
    private String fallbackUser = "";
    private String salesDir;
    private String parteneriDir;
    private String produseDir;
    private String niruriDir;
    private String stocuriDir;
    private String materiePrimaDir;
    private String reteteDir;
    private String meniuriDir;
    private String tranzactiiDir;
    private String carduriDir;
    private String ev_defDir;
    private String ev_InstanceDir;
    private String ev_ClientsDir;
    private String clientLocationsMappingDir;
    private String buletineDir;
    private String pasapoarteDir;
    private PreparedStatement insertTriggeredData;
    private PreparedStatement updatePhase2;
    private PreparedStatement updatePhase3SENT;
    private PreparedStatement selectPhase0;
    private PreparedStatement selectPhase1;
    private PreparedStatement selectPhase2;
    private PreparedStatement updatePhase3ERROR;
    private PreparedStatement deleteNoIps;
    private Connection connection;
    private static DataSyncClientLogic instance;

    public static synchronized DataSyncClientLogic getFirstInstance(Hashtable<String, DataSyncChannel> channels, String location, String fallbackUser) {
        try {
            instance = new DataSyncClientLogic(channels, location, fallbackUser);
        }
        catch (Exception e) {
            Logger.logException(DataSyncClientLogic.class.getName(), e);
        }
        return instance;
    }

    public static synchronized DataSyncClientLogic getInstance() {
        return instance;
    }

    private DataSyncClientLogic(Hashtable<String, DataSyncChannel> channels, String location, String fallbackUser) {
        DataSyncClientLogic.channels = channels;
        this.location = location;
        this.fallbackUser = fallbackUser;
        String tmp = FileUtils.getTempDir();
        File f = new File(tmp + File.separator + "exports" + File.separator + "sales");
        f.mkdirs();
        this.salesDir = f.getAbsolutePath();
        f = new File(tmp + File.separator + "exports" + File.separator + "parteneri");
        f.mkdirs();
        this.parteneriDir = f.getAbsolutePath();
        f = new File(tmp + File.separator + "exports" + File.separator + "produse");
        f.mkdirs();
        this.produseDir = f.getAbsolutePath();
        f = new File(tmp + File.separator + "exports" + File.separator + "stocuri");
        f.mkdirs();
        this.stocuriDir = f.getAbsolutePath();
        f = new File(tmp + File.separator + "exports" + File.separator + "niruri");
        f.mkdirs();
        this.niruriDir = f.getAbsolutePath();
        f = new File(tmp + File.separator + "exports" + File.separator + "matprima");
        f.mkdirs();
        this.materiePrimaDir = f.getAbsolutePath();
        f = new File(tmp + File.separator + "exports" + File.separator + "retete");
        f.mkdirs();
        this.reteteDir = f.getAbsolutePath();
        f = new File(tmp + File.separator + "exports" + File.separator + "meniuri");
        f.mkdirs();
        this.meniuriDir = f.getAbsolutePath();
        f = new File(tmp + File.separator + "exports" + File.separator + "tranzactii");
        f.mkdirs();
        this.tranzactiiDir = f.getAbsolutePath();
        f = new File(tmp + File.separator + "exports" + File.separator + "carduri");
        f.mkdirs();
        this.carduriDir = f.getAbsolutePath();
        f = new File(tmp + File.separator + "exports" + File.separator + "ev_def");
        f.mkdirs();
        this.ev_defDir = f.getAbsolutePath();
        f = new File(tmp + File.separator + "exports" + File.separator + "ev_instance");
        f.mkdirs();
        this.ev_InstanceDir = f.getAbsolutePath();
        f = new File(tmp + File.separator + "exports" + File.separator + "ev_clients");
        f.mkdirs();
        this.ev_ClientsDir = f.getAbsolutePath();
        f = new File(tmp + File.separator + "exports" + File.separator + "clients_locations");
        f.mkdirs();
        this.clientLocationsMappingDir = f.getAbsolutePath();
        f = new File(tmp + File.separator + "exports" + File.separator + "buletine");
        f.mkdirs();
        this.buletineDir = f.getAbsolutePath();
        f = new File(tmp + File.separator + "exports" + File.separator + "pasapoarte");
        f.mkdirs();
        this.pasapoarteDir = f.getAbsolutePath();
        Thread th = new Thread(this);
        th.setName("DataSync");
        th.start();
    }

    private void buildPreparedStatements() throws SQLException {
        this.deleteNoIps = this.connection.prepareStatement("delete from triggered_data where id = ?");
        this.insertTriggeredData = this.connection.prepareStatement("insert into triggered_data ( what, status, id_data, error_type, channel, remote, dateadd ) values (?, ?, ?, 0, ?, ?, ?)");
        this.updatePhase2 = this.connection.prepareStatement("update triggered_data set status = 2, xml_data = ?, last_action = current_timestamp where id = ?");
        this.updatePhase3SENT = this.connection.prepareStatement("update triggered_data set status = 3,last_action = current_timestamp where id = ?");
        this.updatePhase3ERROR = this.connection.prepareStatement("update triggered_data set status = 4, error_type = ?, error_details = ?, last_action = current_timestamp where id = ?");
        this.selectPhase0 = this.connection.prepareStatement("select * from triggered_data where status = 1 order by dateadd");
        this.selectPhase1 = this.connection.prepareStatement("select * from triggered_data where status = 0 order by dateadd");
        this.selectPhase2 = this.connection.prepareStatement("select * from triggered_data where status = 2 and channel = ? order by status, dateadd, last_action limit 100");
    }

    private void reconnect() {
        try {
            this.connection = DatabaseManager.getInstance().getClientConnectionPostgres(10);
            this.buildPreparedStatements();
            this.connection.commit();
        }
        catch (Exception e) {
            Logger.logException(this, e);
        }
    }

    private void updateStep2(String filename, int idTriggeredData) throws SQLException {
        this.updatePhase2.setString(1, filename);
        this.updatePhase2.setInt(2, idTriggeredData);
        this.updatePhase2.execute();
        this.connection.commit();
    }

    private void notaStep2(int idData, int idTriggeredData, String channel) throws SQLException {
        String filename = this.salesDir + File.separator + idData + "_" + channel + ".xml";
        Hashtable<String, Object> hash = new Hashtable<String, Object>();
        hash.put("id_order_key", new Integer(idData));
        hash.put("Tip_Order", (Object)Order.TIP_ORDER.ALL);
        Order o = RestLogic.getInstance().getOrderById(idData);
        if (o != null) {
            Client client;
            double total = RestLogic.getInstance().getTotal(o);
            Vector<SalesEntry> sales = RestLogic.getInstance().getSalesReport(hash, -1);
            String optionalAttributes = "";
            String username = "";
            User u = UsersLogic.getInstance().getUserById(o.getUser());
            if (u != null) {
                username = u.getLogin();
            }
            if ((client = ClientLogic.getInstance().getClientById(o.getIdClient())) != null && Validators.correctString(client.getCodSyncClient())) {
                optionalAttributes = optionalAttributes + " clientCodSync=\"" + client.getCodSyncClient() + "\"";
            }
            optionalAttributes = optionalAttributes + " location=\"" + this.location + "\"";
            optionalAttributes = optionalAttributes + " fallbackUser=\"" + this.fallbackUser + "\"";
            optionalAttributes = optionalAttributes + " idTable=\"" + o.getTable() + "\"";
            String tablename = "";
            Table t = RestLogic.getInstance().getTableById(o.getTable());
            if (t != null) {
                tablename = t.getLabel();
            }
            optionalAttributes = optionalAttributes + " tablename=\"" + tablename + "\"";
            optionalAttributes = optionalAttributes + " idUser=\"" + o.getUser() + "\"";
            optionalAttributes = optionalAttributes + " username=\"" + username + "\"";
            optionalAttributes = optionalAttributes + " f=\"" + o.isFiscal() + "\"";
            optionalAttributes = optionalAttributes + " orderIdentifier=\"" + RestLogic.getOrderIdentifier(u.getLogin(), o.getId()) + "\"";
            optionalAttributes = optionalAttributes + " tipOrder=\"" + o.getTipOrder().toString() + "\"";
            BonFiscalNumber bfn = RestLogic.getInstance().getBonFiscalNumber(o.getId());
            if (bfn != null) {
                optionalAttributes = optionalAttributes + " bfn_nrz=\"" + bfn.getNrZ() + "\"";
                optionalAttributes = optionalAttributes + " bfn_nrbon=\"" + bfn.getNrBon() + "\"";
                optionalAttributes = optionalAttributes + " bfn_nrcasa=\"" + bfn.getNrCasa() + "\"";
            }
            int idPromo = o.getIdPromotie();
            Promotion promotion = PromotionLogic.getInstance().getPromotionById(idPromo);
            if (promotion != null) {
                optionalAttributes = optionalAttributes + " promoName=\"" + promotion.getLabel() + "\"";
            }
            RestLogic.getInstance().exportSalesToXml(hash, sales, filename, total, o.getId(), o.getStopTime(), optionalAttributes);
        } else {
            Logger.logWarning(this, "Order deleted: " + idData);
        }
        this.updateStep2(filename, idTriggeredData);
    }

    private void partenerStep2(int idData, int idTriggeredData, String channel) throws SQLException {
        String filename = this.parteneriDir + File.separator + channel + "_" + idData + ".xml";
        ClientLogic.getInstance().exportPartenerToXml(idData, filename);
        this.updateStep2(filename, idTriggeredData);
    }

    private void productStep2(int idData, int idTriggeredData, String channel) throws SQLException {
        String filename = this.produseDir + File.separator + idData + "_" + channel + ".xml";
        RestLogic.getInstance().exportProductToXml(idData, filename);
        this.updateStep2(filename, idTriggeredData);
    }

    private void materiePrimaStep2(int idData, int idTriggeredData, String channel) throws SQLException {
        String filename = this.materiePrimaDir + File.separator + idData + "_" + channel + ".xml";
        RestLogic.getInstance().exportMateriePrimaToXml(idData, filename);
        this.updateStep2(filename, idTriggeredData);
    }

    private void retetaStep2(int idData, int idTriggeredData, String channel) throws SQLException {
        String filename = this.reteteDir + File.separator + idData + "_" + channel + ".xml";
        RestLogic.getInstance().exportRetetaToXml(idData, filename);
        this.updateStep2(filename, idTriggeredData);
    }

    private void stockStep2(int idData, int idTriggeredData, String channel) throws SQLException {
        String filename = this.stocuriDir + File.separator + idData + "_" + channel + ".xml";
        RestLogic.getInstance().exportStockToXml(idData, filename);
        this.updateStep2(filename, idTriggeredData);
    }

    private void nirStep2(int idData, int idTriggeredData, String channel) throws SQLException {
        String filename = this.niruriDir + File.separator + idData + "_" + channel + ".xml";
        RestLogic.getInstance().exportNirToXml(idData, filename);
        this.updateStep2(filename, idTriggeredData);
    }

    private void meniuStep2(int idData, int idTriggeredData, String channel) throws SQLException {
        String filename = this.meniuriDir + File.separator + idData + "_" + channel + ".xml";
        RestLogic.getInstance().exportMeniuToXml(idData, filename);
        this.updateStep2(filename, idTriggeredData);
    }

    private void tranzactieStep2(int idData, int idTriggeredData, String channel, String remote) throws SQLException {
        String filename = this.tranzactiiDir + File.separator + channel + "_" + idData + ".xml";
        RestLogic.getInstance().exportTranzactieToXml(idData, filename, remote);
        this.updateStep2(filename, idTriggeredData);
    }

    private void exportCardStep2(int idClient, int idTriggeredData, String channel, String remote) throws SQLException {
        String filename = this.carduriDir + File.separator + channel + "_" + idClient + ".xml";
        RestLogic.getInstance().exportCarduriToXml(idClient, filename, remote);
        this.updateStep2(filename, idTriggeredData);
    }

    private void exportClientLocationMapping(int idMapping, int idTriggeredData, String channel, String remote) throws SQLException {
        String filename = this.clientLocationsMappingDir + File.separator + channel + "_" + idMapping + ".xml";
        ClientLogic.getInstance().exportClientsLocationsToXml(idMapping, filename, remote);
        this.updateStep2(filename, idTriggeredData);
    }

    private void exportEvDefStep2(int idData, int idTriggeredData, String channel, String remote) throws SQLException {
        String filename = this.ev_defDir + File.separator + idData + "_" + channel + ".xml";
        FidelityLogic.getInstance().exportEv_DefToXml(idData, filename, remote);
        this.updateStep2(filename, idTriggeredData);
    }

    private void exportEvInstanceStep2(int idData, int idTriggeredData, String channel, String remote) throws SQLException {
        String filename = this.ev_InstanceDir + File.separator + idData + "_" + channel + ".xml";
        FidelityLogic.getInstance().exportEv_InstanceToXml(idData, filename, remote);
        this.updateStep2(filename, idTriggeredData);
    }

    private void exportEvClientStep2(int idData, int idTriggeredData, String channel, String remote) throws SQLException {
        String filename = this.ev_ClientsDir + File.separator + idData + "_" + channel + ".xml";
        FidelityLogic.getInstance().exportEv_ClientToXml(idData, filename, remote);
        this.updateStep2(filename, idTriggeredData);
    }

    private void exportBuletinStep2(int idData, int idTriggeredData, String channel, String remote) throws SQLException {
        String filename = this.ev_ClientsDir + File.separator + idData + "_" + channel + ".xml";
        ClientLogic.getInstance().exportBuletinToXml(idData, filename, remote);
        this.updateStep2(filename, idTriggeredData);
    }

    private void exportPasaportStep2(int idData, int idTriggeredData, String channel, String remote) throws SQLException {
        String filename = this.ev_ClientsDir + File.separator + idData + "_" + channel + ".xml";
        ClientLogic.getInstance().exportPasaportToXml(idData, filename, remote);
        this.updateStep2(filename, idTriggeredData);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.reconnect();
        while (true) {
            try {
                String remote;
                Vector<Integer> toDelete = new Vector<Integer>();
                ResultSet rs = this.selectPhase0.executeQuery();
                while (rs.next()) {
                    int idTriggeredData = rs.getInt("id");
                    int tipD = rs.getInt("what");
                    int idData = rs.getInt("id_data");
                    remote = rs.getString("remote");
                    for (String channel : channels.keySet()) {
                        boolean accept;
                        DataSyncChannel channel1 = channels.get(channel);
                        Vector<String> objectsToSync = channel1.getFilters();
                        boolean bl = accept = objectsToSync == null || objectsToSync.size() == 0;
                        if (!accept) {
                            DataSyncServerLogic.SYNC_OBJECTS sync_objects = DataSyncServerLogic.getTipFromCode(tipD);
                            for (String currentTypeS : objectsToSync) {
                                DataSyncServerLogic.SYNC_OBJECTS currentType = DataSyncServerLogic.SYNC_OBJECTS.valueOf(currentTypeS);
                                if (!sync_objects.equals((Object)currentType)) continue;
                                accept = true;
                                break;
                            }
                        }
                        if (!accept) continue;
                        this.insertTriggeredData.setInt(1, tipD);
                        this.insertTriggeredData.setInt(2, 0);
                        this.insertTriggeredData.setInt(3, idData);
                        this.insertTriggeredData.setString(4, channel);
                        this.insertTriggeredData.setString(5, remote);
                        this.insertTriggeredData.setTimestamp(6, DateUtils.getCurrentTimestamp());
                        this.insertTriggeredData.execute();
                    }
                    toDelete.add(idTriggeredData);
                }
                rs.close();
                for (Integer idToDelete : toDelete) {
                    this.deleteNoIps.setInt(1, idToDelete);
                    this.deleteNoIps.execute();
                }
                this.connection.commit();
                ResultSet rs2 = this.selectPhase1.executeQuery();
                while (rs2.next()) {
                    int idTriggeredData = rs2.getInt("id");
                    int tipD = rs2.getInt("what");
                    int idData = rs2.getInt("id_data");
                    String channel = rs2.getString("channel");
                    remote = rs2.getString("remote");
                    if (idTriggeredData <= 0) continue;
                    DataSyncServerLogic.SYNC_OBJECTS type = DataSyncServerLogic.getTipFromCode(tipD);
                    switch (type) {
                        case SYNC_NOTA: {
                            this.notaStep2(idData, idTriggeredData, channel);
                            break;
                        }
                        case SYNC_PRODUCT: {
                            this.productStep2(idData, idTriggeredData, channel);
                            break;
                        }
                        case SYNC_NIR: {
                            this.nirStep2(idData, idTriggeredData, channel);
                            break;
                        }
                        case SYNC_STOCK: {
                            this.stockStep2(idData, idTriggeredData, channel);
                            break;
                        }
                        case SYNC_MAT_PRIMA: {
                            this.materiePrimaStep2(idData, idTriggeredData, channel);
                            break;
                        }
                        case SYNC_RETETA: {
                            this.retetaStep2(idData, idTriggeredData, channel);
                            break;
                        }
                        case SYNC_MENIU: {
                            this.meniuStep2(idData, idTriggeredData, channel);
                            break;
                        }
                        case SYNC_CONTCLIENT: {
                            this.tranzactieStep2(idData, idTriggeredData, channel, remote);
                            break;
                        }
                        case SYNC_CARDURI: {
                            this.exportCardStep2(idData, idTriggeredData, channel, remote);
                            break;
                        }
                        case SYNC_EV_DEF: {
                            this.exportEvDefStep2(idData, idTriggeredData, channel, remote);
                            break;
                        }
                        case SYNC_EV_INSTANCE: {
                            this.exportEvInstanceStep2(idData, idTriggeredData, channel, remote);
                            break;
                        }
                        case SYNC_EV_CLIENTS: {
                            this.exportEvClientStep2(idData, idTriggeredData, channel, remote);
                            break;
                        }
                        case SYNC_PARTENER_NEW: {
                            this.partenerStep2(idData, idTriggeredData, channel);
                            break;
                        }
                        case SYNC_CLIENTS_LOCATIONS: {
                            this.exportClientLocationMapping(idData, idTriggeredData, channel, remote);
                        }
                    }
                }
                rs2.close();
                this.connection.commit();
            }
            catch (Throwable th) {
                th.printStackTrace();
                Logger.logError((Object)this, th);
            }
            try {
                Thread.sleep(300L);
            }
            catch (InterruptedException interruptedException) {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<DataSyncBean> getDataToSync(String channel) {
        Vector<DataSyncBean> toProcess = new Vector<DataSyncBean>();
        try {
            this.selectPhase2.setString(1, channel);
            ResultSet rs = this.selectPhase2.executeQuery();
            while (rs.next()) {
                int idTriggeredData = rs.getInt("id");
                int tipD = rs.getInt("what");
                int idData = rs.getInt("id_data");
                String xmlData = rs.getString("xml_data");
                String content = null;
                try {
                    content = FileUtils.readFileToString(xmlData);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    this.updatePhase3ERROR.setInt(1, 1);
                    this.updatePhase3ERROR.setString(2, "File error while reading xml file \"" + xmlData + "\" from disk.");
                    this.updatePhase3ERROR.setInt(3, idTriggeredData);
                    this.updatePhase3ERROR.execute();
                    Logger.logWarning(this, "Permanently dropping message with id=" + idTriggeredData);
                    continue;
                }
                DataSyncBean toAdd = new DataSyncBean();
                toAdd.setDataType(tipD);
                toAdd.setId(idTriggeredData);
                toAdd.setPayload(content);
                toProcess.add(toAdd);
            }
            rs.close();
            this.connection.commit();
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            try {
                this.connection.rollback();
            }
            catch (SQLException e1) {
                Logger.logException(this, (Exception)e);
            }
        }
        return toProcess;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sentOK(List<DataSyncBean> toDelete) {
        try {
            for (DataSyncBean dataSyncBean : toDelete) {
                this.updatePhase3SENT.setInt(1, dataSyncBean.getId());
                this.updatePhase3SENT.execute();
            }
            this.connection.commit();
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            try {
                this.connection.rollback();
            }
            catch (SQLException e1) {
                Logger.logException(this, (Exception)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void permanentErrors(List<DataSyncBean> errors) {
        try {
            for (DataSyncBean dataSyncBean : errors) {
                this.updatePhase3ERROR.setInt(1, 1);
                this.updatePhase3ERROR.setString(2, dataSyncBean.getErrorMessage());
                this.updatePhase3ERROR.setInt(3, dataSyncBean.getId());
                this.updatePhase3ERROR.execute();
            }
            this.connection.commit();
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            try {
                this.connection.rollback();
            }
            catch (SQLException e1) {
                Logger.logException(this, (Exception)e);
            }
        }
    }

    public static Hashtable<String, DataSyncChannel> buildChannels(String channelString) {
        Hashtable<String, DataSyncChannel> channels = new Hashtable<String, DataSyncChannel>();
        Vector channelDef = Utils.splitString(channelString, ',');
        for (String channel : channelDef) {
            Vector sections = Utils.splitStringKeepStructure(channel, '=', ' ');
            String channelName = (String)sections.get(0);
            String channelFilters = "";
            if (sections.size() > 1) {
                channelFilters = (String)sections.get(1);
            }
            DataSyncChannel toAdd = new DataSyncChannel();
            String channelCodePrefix = "";
            if (sections.size() > 2) {
                channelCodePrefix = (String)sections.get(2);
                channelCodePrefix = channelCodePrefix != null ? channelCodePrefix.trim() : "";
            }
            toAdd.setChannelCodePrefix(channelCodePrefix);
            toAdd.setChannelName(channelName);
            if (Validators.correctString(channelFilters)) {
                Vector newObjects = Utils.splitString(channelFilters, '-');
                toAdd.setFilters(newObjects);
            } else {
                toAdd.setFilters(new Vector<String>());
            }
            channels.put(channelName, toAdd);
        }
        return channels;
    }
}

