/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.restaurant.logic.exports;

import com.google.code.gsonrmi.Parameter;
import com.google.code.gsonrmi.RpcError;
import com.google.code.gsonrmi.annotations.RMI;
import com.google.code.gsonrmi.annotations.Session;
import com.google.code.gsonrmi.serializer.ExceptionSerializer;
import com.google.code.gsonrmi.serializer.ParameterSerializer;
import com.google.code.gsonrmi.transport.Route;
import com.google.code.gsonrmi.transport.rmi.Call;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Type;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.UUID;
import ro.atreides.restaurant.logic.DataSyncServerLogic;
import ro.atreides.restaurant.logic.exports.DataSyncBean;
import ro.atreides.restaurant.logic.exports.DataSyncClientLogic;
import ro.atreides.restaurant.logic.exports.GSONSession;
import ro.atreides.utils.Logger;
import ro.deversoft.android.foodtablet.gsonserver.GSONEntity;

public class DataSyncGsonClient
extends GSONEntity {
    private static DataSyncGsonClient serverGsonClient;
    private String channel;

    public static synchronized DataSyncGsonClient getFirstInstance(String url, String serverName, String clientName, Integer listeningPort, String channel) {
        try {
            serverGsonClient = new DataSyncGsonClient(url, serverName, clientName, listeningPort, channel);
        }
        catch (Exception e) {
            Logger.logException(DataSyncGsonClient.class.getName(), e);
        }
        return serverGsonClient;
    }

    @Override
    protected Gson buildGson() {
        return new GsonBuilder().registerTypeAdapter((Type)((Object)Exception.class), new ExceptionSerializer()).registerTypeAdapter((Type)((Object)Parameter.class), new ParameterSerializer()).create();
    }

    public static synchronized DataSyncGsonClient getInstance() {
        return serverGsonClient;
    }

    private DataSyncGsonClient(String url, String serverName, String clientName, Integer listeningPort, final String channel) throws InvocationTargetException, URISyntaxException {
        super(url, serverName, clientName, listeningPort);
        this.channel = channel;
        Thread sendToServer = new Thread(){

            @Override
            public void run() {
                block4: while (true) {
                    try {
                        while (true) {
                            List<DataSyncBean> toPushToServer;
                            List<DataSyncBean> pushResult;
                            List<DataSyncBean> news;
                            if ((news = DataSyncGsonClient.this.getNewsFromServer()) != null) {
                                Boolean deleteResult;
                                if (news.size() > 0) {
                                    Logger.logDebug(this, "Received NEWS from server : " + news.size() + " on channel " + channel);
                                }
                                DataSyncServerLogic.getLaterInstance().processRemoteCommands(news, channel);
                                ArrayList<DataSyncBean> toDeleteFromServer = new ArrayList<DataSyncBean>();
                                ArrayList<DataSyncBean> errorsOnServer = new ArrayList<DataSyncBean>();
                                for (DataSyncBean newsBean : news) {
                                    if (newsBean.isProcessedOK()) {
                                        toDeleteFromServer.add(newsBean);
                                        continue;
                                    }
                                    errorsOnServer.add(newsBean);
                                }
                                if (toDeleteFromServer.size() > 0) {
                                    deleteResult = DataSyncGsonClient.this.deleteNewsFromServer(toDeleteFromServer);
                                }
                                if (errorsOnServer.size() > 0) {
                                    deleteResult = DataSyncGsonClient.this.errorsOnServer(errorsOnServer);
                                }
                            }
                            if ((pushResult = DataSyncGsonClient.this.pushNewsToServer(toPushToServer = DataSyncClientLogic.getInstance().getDataToSync(channel))) != null) {
                                if (pushResult.size() > 0) {
                                    Logger.logDebug(this, "Sending NEWS to server : " + toPushToServer.size() + " on channel " + channel);
                                }
                                LinkedList<DataSyncBean> sendOK = new LinkedList<DataSyncBean>();
                                LinkedList<DataSyncBean> permanentErrors = new LinkedList<DataSyncBean>();
                                for (DataSyncBean dataSyncBean : pushResult) {
                                    if (dataSyncBean.isProcessedOK()) {
                                        sendOK.add(dataSyncBean);
                                        continue;
                                    }
                                    Logger.logWarning(this, "Sending NEWS channel " + channel + " Permanent Error : " + dataSyncBean);
                                    permanentErrors.add(dataSyncBean);
                                }
                                DataSyncClientLogic.getInstance().sentOK(sendOK);
                                DataSyncClientLogic.getInstance().permanentErrors(permanentErrors);
                            }
                            try {
                                Thread.sleep(1000L);
                                continue block4;
                            }
                            catch (InterruptedException e) {
                                continue;
                            }
                            break;
                        }
                    }
                    catch (Throwable th) {
                        Logger.logError((Object)this, th);
                        continue;
                    }
                    break;
                }
            }
        };
        sendToServer.setName("DataSyncClientSendToServerThread");
        sendToServer.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Boolean deleteNewsFromServer(List<DataSyncBean> toDelete) {
        Boolean result = null;
        try {
            GSONSession memshareSession = new GSONSession();
            Route to = new Route(new URI(this.url), new URI(this.serverName + "#" + UUID.randomUUID()));
            URI from = new URI(this.clientName);
            Call basic = new Call(to, "deleteNews", toDelete);
            Call returnRoster = basic.callback(from, "returnBoolean", new Object[0]).session(memshareSession);
            GSONSession gSONSession = memshareSession;
            synchronized (gSONSession) {
                returnRoster.send(this.t);
                memshareSession.wait(120000L);
            }
            if (memshareSession.getRpcError() != null) {
                System.out.println(memshareSession.getRpcError());
                return null;
            }
            result = (Boolean)memshareSession.getResult();
        }
        catch (Exception e) {
            Logger.logException(this, e);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Boolean errorsOnServer(List<DataSyncBean> errors) {
        Boolean result = null;
        try {
            GSONSession memshareSession = new GSONSession();
            Route to = new Route(new URI(this.url), new URI(this.serverName + "#" + UUID.randomUUID()));
            URI from = new URI(this.clientName);
            Call basic = new Call(to, "newsErrors", errors);
            Call returnRoster = basic.callback(from, "returnBoolean", new Object[0]).session(memshareSession);
            GSONSession gSONSession = memshareSession;
            synchronized (gSONSession) {
                returnRoster.send(this.t);
                memshareSession.wait(120000L);
            }
            if (memshareSession.getRpcError() != null) {
                System.out.println(memshareSession.getRpcError());
                return null;
            }
            result = (Boolean)memshareSession.getResult();
        }
        catch (Exception e) {
            Logger.logException(this, e);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<DataSyncBean> pushNewsToServer(List<DataSyncBean> newsToPush) {
        List beans = null;
        try {
            GSONSession memshareSession = new GSONSession();
            Route to = new Route(new URI(this.url), new URI(this.serverName + "#" + UUID.randomUUID()));
            URI from = new URI(this.clientName);
            Call basic = new Call(to, "receiveNewsFromChannel", newsToPush, this.channel);
            Call returnRoster = basic.callback(from, "returnNewsForChannel", new Object[0]).session(memshareSession);
            GSONSession gSONSession = memshareSession;
            synchronized (gSONSession) {
                returnRoster.send(this.t);
                memshareSession.wait(120000L);
            }
            if (memshareSession.getRpcError() != null) {
                System.out.println(memshareSession.getRpcError());
                return null;
            }
            beans = (List)memshareSession.getResult();
        }
        catch (Exception e) {
            Logger.logException(this, e);
        }
        return beans;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<DataSyncBean> getNewsFromServer() {
        List beans = null;
        try {
            GSONSession memshareSession = new GSONSession();
            Route to = new Route(new URI(this.url), new URI(this.serverName + "#" + UUID.randomUUID()));
            URI from = new URI(this.clientName);
            Call basic = new Call(to, "getNewsForChannel", this.channel);
            Call returnRoster = basic.callback(from, "returnNewsForChannel", new Object[0]).session(memshareSession);
            GSONSession gSONSession = memshareSession;
            synchronized (gSONSession) {
                returnRoster.send(this.t);
                memshareSession.wait(120000L);
            }
            if (memshareSession.getRpcError() != null) {
                System.out.println(memshareSession.getRpcError());
                return null;
            }
            beans = (List)memshareSession.getResult();
        }
        catch (Exception e) {
            Logger.logException(this, e);
        }
        return beans;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RMI
    public void returnNewsForChannel(List<DataSyncBean> value, @Session GSONSession memshareSession, RpcError rpcError) {
        GSONSession gSONSession = memshareSession;
        synchronized (gSONSession) {
            memshareSession.setRpcError(rpcError);
            memshareSession.setResult(value);
            memshareSession.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RMI
    public void returnBoolean(Boolean value, @Session GSONSession memshareSession, RpcError rpcError) {
        GSONSession gSONSession = memshareSession;
        synchronized (gSONSession) {
            memshareSession.setRpcError(rpcError);
            memshareSession.setResult(value);
            memshareSession.notify();
        }
    }
}

