/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.restaurant.logic.exports;

import com.google.code.gsonrmi.Parameter;
import com.google.code.gsonrmi.annotations.RMI;
import com.google.code.gsonrmi.serializer.ExceptionSerializer;
import com.google.code.gsonrmi.serializer.ParameterSerializer;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Type;
import java.net.URISyntaxException;
import java.util.List;
import ro.atreides.restaurant.logic.DataSyncServerLogic;
import ro.atreides.restaurant.logic.exports.DataSyncBean;
import ro.atreides.restaurant.logic.exports.DataSyncClientLogic;
import ro.atreides.restaurant.logic.exports.DataSyncGsonClient;
import ro.atreides.utils.Logger;
import ro.deversoft.android.foodtablet.gsonserver.GSONEntity;

public class DataSyncGsonServer
extends GSONEntity {
    private static DataSyncGsonServer serverGsonServer;

    private DataSyncGsonServer(String url, String serverName, String clientName, Integer listeningPort) throws InvocationTargetException, URISyntaxException {
        super(url, serverName, clientName, listeningPort);
    }

    public static synchronized DataSyncGsonServer getFirstInstance(String url, String serverName, String clientName, Integer listeningPort) {
        try {
            serverGsonServer = new DataSyncGsonServer(url, serverName, clientName, listeningPort);
        }
        catch (Exception e) {
            Logger.logException(DataSyncGsonClient.class.getName(), e);
        }
        return serverGsonServer;
    }

    @Override
    protected Gson buildGson() {
        return new GsonBuilder().registerTypeAdapter((Type)((Object)Exception.class), new ExceptionSerializer()).registerTypeAdapter((Type)((Object)Parameter.class), new ParameterSerializer()).create();
    }

    public static synchronized DataSyncGsonServer getInstance() {
        return serverGsonServer;
    }

    @RMI
    public List<DataSyncBean> receiveNewsFromChannel(List<DataSyncBean> toProcess, String channelName) {
        return DataSyncServerLogic.getLaterInstance().processRemoteCommands(toProcess, channelName);
    }

    @RMI
    public List<DataSyncBean> getNewsForChannel(String channelName) {
        return DataSyncClientLogic.getInstance().getDataToSync(channelName);
    }

    @RMI
    public Boolean deleteNews(List<DataSyncBean> toDelete) {
        DataSyncClientLogic.getInstance().sentOK(toDelete);
        return true;
    }

    @RMI
    public Boolean newsErrors(List<DataSyncBean> errors) {
        DataSyncClientLogic.getInstance().permanentErrors(errors);
        return true;
    }
}

