/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.restaurant.modules.acces.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.sql.Timestamp;
import java.text.ParseException;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.border.TitledBorder;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import ro.atreides.acces.contracte.CardClientBean;
import ro.atreides.acces.contracte.ContracteLogic;
import ro.atreides.acces.contracte.ContractePerioada;
import ro.atreides.acces.contracte.PerioadaEntry;
import ro.atreides.acces.contracte.StatusContractView;
import ro.atreides.acces.contracte.TipContract;
import ro.atreides.clienti.AltAct;
import ro.atreides.clienti.ClientLogic;
import ro.atreides.clienti.ClientNumeProvider;
import ro.atreides.clienti.ClientPersFizica;
import ro.atreides.clienti.ClientPersJuridica;
import ro.atreides.clienti.gui.ClientEditDialog;
import ro.atreides.clienti.gui.ClientEditPanelProvider;
import ro.atreides.clienti.gui.ClientPicturePanel;
import ro.atreides.clienti.gui.ClientSelectDialog;
import ro.atreides.clienti.gui.PersFizicaAddEditPanel;
import ro.atreides.clienti.gui.PersFizicaAddEditPanelAccesShort;
import ro.atreides.clienti.gui.PersJuridicaAddEditPanel;
import ro.atreides.pontaj.PontajLogic;
import ro.atreides.restaurant.VpConfig;
import ro.atreides.restaurant.base.Table;
import ro.atreides.restaurant.gui.GuiUtilsRest;
import ro.atreides.restaurant.logic.RestLogic;
import ro.atreides.restaurant.modules.acces.gui.AbonamentChooser;
import ro.atreides.restaurant.modules.acces.gui.CarduriDialog;
import ro.atreides.users.User;
import ro.atreides.utils.Client;
import ro.atreides.utils.DateUtils;
import ro.atreides.utils.EventGenerator;
import ro.atreides.utils.Formatters;
import ro.atreides.utils.Location;
import ro.atreides.utils.Logger;
import ro.atreides.utils.ObjectEventListener;
import ro.atreides.utils.ReflectedJPanel;
import ro.atreides.utils.Utils;
import ro.atreides.utils.config.Config;
import ro.atreides.utils.gui.ColorProvider;
import ro.atreides.utils.gui.GuiUtils;
import ro.atreides.utils.gui.JMultilineLabel;
import ro.atreides.utils.gui.Legenda;
import ro.atreides.utils.gui.Validators;
import ro.atreides.utils.gui.dialogs.CardInputDialog;
import ro.atreides.utils.gui.dialogs.DialogUtils;
import ro.atreides.utils.gui.dialogs.FileDialog;
import ro.atreides.utils.gui.dialogs.MultipleSelectionPanel;
import ro.atreides.utils.gui.table.AbstractListPanel;
import ro.atreides.utils.gui.table.AbstractTM;
import ro.atreides.utils.gui.table.ColumnSizeProvider;
import ro.atreides.utils.gui.table.CustomCellRenderer;
import ro.atreides.utils.gui.table.TmInterface;
import ro.atreides.utils.messaging.Message;
import ro.atreides.utils.messaging.Messenger;
import ro.atreides.utils.multilang.LangRoAll;

public class AccesFOPanel
extends ReflectedJPanel {
    private JMultilineLabel nume;
    private JMultilineLabel detalii;
    private JMultilineLabel vechime;
    private JMultilineLabel last;
    private ClientPicturePanel img;
    private JLabel numeL;
    private JLabel detaliiL;
    private JLabel vechimeL;
    private JLabel lastL;
    private JTextArea comentarii;
    private AbstractListPanel evenimente;
    private JButton citire;
    private JButton plata;
    private JButton addComment;
    private JButton admin;
    private JButton client;
    private JButton checkout;
    private JButton incarcaTag;
    private JButton modificaAbonamente;
    private JButton modificaClient;
    private JButton importClienti;
    private JButton carduriClient;
    private JButton sincronizareBtn;
    private static final int FONT_SIZE = 30;
    private JTable perioadeTable;
    private JPanel leftPanel;
    private AbstractTM perioadeTableModel;
    private int idClient = -1;
    private String currentCard = null;
    public static Vector<Location> locations = new Vector();
    private String codAutentificare = "";
    private long lastCharRead = System.currentTimeMillis();
    private static final long cardReadTimeout = 3000L;
    public static boolean hardwareReader = false;

    private void display() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 1;
        c.anchor = 10;
        c.insets = new Insets(5, 5, 5, 5);
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 2;
        c.gridheight = 2;
        JPanel left = this.getLeftPanel();
        this.add((Component)left, c);
        c.gridx = 0;
        c.gridy = 2;
        c.weighty = 1.0;
        c.gridwidth = 2;
        c.gridheight = 2;
        JPanel middle = this.getMiddlePanel();
        this.add((Component)middle, c);
        c.weightx = 0.0;
        c.gridwidth = 1;
        c.gridx = 2;
        c.gridy = 0;
        c.gridheight = 1;
        c.weighty = 0.0;
        JPanel actiuni = this.getButtonPanel();
        this.add((Component)actiuni, c);
        c.weightx = 0.0;
        c.gridy = 1;
        c.weighty = 0.0;
        c.gridheight = 3;
        this.img = new ClientPicturePanel(new ClientNumeProvider(){

            @Override
            public String getNumeClient() {
                return AccesFOPanel.this.nume.getText();
            }
        });
        this.add((Component)this.img, c);
        c.weighty = 1.0;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.gridy = 4;
        c.gridx = 0;
        Legenda l = new Legenda(new String[]{"Activ", "De prelungit", "Gratie", "Suspendat"}, new Color[]{Color.GREEN, Color.BLUE, Color.YELLOW, Color.RED});
        this.add((Component)l, c);
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.gridx = 1;
        c.gridwidth = 3;
        JPanel evPanel = this.getEvenimenteCommentsPanel();
        this.add((Component)evPanel, c);
        Thread refreshPersonsThread = new Thread(){

            @Override
            public void run() {
                while (true) {
                    try {
                        Thread.sleep(5000L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    AccesFOPanel.this.updatePersoaneInSala();
                }
            }
        };
        refreshPersonsThread.setName("Refresh People in Shift Thread");
        refreshPersonsThread.start();
    }

    private JPanel getEvenimenteCommentsPanel() {
        JPanel leftPanel = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 1;
        c.anchor = 10;
        c.insets = new Insets(0, 0, 0, 0);
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.gridheight = 1;
        c.gridx = 0;
        c.gridy = 0;
        JPanel evPanel = this.getEvenimentePanel();
        leftPanel.add((Component)evPanel, c);
        ++c.gridx;
        JPanel comPanel = this.getCommentsPanel();
        leftPanel.add((Component)comPanel, c);
        return leftPanel;
    }

    private JPanel getCommentsPanel() {
        JPanel leftPanel = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 1;
        c.anchor = 10;
        c.insets = new Insets(2, 2, 2, 2);
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.gridheight = 1;
        c.gridx = 0;
        c.gridy = 0;
        this.comentarii = new JTextArea();
        this.comentarii.setEditable(false);
        JScrollPane s1 = new JScrollPane(this.comentarii, 22, 32);
        leftPanel.add((Component)s1, c);
        leftPanel.setBorder(new TitledBorder("Comentarii"));
        return leftPanel;
    }

    private JPanel getEvenimentePanel() {
        JPanel leftPanel = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 1;
        c.anchor = 10;
        c.insets = new Insets(2, 2, 2, 2);
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.gridheight = 1;
        c.gridx = 0;
        c.gridy = 0;
        this.evenimente = new AbstractListPanel(){

            @Override
            public String[] buildColumns() {
                return new String[]{""};
            }

            @Override
            public Vector buildData() {
                Vector<Message> messages = Messenger.getInstance().getMessages("SOYAL_IN_OUT_READER");
                return messages;
            }

            @Override
            public AbstractTM buildTableModel() {
                this.tm = new AbstractTM(this.buildColumns(), this.buildTypes(), new TmInterface(){

                    @Override
                    public Object getValueAt(int rowIndex, int columnIndex, Vector data) {
                        Message m = (Message)data.elementAt(data.size() - rowIndex - 1);
                        String codedInfo = m.getText();
                        Hashtable<String, String> values = Messenger.getInfosCodedInMessageText(codedInfo);
                        String text = values.get("t");
                        String statusS = values.get("s");
                        String color = null;
                        if (Validators.correctInteger(statusS)) {
                            int status = Integer.parseInt(statusS);
                            switch (status) {
                                case 1: {
                                    color = "\"green\"";
                                    break;
                                }
                                case 2: {
                                    color = "\"blue\"";
                                    break;
                                }
                                case 3: {
                                    color = "\"#db9418\"";
                                    break;
                                }
                                case 4: {
                                    color = "\"red\"";
                                }
                            }
                        }
                        if (color != null) {
                            return "<html><font color=" + color + " size=\"+1\">" + text + "</font></html>";
                        }
                        return text;
                    }

                    @Override
                    public boolean isCellEditable(int rowIndex, int columnIndex) {
                        return false;
                    }

                    @Override
                    public void setValueAt(Object aValue, int rowIndex, int columnIndex, Vector data) {
                    }
                });
                return this.tm;
            }

            @Override
            public Class[] buildTypes() {
                return new Class[]{String.class};
            }

            @Override
            public JPanel getBottomPanel() {
                return null;
            }

            @Override
            public void doStuff() {
                this.display();
            }
        };
        leftPanel.add((Component)this.evenimente, c);
        leftPanel.setBorder(new TitledBorder("Evenimente"));
        return leftPanel;
    }

    private String citireCard() {
        if (hardwareReader) {
            final StringBuffer card = new StringBuffer();
            EventGenerator soyal = RestLogic.getInstance().getAccesInterface();
            if (soyal != null) {
                System.out.println("AccesFOPanel: 1");
                final CardInputDialog dialog = new CardInputDialog((Frame)GuiUtils.currentFrame, true, VpConfig.getInstance().codFidelitateLength);
                ObjectEventListener l = new ObjectEventListener(){

                    @Override
                    public void dataChanged(Object o) {
                        System.out.println("Object Listener received data : " + o.toString());
                        card.append(o);
                        dialog.dispose();
                    }

                    @Override
                    public String getName() {
                        return "touch3_soyal_fidelitate";
                    }
                };
                soyal.addObjectListener(l, 701);
                dialog.setVisible(true);
                soyal.removeObjectListener(l);
            } else {
                CardInputDialog dialog = new CardInputDialog((Frame)GuiUtils.currentFrame, true, VpConfig.getInstance().codFidelitateLength);
                dialog.setVisible(true);
                card.append(dialog.getCodAutentificare());
            }
            return card.toString();
        }
        String s = DialogUtils.inputDialog(GuiUtils.currentFrame, "", "Introduceti codul de card");
        return s;
    }

    private JPanel getButtonPanel() {
        JPanel result = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 2;
        c.anchor = 10;
        c.insets = new Insets(2, 2, 2, 2);
        c.weightx = 1.0;
        c.weighty = 0.2;
        c.gridheight = 1;
        c.gridx = 0;
        c.gridy = 0;
        this.citire = new JButton("Citire card");
        this.citire.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                String card = AccesFOPanel.this.citireCard();
                AccesFOPanel.this.cardRead(card.toString());
            }
        });
        result.add((Component)this.citire, c);
        ++c.gridx;
        this.client = new JButton("Intrare client");
        this.client.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                AccesFOPanel.this.clientSelection();
            }
        });
        result.add((Component)this.client, c);
        final AccesFOPanel panel = this;
        ++c.gridx;
        this.checkout = new JButton("Checkout");
        this.checkout.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                if (AccesFOPanel.this.idClient > 0 && DialogUtils.confirmDialog(panel, "Inregistram Checkout", LangRoAll.confirmare)) {
                    ContracteLogic.getInstance().recordClientOut(AccesFOPanel.this.idClient);
                    AccesFOPanel.this.updatePersoaneInSala();
                }
            }
        });
        result.add((Component)this.checkout, c);
        ++c.gridy;
        c.gridx = 0;
        this.plata = new JButton("Plata");
        this.plata.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                if (AccesFOPanel.this.currentCard != null && DialogUtils.confirmDialog(GuiUtils.currentFrame, "Platim", LangRoAll.confirmare)) {
                    Vector waiters = RestLogic.getInstance().getWaiters();
                    if (waiters.size() == 0) {
                        DialogUtils.errorDialog(GuiUtils.currentFrame, "Adaugati un ospatar", LangRoAll.nuPotContinua);
                        return;
                    }
                    int idUser = ((User)waiters.get(0)).getId();
                    Vector<Table> tables = RestLogic.getInstance().getTables();
                    if (tables.size() == 0) {
                        DialogUtils.errorDialog(GuiUtils.currentFrame, "Adaugati o masa", LangRoAll.nuPotContinua);
                        return;
                    }
                    Table t = tables.get(0);
                    StatusContractView scv = null;
                    Vector<StatusContractView> contracte = ContracteLogic.getInstance().getStatusContracteByCard(AccesFOPanel.this.currentCard);
                    if (contracte.size() > 1) {
                        AbonamentChooser chooser = new AbonamentChooser(4, contracte);
                        scv = (StatusContractView)chooser.getSelected();
                        if (scv == null) {
                            return;
                        }
                    } else {
                        scv = contracte.get(0);
                    }
                    boolean plataMade = ContracteLogic.getInstance().prelungesteContract(scv, idUser, t, panel);
                    AccesFOPanel.this.updatePerioadeTable();
                    AccesFOPanel.this.completeIstoric(AccesFOPanel.this.idClient);
                }
            }
        });
        result.add((Component)this.plata, c);
        ++c.gridx;
        this.addComment = new JButton("Comentariu");
        this.addComment.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                String com;
                if (AccesFOPanel.this.idClient != -1 && Validators.correctString(com = DialogUtils.inputDialog(GuiUtils.currentFrame, "", "Comentariu despre client"))) {
                    String now = Formatters.DATE_AND_TIME_FORMAT.format(new Date());
                    ContracteLogic.getInstance().addComment(now + ": " + com, AccesFOPanel.this.idClient);
                    AccesFOPanel.this.completeIstoric(AccesFOPanel.this.idClient);
                }
            }
        });
        result.add((Component)this.addComment, c);
        ++c.gridx;
        this.admin = new JButton(LangRoAll.administrare);
        this.admin.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                GuiUtilsRest.doAdminLogin(RestLogic.getInstance());
            }
        });
        result.add((Component)this.admin, c);
        ++c.gridy;
        c.gridx = 0;
        this.incarcaTag = new JButton("Incarca Tag");
        this.incarcaTag.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Vector waiters = RestLogic.getInstance().getWaiters();
                if (waiters.size() == 0) {
                    DialogUtils.errorDialog(GuiUtils.currentFrame, "Adaugati un ospatar", LangRoAll.nuPotContinua);
                    return;
                }
                int idUser = ((User)waiters.get(0)).getId();
                String card = AccesFOPanel.this.citireCard();
                if (DialogUtils.confirmDialog(panel, "Incarcam TAG cu cod " + card, LangRoAll.confirmare)) {
                    ContracteLogic.getInstance().incarcaTag(card, panel, idUser, locations);
                }
            }
        });
        if (VpConfig.getInstance().accesShowIncarcaTagButton) {
            result.add((Component)this.incarcaTag, c);
            ++c.gridx;
        }
        this.modificaAbonamente = new JButton("Abonamente");
        this.modificaAbonamente.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AccesFOPanel.this.modificaAbonamente(AccesFOPanel.this.idClient);
            }
        });
        result.add((Component)this.modificaAbonamente, c);
        ++c.gridx;
        this.modificaClient = new JButton("Modifica client");
        this.modificaClient.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Client currentClient = ClientLogic.getInstance().getClientById(AccesFOPanel.this.idClient);
                AccesFOPanel.this.idClient = AccesFOPanel.this.addEditClient(currentClient);
                AccesFOPanel.this.cardRead(AccesFOPanel.this.currentCard);
            }
        });
        result.add((Component)this.modificaClient, c);
        ++c.gridy;
        c.gridx = 0;
        this.importClienti = new JButton("Import clienti");
        this.importClienti.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AccesFOPanel.this.importClienti(panel);
            }
        });
        if (VpConfig.getInstance().accesShowImportClientiButton) {
            result.add((Component)this.importClienti, c);
        }
        ++c.gridx;
        this.carduriClient = new JButton("Carduri");
        this.carduriClient.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Client client = ClientLogic.getInstance().getClientById(AccesFOPanel.this.idClient);
                if (client != null) {
                    Vector<CardClientBean> ccb = ContracteLogic.getInstance().getCardsForClient(AccesFOPanel.this.idClient);
                    CardClientBean ccb0 = ccb.get(0);
                    CarduriDialog dialog = new CarduriDialog((Frame)GuiUtils.currentFrame, true, ccb0.getCard(), ccb0.getCardSecundar());
                    String card1 = dialog.getCard1();
                    String card2 = dialog.getCard2();
                    if (Validators.correctString(card1) || Validators.correctString(card2)) {
                        if (DialogUtils.confirmDialog(GuiUtils.currentFrame, "Salvam cardurile pentru clientul " + client, LangRoAll.confirmare)) {
                            DialogUtils.okDialog(GuiUtils.currentFrame, LangRoAll.operatieExecutata, LangRoAll.succes);
                            ContracteLogic.getInstance().setCarduriForClient(AccesFOPanel.this.idClient, card1, card2);
                        }
                    } else {
                        DialogUtils.errorDialog(GuiUtils.currentFrame, "Completati cel putin un card!", LangRoAll.operatieEsuata);
                    }
                }
            }
        });
        result.add((Component)this.carduriClient, c);
        ++c.gridx;
        this.sincronizareBtn = new JButton("Sincronizare");
        this.sincronizareBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String message = ContracteLogic.getInstance().syncAdvancedControlLogic();
                if (!Validators.correctString(message)) {
                    DialogUtils.okDialog(panel, LangRoAll.operatieExecutata, LangRoAll.succes);
                } else {
                    DialogUtils.errorDialog(panel, message, LangRoAll.operatieEsuata);
                }
            }
        });
        if (VpConfig.getInstance().accesShowSyncBtn) {
            result.add((Component)this.sincronizareBtn, c);
        }
        this.admin.setFocusable(false);
        this.citire.setFocusable(false);
        this.client.setFocusable(false);
        this.addComment.setFocusable(false);
        this.plata.setFocusable(false);
        this.modificaClient.setFocusable(false);
        this.modificaAbonamente.setFocusable(false);
        this.incarcaTag.setFocusable(false);
        this.checkout.setFocusable(false);
        this.importClienti.setFocusable(false);
        this.carduriClient.setFocusable(false);
        this.updatePersoaneInSala();
        result.setBorder(new TitledBorder(LangRoAll.actiuni));
        return result;
    }

    private void updatePersoaneInSala() {
        String newLabel = "Checkout";
        int peopleIn = PontajLogic.getInstance().getPeopleInShift();
        newLabel = newLabel + " (" + peopleIn + ")";
        this.checkout.setText(newLabel);
    }

    private void updatePerioadeTable() {
        Vector<Object> perioade = new Vector();
        if (this.idClient > 0) {
            perioade = ContracteLogic.getInstance().getPerioadeEntry(this.idClient);
        }
        this.perioadeTableModel.refresh(perioade);
    }

    private boolean modificaAbonamente(int idClient, String card1, String card2) {
        if (idClient > 0) {
            Vector<TipContract> allTipContract = ContracteLogic.getInstance().getTipuriContract();
            Vector<TipContract> selectedContracts = ContracteLogic.getInstance().getTipContractSelected(idClient);
            MultipleSelectionPanel msp = new MultipleSelectionPanel(allTipContract, 6, selectedContracts);
            JDialog dialog = DialogUtils.getJDialogOKButton(msp, GuiUtils.currentFrame, "Selectati abonamentele active", 1.05);
            dialog.setVisible(true);
            Vector newItems = msp.getSelectedItems();
            return ContracteLogic.getInstance().modificaAbonamente(idClient, selectedContracts, newItems, card1, card2);
        }
        return false;
    }

    private boolean modificaAbonamente(int idClient) {
        Vector<CardClientBean> carduri = ContracteLogic.getInstance().getCardsForClient(idClient);
        if (carduri.size() > 0) {
            CardClientBean ccb = carduri.get(0);
            String card1 = ccb.getCard();
            String card2 = ccb.getCardSecundar();
            return this.modificaAbonamente(idClient, card1, card2);
        }
        return false;
    }

    private int addEditClient(Client c) {
        ClientEditPanelProvider provider = new ClientEditPanelProvider(){

            @Override
            public PersFizicaAddEditPanel getPfPanel() {
                return new PersFizicaAddEditPanelAccesShort();
            }

            @Override
            public PersJuridicaAddEditPanel getPjPanel() {
                return new PersJuridicaAddEditPanel();
            }
        };
        ClientEditDialog cDia = new ClientEditDialog(GuiUtils.currentFrame, ClientLogic.getInstance(), c, false, provider);
        return cDia.getClientId();
    }

    private void clientSelection() {
        ClientSelectDialog dia = new ClientSelectDialog(GuiUtils.currentFrame);
        int sel = dia.getSelected();
        Client c = dia.getSelectedClient();
        if (sel == -1 && dia.isMustAdd()) {
            sel = this.addEditClient(null);
        }
        this.clientSelected(sel);
    }

    private void clientSelected(int sel) {
        if (sel > 0) {
            Vector<CardClientBean> carduri = ContracteLogic.getInstance().getCardsForClient(sel);
            if (carduri.size() > 0) {
                CardClientBean ccb = carduri.elementAt(0);
                if (carduri.size() > 1) {
                    AbonamentChooser chooser = new AbonamentChooser(4, carduri);
                    ccb = (CardClientBean)chooser.getSelected();
                }
                if (ccb == null) {
                    return;
                }
                this.cardRead(ccb.getCard());
            } else if (DialogUtils.confirmDialog(GuiUtils.currentFrame, "Nici un abonament asociat ! Asociem acum ?", LangRoAll.confirmare)) {
                String card = this.citireCard();
                if (this.modificaAbonamente(sel, card, card)) {
                    this.cardRead(card);
                } else {
                    DialogUtils.confirmDialog(GuiUtils.currentFrame, "Abonament neasociat", "Incercati mai tarziu");
                }
            } else {
                DialogUtils.confirmDialog(GuiUtils.currentFrame, "Abonament neasociat", "Incercati mai tarziu");
            }
        }
    }

    private void cardRead(String card) {
        if (!Validators.correctString(card)) {
            Logger.logError((Object)this, "card gol");
            return;
        }
        Logger.logError((Object)this, "CardRead : \"" + card + "\"");
        Vector<StatusContractView> contracte = ContracteLogic.getInstance().getStatusContracteByCard(card);
        if (contracte.size() > 0) {
            StatusContractView scv = contracte.elementAt(0);
            Client c = ClientLogic.getInstance().getClientById(scv.getIdClient());
            this.nume.setText(c.toString());
            String detaliiS = "";
            if (c instanceof ClientPersFizica) {
                ClientPersFizica cpf = (ClientPersFizica)c;
                int idPass = cpf.getIdPassport();
                if (idPass > 0) {
                    AltAct altAct = ClientLogic.getInstance().getPassportById(idPass);
                    detaliiS = detaliiS + altAct.getTipAct() + " " + altAct.getSeria() + " (" + Formatters.DATE_FORMAT_RO.format(altAct.getDataEliberarii()) + " - " + Formatters.DATE_FORMAT_RO.format(altAct.getDataExpirarii()) + ")";
                }
            } else {
                ClientPersJuridica cpj = (ClientPersJuridica)c;
                detaliiS = detaliiS + cpj.getCui();
            }
            this.detalii.setText(detaliiS);
            this.detalii.setMaxWidth((int)this.detalii.getVisibleRect().getWidth());
            this.idClient = c.getId();
            this.currentCard = card;
            Timestamp l = PontajLogic.getInstance().getLastClientCheckIn(this.idClient);
            if (l != null) {
                String d = Formatters.DATE_AND_TIME_FORMAT.format(l);
                this.last.setText(d);
            } else {
                this.last.setText("");
                l = DateUtils.getCurrentTimestamp();
            }
            if (c instanceof ClientPersFizica) {
                ClientPersFizica pf = (ClientPersFizica)c;
                this.img.reload(pf.getIdPersFizica());
            }
            this.completeIstoric(this.idClient);
            this.updatePerioadeTable();
            return;
        }
        if (DialogUtils.confirmDialog(GuiUtils.currentFrame, "Nici un abonament asociat ! Asociem acum ?", LangRoAll.confirmare)) {
            if (DialogUtils.confirmDialog(GuiUtils.currentFrame, "Adaugam client nou", "Client nou / existent")) {
                int idClientNew = this.addEditClient(null);
                if (idClientNew > 0) {
                    if (this.modificaAbonamente(idClientNew, card, card)) {
                        this.cardRead(card);
                    } else {
                        DialogUtils.confirmDialog(GuiUtils.currentFrame, "Abonament neasociat", "Incercati mai tarziu");
                    }
                }
            } else {
                this.client.doClick();
            }
        } else {
            DialogUtils.confirmDialog(GuiUtils.currentFrame, "Abonament neasociat", "Incercati mai tarziu");
        }
    }

    private void completeIstoric(int idClient) {
        StringBuffer c = new StringBuffer();
        Vector c1 = ContracteLogic.getInstance().getComments(idClient);
        for (int i = 0; i < c1.size(); ++i) {
            String s = (String)c1.elementAt(i);
            c.append(s);
            c.append("\n\n----\n\n");
        }
        this.comentarii.setText(c.toString());
    }

    private JPanel getMiddlePanel() {
        JPanel leftPanel = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 1;
        c.anchor = 10;
        c.insets = new Insets(2, 2, 2, 2);
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.gridheight = 1;
        final String[] columns = new String[]{LangRoAll.tip, "Valabilitate", "Sedinte L/T/C"};
        this.perioadeTableModel = new AbstractTM(columns, Utils.getStringClass(columns.length), new TmInterface(){

            @Override
            public Object getValueAt(int rowIndex, int columnIndex, Vector data) {
                PerioadaEntry pe = (PerioadaEntry)data.get(rowIndex);
                switch (columnIndex) {
                    case 0: {
                        return pe.getTipAbonament();
                    }
                    case 1: {
                        return pe.getValabilitate();
                    }
                    case 2: {
                        return pe.getIntrari();
                    }
                }
                return null;
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return false;
            }

            @Override
            public void setValueAt(Object aValue, int rowIndex, int columnIndex, Vector data) {
            }
        });
        final AccesFOPanel panel = this;
        this.perioadeTable = new JTable(this.perioadeTableModel);
        this.perioadeTable.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
            }

            @Override
            public void mousePressed(MouseEvent e) {
                Point p;
                JTable t = (JTable)e.getSource();
                int selRow = t.rowAtPoint(p = e.getPoint());
                if (selRow == -1) {
                    return;
                }
                final PerioadaEntry pe = (PerioadaEntry)AccesFOPanel.this.perioadeTableModel.getObjectAt(selRow);
                if (pe.getStatus() == 2) {
                    return;
                }
                JPopupMenu popup = new JPopupMenu();
                Font bonItemFont = new Font(null, 1, 12);
                JMenuItem checkin = new JMenuItem("Checkin");
                checkin.setFont(bonItemFont);
                popup.add(checkin);
                checkin.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent ev) {
                        if (DialogUtils.confirmDialog(panel, "Inregistram checkin", LangRoAll.confirmare)) {
                            ContractePerioada cp = ContracteLogic.getInstance().getCurrentPerioada(pe.getIdContract());
                            if (cp == null || cp.getIdAbonamentClient() == pe.getIdContract()) {
                                if (cp == null) {
                                    ContracteLogic.getInstance().activeazaPerioada(pe.getId());
                                }
                                int idContract = pe.getIdContract();
                                ContracteLogic.getInstance().addIntrareClient(idContract);
                                int idClient = ContracteLogic.getInstance().getClientByIdAbonament(idContract);
                                PontajLogic.getInstance().punchClientIn(idClient, idContract, pe.getTipAbonament(), true);
                                ContracteLogic.getInstance().updateContractStatus(pe.getIdContract(), pe.getIdTipContract(), idClient);
                                AccesFOPanel.this.updatePerioadeTable();
                                AccesFOPanel.this.updatePersoaneInSala();
                            } else {
                                DialogUtils.errorDialog(panel, "Folositi perioadele active", LangRoAll.nuPotContinua);
                                return;
                            }
                        }
                    }
                });
                if (VpConfig.getInstance().accesAllowSchimbareAbonament) {
                    JMenuItem tipAbonament = new JMenuItem("Schimba tip abonament");
                    tipAbonament.setFont(bonItemFont);
                    popup.add(tipAbonament);
                    tipAbonament.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent ev) {
                            if (DialogUtils.confirmDialog(panel, "Modificam tipul de abonament", LangRoAll.confirmare)) {
                                Vector<TipContract> tipContractVector = ContracteLogic.getInstance().getTipuriContract();
                                AbonamentChooser chooser = new AbonamentChooser(4, tipContractVector);
                                TipContract tc = (TipContract)chooser.getSelected();
                                if (tc == null) {
                                    return;
                                }
                                ContracteLogic.getInstance().modificaTipAbonament(pe.getIdContract(), tc.getId());
                                AccesFOPanel.this.updatePerioadeTable();
                            }
                        }
                    });
                }
                if (pe.getStatus() == 6) {
                    JMenuItem nrZile = new JMenuItem("Seteaza nr zile");
                    nrZile.setFont(bonItemFont);
                    popup.add(nrZile);
                    nrZile.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent ev) {
                            if (DialogUtils.confirmDialog(panel, "Modificam numarul de zile", LangRoAll.confirmare)) {
                                String nrZile = DialogUtils.inputDialog(panel, pe.getForcedDays() + "", "Introduceti numarul de zile");
                                if (!Validators.correctInteger(nrZile)) {
                                    DialogUtils.errorDialog(panel, "Introduceti un numar !!", LangRoAll.nuPotContinua);
                                    return;
                                }
                                int nrZileI = Integer.valueOf(nrZile);
                                ContracteLogic.getInstance().setDaysForcedToPerioadaCommit(nrZileI, pe.getId());
                            }
                        }
                    });
                }
                if (pe.getStatus() != 6) {
                    JMenuItem intrerupere = new JMenuItem("Intrerupere");
                    intrerupere.setFont(bonItemFont);
                    popup.add(intrerupere);
                    intrerupere.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent ev) {
                            if (DialogUtils.confirmDialog(panel, "Intrerupere perioada", LangRoAll.confirmare)) {
                                String s1 = Formatters.DATE_FORMAT.format(DateUtils.addDaysToDate(new Date(), 1));
                                String start = DialogUtils.inputDialog(panel, s1, "Introduceti data de intrerupere");
                                if (!Validators.correctDate(start, Formatters.DATE_FORMAT)) {
                                    DialogUtils.errorDialog(panel, "Format de data incorect", LangRoAll.nuPotContinua);
                                    return;
                                }
                                try {
                                    Date stop = Formatters.DATE_FORMAT.parse(start);
                                    stop = DateUtils.getEndOfDay(stop);
                                    boolean ok = ContracteLogic.getInstance().intrerupePerioada(pe, new Timestamp(stop.getTime()));
                                    if (ok) {
                                        DialogUtils.okDialog(panel, LangRoAll.operatieExecutata, LangRoAll.succes);
                                    } else {
                                        DialogUtils.errorDialog(panel, LangRoAll.operatieEsuata, LangRoAll.eroare);
                                    }
                                    AccesFOPanel.this.updatePerioadeTable();
                                }
                                catch (ParseException e1) {
                                    Logger.logException(this, (Exception)e1);
                                }
                            }
                        }
                    });
                    JMenuItem dataStop = new JMenuItem("Seteaza data stop");
                    dataStop.setFont(bonItemFont);
                    popup.add(dataStop);
                    dataStop.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent ev) {
                            if (DialogUtils.confirmDialog(panel, "Setem data de stop", LangRoAll.confirmare)) {
                                String s1 = Formatters.DATE_FORMAT.format(pe.getStopTime());
                                String start = DialogUtils.inputDialog(panel, s1, "Introduceti data de stop");
                                if (!Validators.correctDate(start, Formatters.DATE_FORMAT)) {
                                    DialogUtils.errorDialog(panel, "Format de data incorect", LangRoAll.nuPotContinua);
                                    return;
                                }
                                try {
                                    Date stop = Formatters.DATE_FORMAT.parse(start);
                                    stop = DateUtils.getEndOfDay(stop);
                                    ContracteLogic.getInstance().updateStopForPerioadaCommit(pe.getId(), new Timestamp(stop.getTime()));
                                    AccesFOPanel.this.updatePerioadeTable();
                                    DialogUtils.okDialog(panel, LangRoAll.operatieExecutata, LangRoAll.succes);
                                }
                                catch (ParseException e1) {
                                    Logger.logException(this, (Exception)e1);
                                }
                            }
                        }
                    });
                }
                popup.show(e.getComponent(), e.getX(), e.getY());
            }

            @Override
            public void mouseReleased(MouseEvent e) {
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }
        });
        this.perioadeTableModel.refresh(new Vector());
        GuiUtils.updateJTableRowSize(this.perioadeTable, VpConfig.getInstance().touchTableFontSize);
        this.perioadeTable.setFont(new Font(null, 0, VpConfig.getInstance().touchTableFontSize));
        GuiUtils.updateJTableColumnSize(this.perioadeTable, new ColumnSizeProvider(){

            @Override
            public int getColumnSize(int column) {
                switch (column) {
                    case 0: {
                        return 20;
                    }
                    case 1: {
                        return 40;
                    }
                    case 2: {
                        return 10;
                    }
                }
                return 10;
            }

            public int getColumnCount() {
                return columns.length;
            }
        });
        CustomCellRenderer cellRender = new CustomCellRenderer(new ColorProvider(){

            @Override
            public Color getColorForLine(int line, AbstractTableModel tm) {
                PerioadaEntry pe = (PerioadaEntry)AccesFOPanel.this.perioadeTableModel.getObjectAt(line);
                switch (pe.getStatus()) {
                    case 1: {
                        return Color.GREEN;
                    }
                    case 6: {
                        return Color.YELLOW;
                    }
                    case 2: {
                        return Color.RED;
                    }
                }
                return null;
            }
        }, this.perioadeTableModel);
        TableColumnModel colModel = this.perioadeTable.getColumnModel();
        Enumeration<TableColumn> enum1 = colModel.getColumns();
        while (enum1.hasMoreElements()) {
            TableColumn column = enum1.nextElement();
            column.setCellRenderer(cellRender);
        }
        JScrollPane scroll = new JScrollPane(this.perioadeTable);
        leftPanel.add((Component)scroll, c);
        leftPanel.setBorder(new TitledBorder("Perioade"));
        this.perioadeTable.setFocusable(false);
        return leftPanel;
    }

    private JPanel getLeftPanel() {
        this.leftPanel = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 2;
        c.anchor = 17;
        c.insets = new Insets(2, 2, 2, 2);
        c.weightx = 0.0;
        c.weighty = 0.2;
        c.gridheight = 1;
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 0.1;
        this.numeL = new JLabel("Nume");
        this.numeL.setFont(new Font(null, 0, 30));
        this.leftPanel.add((Component)this.numeL, c);
        ++c.gridx;
        c.weightx = 0.9;
        this.nume = new JMultilineLabel();
        this.nume.setFont(new Font(null, 0, 30));
        this.leftPanel.add((Component)this.nume, c);
        ++c.gridy;
        c.gridx = 0;
        c.weightx = 0.1;
        this.detaliiL = new JLabel(LangRoAll.detalii);
        this.detaliiL.setFont(new Font(null, 0, 30));
        this.leftPanel.add((Component)this.detaliiL, c);
        ++c.gridx;
        c.weightx = 0.9;
        this.detalii = new JMultilineLabel();
        this.detalii.setFont(new Font(null, 0, 30));
        this.leftPanel.add((Component)this.detalii, c);
        ++c.gridy;
        c.gridx = 0;
        c.weightx = 0.1;
        this.lastL = new JLabel("Ultima intrare");
        this.lastL.setFont(new Font(null, 0, 30));
        this.leftPanel.add((Component)this.lastL, c);
        ++c.gridx;
        c.weightx = 0.9;
        this.last = new JMultilineLabel();
        this.last.setFont(new Font(null, 0, 30));
        this.leftPanel.add((Component)this.last, c);
        ++c.gridy;
        c.gridx = 0;
        c.weightx = 0.1;
        this.vechimeL = new JLabel("Vechime");
        this.vechimeL.setFont(new Font(null, 0, 30));
        ++c.gridx;
        c.weightx = 0.9;
        this.vechime = new JMultilineLabel();
        this.vechime.setFont(new Font(null, 0, 30));
        this.leftPanel.setBorder(new TitledBorder("Informatii"));
        this.leftPanel.addKeyListener(new KeyListener(){

            @Override
            public void keyPressed(KeyEvent e) {
            }

            @Override
            public void keyReleased(KeyEvent e) {
            }

            @Override
            public void keyTyped(KeyEvent e) {
                if (AccesFOPanel.this.lastCharRead + 3000L < System.currentTimeMillis()) {
                    AccesFOPanel.this.codAutentificare = "";
                }
                if (e.getKeyChar() == '\n') {
                    System.out.println("am prins un \\n");
                } else {
                    AccesFOPanel.this.codAutentificare = AccesFOPanel.this.codAutentificare + String.valueOf(e.getKeyChar());
                    AccesFOPanel.this.lastCharRead = System.currentTimeMillis();
                    if (AccesFOPanel.this.codAutentificare.length() == Config.getInstance().getInt("codFidelitateLength")) {
                        String card = AccesFOPanel.this.codAutentificare;
                        AccesFOPanel.this.cardRead(card);
                        AccesFOPanel.this.autoreadCheckin(card);
                        AccesFOPanel.this.codAutentificare = "";
                    }
                }
            }
        });
        this.leftPanel.setFocusable(true);
        return this.leftPanel;
    }

    private void autoreadCheckin(String card) {
        Vector<Object> perioade = new Vector();
        if (this.idClient > 0) {
            perioade = ContracteLogic.getInstance().getPerioadeEntry(this.idClient);
        }
        for (PerioadaEntry perioadaEntry : perioade) {
            int idContract = perioadaEntry.getIdContract();
            int idClient = ContracteLogic.getInstance().getClientByIdAbonament(idContract);
            ContracteLogic.getInstance().updateContractStatus(perioadaEntry.getIdContract(), perioadaEntry.getIdTipContract(), idClient);
        }
    }

    private void importClienti(JComponent panel) {
        if (DialogUtils.confirmDialog(panel, "Importam clientii din centrala Advanced Control Logic ", LangRoAll.confirmare)) {
            String authFile = FileDialog.getLoadDialogLocation(panel, "Selectati fisierul GET_AUTH", "csv,txt");
            String usersFile = FileDialog.getLoadDialogLocation(panel, "Selectati fisierul GET_USERS", "csv,txt");
            String numeClientiFile = FileDialog.getLoadDialogLocation(panel, "Selectati fisierul de NUME clienti", "csv,txt");
            String carduriClientiFile = FileDialog.getLoadDialogLocation(panel, "Selectati fisierul de CARDURI clienti", "csv,txt");
            String pictureFolder = FileDialog.getLoadDialogFolder(panel, "Selectati directorul de poze");
            if (authFile == null || usersFile == null || numeClientiFile == null || carduriClientiFile == null || pictureFolder == null) {
                return;
            }
            boolean allOK = ContracteLogic.getInstance().importClientiAdvancedControlUtils(authFile, usersFile, numeClientiFile, carduriClientiFile, pictureFolder, this);
            if (allOK) {
                DialogUtils.okDialog(panel, LangRoAll.operatieExecutata, LangRoAll.succes);
            } else {
                DialogUtils.errorDialog(panel, LangRoAll.operatieEsuata, LangRoAll.operatieEsuata);
            }
        }
    }

    @Override
    public void doStuff() {
        this.display();
        this.evenimente.doStuff();
        Thread th = new Thread(){

            @Override
            public void run() {
                while (true) {
                    try {
                        Thread.sleep(500L);
                    }
                    catch (InterruptedException e) {
                        // empty catch block
                    }
                    Vector oldData = AccesFOPanel.this.evenimente.getTm().getData();
                    AccesFOPanel.this.evenimente.refreshTable();
                    Vector newData = AccesFOPanel.this.evenimente.getTm().getData();
                    AccesFOPanel.this.triggerAlarm(oldData, newData);
                }
            }
        };
        th.setName("AccesFOPanel.EvenimenteRefreshThread");
        th.start();
        this.leftPanel.requestFocus();
        this.leftPanel.requestDefaultFocus();
        this.evenimente.getJTable().addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                String idClient;
                Point p;
                JTable t = (JTable)e.getSource();
                int selRow = t.rowAtPoint(p = e.getPoint());
                if (selRow == -1) {
                    return;
                }
                Vector data = AccesFOPanel.this.evenimente.getTm().getData();
                Message m = (Message)data.elementAt(data.size() - selRow - 1);
                String codedInfo = m.getText();
                Hashtable<String, String> values = Messenger.getInfosCodedInMessageText(codedInfo);
                int modifiers = e.getModifiers();
                if ((modifiers & 0x10) > 0 && e.getClickCount() >= 2 && Validators.correctInteger(idClient = values.get("u"))) {
                    AccesFOPanel.this.clientSelected(Integer.parseInt(idClient));
                }
            }
        });
        GuiUtils.updateJTableRowSize(this.evenimente.getJTable(), 20);
    }

    private void triggerAlarm(Vector<String> oldData, Vector<String> newData) {
    }

    public void triggerAlerts(Vector newData) {
    }
}

