/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.restaurant.modules.accesfilereadermaster;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.LineNumberReader;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.Vector;
import javax.mail.MessagingException;
import ro.atreides.acces.AccesRequestToReaderBean;
import ro.atreides.acces.AccessAlertInterface;
import ro.atreides.acces.CallBackInterface;
import ro.atreides.acces.ExternalDeviceListener;
import ro.atreides.acces.ExternalReaderBean;
import ro.atreides.acces.advancedcontrol.AdvancedControlUtils;
import ro.atreides.acces.contracte.ContracteLogic;
import ro.atreides.acces.contracte.TipContract;
import ro.atreides.acces.soyal.rules.InReader;
import ro.atreides.restaurant.VpConfig;
import ro.atreides.users.User;
import ro.atreides.utils.Client;
import ro.atreides.utils.FileUtils;
import ro.atreides.utils.Formatters;
import ro.atreides.utils.Logger;
import ro.atreides.utils.MailUtils;
import ro.atreides.utils.ModuleInstantiationException;
import ro.atreides.utils.Utils;
import ro.atreides.utils.gui.Validators;

public class Module
implements ro.atreides.utils.Module {
    private Hashtable<String, InReader> readersHash = new Hashtable();
    private Hashtable<String, Vector<AccesRequestToReaderBean>> outQueue = new Hashtable();
    private Hashtable<String, Object> locks = new Hashtable();
    private static final long TIMEOUT = 20000L;
    private Hashtable<String, String> waitForAnswer = new Hashtable();
    private HashMap<String, Boolean> answers = new HashMap();
    private HashMap<String, String> errorType = new HashMap();

    @Override
    public String getModuleName() {
        return "AccesFileReaderMaster";
    }

    @Override
    public Collection getViews() {
        return null;
    }

    @Override
    public void init(String[] cmdArgs, Hashtable runtimeObjects) throws ModuleInstantiationException {
        final String mailUser = Utils.getCmdlineValue("-mailUser", cmdArgs);
        final String mailPassword = Utils.getCmdlineValue("-mailPass", cmdArgs);
        final String mailFrom = Utils.getCmdlineValue("-mailFrom", cmdArgs);
        final String mailSubjectTemplate = Utils.getCmdlineValue("-mailSubjectTemplate", cmdArgs);
        String params = Utils.getCmdlineValue("-params", cmdArgs);
        Vector readers = Utils.splitString(params, ',');
        for (String reader : readers) {
            String achivePath;
            File archiveFile;
            String timeoutPath;
            File timeoutFile;
            String errPath;
            File errFile;
            String okPath;
            File okFile;
            String resultsPath;
            File resultsFile;
            Vector p = Utils.splitString(reader, '=');
            final String readerName = (String)p.get(0);
            String rootFolder = (String)p.get(1);
            this.locks.put(readerName, new Object());
            this.outQueue.put(readerName, new Vector());
            Boolean consumeSedinte = Boolean.parseBoolean((String)p.get(2));
            String currDir = FileUtils.getCurrentDir();
            final String toProcessPath = currDir + File.separator + rootFolder + File.separator + "to_process";
            File toProcessFile = new File(toProcessPath);
            if (!toProcessFile.exists()) {
                toProcessFile.mkdirs();
            }
            if (!(resultsFile = new File(resultsPath = currDir + File.separator + rootFolder + File.separator + "results")).exists()) {
                resultsFile.mkdirs();
            }
            if (!(okFile = new File(okPath = currDir + File.separator + rootFolder + File.separator + "ok")).exists()) {
                okFile.mkdirs();
            }
            if (!(errFile = new File(errPath = currDir + File.separator + rootFolder + File.separator + "err")).exists()) {
                errFile.mkdirs();
            }
            if (!(timeoutFile = new File(timeoutPath = currDir + File.separator + rootFolder + File.separator + "timeout")).exists()) {
                timeoutFile.mkdirs();
            }
            if (!(archiveFile = new File(achivePath = currDir + File.separator + rootFolder + File.separator + "archive")).exists()) {
                archiveFile.mkdirs();
            }
            InReader readerInterface = new InReader(readerName, consumeSedinte);
            this.readersHash.put(readerName, readerInterface);
            if (Validators.correctString(mailUser) && Validators.correctString(mailPassword) && Validators.correctString(mailFrom) && Validators.correctString(mailSubjectTemplate)) {
                readerInterface.setAlertInterface(new AccessAlertInterface(){

                    @Override
                    public void logEntry(User user, String readerName, Date eventDate) {
                    }

                    @Override
                    public void logEntry(Client user, String readerName, Date eventDate) {
                        if (VpConfig.getInstance().accesSendEmailAtEvent) {
                            try {
                                Object[] values = new String[]{user.toString(), readerName, Formatters.DATE_AND_TIME_FORMAT.format(eventDate)};
                                String subject = MessageFormat.format(mailSubjectTemplate, values);
                                MailUtils.sendMailGoogleSMTP(mailUser, mailPassword, mailFrom, user.getEmail(), subject, "", null);
                            }
                            catch (MessagingException e) {
                                Logger.logError((Object)this, e);
                            }
                        }
                    }
                });
            }
            Vector<TipContract> contracte = ContracteLogic.getInstance().getTipuriContract();
            Vector<String> tipAb = new Vector<String>();
            for (TipContract tipContract : contracte) {
                tipAb.add(tipContract.getNume());
            }
            readerInterface.setTipAbonamente(tipAb);
            Thread thread = new Thread(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    block7: while (true) {
                        try {
                            while (true) {
                                boolean deleteOk;
                                boolean movedOk;
                                File[] items;
                                for (File item : items = resultsFile.listFiles()) {
                                    if (!item.isFile()) continue;
                                    boolean processedOK = false;
                                    boolean nothingToProcess = true;
                                    String shortName = item.getName();
                                    if (shortName.startsWith("RTLOG")) {
                                        nothingToProcess = false;
                                        processedOK = Module.this.processRTLOG(item, readerName);
                                    }
                                    String moveToPath = archiveFile.getAbsolutePath() + File.separator + item.getName();
                                    if (!processedOK && !nothingToProcess || (movedOk = item.renameTo(new File(moveToPath)))) continue;
                                    Logger.logError((Object)(this + " " + readerName), "Could not move " + item.getAbsolutePath() + " to " + moveToPath);
                                    deleteOk = item.delete();
                                    if (deleteOk) continue;
                                    Logger.logError((Object)(this + " " + readerName), "Could not delete " + item.getAbsolutePath() + " FIX THIS AND RESTART APP. NOW QUITING !!");
                                    Utils.systemExit();
                                }
                                Vector outQueueCurrentReader = (Vector)Module.this.outQueue.get(readerName);
                                if (outQueueCurrentReader.size() > 0) {
                                    CallBackInterface callBackInterface;
                                    File item;
                                    final AccesRequestToReaderBean bean = (AccesRequestToReaderBean)outQueueCurrentReader.get(0);
                                    bean.setCallBackInterface(new CallBackInterface(){

                                        @Override
                                        public void showErrorMessage(String errorMessage) {
                                            Logger.logDebug(this + " " + readerName, "ErrorMessage \"" + errorMessage + "\" for bean : \"COMMAND: " + bean.getCommand() + ",PAYLOAD: " + bean.getPayload() + "\"");
                                        }
                                    });
                                    Object lock = Module.this.locks.get(readerName);
                                    item = lock;
                                    synchronized (item) {
                                        String filename = bean.getCommand() + Formatters.currentDateAndTimeForFileSystem.format(new Date()) + ".txt";
                                        String absolutePath = toProcessPath + File.separator + filename;
                                        Module.this.waitForAnswer.put(readerName, filename);
                                        Module.this.answers.put(readerName, null);
                                        Module.this.errorType.put(readerName, null);
                                        FileUtils.writeTextToFile(absolutePath, bean.getPayload().toString(), "UTF-8");
                                        lock.wait(20000L);
                                    }
                                    if (Module.this.answers.get(readerName) == null) {
                                        String filename = (String)Module.this.waitForAnswer.get(readerName);
                                        String errMess = "No response from driver (stopped?) , for file : " + filename + " !! Moving to timeout dir ";
                                        Logger.logError((Object)(this + " " + readerName), errMess);
                                        CallBackInterface callBackInterface2 = bean.getCallBackInterface();
                                        callBackInterface2.showErrorMessage(errMess);
                                        String moveToPath = timeoutFile.getAbsolutePath() + File.separator + filename;
                                        File initialFile = new File(toProcessPath + File.separator + filename);
                                        movedOk = initialFile.renameTo(new File(moveToPath));
                                        if (!movedOk) {
                                            Logger.logError((Object)(this + " " + readerName), "Could not move " + initialFile.getAbsolutePath() + " to " + moveToPath);
                                            deleteOk = initialFile.delete();
                                            if (!deleteOk) {
                                                Logger.logError((Object)(this + " " + readerName), "Could not delete " + initialFile.getAbsolutePath() + " FIX THIS AND RESTART APP. NOW QUITING !!");
                                                Utils.systemExit();
                                            }
                                        }
                                    } else if (((Boolean)Module.this.answers.get(readerName)).booleanValue()) {
                                        callBackInterface = bean.getCallBackInterface();
                                        callBackInterface.showErrorMessage(null);
                                    } else {
                                        callBackInterface = bean.getCallBackInterface();
                                        callBackInterface.showErrorMessage((String)Module.this.errorType.get(readerName));
                                    }
                                    outQueueCurrentReader.remove(0);
                                }
                                try {
                                    Thread.sleep(100L);
                                    continue block7;
                                }
                                catch (InterruptedException interruptedException) {
                                    continue;
                                }
                                break;
                            }
                        }
                        catch (Throwable th) {
                            Logger.logError((Object)this, th);
                            continue;
                        }
                        break;
                    }
                }
            };
            String mainThreadName = this.getModuleName() + "_" + readerName + "_" + this.hashCode();
            thread.setName(mainThreadName);
            thread.start();
            Thread waitForResponseThread = new Thread(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    while (true) {
                        String waitForAnswerFile;
                        Object v;
                        Object lock;
                        File[] items;
                        for (File item : items = okFile.listFiles()) {
                            if (!item.isFile()) continue;
                            v = lock = Module.this.locks.get(readerName);
                            synchronized (v) {
                                waitForAnswerFile = (String)Module.this.waitForAnswer.get(readerName);
                                if (item.getName().equalsIgnoreCase(waitForAnswerFile)) {
                                    Logger.logDebug(this + " " + readerName, "Command file processed ok : " + (String)Module.this.waitForAnswer.get(readerName) + " !!");
                                    Module.this.answers.put(readerName, true);
                                    item.delete();
                                    lock.notify();
                                }
                            }
                        }
                        for (File item : items = errFile.listFiles()) {
                            if (!item.isFile()) continue;
                            v = lock = Module.this.locks.get(readerName);
                            synchronized (v) {
                                waitForAnswerFile = (String)Module.this.waitForAnswer.get(readerName);
                                if (item.getName().equalsIgnoreCase(waitForAnswerFile)) {
                                    Logger.logDebug(this + " " + readerName, "Command file FAILED : " + (String)Module.this.waitForAnswer.get(readerName) + " !!");
                                    String content = null;
                                    try {
                                        content = FileUtils.readFileToString(errPath + File.separator + waitForAnswerFile);
                                    }
                                    catch (IOException e) {
                                        Logger.logError((Object)(this + " " + readerName), e);
                                    }
                                    Module.this.errorType.put(readerName, content);
                                    Module.this.answers.put(readerName, false);
                                    item.delete();
                                    lock.notify();
                                }
                            }
                        }
                        try {
                            Thread.sleep(200L);
                        }
                        catch (InterruptedException interruptedException) {
                        }
                    }
                }
            };
            waitForResponseThread.setName("Response : " + mainThreadName);
            waitForResponseThread.start();
            ContracteLogic.getInstance().addExternalDeviceListener(new ExternalDeviceListener(){

                @Override
                public boolean syncAuth(Map<String, String> values) {
                    AccesRequestToReaderBean usersSync = Module.this.addAuthCommand(values);
                    ((Vector)Module.this.outQueue.get(readerName)).add(usersSync);
                    return true;
                }

                @Override
                public boolean syncUsers(Map<String, ExternalReaderBean> users) {
                    AccesRequestToReaderBean usersSync = Module.this.addSetUserAccessCommand(users);
                    ((Vector)Module.this.outQueue.get(readerName)).add(usersSync);
                    return true;
                }

                @Override
                public boolean syncTimezones(Map<String, String> values) {
                    AccesRequestToReaderBean usersSync = Module.this.addTimezoneCommand(values);
                    ((Vector)Module.this.outQueue.get(readerName)).add(usersSync);
                    return true;
                }
            });
        }
    }

    private AccesRequestToReaderBean addSetUserAccessCommand(Map<String, ExternalReaderBean> users) {
        String template = "Pin={0}\tCardNo={1}\tPassword={2}\tStartTime={3};\tEndTime={4};";
        AccesRequestToReaderBean toReaderBean = new AccesRequestToReaderBean();
        String payload = "";
        for (String pin : users.keySet()) {
            ExternalReaderBean bean = users.get(pin);
            Date start = bean.getStart();
            Date stop = bean.getStop();
            String card = bean.getCard();
            String cardShort = Utils.stripLeadingChar(card, '0');
            Object[] values = new String[]{pin, cardShort, "1234", Formatters.ACCESS_CONTROL_LOGIC_FORMAT.format(start), Formatters.ACCESS_CONTROL_LOGIC_FORMAT.format(stop)};
            String line = MessageFormat.format(template, values);
            payload = payload + line + "\r\n";
        }
        toReaderBean.setCommand("SET_USERS");
        toReaderBean.setPayload(payload);
        return toReaderBean;
    }

    private AccesRequestToReaderBean addAuthCommand(Map<String, String> values) {
        String template = "Pin={0}\tAuthorizeTimezoneId={1}\tAuthorizeDoorId={2}";
        String payload = "";
        for (String pin : values.keySet()) {
            String timezoneId = values.get(pin);
            Object[] lineV = new String[]{pin, timezoneId, "1"};
            String line = MessageFormat.format(template, lineV);
            payload = payload + line + "\r\n";
        }
        AccesRequestToReaderBean toReaderBean = new AccesRequestToReaderBean();
        toReaderBean.setCommand("SET_AUTH");
        toReaderBean.setPayload(payload);
        return toReaderBean;
    }

    private AccesRequestToReaderBean addTimezoneCommand(Map<String, String> values) {
        String payload = "";
        for (String idExternTimezone : values.keySet()) {
            String orarDef = values.get(idExternTimezone);
            String content = AdvancedControlUtils.getFullOrarForCentrala(idExternTimezone, orarDef);
            payload = payload + content + "\r\n";
        }
        AccesRequestToReaderBean timezones = new AccesRequestToReaderBean();
        timezones.setCommand("SET_TIMEZONE");
        timezones.setPayload(payload);
        return timezones;
    }

    private boolean processRTLOG(File file, String readerName) {
        try {
            String line;
            Logger.logDebug(this, "Processing RTLOG file : " + file.getAbsolutePath());
            LineNumberReader reader = new LineNumberReader(new FileReader(file));
            while ((line = reader.readLine()) != null) {
                if (!Validators.correctString(line.trim())) continue;
                Logger.logDebug(this, "Processing line : " + line);
                try {
                    Vector items = Utils.splitString(line, ',');
                    String card = (String)items.get(2);
                    String userId = (String)items.get(1);
                    String data = (String)items.get(0);
                    String eventCode = (String)items.get(4);
                    String modAcces = (String)items.get(6);
                    Date eventDate = Formatters.DATE_AND_TIME_AND_SECONDS_HUMAN_FORMAT.parse(data);
                    if (!modAcces.equalsIgnoreCase("4")) continue;
                    String cardFull = Utils.getStringMaxSize(10, card, Character.valueOf('0'), true);
                    InReader reader1 = this.readersHash.get(readerName);
                    reader1.getResponse(cardFull, eventDate);
                }
                catch (Exception e) {
                    Logger.logException(this, e);
                }
            }
            Logger.logDebug(this, "Finished Processing RTLOG file : " + file.getAbsolutePath());
        }
        catch (IOException e) {
            Logger.logException(this, (Exception)e);
        }
        return true;
    }
}

