/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.restaurant.modules.accesmonitor;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.IOException;
import java.util.Date;
import java.util.Vector;
import javax.swing.JLabel;
import ro.atreides.acces.contracte.ContracteLogic;
import ro.atreides.acces.contracte.TipContract;
import ro.atreides.acces.soyal.rules.InReader;
import ro.atreides.utils.Logger;
import ro.atreides.utils.ReflectedJPanel;
import ro.atreides.utils.config.Config;

public class AccesMonitorPanel
extends ReflectedJPanel {
    private String codAutentificare = "";
    private long lastCharRead = System.currentTimeMillis();
    private static final long cardReadTimeout = 3000L;
    private InReader readerInterface = new InReader("AccesMonitor", false);
    public static String monitorAlertCommand;

    public AccesMonitorPanel() {
        Vector<TipContract> contracte = ContracteLogic.getInstance().getTipuriContract();
        Vector<String> tipAb = new Vector<String>();
        for (TipContract tipContract : contracte) {
            tipAb.add(tipContract.getNume());
        }
        this.readerInterface.setTipAbonamente(tipAb);
    }

    private void display() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 10;
        c.insets = new Insets(10, 10, 10, 10);
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.gridx = 0;
        c.gridy = 0;
        c.fill = 2;
        c.anchor = 11;
        c.weighty = 1.0;
        ++c.gridy;
        c.fill = 1;
        JLabel focusEater = new JLabel("");
        focusEater.setFocusable(true);
        focusEater.addKeyListener(new KeyListener(){

            @Override
            public void keyPressed(KeyEvent e) {
            }

            @Override
            public void keyReleased(KeyEvent e) {
            }

            @Override
            public void keyTyped(KeyEvent e) {
                if (AccesMonitorPanel.this.lastCharRead + 3000L < System.currentTimeMillis()) {
                    AccesMonitorPanel.this.codAutentificare = "";
                }
                if (e.getKeyChar() == '\n') {
                    System.out.println("am prins un \\n");
                } else {
                    AccesMonitorPanel.this.codAutentificare = AccesMonitorPanel.this.codAutentificare + String.valueOf(e.getKeyChar());
                    AccesMonitorPanel.this.lastCharRead = System.currentTimeMillis();
                    if (AccesMonitorPanel.this.codAutentificare.length() == Config.getInstance().getInt("codFidelitateLength")) {
                        String card = AccesMonitorPanel.this.codAutentificare;
                        AccesMonitorPanel.this.cardRead(card);
                        AccesMonitorPanel.this.codAutentificare = "";
                    }
                }
            }
        });
        this.add((Component)focusEater, c);
        focusEater.requestFocus();
    }

    private void cardRead(String card) {
        boolean response = this.readerInterface.getResponse(card, new Date());
        if (!response) {
            try {
                if (monitorAlertCommand != null) {
                    Runtime.getRuntime().exec(monitorAlertCommand);
                }
            }
            catch (IOException e) {
                Logger.logException(this, (Exception)e);
            }
        }
    }

    @Override
    public void doStuff() {
        this.display();
    }
}

