/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.restaurant.modules.afisajclient.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Vector;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;
import ro.atreides.restaurant.base.Sale;
import ro.atreides.restaurant.logic.RestLogic;
import ro.atreides.restaurant.modules.afisajclient.AfisajClientBean;
import ro.atreides.utils.Utils;
import ro.atreides.utils.gui.Validators;
import ro.atreides.utils.gui.table.AbstractListPanel;
import ro.atreides.utils.gui.table.AbstractTM;
import ro.atreides.utils.gui.table.TmInterface;
import ro.atreides.utils.multilang.LangRoAll;

public class AfisajClientPanel
extends AbstractListPanel {
    private JLabel totalLabel;
    private JLabel platiLabel;
    private JLabel restLabel;
    private int tableFontSize = 30;
    private int totalFontSize = 40;

    public AfisajClientPanel() {
        new Thread(){

            @Override
            public void run() {
                while (true) {
                    try {
                        Thread.sleep(2000L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    AfisajClientPanel.this.refreshTable();
                }
            }
        }.start();
    }

    @Override
    public String[] buildColumns() {
        return new String[]{LangRoAll.produs, LangRoAll.cantitate, LangRoAll.valoare};
    }

    @Override
    public Vector buildData() {
        AfisajClientBean acb = RestLogic.getInstance().getAfisajClientInfos();
        if (this.totalLabel != null) {
            this.totalLabel.setText(Utils.getString2Decimals(acb.getTotal()));
            this.platiLabel.setText(acb.getPlatiString());
            this.restLabel.setText(Utils.getString2Decimals(acb.getRestdeplata()));
        }
        return acb.getSales();
    }

    @Override
    public AbstractTM buildTableModel() {
        this.tm = new AbstractTM(this.buildColumns(), this.buildTypes(), new TmInterface(){

            @Override
            public Object getValueAt(int rowIndex, int columnIndex, Vector data) {
                if (data == null) {
                    return null;
                }
                Sale o = (Sale)data.elementAt(rowIndex);
                switch (columnIndex) {
                    case 0: {
                        String s = o.getProductName();
                        String mp = o.getModPreparare();
                        if (Validators.correctString(mp)) {
                            s = s + " (" + mp + ")";
                        }
                        return s;
                    }
                    case 1: {
                        return o.getQuantity();
                    }
                    case 2: {
                        return Utils.getString2Decimals(o.getTotal());
                    }
                }
                return null;
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return false;
            }

            @Override
            public void setValueAt(Object aValue, int rowIndex, int columnIndex, Vector data) {
            }
        });
        return this.tm;
    }

    @Override
    public Class[] buildTypes() {
        return Utils.getStringClass(this.buildColumns().length);
    }

    @Override
    public JPanel getBottomPanel() {
        JPanel result = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 10;
        c.fill = 0;
        c.weighty = 1.0;
        c.gridheight = 1;
        c.gridwidth = 1;
        c.insets = new Insets(2, 2, 2, 2);
        c.gridy = 0;
        c.weightx = 0.0;
        c.gridx = 0;
        c.anchor = 17;
        JLabel l2 = new JLabel("Platit ");
        l2.setFont(new Font(null, 0, this.tableFontSize));
        result.add((Component)l2, c);
        ++c.gridx;
        c.anchor = 17;
        c.gridwidth = 4;
        this.platiLabel = new JLabel("");
        this.platiLabel.setFont(new Font(null, 0, this.tableFontSize));
        result.add((Component)this.platiLabel, c);
        ++c.gridy;
        c.gridx = 0;
        c.gridwidth = 1;
        c.anchor = 17;
        JLabel l1 = new JLabel(LangRoAll.total);
        l1.setFont(new Font(null, 0, this.totalFontSize));
        l1.setForeground(Color.RED);
        result.add((Component)l1, c);
        ++c.gridx;
        c.anchor = 17;
        this.totalLabel = new JLabel("");
        this.totalLabel.setFont(new Font(null, 0, this.totalFontSize));
        this.totalLabel.setForeground(Color.RED);
        result.add((Component)this.totalLabel, c);
        ++c.gridx;
        c.weightx = 1.0;
        c.fill = 2;
        result.add((Component)new JLabel(""), c);
        c.weightx = 0.0;
        c.fill = 0;
        ++c.gridx;
        c.anchor = 13;
        JLabel l3 = new JLabel("Rest ");
        l3.setFont(new Font(null, 0, this.totalFontSize));
        l3.setForeground(Color.RED);
        result.add((Component)l3, c);
        ++c.gridx;
        c.anchor = 13;
        this.restLabel = new JLabel("");
        this.restLabel.setFont(new Font(null, 0, this.totalFontSize));
        this.restLabel.setForeground(Color.RED);
        result.add((Component)this.restLabel, c);
        result.setBorder(new TitledBorder(LangRoAll.total));
        return result;
    }

    @Override
    public void doStuff() {
        this.display();
        this.table.setRowHeight(this.tableFontSize);
        this.table.setFont(new Font(null, 0, this.tableFontSize));
    }

    @Override
    public void refreshTable() {
        super.refreshTable();
        this.table.changeSelection(this.table.getRowCount() - 1, 0, false, false);
    }
}

