/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.restaurant.modules.afisajclientxml;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import javax.servlet.ServletException;
import javax.servlet.SingleThreadModel;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import ro.atreides.restaurant.base.Sale;
import ro.atreides.restaurant.logic.RestLogic;
import ro.atreides.restaurant.modules.afisajclient.AfisajClientBean;
import ro.atreides.utils.TextUtils;
import ro.atreides.utils.Utils;
import ro.atreides.utils.plati.Plata;

public class AfisajClientXmlServlet
extends HttpServlet
implements SingleThreadModel {
    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.doGet(req, resp);
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        PrintWriter out = null;
        try {
            out = new PrintWriter(new OutputStreamWriter((OutputStream)response.getOutputStream()));
        }
        catch (IllegalStateException e) {
            out = response.getWriter();
        }
        AfisajClientBean acb = RestLogic.getInstance().getAfisajClientInfos();
        if (!acb.isNull()) {
            String result = this.buildString(acb);
            this.sendResponse(result, out);
        }
    }

    private String buildString(AfisajClientBean acb) {
        StringBuffer sb = new StringBuffer();
        sb.append("<sales>\n");
        for (Sale sale : acb.getSales()) {
            sb.append("<sale name=\"" + TextUtils.escapeForXML(sale.getProductName()) + "\"" + " qty=\"" + sale.getCantitateMarcata() + "\"" + " originalPrice=\"" + sale.getPpuOriginal() + "\"" + " discountprice=\"" + sale.getPrice() + "\"/>\n");
        }
        sb.append("<customer name=\"" + TextUtils.escapeForXML(acb.getCustomerName()) + "\"" + " discountLevel=\"" + TextUtils.escapeForXML(acb.getPromotion()) + "\"" + " accountValues=\"" + TextUtils.escapeForXML(acb.getConturi()) + "\"/>\n");
        for (Plata plata : acb.getPlati()) {
            sb.append("<payment name=\"" + TextUtils.escapeForXML(plata.getTipPlata()) + "\" value=\"" + Utils.getString2Decimals(plata.getSuma()) + "\"/>\n");
        }
        double rest = acb.getRestdeplata();
        sb.append("<rest value=\"" + Utils.getString2Decimals(rest) + "\"/>\n");
        sb.append("</sales>");
        return sb.toString();
    }

    private void sendResponse(String s, PrintWriter out) {
        out.write(s);
        out.flush();
    }
}

