/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.restaurant.modules.bonrepair;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.LineNumberReader;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.ParseException;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Hashtable;
import java.util.Vector;
import ro.atreides.nomenclatura.NomeclaturaLogic;
import ro.atreides.nomenclatura.Product;
import ro.atreides.restaurant.base.PrintSaleInterface;
import ro.atreides.restaurant.base.Sale;
import ro.atreides.restaurant.logic.RestLogic;
import ro.atreides.restaurant.modules.bonrepair.BonFileEntry;
import ro.atreides.restaurant.modules.bonrepair.BonFromDisk;
import ro.atreides.restaurant.modules.bonrepair.BonFromDiskPlata;
import ro.atreides.restaurant.modules.bonrepair.BonFromDiskSale;
import ro.atreides.utils.Constants;
import ro.atreides.utils.DateUtils;
import ro.atreides.utils.FileUtils;
import ro.atreides.utils.Formatters;
import ro.atreides.utils.IncasareClientView;
import ro.atreides.utils.Logger;
import ro.atreides.utils.ModuleInstantiationException;
import ro.atreides.utils.Utils;
import ro.atreides.utils.db.ConnectionPool;
import ro.atreides.utils.events.EventsLogic;
import ro.atreides.utils.gui.Validators;

@Deprecated
public class Module
implements ro.atreides.utils.Module {
    @Override
    public Collection getViews() {
        return null;
    }

    @Override
    public String getModuleName() {
        return "bonrepair";
    }

    @Override
    public void init(String[] cmdArgs, Hashtable runtimeObjects) throws ModuleInstantiationException {
        final String bonuriDir = Utils.getCmdlineValue("-repairdirbonuri", cmdArgs, "bonuri");
        final String zStart = Utils.getCmdlineValue("-repairzstart", cmdArgs);
        final String zStop = Utils.getCmdlineValue("-repairzstop", cmdArgs);
        Runnable th = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                if (!Validators.correctInteger(zStart)) {
                    return;
                }
                final int startZ = Integer.parseInt(zStart);
                if (!Validators.correctInteger(zStop)) {
                    return;
                }
                final int stopZ = Integer.parseInt(zStop);
                Vector<Integer> ids = new Vector<Integer>();
                try {
                    final Vector bonuri = new Vector();
                    final Hashtable inchidereCasa = new Hashtable();
                    final Hashtable deschidereCasa = new Hashtable();
                    File f = new File(FileUtils.getCurrentDir() + File.separator + bonuriDir);
                    f.list(new FilenameFilter(){

                        @Override
                        public boolean accept(File dir, String name) {
                            File f1 = new File(dir, name);
                            if (f1.isDirectory()) {
                                return false;
                            }
                            int index = name.indexOf("__");
                            if (index > 0) {
                                String d = name.substring(0, index);
                                try {
                                    Date date = Formatters.currentDateAndTimeForFileSystem.parse(d);
                                    int punct = name.indexOf(".");
                                    String rest = name.substring(index + 2, punct);
                                    Vector v = Utils.splitString(rest, '_');
                                    String nrZs = (String)v.get(0);
                                    String nrBons = (String)v.get(1);
                                    if (Validators.correctInteger(nrZs) && Validators.correctInteger(nrBons)) {
                                        Date closeZ;
                                        int nrZ = Integer.parseInt(nrZs);
                                        int nrBon = Integer.parseInt(nrBons);
                                        if (nrZ < startZ || nrZ > stopZ) {
                                            return false;
                                        }
                                        BonFileEntry bfe = new BonFileEntry(f1.getAbsolutePath(), date, nrZ, nrBon);
                                        bonuri.add(bfe);
                                        Date openZ = (Date)deschidereCasa.get(nrZ);
                                        if (openZ != null) {
                                            if (openZ.after(bfe.getDate())) {
                                                deschidereCasa.put(nrZ, bfe.getDate());
                                            }
                                        } else {
                                            deschidereCasa.put(nrZ, bfe.getDate());
                                        }
                                        if ((closeZ = (Date)inchidereCasa.get(nrZ)) != null) {
                                            if (closeZ.before(bfe.getDate())) {
                                                inchidereCasa.put(nrZ, bfe.getDate());
                                            }
                                        } else {
                                            inchidereCasa.put(nrZ, bfe.getDate());
                                        }
                                        return true;
                                    }
                                    return false;
                                }
                                catch (ParseException e) {
                                    return false;
                                }
                            }
                            return false;
                        }
                    });
                    Collections.sort(bonuri, new Comparator(){

                        public int compare(Object o1, Object o2) {
                            BonFileEntry b1 = (BonFileEntry)o1;
                            BonFileEntry b2 = (BonFileEntry)o2;
                            return b1.getDate().compareTo(b2.getDate());
                        }
                    });
                    for (BonFileEntry bonFileEntry : bonuri) {
                        Date stop = bonFileEntry.getDate();
                        Date start = (Date)deschidereCasa.get(bonFileEntry.getNrZ());
                        start = EventsLogic.getInstance().getStartForDayNoCommit(new Timestamp(start.getTime()), 1);
                        stop = DateUtils.addMinutesToDate(stop, 1);
                        Hashtable<String, Date> criteria = new Hashtable<String, Date>();
                        criteria.put(Constants.START_KEY, start);
                        criteria.put(Constants.STOP_KEY, stop);
                        Vector<IncasareClientView> noteInPerioada = RestLogic.getInstance().getIncasariClientiNoCommit(criteria, 3);
                        if (noteInPerioada.size() == 0) continue;
                        Collections.sort(noteInPerioada, new Comparator(){

                            public int compare(Object o1, Object o2) {
                                IncasareClientView i1 = (IncasareClientView)o1;
                                IncasareClientView i2 = (IncasareClientView)o2;
                                return i1.getData().compareToIgnoreCase(i2.getData());
                            }
                        });
                        String path = bonFileEntry.getFullPath();
                        BonFromDisk b = Module.this.readBonFromFile(path);
                        boolean found = false;
                        int idOrder = 0;
                        for (IncasareClientView incasareClientView : noteInPerioada) {
                            idOrder = incasareClientView.getIdOrder();
                            Vector<Sale> sales = RestLogic.getInstance().getSalesNoCommitNoSort(idOrder, true, -1, new PrintSaleInterface(), -1);
                            double total = RestLogic.computeTotalForSales(sales);
                            if (b.getTotal() != total) continue;
                            Vector<BonFromDiskSale> bsales = b.getSales();
                            boolean ok1 = true;
                            if (bsales.size() != sales.size()) {
                                ok1 = false;
                            }
                            if (ok1) {
                                for (BonFromDiskSale bsale : bsales) {
                                    String casaName = bsale.getProdus();
                                    boolean ok2 = false;
                                    for (Sale sale : sales) {
                                        int idProduct = sale.getIdProduct();
                                        Product p = NomeclaturaLogic.getInstance().getProductByIdNoCommit(idProduct);
                                        String numeCasa = p.getNumeCasa();
                                        if ((numeCasa = numeCasa.toUpperCase()).startsWith(casaName)) {
                                            ok2 = true;
                                            break;
                                        }
                                        if (sale.getPrice() != bsale.getPret() || sale.getCantitateMarcata() != bsale.getCantitate()) continue;
                                        ok2 = true;
                                        break;
                                    }
                                    if (ok2) continue;
                                    ok1 = false;
                                    break;
                                }
                            }
                            if (!ok1) continue;
                            found = true;
                        }
                        if (found) {
                            ids.add(idOrder);
                            continue;
                        }
                        System.out.println("NEGASIT=" + bonFileEntry.getFullPath());
                    }
                    String result = Utils.getSqlInSequence(ids);
                    System.out.println("");
                    System.out.println("result : \"" + result + "\"");
                    System.out.println("");
                    System.out.println("Bonuri : " + bonuri.size() + " gasite : " + ids.size() + " negasite : " + (bonuri.size() - ids.size()));
                    ConnectionPool.getInstance().commit();
                }
                catch (SQLException e) {
                    Logger.logException(this, (Exception)e);
                    try {
                        ConnectionPool.getInstance().rollBack();
                    }
                    catch (SQLException e1) {
                        Logger.logException(this, (Exception)e1);
                    }
                }
                finally {
                    ConnectionPool.getInstance().releaseConnection();
                }
            }
        };
        Thread t = new Thread(th);
        t.setName(this.getModuleName());
        t.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BonFromDisk readBonFromFile(String path) {
        BonFromDisk b = new BonFromDisk();
        FileReader f = null;
        BufferedReader reader = null;
        try {
            f = new FileReader(path);
            reader = new LineNumberReader(f);
            String line = ((LineNumberReader)reader).readLine();
            line = ((LineNumberReader)reader).readLine();
            boolean stop = false;
            double total = 0.0;
            while (!stop) {
                if (line != null) {
                    line = line.trim();
                }
                if (Validators.correctString(line)) {
                    Vector tokens;
                    if (line.startsWith("S,")) {
                        tokens = Utils.splitString(line, ';');
                        String produs = (String)tokens.get(1);
                        String priceS = (String)tokens.get(2);
                        String qS = (String)tokens.get(3);
                        double p = Utils.parseDouble(priceS);
                        double q = Utils.parseDouble(qS);
                        BonFromDiskSale s = new BonFromDiskSale(produs, q, p);
                        total += p * q;
                        b.addSale(s);
                    }
                    if (line.startsWith("T,")) {
                        tokens = Utils.splitString(line, ';');
                        String cod = (String)tokens.get(1);
                        String valS = (String)tokens.get(2);
                        double v = Utils.parseDouble(valS);
                        BonFromDiskPlata p = new BonFromDiskPlata(v, cod);
                        b.addPlata(p);
                    }
                    line = ((LineNumberReader)reader).readLine();
                    continue;
                }
                stop = true;
            }
            b.setTotal(total);
            BonFromDisk bonFromDisk = b;
            return bonFromDisk;
        }
        catch (IOException e) {
            Logger.logException(this, (Exception)e);
            BonFromDisk bonFromDisk = null;
            return bonFromDisk;
        }
        finally {
            try {
                reader.close();
            }
            catch (IOException e) {}
            try {
                f.close();
            }
            catch (IOException e) {}
        }
    }
}

