/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.restaurant.modules.counterclienti.gui;

import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.sql.Timestamp;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;
import ro.atreides.acces.contracte.ContracteLogic;
import ro.atreides.acces.contracte.StatusContractView;
import ro.atreides.clienti.ClientLogic;
import ro.atreides.clienti.ClientPersFizica;
import ro.atreides.clienti.ClientPersJuridica;
import ro.atreides.pontaj.PontajLogic;
import ro.atreides.pontaj.gui.CardNeprogramatSelectDialog;
import ro.atreides.restaurant.gui.GuiUtilsRest;
import ro.atreides.restaurant.logic.RestLogic;
import ro.atreides.utils.Client;
import ro.atreides.utils.Formatters;
import ro.atreides.utils.Logger;
import ro.atreides.utils.ReflectedJPanel;
import ro.atreides.utils.Utils;
import ro.atreides.utils.config.Config;
import ro.atreides.utils.gui.GuiUtils;
import ro.atreides.utils.gui.dialogs.DialogUtils;
import ro.atreides.utils.gui.dialogs.FileDialog;
import ro.atreides.utils.multilang.LangRoAll;

public class CounterPanel
extends ReflectedJPanel {
    private JButton incarcaClienti;
    private JButton logout;
    private JButton admin;
    private String codAutentificare = "";
    private boolean codStarted = false;
    private JLabel nume;
    private JLabel departament;
    private JLabel last;
    private JLabel numeL;
    private JLabel departamentL;
    private JLabel lastL;
    private static final int FONT_SIZE = 30;

    private void display() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 10;
        c.insets = new Insets(10, 10, 10, 10);
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.gridx = 0;
        c.gridy = 0;
        c.fill = 2;
        c.anchor = 11;
        this.add((Component)this.getButtonPanel(), c);
        ++c.gridy;
        this.add((Component)this.getLeftPanel(), c);
        String stopDelimiters = Config.getInstance().getString("cardStopDelimiters");
        final Vector stopDelim = Utils.splitString(stopDelimiters, ',');
        String startDelimiters = Config.getInstance().getString("cardStartDelimiters");
        final Vector startDelim = Utils.splitString(startDelimiters, ',');
        c.weighty = 1.0;
        ++c.gridy;
        c.fill = 1;
        JLabel focusEater = new JLabel("");
        focusEater.addKeyListener(new KeyListener(){

            @Override
            public void keyPressed(KeyEvent e) {
            }

            @Override
            public void keyReleased(KeyEvent e) {
                char c = e.getKeyChar();
                System.out.println("char: " + c + " code : " + e.getKeyCode());
                if (!CounterPanel.this.codStarted) {
                    for (int i = 0; i < startDelim.size(); ++i) {
                        String s = (String)startDelim.elementAt(i);
                        if (c != s.charAt(0)) continue;
                        CounterPanel.this.codStarted = true;
                        CounterPanel.this.codAutentificare = c + "";
                        return;
                    }
                    return;
                }
                CounterPanel.this.codAutentificare = CounterPanel.this.codAutentificare + String.valueOf(c);
                Logger.logDebugVerbose(this, "Key : \"" + c + "\"");
                boolean stopFound = false;
                for (int i = 0; i < stopDelim.size() && !stopFound; ++i) {
                    String s = (String)stopDelim.elementAt(i);
                    if (c != s.charAt(0)) continue;
                    stopFound = true;
                }
                if (stopFound || CounterPanel.this.codAutentificare.length() >= 10) {
                    Logger.logDebugVerbose(this, "Am citit : \"" + CounterPanel.this.codAutentificare + "\"");
                    System.out.println("Am citit : \"" + CounterPanel.this.codAutentificare + "\"");
                    CounterPanel.this.codStarted = false;
                    CounterPanel.this.cardRead(CounterPanel.this.codAutentificare);
                }
            }

            @Override
            public void keyTyped(KeyEvent e) {
            }
        });
        focusEater.setFocusable(true);
        this.add((Component)focusEater, c);
        focusEater.requestFocus();
    }

    private void cardRead(String card) {
        CounterPanel parent = this;
        Vector<StatusContractView> contracte = ContracteLogic.getInstance().getStatusContracteByCard(card);
        if (contracte.size() > 0) {
            StatusContractView scv = contracte.elementAt(0);
            Client c = ClientLogic.getInstance().getClientById(scv.getIdClient());
            this.nume.setText(c.toString());
            Timestamp l = PontajLogic.getInstance().getLastClientCheckIn(c.getId());
            if (l != null) {
                String d = Formatters.DATE_AND_TIME_FORMAT.format(l);
                this.last.setText(d);
            } else {
                this.last.setText("");
            }
            PontajLogic.getInstance().punchClientIn(c.getId(), scv.getId(), "", true);
            ClientPersFizica cpf = (ClientPersFizica)c;
            int idDep = cpf.getIdPersJuridica();
            if (idDep != -1) {
                ClientPersJuridica cpj = ClientLogic.getInstance().getPersJuridicaById(idDep);
                this.departament.setText(cpj.toString());
            }
        } else {
            CardNeprogramatSelectDialog dia = new CardNeprogramatSelectDialog(GuiUtils.currentFrame);
            int sel = dia.getSelected();
            Client c = dia.getSelectedClient();
            if (sel != -1) {
                boolean ok = DialogUtils.confirmDialog(parent, "Programam cardul " + this.codAutentificare + " pentru clientul " + c.toString(), LangRoAll.confirmare);
                if (ok) {
                    ContracteLogic.getInstance().addContract(c.getId(), 1, -1, this.codAutentificare, "", false, -1);
                    DialogUtils.okDialog(parent, "Card programat. Introduceti cardul din nou.", LangRoAll.succes);
                } else {
                    DialogUtils.okDialog(parent, "Operatie anulata de utilizator.", "Operatie anulata");
                }
            } else {
                DialogUtils.errorDialog(parent, "Nu s-a ales clientul", "Operatie anulata");
            }
        }
    }

    private JPanel getLeftPanel() {
        JPanel leftPanel = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 2;
        c.anchor = 17;
        c.insets = new Insets(2, 2, 2, 2);
        c.weightx = 0.0;
        c.weighty = 0.2;
        c.gridheight = 1;
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 0.1;
        this.numeL = new JLabel("Nume");
        this.numeL.setFont(new Font(null, 0, 30));
        leftPanel.add((Component)this.numeL, c);
        ++c.gridx;
        c.weightx = 0.9;
        this.nume = new JLabel("");
        this.nume.setFont(new Font(null, 0, 30));
        leftPanel.add((Component)this.nume, c);
        ++c.gridy;
        c.gridx = 0;
        c.weightx = 0.1;
        this.departamentL = new JLabel("Departament");
        this.departamentL.setFont(new Font(null, 0, 30));
        leftPanel.add((Component)this.departamentL, c);
        ++c.gridx;
        c.weightx = 0.9;
        this.departament = new JLabel("");
        this.departament.setFont(new Font(null, 0, 30));
        leftPanel.add((Component)this.departament, c);
        ++c.gridy;
        c.gridx = 0;
        c.weightx = 0.1;
        this.lastL = new JLabel("Ultima intrare");
        this.lastL.setFont(new Font(null, 0, 30));
        leftPanel.add((Component)this.lastL, c);
        ++c.gridx;
        c.weightx = 0.9;
        this.last = new JLabel("");
        this.last.setFont(new Font(null, 0, 30));
        leftPanel.add((Component)this.last, c);
        leftPanel.setBorder(new TitledBorder("Informatii"));
        return leftPanel;
    }

    private JPanel getButtonPanel() {
        JPanel result = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 0;
        c.anchor = 10;
        c.insets = new Insets(2, 2, 2, 2);
        c.weightx = 1.0;
        c.weighty = 0.2;
        c.gridheight = 1;
        c.gridx = 0;
        c.gridy = 0;
        this.logout = new JButton(LangRoAll.logout);
        result.add((Component)this.logout, c);
        final CounterPanel parent = this;
        ++c.gridx;
        this.incarcaClienti = new JButton("Incarca clienti din excel");
        this.incarcaClienti.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                String inputFile = FileDialog.getLoadDialogLocation(parent, "Selectati fisierul de importat", "xls");
                if (inputFile != null) {
                    ClientLogic.getInstance().incarcaClientiDinExcel(inputFile);
                }
            }
        });
        result.add((Component)this.incarcaClienti, c);
        ++c.gridx;
        this.admin = new JButton(LangRoAll.administrare);
        this.admin.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                GuiUtilsRest.doAdminLogin(RestLogic.getInstance());
            }
        });
        result.add((Component)this.admin, c);
        this.admin.setFocusable(false);
        this.logout.setFocusable(false);
        this.incarcaClienti.setFocusable(false);
        result.setBorder(new TitledBorder(LangRoAll.actiuni));
        return result;
    }

    @Override
    public void doStuff() {
        this.display();
    }
}

