/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.restaurant.modules.datasync;

import java.util.Collection;
import java.util.Hashtable;
import ro.atreides.restaurant.VpConfig;
import ro.atreides.restaurant.logic.DataSyncServerLogic;
import ro.atreides.restaurant.logic.exports.DataSyncChannel;
import ro.atreides.restaurant.logic.exports.DataSyncClientLogic;
import ro.atreides.restaurant.logic.exports.DataSyncGsonClient;
import ro.atreides.utils.ModuleInstantiationException;
import ro.atreides.utils.Utils;
import ro.atreides.utils.gui.GuiUtils;
import ro.atreides.utils.gui.Validators;
import ro.atreides.utils.gui.dialogs.DialogUtils;
import ro.atreides.utils.multilang.LangRoAll;

public class Module
implements ro.atreides.utils.Module {
    @Override
    public String getModuleName() {
        return "DataSync";
    }

    @Override
    public Collection getViews() {
        return null;
    }

    @Override
    public void init(String[] args, Hashtable runtimeObjects) throws ModuleInstantiationException {
        String serverIp = Utils.getCmdlineValue("-datasyncserverip", args);
        String serverPortS = Utils.getCmdlineValue("-datasyncserverport", args);
        String channel = Utils.getCmdlineValue("-datasyncchannel", args);
        String fallBackLocation = Utils.getCmdlineValue("-datasynclocation", args, "");
        String fallBackUser = Utils.getCmdlineValue("-datasyncuser", args, "");
        if (!(Validators.correctString(serverIp) && Validators.correctInteger(serverPortS) && Validators.correctString(channel))) {
            throw new ExceptionInInitializerError("Cannot initialize module datasync. Channel missing !");
        }
        String codDb = VpConfig.getInstance().codUnicDatabase;
        if (codDb.equals("") || codDb.isEmpty()) {
            DialogUtils.errorDialog(GuiUtils.currentFrame, "codUnicDatabase nesetat, programul se inchide", LangRoAll.nuPotContinua);
            Utils.systemExit();
        }
        Hashtable<String, DataSyncChannel> channels = DataSyncClientLogic.buildChannels(channel);
        String channelName = "";
        if (channels.size() != 1) {
            DialogUtils.errorDialog(GuiUtils.currentFrame, "Configurare -datasynchannel incorecta, setati 1 (singur) canal !", LangRoAll.nuPotContinua);
            Utils.systemExit();
        } else {
            for (String key : channels.keySet()) {
                DataSyncChannel dataSyncChannel = channels.get(key);
                channelName = dataSyncChannel.getChannelName();
            }
        }
        DataSyncServerLogic.getFirstInstance(channels);
        DataSyncGsonClient.getFirstInstance("tcp://" + serverIp + ":" + serverPortS, "datasync_server", "datasync_client", null, channelName);
        DataSyncClientLogic clientLogic = DataSyncClientLogic.getFirstInstance(channels, fallBackLocation, fallBackUser);
    }
}

