/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.restaurant.modules.datasyncserver;

import java.util.Collection;
import java.util.Hashtable;
import ro.atreides.restaurant.VpConfig;
import ro.atreides.restaurant.logic.DataSyncServerLogic;
import ro.atreides.restaurant.logic.exports.DataSyncChannel;
import ro.atreides.restaurant.logic.exports.DataSyncClientLogic;
import ro.atreides.restaurant.logic.exports.DataSyncGsonServer;
import ro.atreides.utils.ModuleInstantiationException;
import ro.atreides.utils.Utils;
import ro.atreides.utils.gui.GuiUtils;
import ro.atreides.utils.gui.Validators;
import ro.atreides.utils.gui.dialogs.DialogUtils;
import ro.atreides.utils.multilang.LangRoAll;

public class Module
implements ro.atreides.utils.Module {
    @Override
    public String getModuleName() {
        return "DataSyncServer";
    }

    @Override
    public Collection getViews() {
        return null;
    }

    @Override
    public void init(String[] args, Hashtable runtimeObjects) throws ModuleInstantiationException {
        String isRouterS = Utils.getCmdlineValue("-isdatasyncrouter", args, "false");
        Boolean isRouter = Boolean.parseBoolean(isRouterS);
        VpConfig.isSyncRouter = isRouter;
        String serverPortS = Utils.getCmdlineValue("-datasyncserverport", args);
        String channelsS = Utils.getCmdlineValue("-datasyncserverchannels", args);
        Boolean printBonFiscal = Boolean.parseBoolean(Utils.getCmdlineValue("-datasyncprintbonfiscal", args, "false"));
        String fallBackLocation = Utils.getCmdlineValue("-datasynclocation", args, "");
        String fallBackUser = Utils.getCmdlineValue("-datasyncuser", args, "");
        if (!Validators.correctInteger(serverPortS) || !Validators.correctString(channelsS)) {
            throw new ExceptionInInitializerError("Cannot initialize module datasync. Channel missing !");
        }
        String codDb = VpConfig.getInstance().codUnicDatabase;
        if (codDb == null || codDb.equals("") || codDb.isEmpty()) {
            DialogUtils.errorDialog(GuiUtils.currentFrame, "codUnicDatabase nesetat, programul se inchide", LangRoAll.nuPotContinua);
            Utils.systemExit();
        }
        Hashtable<String, DataSyncChannel> channels = DataSyncClientLogic.buildChannels(channelsS);
        DataSyncServerLogic.getFirstInstance(channels).setPrintBonFiscal(printBonFiscal);
        DataSyncGsonServer.getFirstInstance("tcp://localhost:33336", "datasync_client", "datasync_server", Integer.parseInt(serverPortS));
        DataSyncClientLogic clientLogic = DataSyncClientLogic.getFirstInstance(channels, fallBackLocation, fallBackUser);
    }
}

