/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.restaurant.modules.datecsonline;

import java.sql.SQLException;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Vector;
import ro.atreides.ecronline.BonFiscal;
import ro.atreides.ecronline.EcrOnlineInterface;
import ro.atreides.ecronline.datecs.RandomAccessDatecsEcrOnline;
import ro.atreides.restaurant.VpConfig;
import ro.atreides.restaurant.base.Table;
import ro.atreides.restaurant.logic.RestLogic;
import ro.atreides.users.User;
import ro.atreides.utils.Location;
import ro.atreides.utils.Logger;
import ro.atreides.utils.ModuleInstantiationException;
import ro.atreides.utils.Utils;

public class Module
implements ro.atreides.utils.Module {
    private RestLogic logic = RestLogic.getInstance();

    @Override
    public String getModuleName() {
        return "DatecsEcrOnline";
    }

    @Override
    public Collection getViews() {
        return null;
    }

    @Override
    public void init(String[] args, Hashtable runtimeObjects) throws ModuleInstantiationException {
        Vector<Table> tables = this.logic.getTables();
        String location = Utils.getCmdlineValue("-location", args, "");
        Location l = this.logic.getLocationByName(location);
        if (l != null) {
            tables = this.logic.getTablesByLocation(l.getId());
        }
        final Table t = tables.elementAt(0);
        final User w = (User)this.logic.getWaiters().elementAt(0);
        final RestLogic logic = RestLogic.getInstance();
        try {
            String s = Utils.getCmdlineValue("-ecrNrLogic", args, "1");
            Vector ecrCase = Utils.splitString(s, ',');
            for (int i = 0; i < ecrCase.size(); ++i) {
                String o = (String)ecrCase.elementAt(i);
                int nrLogic = Integer.parseInt(o);
                RandomAccessDatecsEcrOnline dto = new RandomAccessDatecsEcrOnline(new EcrOnlineInterface(){

                    @Override
                    public boolean readBon(BonFiscal bf) {
                        boolean result = false;
                        try {
                            logic.notaByBonFiscal(bf, w.getId(), t.getId(), false, VpConfig.getInstance().datecsOnlineCodBare, true);
                            result = true;
                        }
                        catch (SQLException e) {
                            Logger.logException(this, (Exception)e);
                        }
                        return result;
                    }
                }, nrLogic, VpConfig.getInstance().datecsOnlineCodBare);
                logic.setPluPrinter(dto);
                dto.start();
            }
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
        }
    }
}

