/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.restaurant.modules.droidsms;

import java.sql.SQLException;
import java.util.Collection;
import java.util.Iterator;
import java.util.Vector;
import ro.atreides.restaurant.modules.droidsms.DroidSms;
import ro.atreides.restaurant.modules.droidsms.DroidSmsDao;
import ro.atreides.utils.Logger;
import ro.atreides.utils.SmsSender;
import ro.atreides.utils.db.ConnectionPool;
import ro.atreides.utils.db.ConnectionWrapper;

public class DroidSmsSender
implements SmsSender {
    public static final int TO_SEND = 1;
    public static final int PENDING = 2;
    public static final int DELIVERED = 3;
    ConnectionPool pool = ConnectionPool.getInstance();
    private static DroidSmsSender instance;

    public static synchronized DroidSmsSender getInstance() {
        if (instance == null) {
            instance = new DroidSmsSender();
        }
        return instance;
    }

    private DroidSmsSender() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sendSms(String text, Collection destinations) {
        Iterator iter = destinations.iterator();
        try {
            while (iter.hasNext()) {
                String number = (String)iter.next();
                this.addSmsNoCommit(number, text);
            }
            this.pool.commit();
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            try {
                this.pool.rollBack();
            }
            catch (SQLException e1) {
                Logger.logException(this, (Exception)e);
            }
        }
        finally {
            this.pool.releaseConnection();
        }
    }

    public void addSmsNoCommit(String number, String text) throws SQLException {
        this.getDao().addSms(number, text);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Vector<DroidSms> getToSend() {
        try {
            Vector<DroidSms> vector = this.getDao().getNew();
            return vector;
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            Vector<DroidSms> vector = new Vector<DroidSms>();
            return vector;
        }
        finally {
            try {
                this.pool.commit();
            }
            catch (SQLException e) {
                Logger.logException(this, (Exception)e);
            }
            this.pool.releaseConnection();
        }
    }

    private void addToStringBuffer(Vector<DroidSms> toSend, StringBuffer buffer) {
        for (DroidSms droidSms : toSend) {
            buffer.append(droidSms.toString());
            buffer.append('\n');
        }
    }

    public void addSmsToSendToStringBuffer(StringBuffer buffer) {
        Vector<DroidSms> toSend = this.getToSend();
        this.addToStringBuffer(toSend, buffer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void messageSent(int id) {
        try {
            this.getDao().setStatus(id, 2, 0);
            this.pool.commit();
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            try {
                this.pool.rollBack();
            }
            catch (SQLException e1) {
                Logger.logException(this, (Exception)e);
            }
        }
        finally {
            this.pool.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void messageNotSent(int id) {
        try {
            this.getDao().setStatus(id, 1, 1);
            this.pool.commit();
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            try {
                this.pool.rollBack();
            }
            catch (SQLException e1) {
                Logger.logException(this, (Exception)e);
            }
        }
        finally {
            this.pool.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void messageDelivered(int id) {
        try {
            this.getDao().setStatus(id, 3, 0);
            this.pool.commit();
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            try {
                this.pool.rollBack();
            }
            catch (SQLException e1) {
                Logger.logException(this, (Exception)e);
            }
        }
        finally {
            this.pool.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void messageNotDelivered(int id) {
        try {
            this.getDao().setStatus(id, 1, 1);
            this.pool.commit();
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            try {
                this.pool.rollBack();
            }
            catch (SQLException e1) {
                Logger.logException(this, (Exception)e);
            }
        }
        finally {
            this.pool.releaseConnection();
        }
    }

    private synchronized DroidSmsDao getDao() {
        ConnectionWrapper connection = this.pool.requestConnection();
        DroidSmsDao dao = null;
        while (dao == null) {
            dao = (DroidSmsDao)this.pool.getDao(DroidSmsDao.class, connection);
            if (dao != null) continue;
            this.pool.buildDao(DroidSmsDao.class.getName(), connection);
        }
        return dao;
    }
}

