/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.restaurant.modules.exportclientsold;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.Date;
import java.util.Hashtable;
import java.util.Map;
import java.util.Vector;
import ro.atreides.clienti.ClientLogic;
import ro.atreides.clienti.ClientPersJuridica;
import ro.atreides.facturi.FacturiLogic;
import ro.atreides.restaurant.modules.exportclientsold.ConsumeAndSendThread;
import ro.atreides.utils.Client;
import ro.atreides.utils.DateUtils;
import ro.atreides.utils.FacturiNeplatiteEntry;
import ro.atreides.utils.GenericListenersLogic;
import ro.atreides.utils.Logger;
import ro.atreides.utils.ModuleInstantiationException;
import ro.atreides.utils.ObjectEventListener;
import ro.atreides.utils.Utils;
import ro.atreides.utils.gui.Validators;

public class Module
implements ro.atreides.utils.Module {
    private MessageFormat exportUrl;
    private ConsumeAndSendThread consumer;

    @Override
    public String getModuleName() {
        return "ExportClientSold";
    }

    @Override
    public Collection getViews() {
        return null;
    }

    @Override
    public void init(String[] cmdArgs, Hashtable runtimeObjects) throws ModuleInstantiationException {
        String exportUrlString = Utils.getCmdlineValue("-exporturl", cmdArgs);
        this.exportUrl = new MessageFormat(exportUrlString);
        String successKey = Utils.getCmdlineValue("-successkey", cmdArgs, "SUCCES");
        this.consumer = new ConsumeAndSendThread();
        this.consumer.setSuccessKey(successKey);
        this.consumer.start();
        GenericListenersLogic.getInstance().addObjectListener(this.buildEventListener(), 99);
        GenericListenersLogic.getInstance().addObjectListener(this.buildEventListener(), 98);
        GenericListenersLogic.getInstance().addObjectListener(this.buildEventListener(), 0);
        GenericListenersLogic.getInstance().addObjectListener(this.buildEventListener(), 86);
        Vector<ClientPersJuridica> persJuridice = ClientLogic.getInstance().getAllPersJuridiceSorted();
        for (ClientPersJuridica clientPersJuridica : persJuridice) {
            this.addExportLinkForIdClient(clientPersJuridica);
        }
    }

    private ObjectEventListener buildEventListener() {
        ObjectEventListener result = new ObjectEventListener(){

            @Override
            public void dataChanged(Object o) {
                Client client;
                Map map = (Map)o;
                Integer idClient = (Integer)map.get("id_client_key");
                if (idClient != null && (client = ClientLogic.getInstance().getClientById(idClient)) != null) {
                    Module.this.addExportLinkForIdClient(client);
                }
            }

            @Override
            public String getName() {
                return "ExportClientSold Listener";
            }
        };
        return result;
    }

    private synchronized void addExportLinkForIdClient(Client client) {
        ClientPersJuridica cpj;
        String cui = "LipsaCui";
        if (client instanceof ClientPersJuridica && !Validators.correctString(cui = (cpj = (ClientPersJuridica)client).getCui())) {
            return;
        }
        Vector<FacturiNeplatiteEntry> facturiNeplatite = FacturiLogic.getInstance().getFacturiNeplatite(client.getId(), 1);
        double dePlata = 0.0;
        Date endOfToday = DateUtils.getEndOfDay(new Date());
        for (FacturiNeplatiteEntry entry : facturiNeplatite) {
            if (!entry.getScadenta().before(endOfToday)) continue;
            dePlata += entry.getDePlata();
        }
        try {
            String exportLink = Utils.getTranslation(this.exportUrl, URLEncoder.encode(client.toString(), "UTF-8"), URLEncoder.encode(cui, "UTF-8"), URLEncoder.encode(Utils.getString2Decimals(dePlata), "UTF-8"));
            this.consumer.add(exportLink);
        }
        catch (UnsupportedEncodingException e) {
            Logger.logException(this, (Exception)e);
        }
    }
}

