/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.restaurant.modules.fidelitybo;

import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.JTextField;
import net.miginfocom.swing.MigLayout;
import ro.atreides.restaurant.modules.fidelitybo.EventDef;
import ro.atreides.restaurant.modules.fidelitybo.FidelityLogic;
import ro.atreides.utils.CleanupRequired;
import ro.atreides.utils.Constants;
import ro.atreides.utils.GenericListenersLogic;
import ro.atreides.utils.gui.ComboUtils;
import ro.atreides.utils.gui.Validators;
import ro.atreides.utils.gui.dialogs.DialogUtils;
import ro.atreides.utils.gui.table.AbstractListPanel;
import ro.atreides.utils.gui.table.AbstractTM;
import ro.atreides.utils.gui.table.TmInterface;
import ro.atreides.utils.multilang.LangRoAll;

public class EvDefPanel
extends AbstractListPanel
implements CleanupRequired {
    private JTextField label;
    private JTextField nrPuncte;
    private JTextField smsPeriod;
    private JTextField emailPeriod;
    private JTextField deltaInainte;
    private JTextField deltaDupa;
    private JCheckBox active;
    private JComboBox<FidelityLogic.TIP_EVENIMENT> tipEveniment;
    private EventDef currentEvDef = null;
    private JComponent parent = this;

    @Override
    public AbstractTM buildTableModel() {
        this.tm = new AbstractTM(this.buildColumns(), this.buildTypes(), new TmInterface(){

            @Override
            public Object getValueAt(int rowIndex, int columnIndex, Vector data) {
                EventDef evDef = (EventDef)data.get(rowIndex);
                switch (columnIndex) {
                    case 0: {
                        return evDef.getLabel();
                    }
                    case 1: {
                        return evDef.getTip_eveniment().toString();
                    }
                    case 2: {
                        return evDef.getPuncte();
                    }
                    case 3: {
                        return evDef.getSmsPeriod();
                    }
                    case 4: {
                        return evDef.getEmailPeriod();
                    }
                    case 5: {
                        return evDef.getDeltaInainte();
                    }
                    case 6: {
                        return evDef.getDeltaDupa();
                    }
                    case 7: {
                        return evDef.isActiv();
                    }
                }
                return null;
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return false;
            }

            @Override
            public void setValueAt(Object aValue, int rowIndex, int columnIndex, Vector data) {
            }
        });
        return this.tm;
    }

    @Override
    public JPanel getBottomPanel() {
        JPanel result = new JPanel((LayoutManager)new MigLayout("", "[][grow][][grow][][grow]", ""));
        result.add(new JLabel("Nume"));
        this.label = new JTextField();
        result.add((Component)this.label, "growx");
        result.add(new JLabel("Nr puncte"));
        this.nrPuncte = new JTextField();
        result.add((Component)this.nrPuncte, "growx");
        result.add(new JLabel("Minute inainte"));
        this.deltaInainte = new JTextField();
        result.add((Component)this.deltaInainte, "growx");
        result.add(new JLabel("Minute dupa"));
        this.deltaDupa = new JTextField();
        result.add((Component)this.deltaDupa, "growx, wrap");
        result.add(new JLabel("Tip"));
        this.tipEveniment = new JComboBox();
        result.add(this.tipEveniment, "growx");
        result.add(new JLabel("SMS minutes period"));
        this.smsPeriod = new JTextField();
        result.add((Component)this.smsPeriod, "growx");
        result.add(new JLabel("Email minutes period"));
        this.emailPeriod = new JTextField();
        result.add((Component)this.emailPeriod, "growx");
        this.active = new JCheckBox("Activ");
        this.active.setSelected(false);
        this.active.setHorizontalTextPosition(2);
        result.add((Component)this.active, "growx");
        JButton salveaza = new JButton("Salveaza");
        salveaza.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String labelText = EvDefPanel.this.label.getText();
                String nrPuncteText = EvDefPanel.this.nrPuncte.getText();
                String deltaInainteText = EvDefPanel.this.deltaInainte.getText();
                String deltaDupaText = EvDefPanel.this.deltaDupa.getText();
                String smsPeriodText = EvDefPanel.this.smsPeriod.getText();
                String emailPeriodText = EvDefPanel.this.emailPeriod.getText();
                boolean isActive = EvDefPanel.this.active.isSelected();
                FidelityLogic.TIP_EVENIMENT tipEvSelected = (FidelityLogic.TIP_EVENIMENT)((Object)EvDefPanel.this.tipEveniment.getSelectedItem());
                if (!Validators.correctString(labelText)) {
                    DialogUtils.errorDialog(EvDefPanel.this.parent, "Numele este incorect", LangRoAll.nuPotContinua);
                    return;
                }
                if (!Validators.correctInteger(nrPuncteText)) {
                    DialogUtils.errorDialog(EvDefPanel.this.parent, "Numarul de puncte este incorect", LangRoAll.nuPotContinua);
                    return;
                }
                Integer deltaInainteInt = !Validators.correctInteger(deltaInainteText) ? Integer.valueOf(0) : Integer.valueOf(Integer.parseInt(deltaInainteText));
                Integer deltaDupaInt = !Validators.correctInteger(deltaDupaText) ? Integer.valueOf(0) : Integer.valueOf(Integer.parseInt(deltaDupaText));
                Integer smsPeriodInt = !Validators.correctInteger(smsPeriodText) ? Integer.valueOf(-1) : Integer.valueOf(Integer.parseInt(smsPeriodText));
                Integer emailPeriodInt = !Validators.correctInteger(emailPeriodText) ? Integer.valueOf(-1) : Integer.valueOf(Integer.parseInt(emailPeriodText));
                if (EvDefPanel.this.currentEvDef != null) {
                    EvDefPanel.this.currentEvDef.setLabel(labelText);
                    EvDefPanel.this.currentEvDef.setPuncte(Integer.parseInt(nrPuncteText));
                    EvDefPanel.this.currentEvDef.setTip_eveniment(tipEvSelected);
                    EvDefPanel.this.currentEvDef.setDeltaInainte(deltaInainteInt);
                    EvDefPanel.this.currentEvDef.setDeltaDupa(deltaDupaInt);
                    EvDefPanel.this.currentEvDef.setSmsPeriod(smsPeriodInt);
                    EvDefPanel.this.currentEvDef.setEmailPeriod(emailPeriodInt);
                    EvDefPanel.this.currentEvDef.setActiv(isActive);
                    FidelityLogic.getInstance().updateEventDefById(EvDefPanel.this.currentEvDef);
                    EvDefPanel.this.refreshTable();
                    EvDefPanel.this.clearBottom();
                } else {
                    EventDef eventDef = new EventDef();
                    eventDef.setLabel(labelText);
                    eventDef.setPuncte(Integer.parseInt(nrPuncteText));
                    eventDef.setTip_eveniment(tipEvSelected);
                    eventDef.setDeltaInainte(deltaInainteInt);
                    eventDef.setDeltaDupa(deltaDupaInt);
                    eventDef.setSmsPeriod(smsPeriodInt);
                    eventDef.setEmailPeriod(emailPeriodInt);
                    eventDef.setActiv(isActive);
                    eventDef.setIdTipCont(1);
                    eventDef.setStatus(1);
                    FidelityLogic.getInstance().addEventDef(eventDef);
                    EvDefPanel.this.refreshTable();
                    EvDefPanel.this.clearBottom();
                }
                GenericListenersLogic.getInstance().notifyListeners(Constants.EVENT_DEF_CHANGED);
            }
        });
        result.add((Component)salveaza, "growx");
        return result;
    }

    @Override
    public Vector buildData() {
        return FidelityLogic.getInstance().getAllEventDef(FidelityLogic.getInstance().getAllTipEvenimente());
    }

    @Override
    public String[] buildColumns() {
        return new String[]{"Nume", "Tip eveniment", "Puncte", "SMS minutes period", "Email minutes period", "Minute inainte", "Minute dupa", "Activ"};
    }

    @Override
    public Class[] buildTypes() {
        return new Class[]{String.class, String.class, String.class, String.class, String.class, String.class, String.class, Boolean.class};
    }

    @Override
    public void cleanup() {
    }

    @Override
    public void doStuff() {
        this.display();
        this.table.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
            }

            @Override
            public void mousePressed(MouseEvent e) {
                Point p;
                int modifiers = e.getModifiers();
                if ((modifiers & 0x10) > 0) {
                    return;
                }
                JTable t = (JTable)e.getSource();
                int selRow = t.rowAtPoint(p = e.getPoint());
                if (selRow == -1) {
                    return;
                }
                final EventDef eventDef = (EventDef)EvDefPanel.this.tm.getObjectAt(selRow);
                final JPopupMenu popup = new JPopupMenu();
                JMenuItem edit = new JMenuItem(LangRoAll.modifica);
                popup.add(edit);
                edit.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        EvDefPanel.this.setEvDefToEdit(eventDef);
                        popup.setVisible(false);
                    }
                });
                JMenuItem delete = new JMenuItem(LangRoAll.sterge);
                popup.add(delete);
                delete.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        if (DialogUtils.confirmDialog(EvDefPanel.this.parent, "Doriti sa stergeti \"" + eventDef.getLabel() + "\"", LangRoAll.confirmare)) {
                            FidelityLogic.getInstance().deleteEventDef(eventDef);
                            EvDefPanel.this.refreshTable();
                            GenericListenersLogic.getInstance().notifyListeners(Constants.EVENT_DEF_CHANGED);
                        }
                        popup.setVisible(false);
                    }
                });
                popup.show(e.getComponent(), e.getX(), e.getY());
            }

            @Override
            public void mouseReleased(MouseEvent e) {
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }
        });
        ComboUtils.replaceItemsForCombo(this.tipEveniment, FidelityLogic.getInstance().getAllTipEvenimente(), false);
        this.table.getColumnModel().getColumn(7).setMaxWidth(50);
    }

    private void clearBottom() {
        this.currentEvDef = null;
        this.label.setText("");
        this.nrPuncte.setText("");
        this.smsPeriod.setText("");
        this.emailPeriod.setText("");
        this.deltaInainte.setText("");
        this.deltaDupa.setText("");
        this.active.setSelected(false);
        if (this.tipEveniment.getModel().getSize() > 0) {
            this.tipEveniment.setSelectedIndex(0);
        }
    }

    private void setEvDefToEdit(EventDef eventDef) {
        this.currentEvDef = eventDef;
        this.label.setText(eventDef.getLabel());
        this.nrPuncte.setText(eventDef.getPuncte() + "");
        this.smsPeriod.setText(eventDef.getSmsPeriod() + "");
        this.emailPeriod.setText(eventDef.getEmailPeriod() + "");
        this.deltaInainte.setText(eventDef.getDeltaInainte() + "");
        this.deltaDupa.setText(eventDef.getDeltaDupa() + "");
        this.active.setSelected(eventDef.isActiv());
        FidelityLogic.TIP_EVENIMENT tipEv = eventDef.getTip_eveniment();
        this.tipEveniment.setSelectedItem((Object)tipEv);
    }
}

