/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.restaurant.modules.fidelitybo;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Date;
import java.util.Hashtable;
import java.util.Vector;
import ro.atreides.restaurant.modules.fidelitybo.EventClients;
import ro.atreides.restaurant.modules.fidelitybo.EventDef;
import ro.atreides.restaurant.modules.fidelitybo.EventDefInstanceBean;
import ro.atreides.restaurant.modules.fidelitybo.EventInstance;
import ro.atreides.restaurant.modules.fidelitybo.FidelityLogic;
import ro.atreides.restaurant.modules.fidelitybo.RaportComenziView;
import ro.atreides.restaurant.modules.fidelitybo.RaportPuncteView;
import ro.atreides.utils.Constants;
import ro.atreides.utils.DateUtils;
import ro.atreides.utils.Location;
import ro.atreides.utils.TipCont;
import ro.atreides.utils.db.DaoInterface;
import ro.atreides.utils.sql.SqlUtils;

public class FidelityDao
implements DaoInterface {
    private Connection connection;
    private PreparedStatement addEventDef;
    private PreparedStatement getEventDefs;
    private PreparedStatement setEvDefCodSync;
    private PreparedStatement getEventDefById;
    private PreparedStatement updateEventDefWhereCodSync;
    private PreparedStatement updateCodSyncToEventDef;
    private PreparedStatement getEventDefByCodSync;
    private PreparedStatement updateEventDefById;
    private PreparedStatement setStatusDeletedToEvDef;
    private PreparedStatement addEventInstance;
    private PreparedStatement setEvInstanceCodSync;
    private PreparedStatement getEvInstance;
    private PreparedStatement setEvInstaceDeletedStatusById;
    private PreparedStatement updateEventInstanceWhereCodSync;
    private PreparedStatement getCurrentEvInstances;
    private PreparedStatement getEventInstanceByCodSync;
    private PreparedStatement getEventInstanceById;
    private PreparedStatement addEvClient;
    private PreparedStatement setEvClientCodSync;
    private PreparedStatement addEvClientFull;
    private PreparedStatement getEventClientById;
    private PreparedStatement getEventClientByCodSync;
    private PreparedStatement getEventClientByClientId;
    private PreparedStatement deleteEvClientByCodSync;
    private PreparedStatement isEventConsumedForClient;

    public Connection getConnection() {
        return this.connection;
    }

    public FidelityDao(Connection connection) throws SQLException {
        this.connection = connection;
        this.buildPreparedStatements();
    }

    @Override
    public void buildPreparedStatements() throws SQLException {
        this.addEventDef = this.connection.prepareStatement("insert into ev_def(tip, activ, tip_cont, puncte_def, delta_t_inainte, delta_t_dupa, notify_sms_period, notify_email_period, label, status) values ( ?, ? ,? ,? ,? ,? ,? , ?, ?, ?)", 1);
        this.getEventDefs = this.connection.prepareStatement("select * from ev_def");
        this.updateEventDefWhereCodSync = this.connection.prepareStatement("update ev_def set tip = ? , tip_cont = ? , puncte_def = ? , delta_t_inainte = ? , delta_t_dupa = ? , notify_sms_period = ? , notify_email_period = ?, label = ?, activ = ?, status = ? where cod_sync = ?");
        this.updateEventDefById = this.connection.prepareStatement("update ev_def set tip = ? , tip_cont = ? , puncte_def = ? , delta_t_inainte = ? , delta_t_dupa = ? , notify_sms_period = ? , notify_email_period = ?, label = ?, activ = ?, status = ? where id = ?");
        this.updateCodSyncToEventDef = this.connection.prepareStatement("update ev_def set cod_sync = ? where id = ?");
        this.setStatusDeletedToEvDef = this.connection.prepareStatement("update ev_def set status = 2 where id = ?");
        this.addEventInstance = this.connection.prepareStatement("insert into ev_instance (id_ev_def, id_locatie, data_Start, data_stop, deleted ) values ( ?, ?, ?, ?, ?)", 1);
        this.setEvInstanceCodSync = this.connection.prepareStatement("update ev_instance set cod_sync = ? where id = ?");
        this.setEvInstaceDeletedStatusById = this.connection.prepareStatement("update ev_instance set deleted = ? where id = ?");
        String evInstanceSelect = "select ev_instance.* , ev_def.label as nume_event , locations.name as nume_locatie from ev_instance inner join locations on ev_instance.id_locatie = locations.id inner join ev_def on ev_instance.id_ev_def = ev_def.id where 1 = 1 ";
        this.getEvInstance = this.connection.prepareStatement(evInstanceSelect + " and data_start <= ? and data_stop >= ?" + " and ( id_locatie = ? or ? = " + -1 + ")" + " and ( id_ev_Def = ? or ? = " + -1 + ") ");
        this.updateEventInstanceWhereCodSync = this.connection.prepareStatement("UPDATE ev_instance SET id_locatie = ?, id_ev_def = ?, data_start = ?,  data_stop = ?, status = ? where cod_sync = ?");
        this.addEvClient = this.connection.prepareStatement("insert into ev_clienti(id_ev_def, id_client, id_locatie, puncte_client, nr_Card, tip_card, data_puncte) values (?,?, ?,?, ?,?, current_timestamp)", 1);
        this.addEvClientFull = this.connection.prepareStatement("insert into ev_clienti(id_ev_def, id_client, id_locatie, puncte_client, nr_Card, tip_card, data_puncte, cod_sync) values (?,?, ?,?, ?,?, ?, ?)");
        this.setEvClientCodSync = this.connection.prepareStatement("update ev_clienti set cod_sync = ? where id = ?");
        this.isEventConsumedForClient = this.connection.prepareStatement("select * from ev_clienti where id_ev_def = ? and id_client = ? and data_puncte < ? and data_puncte > ?");
        this.getEventDefById = this.connection.prepareStatement("select * from ev_def where id = ?");
        this.getEventInstanceById = this.connection.prepareStatement(evInstanceSelect + " and ev_instance.id = ?");
        this.getEventDefByCodSync = this.connection.prepareStatement("select * from ev_def where cod_sync = ?");
        this.getEventInstanceByCodSync = this.connection.prepareStatement(evInstanceSelect + " and ev_instance.cod_sync = ?");
        String selectEventClient = "select ev_clienti.*, locations.name as locatie, ev_def.label as ev_def_label from ev_clienti inner join locations on locations.id = ev_clienti.id_locatie inner join ev_def on ev_def.id = ev_clienti.id_ev_def ";
        this.getEventClientById = this.connection.prepareStatement(selectEventClient + " where ev_clienti.id = ?");
        this.getEventClientByCodSync = this.connection.prepareStatement(selectEventClient + " where ev_clienti.cod_sync = ?");
        this.getEventClientByClientId = this.connection.prepareStatement(selectEventClient + " where ev_clienti.id_client = ?");
        this.deleteEvClientByCodSync = this.connection.prepareStatement("delete from ev_clienti where cod_sync = ?");
        this.getCurrentEvInstances = this.connection.prepareStatement(evInstanceSelect + " and ev_instance.deleted is false" + " and ev_def.tip = " + FidelityLogic.TIP_EVENIMENT.MANUAL.code + " and ev_instance.data_start < current_timestamp" + " and ev_instance.data_stop > current_timestamp");
    }

    public Vector<EventDef> getAllActiveEventsDefs(Vector<FidelityLogic.TIP_EVENIMENT> tipEveniment) throws SQLException {
        Vector<EventDef> result = new Vector<EventDef>();
        String s = "select * from ev_def  where ev_def.status = 1";
        if (tipEveniment != null && tipEveniment.size() > 0) {
            s = s + " and (";
            for (int i = 0; i < tipEveniment.size(); ++i) {
                s = s + " ev_def.tip = " + tipEveniment.get((int)i).code;
                if (i >= tipEveniment.size() - 1) continue;
                s = s + " or ";
            }
            s = s + ")";
        }
        ResultSet rs = SqlUtils.executeQuery(s, this.connection);
        while (rs.next()) {
            EventDef toadd = this.getEventDefFromRs(rs);
            result.add(toadd);
        }
        rs.close();
        return result;
    }

    public Vector<EventDefInstanceBean> getAllActiveEventsNow(int idLocatie) throws SQLException {
        Vector<EventDefInstanceBean> result = new Vector<EventDefInstanceBean>();
        String s = "select ev_def.*, coalesce(ev_instance.id, -1 ) as id_instance, data_Start, data_stop from ev_def left outer join ev_instance on ( ev_instance.deleted is false  and ev_def.id = ev_instance.id_ev_def and id_locatie = " + idLocatie + "" + " and ((data_start is null and data_stop is null) or" + " (data_start <= current_timestamp and data_Stop >= current_timestamp)) )" + " where ev_def.activ = true and ev_def.status = " + 1;
        ResultSet rs = SqlUtils.executeQuery(s, this.connection);
        while (rs.next()) {
            EventDefInstanceBean toadd = new EventDefInstanceBean();
            EventDef evdef = this.getEventDefFromRs(rs);
            toadd.setDefinition(evdef);
            int idInstace = rs.getInt("id_instance");
            if (idInstace > 0) {
                EventInstance add = new EventInstance();
                add.setDataStart(rs.getTimestamp("data_start"));
                add.setDataStop(rs.getTimestamp("data_stop"));
                add.setId(idInstace);
                toadd.setInstance(add);
            }
            result.add(toadd);
        }
        rs.close();
        return result;
    }

    private EventDef getEventDefFromRs(ResultSet rs) throws SQLException {
        EventDef add = new EventDef();
        add.setId(rs.getInt("id"));
        add.setTip_eveniment(FidelityLogic.TIP_EVENIMENT.getEvenimentByCode(rs.getInt("tip")));
        add.setIdTipCont(rs.getInt("tip_cont"));
        add.setDeltaInainte(rs.getInt("delta_t_inainte"));
        add.setDeltaDupa(rs.getInt("delta_t_dupa"));
        add.setEmailPeriod(rs.getInt("notify_email_period"));
        add.setSmsPeriod(rs.getInt("notify_sms_period"));
        add.setPuncte(rs.getInt("puncte_def"));
        add.setActiv(rs.getBoolean("activ"));
        add.setLabel(rs.getString("label"));
        add.setCodSync(rs.getString("cod_sync"));
        add.setStatus(rs.getInt("status"));
        return add;
    }

    public boolean eventAlreadyProcessed(int evDefId, int idClient, Timestamp start, Timestamp stop) throws SQLException {
        boolean result = false;
        this.isEventConsumedForClient.setInt(1, evDefId);
        this.isEventConsumedForClient.setInt(2, idClient);
        this.isEventConsumedForClient.setTimestamp(3, stop);
        this.isEventConsumedForClient.setTimestamp(4, start);
        ResultSet rs = this.isEventConsumedForClient.executeQuery();
        if (rs.next()) {
            result = true;
        }
        rs.close();
        return result;
    }

    public int addPuncteForClient(int evDefId, int idClient, int idLocatie, double puncte, String nrCard, int tipCard) throws SQLException {
        this.addEvClient.setInt(1, evDefId);
        this.addEvClient.setInt(2, idClient);
        this.addEvClient.setInt(3, idLocatie);
        this.addEvClient.setDouble(4, puncte);
        this.addEvClient.setString(5, nrCard);
        this.addEvClient.setInt(6, tipCard);
        this.addEvClient.execute();
        int result = -1;
        ResultSet rs = this.addEvClient.getGeneratedKeys();
        if (rs.next()) {
            result = rs.getInt(1);
        }
        rs.close();
        return result;
    }

    public void updateEvClientCodSync(int idEvClient, String codSync) throws SQLException {
        this.setEvClientCodSync.setString(1, codSync);
        this.setEvClientCodSync.setInt(2, idEvClient);
        this.setEvClientCodSync.execute();
    }

    public int addEventInstance(int idEventDef, int idLocatie, Timestamp start, Timestamp stop, boolean deleted) throws SQLException {
        this.addEventInstance.setInt(1, idEventDef);
        this.addEventInstance.setInt(2, idLocatie);
        this.addEventInstance.setTimestamp(3, start);
        this.addEventInstance.setTimestamp(4, stop);
        this.addEventInstance.setBoolean(5, deleted);
        this.addEventInstance.execute();
        int result = -1;
        ResultSet rs = this.addEventInstance.getGeneratedKeys();
        if (rs.next()) {
            result = rs.getInt(1);
        }
        rs.close();
        return result;
    }

    public void setEventInstanceDeletedStatusById(int idEventDef, boolean deleted) throws SQLException {
        this.setEvInstaceDeletedStatusById.setBoolean(1, deleted);
        this.setEvInstaceDeletedStatusById.setInt(2, idEventDef);
        this.setEvInstaceDeletedStatusById.execute();
    }

    public void updateEvInstanceCodSync(int id, String codSync) throws SQLException {
        this.setEvInstanceCodSync.setString(1, codSync);
        this.setEvInstanceCodSync.setInt(2, id);
        this.setEvInstanceCodSync.execute();
    }

    public Vector<EventInstance> getEvInstancesReport(int idLocatie, int idEvDef, Timestamp start, Timestamp stop) throws SQLException {
        Vector<EventInstance> result = new Vector<EventInstance>();
        this.getEvInstance.setTimestamp(1, stop);
        this.getEvInstance.setTimestamp(2, start);
        this.getEvInstance.setInt(3, idLocatie);
        this.getEvInstance.setInt(4, idLocatie);
        this.getEvInstance.setInt(5, idEvDef);
        this.getEvInstance.setInt(6, idEvDef);
        ResultSet rs = this.getEvInstance.executeQuery();
        while (rs.next()) {
            EventInstance add = this.getEventInstanceFromRS(rs);
            result.add(add);
        }
        rs.close();
        return result;
    }

    public EventInstance getEventInstanceFromRS(ResultSet rs) throws SQLException {
        EventInstance result = new EventInstance();
        result.setDataStart(rs.getTimestamp("data_start"));
        result.setDataStop(rs.getTimestamp("data_stop"));
        result.setId(rs.getInt("id"));
        result.setIdEventDef(rs.getInt("id_ev_def"));
        result.setIdLocatie(rs.getInt("id_locatie"));
        result.setNumeEventDef(rs.getString("nume_event"));
        result.setNumeLocatie(rs.getString("nume_locatie"));
        result.setCodSync(rs.getString("cod_sync"));
        result.setDeleted(rs.getBoolean("deleted"));
        return result;
    }

    public Vector<RaportPuncteView> getAllPuncteForRaport(Hashtable criteria) throws SQLException {
        Vector<RaportPuncteView> result = new Vector<RaportPuncteView>();
        Long startTime = (Long)criteria.get(Constants.START_KEY);
        Long stopTime = (Long)criteria.get(Constants.STOP_KEY);
        Timestamp start = new Timestamp(startTime);
        Timestamp stop = new Timestamp(stopTime);
        String client = (String)criteria.get(Constants.CLIENT_KEY);
        Location location = (Location)criteria.get(Constants.LOCATIE_KEY);
        TipCont tipCont = (TipCont)criteria.get("tip_cont");
        String card = (String)criteria.get("cont");
        EventDef event = (EventDef)criteria.get("tip_eveniment");
        String sql = "select ev_clienti.puncte_client, ev_clienti.id_client, ev_clienti.id_locatie, ev_def.tip as code_tip_eveniment, locations.name as location_name, ev_def.label as eveniment, ev_def.id as id_eveniment, keys.label as tip_card, promotii_clienti.card, ev_clienti.data_puncte, persoane_fizice.nume, persoane_fizice.prenume from ev_clienti inner join clienti on clienti.id = ev_clienti.id_client inner join locations on locations.id = ev_clienti.id_locatie inner join ev_def on ev_def.id = ev_clienti.id_ev_def inner join tip_cont_client on tip_cont_client.id = ev_clienti.tip_card inner join keys on keys.id = tip_cont_client.id_key inner join promotii_clienti on promotii_clienti.id_client = clienti.id left outer join persoane_fizice on persoane_fizice.id = clienti.idpersfizica where ev_clienti.data_puncte >= '" + start + "' and ev_clienti.data_puncte <= '" + stop + "' ";
        if (client != null) {
            sql = sql + " and lower(persoane_fizice.nume) like '%" + client.toLowerCase() + "%'";
        }
        if (location != null) {
            sql = sql + " and ev_clienti.id_locatie = " + location.getId();
        }
        if (tipCont != null) {
            sql = sql + " and ev_clienti.tip_card = " + tipCont.getId();
        }
        if (card != null) {
            sql = sql + " and promotii_clienti.card = '" + card + "'";
        }
        if (event != null) {
            sql = sql + " and ev_def.id = " + event.getId();
        }
        ResultSet rs = SqlUtils.executeQuery(sql, this.connection);
        while (rs.next()) {
            RaportPuncteView raportPuncteView = new RaportPuncteView();
            raportPuncteView.setNrPuncte(rs.getDouble("puncte_client"));
            raportPuncteView.setIdClient(rs.getInt("id_client"));
            raportPuncteView.setIdLocatie(rs.getInt("id_locatie"));
            raportPuncteView.setEvenimentCode(rs.getInt("code_tip_eveniment"));
            raportPuncteView.setLocatie(rs.getString("location_name"));
            raportPuncteView.setTipEveniment(rs.getString("eveniment"));
            raportPuncteView.setIdEveniment(rs.getInt("id_eveniment"));
            raportPuncteView.setTipCard(rs.getString("tip_card"));
            raportPuncteView.setCard(rs.getString("card"));
            raportPuncteView.setData(rs.getTimestamp("data_puncte"));
            raportPuncteView.setClient(rs.getString("nume") + " " + rs.getString("prenume"));
            result.add(raportPuncteView);
        }
        rs.close();
        return result;
    }

    public Vector<RaportComenziView> getAllComenziView(Hashtable criteria) throws SQLException {
        Vector<RaportComenziView> result = new Vector<RaportComenziView>();
        Long startTime = (Long)criteria.get(Constants.START_KEY);
        Long stopTime = (Long)criteria.get(Constants.STOP_KEY);
        Timestamp start = new Timestamp(startTime);
        Timestamp stop = new Timestamp(stopTime);
        String client = (String)criteria.get(Constants.CLIENT_KEY);
        Location location = (Location)criteria.get(Constants.LOCATIE_KEY);
        String produs = (String)criteria.get("Product");
        String sql = "select sales.quantity_float as cantitate, products.label as produs, products.id as id_produs, orders.id_client, persoane_fizice.nume, persoane_fizice.prenume, sales.ppu as puncte, sales.saledate as data, locations.id as id_location, locations.name as location from sales inner join orders on orders.id = sales.id_order inner join products on products.id = sales.id_product inner join tables on tables.id = orders.id_table inner join locations on locations.id = tables.id_locatie inner join clienti on clienti.id = orders.id_client left outer join persoane_fizice on persoane_fizice.id = clienti.idpersfizica where (orders.status = 4 or orders.status = 3) and sales.saledate >= '" + start + "' and sales.saledate <= '" + stop + "' ";
        if (client != null) {
            sql = sql + " and lower(persoane_fizice.nume) like '%" + client.toLowerCase() + "%'";
        }
        if (location != null) {
            sql = sql + " and locations.id = " + location.getId();
        }
        if (produs != null) {
            sql = sql + " and lower(products.label) like '%" + produs.toLowerCase() + "%'";
        }
        ResultSet rs = SqlUtils.executeQuery(sql, this.connection);
        while (rs.next()) {
            RaportComenziView raportComenziView = new RaportComenziView();
            raportComenziView.setLocatie(rs.getString("location"));
            raportComenziView.setIdLocatie(rs.getInt("id_location"));
            raportComenziView.setCantitate(rs.getDouble("cantitate"));
            raportComenziView.setData(rs.getTimestamp("data"));
            raportComenziView.setClient(rs.getString("nume") + " " + rs.getString("prenume"));
            raportComenziView.setIdClient(rs.getInt("id_client"));
            raportComenziView.setProdus(rs.getString("produs"));
            raportComenziView.setIdProdus(rs.getInt("id_produs"));
            raportComenziView.setPuncteConsumate(rs.getDouble("puncte"));
            result.add(raportComenziView);
        }
        rs.close();
        return result;
    }

    public EventDef getEventDefById(Integer id) throws SQLException {
        EventDef result = null;
        this.getEventDefById.setInt(1, id);
        ResultSet rs = this.getEventDefById.executeQuery();
        if (rs.next()) {
            result = this.getEventDefFromRs(rs);
        }
        rs.close();
        return result;
    }

    public EventInstance getEventInstanceById(Integer id) throws SQLException {
        EventInstance result = null;
        this.getEventInstanceById.setInt(1, id);
        ResultSet rs = this.getEventInstanceById.executeQuery();
        if (rs.next()) {
            result = this.getEventInstanceFromRS(rs);
        }
        rs.close();
        return result;
    }

    public EventDef getEventDefByCodSync(String codSync) throws SQLException {
        EventDef evDef = null;
        this.getEventDefByCodSync.setString(1, codSync);
        ResultSet rs = this.getEventDefByCodSync.executeQuery();
        if (rs.next()) {
            evDef = this.getEventDefFromRs(rs);
        }
        rs.close();
        return evDef;
    }

    public EventInstance getEventInstanceByCodSync(String codSync) throws SQLException {
        EventInstance result = null;
        this.getEventInstanceByCodSync.setString(1, codSync);
        ResultSet rs = this.getEventInstanceByCodSync.executeQuery();
        if (rs.next()) {
            result = this.getEventInstanceFromRS(rs);
        }
        rs.close();
        return result;
    }

    public void addEventClient(EventClients eventClient) throws SQLException {
        this.addEvClientFull.setInt(1, eventClient.getIdEventDef());
        this.addEvClientFull.setInt(2, eventClient.getIdClient());
        this.addEvClientFull.setInt(3, eventClient.getIdLocatie());
        this.addEvClientFull.setInt(4, eventClient.getNrPuncte());
        this.addEvClientFull.setString(5, eventClient.getNrCard());
        this.addEvClientFull.setInt(6, eventClient.getTipCard());
        this.addEvClientFull.setTimestamp(7, eventClient.getDataPuncte());
        this.addEvClientFull.setString(8, eventClient.getCodSync());
        this.addEvClientFull.execute();
    }

    public void deleteEvClientByCodSync(String codSync) throws SQLException {
        this.deleteEvClientByCodSync.setString(1, codSync);
        this.deleteEvClientByCodSync.execute();
    }

    public void updateEventDefWhereCodSync(EventDef eventDef) throws SQLException {
        this.updateEventDefWhereCodSync.setInt(1, eventDef.getTip_eveniment().code);
        this.updateEventDefWhereCodSync.setInt(2, eventDef.getIdTipCont());
        this.updateEventDefWhereCodSync.setInt(3, eventDef.getPuncte());
        this.updateEventDefWhereCodSync.setInt(4, eventDef.getDeltaInainte());
        this.updateEventDefWhereCodSync.setInt(5, eventDef.getDeltaDupa());
        this.updateEventDefWhereCodSync.setInt(6, eventDef.getSmsPeriod());
        this.updateEventDefWhereCodSync.setInt(7, eventDef.getEmailPeriod());
        this.updateEventDefWhereCodSync.setString(8, eventDef.getLabel());
        this.updateEventDefWhereCodSync.setBoolean(9, eventDef.isActiv());
        this.updateEventDefWhereCodSync.setInt(10, eventDef.getStatus());
        this.updateEventDefWhereCodSync.setString(11, eventDef.getCodSync());
        this.updateEventDefWhereCodSync.executeUpdate();
    }

    public void updateEventDefCodSync(int idEvDef, String codSync) throws SQLException {
        this.updateCodSyncToEventDef.setString(1, codSync);
        this.updateCodSyncToEventDef.setInt(2, idEvDef);
        this.updateCodSyncToEventDef.executeUpdate();
    }

    public void updateEventInstanceWhereCodSync(EventInstance eventInstance) throws SQLException {
        this.updateEventInstanceWhereCodSync.setInt(1, eventInstance.getIdLocatie());
        this.updateEventInstanceWhereCodSync.setInt(2, eventInstance.getIdEventDef());
        this.updateEventInstanceWhereCodSync.setTimestamp(3, eventInstance.getDataStart());
        this.updateEventInstanceWhereCodSync.setTimestamp(4, eventInstance.getDataStop());
        this.updateEventInstanceWhereCodSync.setBoolean(5, eventInstance.isDeleted());
        this.updateEventInstanceWhereCodSync.setString(6, eventInstance.getCodSync());
    }

    public int addEventDef(EventDef eventDef) throws SQLException {
        this.addEventDef.setInt(1, eventDef.getTip_eveniment().code);
        this.addEventDef.setBoolean(2, eventDef.isActiv());
        this.addEventDef.setInt(3, eventDef.getIdTipCont());
        this.addEventDef.setInt(4, eventDef.getPuncte());
        this.addEventDef.setInt(5, eventDef.getDeltaInainte());
        this.addEventDef.setInt(6, eventDef.getDeltaDupa());
        this.addEventDef.setInt(7, eventDef.getSmsPeriod());
        this.addEventDef.setInt(8, eventDef.getEmailPeriod());
        this.addEventDef.setString(9, eventDef.getLabel());
        this.addEventDef.setInt(10, eventDef.getStatus());
        this.addEventDef.execute();
        int result = -1;
        ResultSet rs = this.addEventDef.getGeneratedKeys();
        if (rs.next()) {
            result = rs.getInt(1);
        }
        rs.close();
        return result;
    }

    public EventClients getEventClientById(Integer id) throws SQLException {
        EventClients result = null;
        this.getEventClientById.setInt(1, id);
        ResultSet rs = this.getEventClientById.executeQuery();
        if (rs.next()) {
            result = this.getEventClientFromRS(rs);
        }
        rs.close();
        return result;
    }

    public EventClients getEventClientFromRS(ResultSet rs) throws SQLException {
        EventClients result = new EventClients();
        result.setId(rs.getInt("id"));
        result.setIdEventDef(rs.getInt("id_ev_def"));
        result.setIdClient(rs.getInt("id_client"));
        result.setIdLocatie(rs.getInt("id_locatie"));
        result.setNrPuncte(rs.getInt("puncte_client"));
        result.setDataPuncte(rs.getTimestamp("data_puncte"));
        result.setNrCard(rs.getString("nr_card"));
        result.setTipCard(rs.getInt("tip_card"));
        result.setCodSync(rs.getString("cod_sync"));
        result.setLocatie(rs.getString("locatie"));
        result.setEvDefName(rs.getString("ev_def_label"));
        return result;
    }

    public EventClients getEventClientByCodSync(String codSync) throws SQLException {
        EventClients result = null;
        this.getEventClientByCodSync.setString(1, codSync);
        ResultSet rs = this.getEventClientByCodSync.executeQuery();
        if (rs.next()) {
            result = this.getEventClientFromRS(rs);
        }
        rs.close();
        return result;
    }

    public Vector<EventClients> getAllEventsClientsForClient(Integer idClient) throws SQLException {
        Vector<EventClients> result = new Vector<EventClients>();
        this.getEventClientByClientId.setInt(1, idClient);
        ResultSet rs = this.getEventClientByClientId.executeQuery();
        while (rs.next()) {
            EventClients evcl = this.getEventClientFromRS(rs);
            result.add(evcl);
        }
        rs.close();
        return result;
    }

    public Vector<EventInstance> getCurrentEventInstances() throws SQLException {
        Vector<EventInstance> result = new Vector<EventInstance>();
        ResultSet rs = this.getCurrentEvInstances.executeQuery();
        while (rs.next()) {
            EventInstance evInstance = this.getEventInstanceFromRS(rs);
            result.add(evInstance);
        }
        rs.close();
        return result;
    }

    public void updateEventDefById(EventDef eventDef) throws SQLException {
        this.updateEventDefById.setInt(1, eventDef.getTip_eveniment().code);
        this.updateEventDefById.setInt(2, eventDef.getIdTipCont());
        this.updateEventDefById.setInt(3, eventDef.getPuncte());
        this.updateEventDefById.setInt(4, eventDef.getDeltaInainte());
        this.updateEventDefById.setInt(5, eventDef.getDeltaDupa());
        this.updateEventDefById.setInt(6, eventDef.getSmsPeriod());
        this.updateEventDefById.setInt(7, eventDef.getEmailPeriod());
        this.updateEventDefById.setString(8, eventDef.getLabel());
        this.updateEventDefById.setBoolean(9, eventDef.isActiv());
        this.updateEventDefById.setInt(10, eventDef.getStatus());
        this.updateEventDefById.setInt(11, eventDef.getId());
        this.updateEventDefById.executeUpdate();
    }

    public void deleteEventDefSetStatusDeleted(EventDef eventDef) throws SQLException {
        this.setStatusDeletedToEvDef.setInt(1, eventDef.getId());
        this.setStatusDeletedToEvDef.executeUpdate();
    }

    public Vector getRaportClientiActivi(Integer locationId, Integer year) throws SQLException {
        Vector<Object> result = new Vector<Object>();
        result.add("<html><b>Clienti activi</b></html>");
        for (int i = 0; i < 12; ++i) {
            Date firstDay = DateUtils.getFirstDay(i, year);
            Date lastDay = DateUtils.getLastDay(i, year);
            String monthsSQL = "select locations.id, locations.name, count(distinct(ev_clienti.id_client)) as clienti from ev_clienti inner join ev_def on ev_def.id = ev_clienti.id_ev_def inner join locations on ev_clienti.id_locatie = locations.id where ev_def.tip = " + FidelityLogic.TIP_EVENIMENT.DAILY.code + " and ev_clienti.data_puncte >= '" + firstDay + "'" + " and ev_clienti.data_puncte <= '" + lastDay + "'";
            if (locationId != -1) {
                monthsSQL = monthsSQL + " and locations.id = " + locationId;
            }
            monthsSQL = monthsSQL + " group by locations.id, locations.name";
            ResultSet rs = SqlUtils.executeQuery(monthsSQL, this.connection);
            Integer clientiFull = 0;
            while (rs.next()) {
                Integer clienti = rs.getInt("clienti");
                clientiFull = clientiFull + clienti;
            }
            result.add(clientiFull);
        }
        int z = 13;
        for (int j = year.intValue(); j > year - 3; --j) {
            Date firstDayInYear = DateUtils.getFirstDay(0, j);
            Date lastDayInYear = DateUtils.getLastDay(11, j);
            Date today = new Date();
            String totalYearSQL = "select locations.id, locations.name, count(distinct(ev_clienti.id_client)) as clienti from ev_clienti inner join ev_def on ev_def.id = ev_clienti.id_ev_def inner join locations on ev_clienti.id_locatie = locations.id where ev_def.tip = " + FidelityLogic.TIP_EVENIMENT.DAILY.code + " and ev_clienti.data_puncte >= '" + firstDayInYear + "'" + " and ev_clienti.data_puncte <= '" + lastDayInYear + "'";
            if (locationId != -1) {
                totalYearSQL = totalYearSQL + " and locations.id = " + locationId;
            }
            totalYearSQL = totalYearSQL + " group by locations.id, locations.name";
            ResultSet rs = SqlUtils.executeQuery(totalYearSQL, this.connection);
            Integer clientiFull = 0;
            while (rs.next()) {
                Integer clienti = rs.getInt("clienti");
                clientiFull = clientiFull + clienti;
            }
            result.add(clientiFull);
            ++z;
        }
        return result;
    }

    public Vector getRaportVizite(Integer locationId, Integer year) throws SQLException {
        Vector<Object> result = new Vector<Object>();
        result.add("<html><b>Vizite</b></html>");
        for (int i = 0; i < 12; ++i) {
            Date firstDay = DateUtils.getFirstDay(i, year);
            Date lastDay = DateUtils.getLastDay(i, year);
            String monthsSQL = "select locations.id, locations.name, count(*) as vizite from ev_clienti inner join ev_def on ev_def.id = ev_clienti.id_ev_def inner join locations on ev_clienti.id_locatie = locations.id where ev_def.tip = " + FidelityLogic.TIP_EVENIMENT.DAILY.code + " and ev_clienti.data_puncte >= '" + firstDay + "'" + " and ev_clienti.data_puncte <= '" + lastDay + "'";
            if (locationId != -1) {
                monthsSQL = monthsSQL + " and locations.id = " + locationId;
            }
            monthsSQL = monthsSQL + " group by locations.id, locations.name ";
            ResultSet rs = SqlUtils.executeQuery(monthsSQL, this.connection);
            Integer viziteFull = 0;
            while (rs.next()) {
                Integer vizite = rs.getInt("vizite");
                viziteFull = viziteFull + vizite;
            }
            result.add(viziteFull);
        }
        Date today = new Date();
        for (int j = year.intValue(); j > year - 3; --j) {
            Date firstDayInYear = DateUtils.getFirstDay(0, j);
            Date lastDayInYear = DateUtils.getLastDay(11, j);
            String totalYearSQL = "select locations.id, locations.name, count(*) as vizite from ev_clienti inner join ev_def on ev_def.id = ev_clienti.id_ev_def inner join locations on ev_clienti.id_locatie = locations.id where ev_def.tip = " + FidelityLogic.TIP_EVENIMENT.DAILY.code + " and ev_clienti.data_puncte >= '" + firstDayInYear + "'" + " and ev_clienti.data_puncte <= '" + lastDayInYear + "'";
            if (locationId != -1) {
                totalYearSQL = totalYearSQL + " and locations.id = " + locationId;
            }
            totalYearSQL = totalYearSQL + " group by locations.id, locations.name ";
            ResultSet rs = SqlUtils.executeQuery(totalYearSQL, this.connection);
            Integer viziteFull = 0;
            while (rs.next()) {
                Integer vizite = rs.getInt("vizite");
                viziteFull = viziteFull + vizite;
            }
            result.add(viziteFull);
        }
        return result;
    }

    public Vector getRaportCarduriEmiseTotal(Integer locId, Integer year) throws SQLException {
        Vector<Object> result = new Vector<Object>();
        result.add("<html><b>Carduri emise</b><br>\n(total)</html>");
        for (int i = 0; i < 12; ++i) {
            ResultSet rs;
            Date firstDay = DateUtils.getFirstDay(i, year);
            Date lastDay = DateUtils.getLastDay(i, year);
            String monthsSQL = "select count(*) as nr_carduri from promotii_clienti ";
            if (locId != -1) {
                monthsSQL = monthsSQL + " inner join clienti on promotii_clienti.id_client = clienti.id inner join clients_locations on clients_locations.id_client = clienti.id  inner join locations on locations.id = clients_locations.id_location ";
            }
            monthsSQL = monthsSQL + "where promotii_clienti.dateadded >= '" + firstDay + "'" + "and promotii_clienti.dateadded <= '" + lastDay + "'";
            if (locId != -1) {
                monthsSQL = monthsSQL + " and locations.id = " + locId;
            }
            if (!(rs = SqlUtils.executeQuery(monthsSQL, this.connection)).next()) continue;
            Integer clienti = rs.getInt("nr_carduri");
            result.add(clienti);
        }
        int z = 13;
        for (int j = year.intValue(); j > year - 3; --j) {
            ResultSet rs;
            Date firstDayInYear = DateUtils.getFirstDay(0, j);
            Date lastDayInYear = DateUtils.getLastDay(11, j);
            Date today = new Date();
            String totalYearSQL = "select count(*) as nr_carduri from promotii_clienti ";
            if (locId != -1) {
                totalYearSQL = totalYearSQL + " inner join clienti on promotii_clienti.id_client = clienti.id inner join clients_locations on clients_locations.id_client = clienti.id  inner join locations on locations.id = clients_locations.id_location ";
            }
            totalYearSQL = totalYearSQL + " where promotii_clienti.dateadded >= '" + firstDayInYear + "'" + " and promotii_clienti.dateadded <= '" + lastDayInYear + "'";
            if (locId != -1) {
                totalYearSQL = totalYearSQL + " and locations.id = " + locId;
            }
            if ((rs = SqlUtils.executeQuery(totalYearSQL, this.connection)).next()) {
                Integer clienti = rs.getInt("nr_carduri");
                result.add(clienti);
            }
            ++z;
        }
        return result;
    }

    public Vector getRaportCarduriEmiseCumulat(Integer locId, Integer year) throws SQLException {
        Vector<Object> result = new Vector<Object>();
        result.add("<html><b>Carduri emise</b><br>\n(cumulat)</html>");
        for (int i = 0; i < 12; ++i) {
            ResultSet rs;
            Timestamp firstDay = DateUtils.getStartOfDays();
            Date lastDay = DateUtils.getLastDay(i, year);
            String monthsSQL = "select count(*) as nr_carduri from promotii_clienti ";
            if (locId != -1) {
                monthsSQL = monthsSQL + " inner join clienti on promotii_clienti.id_client = clienti.id inner join clients_locations on clients_locations.id_client = clienti.id  inner join locations on locations.id = clients_locations.id_location ";
            }
            monthsSQL = monthsSQL + "where promotii_clienti.dateadded >= '" + firstDay + "'" + "and promotii_clienti.dateadded <= '" + lastDay + "'";
            if (locId != -1) {
                monthsSQL = monthsSQL + " and locations.id = " + locId;
            }
            if ((rs = SqlUtils.executeQuery(monthsSQL, this.connection)).next()) {
                Integer clienti = rs.getInt("nr_carduri");
                result.add(clienti);
            }
            rs.close();
        }
        for (int j = year.intValue(); j > year - 3; --j) {
            result.add(" ");
        }
        return result;
    }

    public Vector<Vector> getRaportPuncteTotal(Integer locId, Integer year) throws SQLException {
        Vector<Vector> result = new Vector<Vector>();
        Hashtable<Integer, Vector> datasHashtable = new Hashtable<Integer, Vector>();
        for (int i = 0; i < 12; ++i) {
            Date firstDay = DateUtils.getFirstDay(i, year);
            Date lastDay = DateUtils.getLastDay(i, year);
            String monthsSQL = "select ev_def.id, ev_def.label, sum(ev_clienti.puncte_client) as puncte from ev_clienti  inner join ev_def on ev_def.id = ev_clienti.id_ev_def  inner join locations on locations.id = ev_clienti.id_locatie  where ev_clienti.data_puncte >= '" + firstDay + "'" + " and ev_clienti.data_puncte <= '" + lastDay + "'";
            if (locId != -1) {
                monthsSQL = monthsSQL + " and locations.id = " + locId;
            }
            monthsSQL = monthsSQL + " group by ev_def.label, ev_def.id";
            ResultSet rs = SqlUtils.executeQuery(monthsSQL, this.connection);
            while (rs.next()) {
                Integer id = rs.getInt("id");
                String label = rs.getString("label");
                int puncte = rs.getInt("puncte");
                Vector vector = (Vector)datasHashtable.get(id);
                if (vector != null) {
                    vector.add(i + 1, puncte);
                    continue;
                }
                Vector rowWithTitle = this.getEmptyRowWithTitle(16, label);
                rowWithTitle.add(i + 1, puncte);
                datasHashtable.put(id, rowWithTitle);
            }
        }
        int z = 13;
        for (int j = year.intValue(); j > year - 3; --j) {
            Date firstDayInYear = DateUtils.getFirstDay(0, j);
            Date lastDayInYear = DateUtils.getLastDay(11, j);
            String totalYearSQL = "select ev_def.id, ev_def.label, sum(ev_clienti.puncte_client) as puncte from ev_clienti  inner join ev_def on ev_def.id = ev_clienti.id_ev_def  inner join locations on locations.id = ev_clienti.id_locatie  where ev_clienti.data_puncte >= '" + firstDayInYear + "'" + " and ev_clienti.data_puncte <= '" + lastDayInYear + "'";
            if (locId != -1) {
                totalYearSQL = totalYearSQL + " and locations.id = " + locId;
            }
            totalYearSQL = totalYearSQL + " group by ev_def.label, ev_def.id";
            ResultSet rs = SqlUtils.executeQuery(totalYearSQL, this.connection);
            while (rs.next()) {
                Integer id = rs.getInt("id");
                String label = rs.getString("label");
                int puncte = rs.getInt("puncte");
                Vector vector = (Vector)datasHashtable.get(id);
                if (vector != null) {
                    vector.add(z, puncte);
                    continue;
                }
                Vector rowWithTitle = this.getEmptyRowWithTitle(16, label);
                rowWithTitle.add(z, puncte);
                datasHashtable.put(id, rowWithTitle);
            }
            ++z;
        }
        Vector rowWithTotals = this.getRowWithTitle(16, "Puncte (total)");
        for (int x = 1; x < 16; ++x) {
            int sum = 0;
            for (Integer integer : datasHashtable.keySet()) {
                Vector vector = (Vector)datasHashtable.get(integer);
                Integer value = (Integer)vector.get(x);
                sum += value.intValue();
            }
            rowWithTotals.add(x, sum);
        }
        result.add(rowWithTotals);
        for (Integer integer : datasHashtable.keySet()) {
            Vector vector = (Vector)datasHashtable.get(integer);
            result.add(vector);
        }
        return result;
    }

    public Vector<Vector> getRaportComenzi(Integer locId, Integer year) throws SQLException {
        Vector rowWithTitle;
        Vector vector;
        Vector<Vector> result = new Vector<Vector>();
        Hashtable<Integer, Vector> datasHashtable = new Hashtable<Integer, Vector>();
        for (int i = 0; i < 12; ++i) {
            Date firstDay = DateUtils.getFirstDay(i, year);
            Date lastDay = DateUtils.getLastDay(i, year);
            String monthsSQL = "select products.id, products.label, sales.ppu, count(products.id) as number from orders  inner join sales on sales.id_order = orders.id  inner join products on products.id = sales.id_product  inner join tables on tables.id = orders.id_table  inner join locations on locations.id = tables.id_locatie  where sales.saledate >= '" + firstDay + "'" + " and sales.saledate <= '" + lastDay + "'";
            if (locId != -1) {
                monthsSQL = monthsSQL + " and locations.id = " + locId;
            }
            monthsSQL = monthsSQL + " group by products.id, sales.ppu";
            ResultSet rs = SqlUtils.executeQuery(monthsSQL, this.connection);
            while (rs.next()) {
                Integer id = rs.getInt("id");
                String label = rs.getString("label");
                int number = rs.getInt("number");
                int ppu = rs.getInt("ppu");
                vector = (Vector)datasHashtable.get(id);
                if (vector != null) {
                    vector.add(i + 1, number);
                    continue;
                }
                rowWithTitle = this.getEmptyRowWithTitle(16, label + " (" + ppu + ")");
                rowWithTitle.add(i + 1, number);
                datasHashtable.put(id, rowWithTitle);
            }
        }
        int z = 13;
        for (int j = year.intValue(); j > year - 3; --j) {
            Date firstDayInYear = DateUtils.getFirstDay(0, j);
            Date lastDayInYear = DateUtils.getLastDay(11, j);
            String totalYearSQL = "select products.id, products.label, sum(sales.ppu * sales.quantity_float) as price from orders  inner join sales on sales.id_order = orders.id  inner join products on products.id = sales.id_product  inner join tables on tables.id = orders.id_table  inner join locations on locations.id = tables.id_locatie  where sales.saledate >= '" + firstDayInYear + "'" + " and  sales.saledate <= '" + lastDayInYear + "'";
            if (locId != -1) {
                totalYearSQL = totalYearSQL + " and locations.id = " + locId;
            }
            totalYearSQL = totalYearSQL + " group by products.id";
            ResultSet rs = SqlUtils.executeQuery(totalYearSQL, this.connection);
            while (rs.next()) {
                Integer id = rs.getInt("id");
                String label = rs.getString("label");
                int price = rs.getInt("price");
                vector = (Vector)datasHashtable.get(id);
                if (vector != null) {
                    vector.add(z, price);
                    continue;
                }
                rowWithTitle = this.getEmptyRowWithTitle(16, label);
                rowWithTitle.add(z, price);
                datasHashtable.put(id, rowWithTitle);
            }
            ++z;
        }
        Vector rowWithTotals = this.getRowWithTitle(16, "Comenzi");
        result.add(rowWithTotals);
        for (Integer integer : datasHashtable.keySet()) {
            Vector vector2 = (Vector)datasHashtable.get(integer);
            result.add(vector2);
        }
        return result;
    }

    private Vector getRowWithTitle(int numberOfColumns, String title) {
        Vector<String> result = new Vector<String>();
        for (int i = 0; i < numberOfColumns; ++i) {
            if (i == 0) {
                result.add("<html><b>" + title + "</b></html>");
                continue;
            }
            result.add(" ");
        }
        return result;
    }

    private Vector getEmptyRowWithTitle(int numberOfColumns, String title) {
        Vector<Object> result = new Vector<Object>();
        for (int i = 0; i < numberOfColumns; ++i) {
            if (i == 0) {
                result.add(title);
                continue;
            }
            result.add(0);
        }
        return result;
    }
}

