/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.restaurant.modules.fidelitybo;

import java.io.IOException;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Date;
import java.util.Hashtable;
import java.util.Vector;
import ro.atreides.clienti.ClientLogic;
import ro.atreides.clienti.ClientPersFizica;
import ro.atreides.restaurant.VpConfig;
import ro.atreides.restaurant.logic.RestLogic;
import ro.atreides.restaurant.modules.fidelitybo.EventClients;
import ro.atreides.restaurant.modules.fidelitybo.EventDef;
import ro.atreides.restaurant.modules.fidelitybo.EventDefInstanceBean;
import ro.atreides.restaurant.modules.fidelitybo.EventInstance;
import ro.atreides.restaurant.modules.fidelitybo.FidelityDao;
import ro.atreides.restaurant.modules.fidelitybo.PuncteBean;
import ro.atreides.restaurant.modules.fidelitybo.RaportComenziView;
import ro.atreides.restaurant.modules.fidelitybo.RaportPuncteView;
import ro.atreides.utils.Client;
import ro.atreides.utils.Constants;
import ro.atreides.utils.DateUtils;
import ro.atreides.utils.FileUtils;
import ro.atreides.utils.FloatUtils;
import ro.atreides.utils.Formatters;
import ro.atreides.utils.Location;
import ro.atreides.utils.Logger;
import ro.atreides.utils.db.ConnectionPool;
import ro.atreides.utils.db.ConnectionWrapper;

public class FidelityLogic {
    private static FidelityLogic instance = null;
    private ConnectionPool pool = ConnectionPool.getInstance();
    private boolean debugMode;
    private Integer logoutSeconds = 10;

    private FidelityLogic() {
    }

    private synchronized FidelityDao getDao() {
        ConnectionWrapper connection = this.pool.requestConnection();
        FidelityDao dao = null;
        while (dao == null) {
            dao = (FidelityDao)this.pool.getDao(FidelityDao.class, connection);
            if (dao != null) continue;
            this.pool.buildDao(FidelityDao.class.getName(), connection);
        }
        return dao;
    }

    public static synchronized FidelityLogic getInstance() {
        if (instance == null) {
            instance = new FidelityLogic();
        }
        return instance;
    }

    public Vector<TIP_EVENIMENT> getAllTipEvenimente() {
        Vector<TIP_EVENIMENT> result = new Vector<TIP_EVENIMENT>();
        for (TIP_EVENIMENT tip_eveniment : TIP_EVENIMENT.values()) {
            result.add(tip_eveniment);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector<EventDef> getAllEventDef(Vector<TIP_EVENIMENT> tips) {
        try {
            Vector<EventDef> allActiveEventsDefs;
            Vector<EventDef> vector = allActiveEventsDefs = this.getDao().getAllActiveEventsDefs(tips);
            return vector;
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            Vector<EventDef> vector = new Vector<EventDef>();
            return vector;
        }
        finally {
            try {
                this.pool.commit();
            }
            catch (SQLException e) {
                Logger.logException(this, (Exception)e);
            }
            this.pool.releaseConnection();
        }
    }

    public Vector<EventDef> getAllActiveEventDef(Vector<TIP_EVENIMENT> tips) {
        Vector<EventDef> result = new Vector<EventDef>();
        Vector<EventDef> allEventDef = this.getAllEventDef(tips);
        for (EventDef eventDef : allEventDef) {
            if (!eventDef.isActiv()) continue;
            result.add(eventDef);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector<PuncteBean> cardRead(int idClient, String card) {
        Vector<PuncteBean> result = new Vector<PuncteBean>();
        try {
            Vector allLocations = RestLogic.getInstance().getLocationsNoCommit(-1);
            for (Location location : allLocations) {
                if (!location.isActive()) continue;
                Vector<EventDefInstanceBean> allEvents = this.getDao().getAllActiveEventsNow(location.getId());
                for (EventDefInstanceBean eventBean : allEvents) {
                    String mess;
                    EventDef event = eventBean.getDefinition();
                    boolean eligibleEvent = false;
                    Date start = null;
                    Date end = null;
                    Date day = new Date();
                    day = DateUtils.getStartOfDay(day);
                    start = DateUtils.addMinutesToDate(day, -event.getDeltaInainte());
                    end = DateUtils.addMinutesToDate(day, event.getDeltaDupa());
                    switch (event.getTip_eveniment()) {
                        case DAILY: {
                            eligibleEvent = true;
                            break;
                        }
                        case BIRTHDAY: {
                            boolean endCondition;
                            ClientPersFizica cpf;
                            Client c = ClientLogic.getInstance().getClientByIdNoCommit(idClient);
                            if (!(c instanceof ClientPersFizica) || (cpf = (ClientPersFizica)c).getDataNasterii() == null) break;
                            Date dn = cpf.getDataNasterii();
                            int month = DateUtils.getMonthFromDate(dn);
                            int bDay = DateUtils.getDayFromDate(dn);
                            dn = DateUtils.getDayInCurrentYear(month, bDay);
                            Date dnS = start = DateUtils.getStartOfDay(DateUtils.addMinutesToDateConsiderDST(dn, -event.getDeltaInainte()));
                            Date dnE = end = DateUtils.addMinutesToDateConsiderDST(dn, event.getDeltaDupa() - 1);
                            boolean startCondition = day.equals(dnS) || day.after(dnS);
                            boolean bl = endCondition = day.equals(dnE) || day.before(dnE);
                            if (startCondition && endCondition) {
                                eligibleEvent = true;
                                Logger.logDebugVerbose(this, "Data nasterii IS A MATCH : \n Data nasterii : " + Formatters.DATE_TIME_SECONDS_MILLIS_FORMAT.format(cpf.getDataNasterii()) + "\n Data curenta : " + Formatters.DATE_TIME_SECONDS_MILLIS_FORMAT.format(day) + "\n dnS : " + Formatters.DATE_TIME_SECONDS_MILLIS_FORMAT.format(dnS) + "\n dnE : " + Formatters.DATE_TIME_SECONDS_MILLIS_FORMAT.format(dnE) + "\n event : " + event.getDebugString());
                                break;
                            }
                            Logger.logDebugVerbose(this, "Data nasterii not a match : \n Data nasterii : " + Formatters.DATE_TIME_SECONDS_MILLIS_FORMAT.format(cpf.getDataNasterii()) + "\n Data curenta : " + Formatters.DATE_TIME_SECONDS_MILLIS_FORMAT.format(day) + "\n dnS : " + Formatters.DATE_TIME_SECONDS_MILLIS_FORMAT.format(dnS) + "\n dnE : " + Formatters.DATE_TIME_SECONDS_MILLIS_FORMAT.format(dnE) + "\n event : " + event.getDebugString());
                            break;
                        }
                        case NAMEDAY: {
                            ClientPersFizica cpf;
                            Client c = ClientLogic.getInstance().getClientByIdNoCommit(idClient);
                            if (!(c instanceof ClientPersFizica) || (cpf = (ClientPersFizica)c).getDataNumelui() == null) break;
                            Date dn = cpf.getDataNumelui();
                            int month = DateUtils.getMonthFromDate(dn);
                            int bDay = DateUtils.getDayFromDate(dn);
                            int year = DateUtils.getYearFromDate(dn);
                            dn = DateUtils.getDayInCurrentYear(month, bDay);
                            Date dnS = start = DateUtils.getStartOfDay(DateUtils.addMinutesToDateConsiderDST(dn, -event.getDeltaInainte()));
                            Date dnE = end = DateUtils.addMinutesToDateConsiderDST(dn, event.getDeltaDupa() - 1);
                            if ((day.equals(dnS) || day.after(dnS)) && (day.equals(dnE) || day.before(dnE))) {
                                if (year <= 1900) break;
                                eligibleEvent = true;
                                Logger.logDebugVerbose(this, "Ziua numelui IS A MATCH : \n Ziua numelui : " + Formatters.DATE_TIME_SECONDS_MILLIS_FORMAT.format(cpf.getDataNumelui()) + "\n Data curenta : " + Formatters.DATE_TIME_SECONDS_MILLIS_FORMAT.format(day) + "\n dnS : " + Formatters.DATE_TIME_SECONDS_MILLIS_FORMAT.format(dnS) + "\n dnE : " + Formatters.DATE_TIME_SECONDS_MILLIS_FORMAT.format(dnE) + "\n event : " + event.getDebugString());
                                break;
                            }
                            Logger.logDebugVerbose(this, "Ziua numelui not a match : \n Ziua numelui : " + Formatters.DATE_TIME_SECONDS_MILLIS_FORMAT.format(cpf.getDataNumelui()) + "\n Data curenta : " + Formatters.DATE_TIME_SECONDS_MILLIS_FORMAT.format(day) + "\n dnS : " + Formatters.DATE_TIME_SECONDS_MILLIS_FORMAT.format(dnS) + "\n dnE : " + Formatters.DATE_TIME_SECONDS_MILLIS_FORMAT.format(dnE) + "\n event : " + event.getDebugString());
                            break;
                        }
                        case MANUAL: {
                            day = new Date();
                            start = DateUtils.addMinutesToDate(day, -event.getDeltaInainte());
                            end = DateUtils.addMinutesToDate(day, event.getDeltaDupa());
                            eligibleEvent = true;
                            EventInstance instanceEv = eventBean.getInstance();
                            if (instanceEv != null) {
                                start = instanceEv.getDataStart();
                                end = instanceEv.getDataStop();
                                break;
                            }
                            eligibleEvent = false;
                        }
                    }
                    if (!eligibleEvent) continue;
                    boolean alreadProcessedForClientAndPeriod = this.getDao().eventAlreadyProcessed(event.getId(), idClient, new Timestamp(start.getTime()), new Timestamp(end.getTime()));
                    if (alreadProcessedForClientAndPeriod) {
                        mess = "Already processed, skipping";
                        continue;
                    }
                    mess = "Not processed, adding";
                    int idTipCard = 1;
                    int idEvClient = this.getDao().addPuncteForClient(event.getId(), idClient, location.getId(), event.getPuncte(), card, idTipCard);
                    String codSyncEvClient = VpConfig.getInstance().codUnicDatabase + "_" + idEvClient;
                    this.getDao().updateEvClientCodSync(idEvClient, codSyncEvClient);
                    String detalii = event.getLabel();
                    if (VpConfig.getInstance().contClientLocationOnDetalii) {
                        detalii = detalii + " (" + location.getName() + ")";
                    }
                    ClientLogic.getInstance().adaugaTranzactieNoCommit(idTipCard, idClient, event.getPuncte(), detalii);
                    PuncteBean toAdd = new PuncteBean();
                    toAdd.setNrPuncte(event.getPuncte());
                    toAdd.setDescriere(event.getLabel());
                    result.add(toAdd);
                }
            }
            this.pool.commit();
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            result.clear();
            try {
                this.pool.rollBack();
            }
            catch (SQLException e1) {
                Logger.logException(this, (Exception)e);
            }
        }
        finally {
            this.pool.releaseConnection();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addEventInstanceLocally(EventDef eventDef, Vector<Location> locations) {
        try {
            for (Location loc : locations) {
                if (!loc.isActive()) continue;
                int minInainte = eventDef.getDeltaInainte();
                int minDupa = eventDef.getDeltaDupa();
                Date now = new Date();
                Date start = DateUtils.addMinutesToDate(now, -minInainte);
                Date stop = DateUtils.addMinutesToDate(now, minDupa);
                int idEvInstance = this.getDao().addEventInstance(eventDef.getId(), loc.getId(), new Timestamp(start.getTime()), new Timestamp(stop.getTime()), false);
                String codSync = VpConfig.getInstance().codUnicDatabase + "_" + idEvInstance;
                this.getDao().updateEvInstanceCodSync(idEvInstance, codSync);
            }
            this.pool.commit();
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            try {
                this.pool.rollBack();
            }
            catch (SQLException e1) {
                Logger.logException(this, (Exception)e);
            }
        }
        finally {
            this.pool.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector<EventInstance> getEvenimenteReport(Hashtable criteria) {
        int idLocatie = -1;
        int idEvDef = -1;
        Date start = (Date)criteria.get(Constants.START_KEY);
        Date stop = (Date)criteria.get(Constants.STOP_KEY);
        try {
            Vector<EventInstance> vector = this.getDao().getEvInstancesReport(idLocatie, idEvDef, new Timestamp(start.getTime()), new Timestamp(stop.getTime()));
            return vector;
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            Vector<EventInstance> vector = new Vector<EventInstance>();
            return vector;
        }
        finally {
            try {
                this.pool.commit();
            }
            catch (SQLException e) {
                Logger.logException(this, (Exception)e);
            }
            this.pool.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector<RaportPuncteView> getAllPuncteView(Hashtable criteria) {
        Vector<RaportPuncteView> result = null;
        try {
            result = this.getDao().getAllPuncteForRaport(criteria);
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
        }
        finally {
            try {
                this.pool.commit();
            }
            catch (SQLException e) {
                Logger.logException(this, (Exception)e);
            }
            this.pool.releaseConnection();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector<RaportComenziView> getAllComenziView(Hashtable criteria) {
        Vector<RaportComenziView> result = new Vector();
        try {
            result = this.getDao().getAllComenziView(criteria);
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
        }
        finally {
            try {
                this.pool.commit();
            }
            catch (SQLException e) {
                Logger.logException(this, (Exception)e);
            }
            this.pool.releaseConnection();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EventDef getEventDefById(Integer id) {
        try {
            EventDef eventDef = this.getDao().getEventDefById(id);
            return eventDef;
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            EventDef eventDef = null;
            return eventDef;
        }
        finally {
            try {
                this.pool.commit();
            }
            catch (SQLException e) {
                Logger.logException(this, (Exception)e);
            }
            this.pool.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EventInstance getEventInstanceById(Integer id) {
        try {
            EventInstance eventInstance = this.getDao().getEventInstanceById(id);
            return eventInstance;
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            EventInstance eventInstance = null;
            return eventInstance;
        }
        finally {
            try {
                this.pool.commit();
            }
            catch (SQLException e) {
                Logger.logException(this, (Exception)e);
            }
            this.pool.releaseConnection();
        }
    }

    public void exportEv_DefToXml(int idData, String destinationFile, String remote) {
        StringBuffer bigFile = new StringBuffer();
        bigFile.append("<document>");
        EventDef ev_def = this.getEventDefById(idData);
        if (ev_def != null) {
            bigFile.append("<ev_def ");
            bigFile.append("\tid=\"" + ev_def.getId() + "\"\n");
            bigFile.append("\tlabel=\"" + ev_def.getLabel() + "\"\n");
            bigFile.append("\ttip=\"" + ev_def.getTip_eveniment().code + "\"\n");
            bigFile.append("\tactiv=\"" + ev_def.isActiv() + "\"\n");
            bigFile.append("\ttipcont=\"" + ev_def.getIdTipCont() + "\"\n");
            bigFile.append("\tpuncte_def=\"" + ev_def.getPuncte() + "\"\n");
            bigFile.append("\tdelta_t_inainte=\"" + ev_def.getDeltaInainte() + "\"\n");
            bigFile.append("\tdelta_t_dupa=\"" + ev_def.getDeltaDupa() + "\"\n");
            bigFile.append("\tnotify_sms_period=\"" + ev_def.getSmsPeriod() + "\"\n");
            bigFile.append("\tnotify_email_period=\"" + ev_def.getEmailPeriod() + "\"\n");
            bigFile.append("\tcod_sync=\"" + ev_def.getCodSync() + "\"\n");
            bigFile.append("\tstatus=\"" + ev_def.getStatus() + "\"\n");
            bigFile.append("/>\n");
        }
        bigFile.append("</document>");
        try {
            FileUtils.writeTextToFile(destinationFile, bigFile.toString());
        }
        catch (IOException e) {
            Logger.logException(this, (Exception)e);
        }
    }

    public void exportEv_InstanceToXml(int idData, String destinationFile, String remote) {
        StringBuffer bigFile = new StringBuffer();
        bigFile.append("<document>");
        EventInstance evI = this.getEventInstanceById(idData);
        if (evI != null) {
            int idLocatie = evI.getIdLocatie();
            Location loc = RestLogic.getInstance().getLocationById(idLocatie);
            EventDef eventDef = FidelityLogic.getInstance().getEventDefById(evI.getIdEventDef());
            bigFile.append("<ev_instance ");
            bigFile.append("\tid=\"" + evI.getId() + "\"\n");
            bigFile.append("\tid_locatie=\"" + idLocatie + "\"\n");
            bigFile.append("\tcod_locatie=\"" + loc.getCod() + "\"\n");
            bigFile.append("\tid_ev_def=\"" + evI.getIdEventDef() + "\"\n");
            bigFile.append("\tcod_sync_id_def=\"" + eventDef.getCodSync() + "\"\n");
            bigFile.append("\tdata_start=\"" + evI.getDataStart() + "\"\n");
            bigFile.append("\tdata_stop=\"" + evI.getDataStop() + "\"\n");
            bigFile.append("\tcod_sync=\"" + evI.getCodSync() + "\"\n");
            bigFile.append("\tdeleted=\"" + evI.isDeleted() + "\"\n");
            bigFile.append("/>\n");
        }
        bigFile.append("</document>");
        try {
            FileUtils.writeTextToFile(destinationFile, bigFile.toString());
        }
        catch (IOException e) {
            Logger.logException(this, (Exception)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EventDef getEventDefByCodSync(String codSync) {
        try {
            EventDef eventDef = this.getDao().getEventDefByCodSync(codSync);
            return eventDef;
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            EventDef eventDef = null;
            return eventDef;
        }
        finally {
            try {
                this.pool.commit();
            }
            catch (SQLException e) {
                Logger.logException(this, (Exception)e);
            }
            this.pool.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EventInstance getEventInstanceByCodSync(String codSync) {
        try {
            EventInstance eventInstance = this.getDao().getEventInstanceByCodSync(codSync);
            return eventInstance;
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            EventInstance eventInstance = null;
            return eventInstance;
        }
        finally {
            try {
                this.pool.commit();
            }
            catch (SQLException e) {
                Logger.logException(this, (Exception)e);
            }
            this.pool.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateEventDefWhereCodSync(EventDef eventDef) {
        try {
            this.getDao().updateEventDefWhereCodSync(eventDef);
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
        }
        finally {
            try {
                this.pool.commit();
            }
            catch (SQLException e) {
                Logger.logException(this, (Exception)e);
            }
            this.pool.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateEventInstanceWhereCodSync(EventInstance eventInstance) {
        try {
            this.getDao().updateEventInstanceWhereCodSync(eventInstance);
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
        }
        finally {
            try {
                this.pool.commit();
            }
            catch (SQLException e) {
                Logger.logException(this, (Exception)e);
            }
            this.pool.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addEventDef(EventDef eventDef) {
        try {
            int idEvDef = this.getDao().addEventDef(eventDef);
            if (eventDef.getCodSync() != null) {
                this.getDao().updateEventDefCodSync(idEvDef, eventDef.getCodSync());
            } else {
                this.getDao().updateEventDefCodSync(idEvDef, VpConfig.getInstance().codUnicDatabase + "_" + idEvDef);
            }
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
        }
        finally {
            try {
                this.pool.commit();
            }
            catch (SQLException e) {
                Logger.logException(this, (Exception)e);
            }
            this.pool.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addEventInstance(EventInstance eventInstance) {
        try {
            int idEvInstance = this.getDao().addEventInstance(eventInstance.getIdEventDef(), eventInstance.getIdLocatie(), eventInstance.getDataStart(), eventInstance.getDataStop(), eventInstance.isDeleted());
            this.getDao().updateEvInstanceCodSync(idEvInstance, eventInstance.getCodSync());
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
        }
        finally {
            try {
                this.pool.commit();
            }
            catch (SQLException e) {
                Logger.logException(this, (Exception)e);
            }
            this.pool.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteEventInstance(EventInstance eventInstance) {
        try {
            this.getDao().setEventInstanceDeletedStatusById(eventInstance.getId(), true);
            this.pool.commit();
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            try {
                this.pool.rollBack();
            }
            catch (SQLException e1) {
                Logger.logException(this, (Exception)e);
            }
        }
        finally {
            this.pool.releaseConnection();
        }
    }

    public void exportEv_ClientToXml(int idData, String destinationFile, String remote) {
        StringBuffer bigFile = new StringBuffer();
        bigFile.append("<document>");
        EventClients evCl = this.getEventClientById(idData);
        if (evCl != null) {
            int idLocatie = evCl.getIdLocatie();
            Location loc = RestLogic.getInstance().getLocationById(idLocatie);
            EventDef eventDef = FidelityLogic.getInstance().getEventDefById(evCl.getIdEventDef());
            Integer idClient = evCl.getIdClient();
            ClientPersFizica persFizica = (ClientPersFizica)ClientLogic.getInstance().getClientById(idClient);
            bigFile.append("<ev_client ");
            bigFile.append("\tid=\"" + evCl.getId() + "\"\n");
            bigFile.append("\tid_locatie=\"" + idLocatie + "\"\n");
            bigFile.append("\tcod_locatie=\"" + loc.getCod() + "\"\n");
            bigFile.append("\tclient_cod_sync=\"" + persFizica.getCodSyncClient() + "\"\n");
            bigFile.append("\tid_ev_def=\"" + evCl.getIdEventDef() + "\"\n");
            bigFile.append("\tcod_sync_id_def=\"" + eventDef.getCodSync() + "\"\n");
            bigFile.append("\tpuncte_client=\"" + evCl.getNrPuncte() + "\"\n");
            bigFile.append("\tdata_puncte=\"" + evCl.getDataPuncte() + "\"\n");
            bigFile.append("\tnr_card=\"" + evCl.getNrCard() + "\"\n");
            bigFile.append("\ttip_card=\"" + evCl.getTipCard() + "\"\n");
            bigFile.append("\tcod_sync=\"" + evCl.getCodSync() + "\"\n");
            bigFile.append("/>\n");
        }
        bigFile.append("</document>");
        try {
            FileUtils.writeTextToFile(destinationFile, bigFile.toString());
        }
        catch (IOException e) {
            Logger.logException(this, (Exception)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EventClients getEventClientById(Integer id) {
        EventClients result = null;
        try {
            result = this.getDao().getEventClientById(id);
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
        }
        finally {
            try {
                this.pool.commit();
            }
            catch (SQLException e) {
                Logger.logException(this, (Exception)e);
            }
            this.pool.releaseConnection();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addEventClient(EventClients eventClient) {
        try {
            this.getDao().addEventClient(eventClient);
            this.pool.commit();
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            try {
                this.pool.commit();
            }
            catch (SQLException e1) {
                Logger.logException(this, (Exception)e1);
            }
        }
        finally {
            this.pool.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EventClients getEventClientByCodSync(String codSync) {
        try {
            EventClients eventClients = this.getDao().getEventClientByCodSync(codSync);
            return eventClients;
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
        }
        finally {
            try {
                this.pool.commit();
            }
            catch (SQLException e) {
                Logger.logException(this, (Exception)e);
            }
            this.pool.releaseConnection();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector<EventClients> getAllEventClientsForClient(Integer idClient) {
        try {
            Vector<EventClients> vector = this.getDao().getAllEventsClientsForClient(idClient);
            return vector;
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
        }
        finally {
            try {
                this.pool.commit();
            }
            catch (SQLException e) {
                Logger.logException(this, (Exception)e);
            }
            this.pool.releaseConnection();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector<EventInstance> getCurrentEventInstances() {
        try {
            Vector<EventInstance> vector = this.getDao().getCurrentEventInstances();
            return vector;
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
        }
        finally {
            try {
                this.pool.commit();
            }
            catch (SQLException e) {
                Logger.logException(this, (Exception)e);
            }
            this.pool.releaseConnection();
        }
        return new Vector<EventInstance>();
    }

    public void setDebugMode(boolean debugMode) {
        this.debugMode = debugMode;
    }

    public boolean isDebugMode() {
        return this.debugMode;
    }

    public Integer getLogoutSeconds() {
        return this.logoutSeconds;
    }

    public void setLogoutSeconds(Integer logoutSeconds) {
        this.logoutSeconds = logoutSeconds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateEventDefById(EventDef eventDef) {
        try {
            this.getDao().updateEventDefById(eventDef);
            this.pool.commit();
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
        }
        finally {
            this.pool.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteEventDef(EventDef eventDef) {
        try {
            this.getDao().deleteEventDefSetStatusDeleted(eventDef);
            this.pool.commit();
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
        }
        finally {
            this.pool.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector<Vector> getRaportCentralizator(Hashtable criteria) {
        Vector<Vector> result = new Vector<Vector>();
        Vector<String> empty = new Vector<String>();
        for (int i = 0; i < 16; ++i) {
            empty.add(" ");
        }
        try {
            Integer year = (Integer)criteria.get("year");
            Vector<String> header = new Vector<String>();
            header.add("");
            header.add("Ian " + year);
            header.add("Feb " + year);
            header.add("Mar " + year);
            header.add("Apr " + year);
            header.add("Mai " + year);
            header.add("Iun " + year);
            header.add("Iul " + year);
            header.add("Aug " + year);
            header.add("Sep " + year);
            header.add("Oct " + year);
            header.add("Noi " + year);
            header.add("Dec " + year);
            header.add("\u00d8 " + year);
            header.add("\u00d8 " + (year - 1));
            header.add("\u00d8 " + (year - 2));
            result.add(header);
            Hashtable<Integer, Location> locationHash = new Hashtable<Integer, Location>();
            Vector<Integer> locationIDS = new Vector<Integer>();
            if (criteria.get("cu sali") != null) {
                Vector locations = RestLogic.getInstance().getLocations();
                for (Object location : locations) {
                    Location l = (Location)location;
                    locationIDS.add(l.getId());
                    locationHash.put(l.getId(), l);
                }
            } else {
                locationIDS.add(-1);
            }
            for (Integer locId : locationIDS) {
                result.add(empty);
                if (locId != -1) {
                    result.add(this.getRowWithTitle(16, ((Location)locationHash.get(locId)).getName()));
                }
                Vector raportCarduriEmiseTotal = this.getDao().getRaportCarduriEmiseTotal(locId, year);
                result.add(raportCarduriEmiseTotal);
                Vector raportCarduriEmiseCumulat = this.getDao().getRaportCarduriEmiseCumulat(locId, year);
                result.add(raportCarduriEmiseCumulat);
                Vector raportVizite = this.getDao().getRaportVizite(locId, year);
                result.add(raportVizite);
                Vector raportClientiActivi = this.getDao().getRaportClientiActivi(locId, year);
                result.add(raportClientiActivi);
                Vector rowWithTitle = this.getRowWithTitle(16, "Activitate");
                for (int i = 1; i < 16; ++i) {
                    Object o;
                    if (i >= 7) {
                        System.out.println("Coloana " + i);
                    }
                    if (!((o = raportCarduriEmiseCumulat.get(i)) instanceof Integer)) continue;
                    Integer totalCarduriEmise = (Integer)o;
                    Integer act = (Integer)raportClientiActivi.get(i);
                    Double percentage = null;
                    percentage = totalCarduriEmise == 0 ? new Double(0.0) : Double.valueOf((double)act.intValue() * new Double(100.0) / (double)totalCarduriEmise.intValue());
                    rowWithTitle.add(i, FloatUtils.roundDoubleUp(percentage, 2) + "%");
                }
                result.add(rowWithTitle);
                result.addAll(this.getDao().getRaportPuncteTotal(locId, year));
                Vector<Vector> raportComenzi = this.getDao().getRaportComenzi(locId, year);
                result.addAll(raportComenzi);
            }
            Vector<Vector> vector = result;
            return vector;
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            Vector<Vector> vector = null;
            return vector;
        }
        finally {
            try {
                this.pool.commit();
            }
            catch (SQLException e) {
                Logger.logException(this, (Exception)e);
            }
            this.pool.releaseConnection();
        }
    }

    private Vector getRowWithTitle(int numberOfColumns, String title) {
        Vector<String> result = new Vector<String>();
        for (int i = 0; i < numberOfColumns; ++i) {
            if (i == 0) {
                result.add("<html><b>" + title + "</b></html>");
                continue;
            }
            result.add(" ");
        }
        return result;
    }

    public static enum TIP_EVENIMENT {
        DAILY(1),
        BIRTHDAY(2),
        MANUAL(3),
        NAMEDAY(4);

        int code;

        private TIP_EVENIMENT(int cod) {
            this.code = cod;
        }

        public int getCode() {
            return this.code;
        }

        public static TIP_EVENIMENT getEvenimentByCode(int code) {
            if (code == DAILY.getCode()) {
                return DAILY;
            }
            if (code == BIRTHDAY.getCode()) {
                return BIRTHDAY;
            }
            if (code == MANUAL.getCode()) {
                return MANUAL;
            }
            if (code == NAMEDAY.getCode()) {
                return NAMEDAY;
            }
            return null;
        }
    }
}

