/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.restaurant.modules.fidelityfo;

import java.awt.AWTEvent;
import java.awt.Color;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.LayoutManager;
import java.awt.Toolkit;
import java.awt.event.AWTEventListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.border.TitledBorder;
import net.miginfocom.swing.MigLayout;
import ro.atreides.clienti.ClientLogic;
import ro.atreides.clienti.ClientPersFizica;
import ro.atreides.clienti.FisaClient;
import ro.atreides.promo.ClientPromotieView;
import ro.atreides.promo.PromotionLogic;
import ro.atreides.restaurant.VpConfig;
import ro.atreides.restaurant.gui.GuiUtilsRest;
import ro.atreides.restaurant.logic.RestLogic;
import ro.atreides.restaurant.modules.fidelitybo.EventInstance;
import ro.atreides.restaurant.modules.fidelitybo.FidelityLogic;
import ro.atreides.restaurant.modules.fidelitybo.PuncteBean;
import ro.atreides.restaurant.modules.fidelityfo.SimpleProductOrderingList;
import ro.atreides.users.User;
import ro.atreides.users.UsersLogic;
import ro.atreides.utils.Client;
import ro.atreides.utils.Constants;
import ro.atreides.utils.DateUtils;
import ro.atreides.utils.Formatters;
import ro.atreides.utils.Logger;
import ro.atreides.utils.ReflectedJPanel;
import ro.atreides.utils.Utils;
import ro.atreides.utils.config.Config;
import ro.atreides.utils.gui.GuiUtils;
import ro.atreides.utils.gui.JMultilineLabel;
import ro.atreides.utils.gui.dialogs.DialogUtils;
import ro.atreides.utils.gui.table.AbstractTM;
import ro.atreides.utils.gui.table.TmInterface;
import ro.atreides.utils.multilang.LangRoAll;

public class FidelityFoPanel
extends ReflectedJPanel {
    private JButton logout;
    private JButton comanda;
    private String codAutentificare = "";
    private boolean codStarted = false;
    private boolean cardCuDelimitatori = false;
    private JMultilineLabel nume;
    private JMultilineLabel messageOnClientScreen = new JMultilineLabel();
    private JLabel puncteNoi;
    private JLabel acumulat;
    private JLabel messageOnWelcomeScreen = new JLabel("");
    private static final int FONT_SIZE = 30;
    private static final int FONT_MID_SIZE = 20;
    private static final int FONT_MID_SIZE2 = 25;
    private static final int FONT_SIZE_SMALLER = 16;
    private static final Font middleFont = new Font(null, 0, 20);
    private static final Font middleFont2 = new Font(null, 0, 25);
    private static final Font smallerFont = new Font(null, 0, 16);
    private Client client;
    private JPanel displayPanel;
    private static final Integer WELCOME_SCREEN = 1;
    private static final Integer CLIENT_SCREEN = 2;
    JLabel focusEater;
    private Vector<PuncteBean> puncteBeanData;
    private Vector<FisaClient> istoricData;
    private AbstractTM puncteTM;
    private AbstractTM istoricTM;
    private JPanel timersPanel;
    private Thread timers;
    private Long lastActionTime = System.currentTimeMillis();
    private JTable istoricTable;
    private JDialog comandaProduseDialog;

    private void display() {
        this.setLayout((LayoutManager)new MigLayout("fill"));
        this.displayPanel = this.getWelcomePanel();
        this.add((Component)this.displayPanel, "grow");
        this.timers = this.getTimersThread();
        this.timers.start();
        if (!FidelityLogic.getInstance().isDebugMode()) {
            new Thread(){

                @Override
                public void run() {
                    try {
                        while (!GuiUtils.currentFrame.isUndecorated()) {
                            Thread.sleep(500L);
                            SwingUtilities.invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    if (!GuiUtils.currentFrame.isUndecorated()) {
                                        GuiUtils.currentFrame = GuiUtilsRest.switchToFullScreen(GuiUtils.currentFrame);
                                    }
                                }
                            });
                        }
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
            }.start();
        }
        Toolkit.getDefaultToolkit().addAWTEventListener(new AWTEventListener(){

            @Override
            public void eventDispatched(AWTEvent event) {
                FidelityFoPanel.this.updateActionTime();
            }
        }, 32L);
        new Thread(){

            @Override
            public void run() {
                EventQueue eq = Toolkit.getDefaultToolkit().getSystemEventQueue();
                FidelityFoPanel.this.updateActionTime();
                Integer logoutSeconds = FidelityLogic.getInstance().getLogoutSeconds();
                while (true) {
                    long time = System.currentTimeMillis() - FidelityFoPanel.this.lastActionTime;
                    long secondsLeft = time / 1000L;
                    if (FidelityFoPanel.this.client != null) {
                        AWTEvent lastEvent = eq.peekEvent();
                        if (lastEvent == null) {
                            if (time > (long)(logoutSeconds * 1000 + 1)) {
                                FidelityFoPanel.this.logout.doClick();
                            }
                        } else {
                            FidelityFoPanel.this.updateActionTime();
                        }
                    }
                    if (FidelityFoPanel.this.logout != null) {
                        FidelityFoPanel.this.logout.setText("Logout (" + ((long)logoutSeconds.intValue() - secondsLeft) + ")");
                    }
                    try {
                        Thread.sleep(100L);
                        continue;
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                        continue;
                    }
                    break;
                }
            }
        }.start();
        this.displayPanel.requestFocus();
    }

    private void cardRead(String card) {
        System.out.println("card to process : " + card);
        Vector<ClientPromotieView> clientiPromotii = PromotionLogic.getInstance().getPromotiiClientForCard(card);
        boolean b = PromotionLogic.getInstance().cardClientExists(card);
        int clId = -1;
        if (b) {
            this.messageOnWelcomeScreen.setText("");
            this.changeScreens(CLIENT_SCREEN);
            for (ClientPromotieView clientPromotieView : clientiPromotii) {
                int idClient;
                clId = idClient = clientPromotieView.getIdClient();
                String numeClient = clientPromotieView.getClient();
                this.nume.setText(numeClient);
                this.puncteBeanData = FidelityLogic.getInstance().cardRead(idClient, card);
                this.puncteTM.refresh(this.puncteBeanData);
                this.refreshAcumulatLabel();
                Double detaliiConturi = ClientLogic.getInstance().getTotalDetaliiConturi(idClient);
                this.puncteNoi.setText(detaliiConturi + "");
                this.client = ClientLogic.getInstance().getClientById(idClient);
                this.nume.setText(this.client.toString());
            }
            Client clientById = ClientLogic.getInstance().getClientById(clId);
            if (clientById instanceof ClientPersFizica) {
                this.istoricData = ClientLogic.getInstance().getFisaClient(this.buildHashForFisa(clientById.getId()));
                Collections.sort(this.istoricData, new Comparator<FisaClient>(){

                    @Override
                    public int compare(FisaClient o1, FisaClient o2) {
                        return o2.getData().compareToIgnoreCase(o1.getData());
                    }
                });
                this.istoricTM.refresh(this.istoricData);
            }
        } else {
            this.messageOnWelcomeScreen.setText("Card neasociat. Va rugam adresati-va personalului !");
            new Thread(){

                @Override
                public void run() {
                    try {
                        Thread.sleep(2000L);
                    }
                    catch (InterruptedException e1) {
                        Logger.logException(this, (Exception)e1);
                    }
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            FidelityFoPanel.this.messageOnWelcomeScreen.setText("");
                        }
                    });
                }
            }.start();
        }
    }

    private JPanel getLeftPanel() {
        JPanel leftPanel = new JPanel((LayoutManager)new MigLayout("wrap 2", "[grow][grow]", "[][grow][]"));
        Font font = new Font(null, 0, 30);
        this.messageOnClientScreen.setMaxWidth(300);
        this.messageOnClientScreen.setText("");
        this.messageOnClientScreen.setFont(font);
        this.messageOnClientScreen.setForeground(Color.RED);
        leftPanel.add((Component)this.messageOnClientScreen, "growx, spanx 2");
        this.nume = new JMultilineLabel();
        this.nume.setMaxWidth(300);
        this.nume.setText("");
        this.nume.setFont(font);
        leftPanel.add((Component)this.nume, "growx, spanx 2");
        this.puncteBeanData = new Vector();
        this.puncteTM = this.getPuncteAcumulateTM();
        JTable puncteTable = new JTable(this.puncteTM);
        puncteTable.setFont(smallerFont);
        puncteTable.setRowHeight(puncteTable.getRowHeight() + 3);
        leftPanel.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                FidelityFoPanel.this.updateActionTime();
            }
        });
        JScrollPane pane = new JScrollPane(puncteTable);
        pane.setBorder(new TitledBorder("Nr Puncte"));
        leftPanel.add((Component)pane, "growx, span 2");
        JLabel labelOne = new JLabel("Ati acumulat : ", 2);
        labelOne.setFont(font);
        leftPanel.add((Component)labelOne, "growx");
        this.acumulat = new JLabel("0 puncte");
        this.acumulat.setFont(font);
        leftPanel.add((Component)this.acumulat, "growx");
        leftPanel.setBorder(new TitledBorder("Informatii"));
        return leftPanel;
    }

    private JPanel getButtonPanel() {
        JPanel result = new JPanel((LayoutManager)new MigLayout("fill"));
        this.logout = new JButton(LangRoAll.logout);
        this.logout.setFont(smallerFont);
        this.logout.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FidelityFoPanel.this.codAutentificare = "";
                FidelityFoPanel.this.codStarted = false;
                FidelityFoPanel.this.nume.setText("");
                FidelityFoPanel.this.puncteNoi.setText("");
                FidelityFoPanel.this.client = null;
                FidelityFoPanel.this.disposeComanda();
                FidelityFoPanel.this.changeScreens(WELCOME_SCREEN);
            }
        });
        result.add((Component)this.logout, "grow, hmin 50");
        this.comanda = new JButton(LangRoAll.comanda);
        this.comanda.setFont(smallerFont);
        this.comanda.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (FidelityFoPanel.this.client != null) {
                    User waiter = UsersLogic.getInstance().getUsersInGroup("group_fo_users").get(0);
                    SimpleProductOrderingList productOrderingList = new SimpleProductOrderingList(FidelityFoPanel.this.client, RestLogic.getInstance().getLocations(), waiter);
                    FidelityFoPanel.this.comandaProduseDialog = DialogUtils.getJDialog(productOrderingList, GuiUtils.currentFrame, "Comanda produse", 1.0, true);
                    productOrderingList.setParentDialog(FidelityFoPanel.this.comandaProduseDialog);
                    FidelityFoPanel.this.comandaProduseDialog.setVisible(true);
                    if (productOrderingList.isComandaFinalizata()) {
                        FisaClient fc1 = new FisaClient();
                        fc1.setData(Formatters.DATE_AND_TIME_FORMAT.format(new Date()));
                        fc1.setDetalii("Comanda curenta");
                        double totalComandat = productOrderingList.getTotalComandat();
                        fc1.setDebit(totalComandat);
                        fc1.setHighlight(true);
                        FidelityFoPanel.this.istoricData.add(0, fc1);
                        FidelityFoPanel.this.istoricTM.fireTableDataChanged();
                        FidelityFoPanel.this.puncteNoi.setText(FidelityFoPanel.this.puncteNoi.getText() + " - " + Utils.getString2Decimals(totalComandat));
                        FidelityFoPanel.this.messageOnClientScreen.setText("Comanda a dumneavoastra a fost preluata. Va rugam adresati-va personalului");
                        new Thread(){

                            @Override
                            public void run() {
                                try {
                                    Thread.sleep(10000L);
                                }
                                catch (InterruptedException e1) {
                                    Logger.logException(this, (Exception)e1);
                                }
                                SwingUtilities.invokeLater(new Runnable(){

                                    @Override
                                    public void run() {
                                        FidelityFoPanel.this.messageOnClientScreen.setText("");
                                    }
                                });
                            }
                        }.start();
                    }
                }
            }
        });
        result.add((Component)this.comanda, "grow, hmin 50");
        this.logout.setFocusable(false);
        this.comanda.setFocusable(false);
        result.setBorder(new TitledBorder(LangRoAll.actiuni));
        return result;
    }

    private JPanel getRightPanel() {
        JPanel result = new JPanel((LayoutManager)new MigLayout("", "[grow]", "[grow][]"));
        this.istoricData = new Vector();
        this.istoricTM = this.getIstoricPuncteTM();
        this.istoricTable = new JTable(this.istoricTM);
        this.istoricTable.setFont(smallerFont);
        this.istoricTable.setRowHeight(this.istoricTable.getRowHeight() + 3);
        result.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                FidelityFoPanel.this.updateActionTime();
            }
        });
        this.istoricTable.setSelectionMode(0);
        JScrollPane pane = new JScrollPane(this.istoricTable);
        this.istoricTable.getColumnModel().getColumn(2).setMaxWidth(100);
        this.istoricTable.getColumnModel().getColumn(2).setMinWidth(100);
        JLabel puncteAcum = new JLabel("Total puncte", 2);
        puncteAcum.setFont(new Font(null, 0, 30));
        this.puncteNoi = new JLabel("", 2);
        this.puncteNoi.setFont(new Font(null, 0, 30));
        result.setBorder(new TitledBorder("Istoric tranzactii"));
        result.add((Component)pane, "grow, span 2, wrap");
        result.add((Component)puncteAcum, "growx");
        result.add((Component)this.puncteNoi, "growx");
        return result;
    }

    @Override
    public void doStuff() {
        this.display();
    }

    public JPanel getClientPanel() {
        JPanel result = new JPanel((LayoutManager)new MigLayout("fill, wrap 2"));
        result.add((Component)this.getLeftPanel(), "grow, spany 2");
        result.add((Component)this.getRightPanel(), "grow, spany 2");
        result.add((Component)this.getButtonPanel(), "grow, span 2");
        return result;
    }

    public JPanel getWelcomePanel() {
        final ImageIcon imageResource = Utils.getImageResource("welcome.png");
        JPanel result = new JPanel((LayoutManager)new MigLayout("fill, rtl", "[]", "[][][][][][][]")){

            @Override
            protected void paintComponent(Graphics g) {
                super.paintComponent(g);
                g.drawImage(imageResource.getImage(), 0, 0, this.getWidth(), this.getHeight(), null);
            }
        };
        Font font = new Font(null, 0, 30);
        this.timersPanel = new JPanel((LayoutManager)new MigLayout("rtl"));
        this.timersPanel.setBackground(new Color(176, 149, 68, 0));
        this.messageOnWelcomeScreen.setForeground(Color.RED);
        this.messageOnWelcomeScreen.setFont(font);
        result.add((Component)this.messageOnWelcomeScreen, "wrap");
        result.add((Component)this.timersPanel, "growx, right");
        String stopDelimiters = Config.getInstance().getString("cardStopDelimiters");
        final Vector stopDelim = Utils.splitString(stopDelimiters, ',');
        String startDelimiters = Config.getInstance().getString("cardStartDelimiters");
        final Vector startDelim = Utils.splitString(startDelimiters, ',');
        this.focusEater = new JLabel("");
        this.focusEater.addKeyListener(new KeyListener(){
            private long lastRead = System.currentTimeMillis();

            @Override
            public void keyPressed(KeyEvent e) {
            }

            @Override
            public void keyTyped(KeyEvent e) {
                long now = System.currentTimeMillis();
                if (now > this.lastRead + 3000L) {
                    FidelityFoPanel.this.codStarted = false;
                    FidelityFoPanel.this.codAutentificare = "";
                }
                this.lastRead = now;
                char c = e.getKeyChar();
                System.out.println("char: " + c + " code : " + e.getKeyCode() + " keychar : " + e.getKeyChar() + " codAutentificare : " + FidelityFoPanel.this.codAutentificare);
                if (!FidelityFoPanel.this.codStarted) {
                    if (startDelim.size() > 0) {
                        for (int i = 0; i < startDelim.size(); ++i) {
                            String s = (String)startDelim.elementAt(i);
                            if (c != s.charAt(0)) continue;
                            FidelityFoPanel.this.codStarted = true;
                            FidelityFoPanel.this.codAutentificare = c + "";
                            FidelityFoPanel.this.cardCuDelimitatori = true;
                            return;
                        }
                        return;
                    }
                    FidelityFoPanel.this.codStarted = true;
                    FidelityFoPanel.this.codAutentificare = c + "";
                    FidelityFoPanel.this.cardCuDelimitatori = false;
                    return;
                }
                FidelityFoPanel.this.codAutentificare = FidelityFoPanel.this.codAutentificare + String.valueOf(c);
                String message = "Key : \"" + c + "\"";
                System.out.println(message);
                Logger.logDebugVerbose(this, message);
                boolean stopFound = false;
                if (stopDelim.size() > 0) {
                    for (int i = 0; i < stopDelim.size() && !stopFound; ++i) {
                        String s = (String)stopDelim.elementAt(i);
                        if (c != s.charAt(0)) continue;
                        stopFound = true;
                    }
                }
                if (stopFound && FidelityFoPanel.this.codAutentificare.length() > 0 || !FidelityFoPanel.this.cardCuDelimitatori && FidelityFoPanel.this.codAutentificare.length() >= VpConfig.getInstance().codFidelitateLength) {
                    Logger.logDebugVerbose(this, "Am citit : \"" + FidelityFoPanel.this.codAutentificare + "\"");
                    System.out.println("Am citit : \"" + FidelityFoPanel.this.codAutentificare + "\"");
                    FidelityFoPanel.this.cardRead(FidelityFoPanel.this.codAutentificare);
                    FidelityFoPanel.this.codStarted = false;
                    FidelityFoPanel.this.cardCuDelimitatori = false;
                    FidelityFoPanel.this.codAutentificare = "";
                }
            }

            @Override
            public void keyReleased(KeyEvent e) {
            }
        });
        this.focusEater.setFocusable(true);
        result.add((Component)this.focusEater, "growx, wrap");
        this.focusEater.requestFocus();
        return result;
    }

    private void changeScreens(Integer what) {
        this.updateActionTime();
        this.remove(this.displayPanel);
        if (what == WELCOME_SCREEN) {
            this.displayPanel = this.getWelcomePanel();
        }
        if (what == CLIENT_SCREEN) {
            this.displayPanel = this.getClientPanel();
        }
        this.add((Component)this.displayPanel, "grow");
        this.revalidate();
        if (what == WELCOME_SCREEN) {
            this.focusEater.requestFocus();
        }
    }

    private AbstractTM getPuncteAcumulateTM() {
        String[] columns = new String[]{"Puncte", "Descriere"};
        AbstractTM tm = new AbstractTM(columns, Utils.getStringClass(columns.length), new TmInterface(){

            @Override
            public Object getValueAt(int rowIndex, int columnIndex, Vector data) {
                PuncteBean puncteBean = (PuncteBean)FidelityFoPanel.this.puncteBeanData.get(rowIndex);
                switch (columnIndex) {
                    case 0: {
                        return puncteBean.getNrPuncte();
                    }
                    case 1: {
                        return puncteBean.getDescriere();
                    }
                }
                return null;
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return false;
            }

            @Override
            public void setValueAt(Object aValue, int rowIndex, int columnIndex, Vector data) {
            }
        });
        return tm;
    }

    private AbstractTM getIstoricPuncteTM() {
        String[] columns = new String[]{"Data", "Denumirea", "Numar Puncte"};
        AbstractTM tm = new AbstractTM(columns, Utils.getStringClass(columns.length), new TmInterface(){

            @Override
            public Object getValueAt(int rowIndex, int columnIndex, Vector data) {
                FisaClient x = (FisaClient)FidelityFoPanel.this.istoricData.get(rowIndex);
                switch (columnIndex) {
                    case 0: {
                        if (x.isHighlight()) {
                            return "<html><font color=\"red\" size=\"+1\">" + x.getData() + "</font></html>";
                        }
                        return x.getData();
                    }
                    case 1: {
                        if (x.isHighlight()) {
                            return "<html><font color=\"red\" size=\"+1\">" + x.getDetalii() + "</font></html>";
                        }
                        return x.getDetalii();
                    }
                    case 2: {
                        Double s = x.getCredit() > 0.0 ? x.getCredit() : (x.getDetalii().equals("Anterior") ? x.getDebit() : -x.getDebit());
                        if (x.isHighlight()) {
                            return "<html><font color=\"red\" size=\"+1\">" + Utils.getString2Decimals(s) + "</font></html>";
                        }
                        return Utils.getString2Decimals(s);
                    }
                }
                return null;
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return false;
            }

            @Override
            public void setValueAt(Object aValue, int rowIndex, int columnIndex, Vector data) {
            }
        });
        return tm;
    }

    private Hashtable buildHashForFisa(int idClient) {
        Hashtable<String, Comparable<Integer>> result = new Hashtable<String, Comparable<Integer>>();
        Date today = new Date();
        Date startDate = DateUtils.addDaysToDate(today, -45);
        result.put(Constants.CLIENT_KEY, Integer.valueOf(idClient));
        result.put("tip_cont", Integer.valueOf(-1));
        result.put(Constants.START_KEY, startDate);
        result.put(Constants.STOP_KEY, today);
        return result;
    }

    private void refreshAcumulatLabel() {
        Double result = new Double(0.0);
        for (PuncteBean puncteBean : this.puncteBeanData) {
            result = result + puncteBean.getNrPuncte();
        }
        this.acumulat.setText(result + " puncte");
    }

    private Thread getTimersThread() {
        Thread thread = new Thread(){
            Integer z = 30;
            Vector<EventInstance> items = new Vector();

            @Override
            public void run() {
                while (true) {
                    try {
                        while (true) {
                            if (this.z > 20) {
                                this.items.removeAllElements();
                                this.items = FidelityLogic.getInstance().getCurrentEventInstances();
                                this.z = 0;
                            }
                            FidelityFoPanel.this.timersPanel.removeAll();
                            if (this.items != null && this.items.size() > 0) {
                                for (EventInstance evi : this.items) {
                                    JPanel fill = FidelityFoPanel.this.getColoredPanel();
                                    fill.add((Component)FidelityFoPanel.this.getColoredJLabel(evi.getNumeEventDef(), Color.WHITE, middleFont2), "grow, wrap");
                                    String time = DateUtils.getStringTimeUntilDate(evi.getDataStop());
                                    fill.add((Component)FidelityFoPanel.this.getColoredJLabel(time, Color.WHITE, middleFont), "grow");
                                    FidelityFoPanel.this.timersPanel.add((Component)fill, "left");
                                    if (!time.equals("00:00:00")) continue;
                                    this.z = 30;
                                }
                            }
                            FidelityFoPanel.this.timersPanel.revalidate();
                            Thread.sleep(500L);
                            if (GuiUtils.currentFrame.isActive()) {
                                FidelityFoPanel.this.focusEater.requestFocus();
                            }
                            Integer i$ = this.z;
                            Integer n = this.z = Integer.valueOf(this.z + 1);
                        }
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                        continue;
                    }
                    break;
                }
            }
        };
        return thread;
    }

    private JLabel getColoredJLabel(String title, Color c, Font f) {
        JLabel result = new JLabel(title, 0);
        result.setFont(f);
        result.setForeground(c);
        return result;
    }

    private JPanel getColoredPanel() {
        JPanel fill = new JPanel((LayoutManager)new MigLayout(""));
        fill.setBackground(Color.red);
        return fill;
    }

    private void updateActionTime() {
        this.lastActionTime = System.currentTimeMillis();
    }

    private void disposeComanda() {
        if (this.comandaProduseDialog != null) {
            this.comandaProduseDialog.dispose();
        }
    }
}

