/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.restaurant.modules.fidelityfo;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.table.TableColumnModel;
import net.miginfocom.swing.MigLayout;
import ro.atreides.nomenclatura.NomeclaturaLogic;
import ro.atreides.nomenclatura.Product;
import ro.atreides.nomenclatura.Sectie;
import ro.atreides.restaurant.VpConfig;
import ro.atreides.restaurant.base.Sale;
import ro.atreides.restaurant.base.Table;
import ro.atreides.restaurant.gui.admin.prices.PricePanelEntry;
import ro.atreides.restaurant.gui.touch2.PreorderTableModel;
import ro.atreides.restaurant.logic.RestLogic;
import ro.atreides.users.User;
import ro.atreides.utils.Client;
import ro.atreides.utils.Order;
import ro.atreides.utils.Utils;
import ro.atreides.utils.gui.GuiUtils;
import ro.atreides.utils.gui.table.AbstractListPanel;
import ro.atreides.utils.gui.table.AbstractTM;
import ro.atreides.utils.gui.table.ColumnSizeProvider;
import ro.atreides.utils.gui.table.TmInterface;

public class SimpleProductOrderingList
extends JPanel {
    protected static final int SCROLLBAR_SIZE = 30;
    private Order order;
    private Client client;
    private Table _table;
    private Vector locations;
    private User waiter;
    private JDialog parentDialog;
    private static final int FONT_SIZE = 20;
    JLabel totalLabel;
    JLabel message;
    private double totalComandat;
    private boolean comandaFinalizata = false;

    public SimpleProductOrderingList(Client client, Vector locations, User waiter) {
        this.client = client;
        this.locations = locations;
        this.waiter = waiter;
        this.display();
    }

    public void setParentDialog(JDialog parentDialog) {
        this.parentDialog = parentDialog;
    }

    protected Order createOrderIfNull() {
        if (this.order == null) {
            this._table = RestLogic.getInstance().getFirstFreeTable(this.locations);
            this.order = RestLogic.getInstance().newOrder(this._table.getId(), this.waiter.getId());
            RestLogic.getInstance().setClientForOrder(this.order, this.client.getId(), "");
        }
        return this.order;
    }

    private void display() {
        this.setLayout((LayoutManager)new MigLayout("", "grow", "[grow][]"));
        final PreorderTableModel preorderTableModel = new PreorderTableModel();
        Dimension preferredSize = new Dimension(420, 200);
        AbstractListPanel produsePanel = new AbstractListPanel(){
            final String[] columns = new String[]{"Produs", "Puncte"};

            @Override
            public AbstractTM buildTableModel() {
                this.tm = new AbstractTM(this.buildColumns(), this.buildTypes(), new TmInterface(){

                    @Override
                    public Object getValueAt(int rowIndex, int columnIndex, Vector data) {
                        PricePanelEntry ide = (PricePanelEntry)data.elementAt(rowIndex);
                        switch (columnIndex) {
                            case 0: {
                                return ide.getProduct();
                            }
                            case 1: {
                                return Utils.getString2Decimals(ide.getPret());
                            }
                        }
                        return null;
                    }

                    @Override
                    public boolean isCellEditable(int rowIndex, int columnIndex) {
                        return false;
                    }

                    @Override
                    public void setValueAt(Object aValue, int rowIndex, int columnIndex, Vector data) {
                    }
                });
                return this.tm;
            }

            @Override
            public JPanel getBottomPanel() {
                return null;
            }

            @Override
            public Vector buildData() {
                return RestLogic.getInstance().getPricesPanelEntries();
            }

            @Override
            public String[] buildColumns() {
                return this.columns;
            }

            @Override
            public Class[] buildTypes() {
                return Utils.getStringClass(this.columns.length);
            }

            @Override
            public void doStuff() {
                this.display();
                GuiUtils.updateJTableRowSize(this.getJTable(), VpConfig.getInstance().touchTableFontSize);
                GuiUtils.setScrollSize(this.scrollPane, 30);
                this.table.addMouseListener(new MouseListener(){

                    @Override
                    public void mouseClicked(MouseEvent e) {
                    }

                    @Override
                    public void mousePressed(MouseEvent e) {
                        Point p;
                        JTable t = (JTable)e.getSource();
                        int selRow = t.rowAtPoint(p = e.getPoint());
                        if (selRow == -1) {
                            return;
                        }
                        PricePanelEntry pw = (PricePanelEntry)tm.getData().elementAt(selRow);
                        boolean canBeBought = RestLogic.getInstance().canBeBought(pw.getIdProduct(), SimpleProductOrderingList.this.client, preorderTableModel.getAllSales());
                        if (canBeBought) {
                            SimpleProductOrderingList.this.createOrderIfNull();
                            Product product = NomeclaturaLogic.getInstance().getProductById(pw.getIdProduct());
                            Sale s = RestLogic.getInstance().buildSale(product, 0.0, 1.0, "", SimpleProductOrderingList.this.order.getId(), -1, -1, -1, -1, System.currentTimeMillis(), 0);
                            preorderTableModel.addSale(s);
                            Vector allSales = preorderTableModel.getAllSales();
                            preorderTableModel.updateTable(allSales);
                            Double totalOnSales = RestLogic.getInstance().getTotalOnSales(allSales);
                            SimpleProductOrderingList.this.totalLabel.setText("TOTAL : " + totalOnSales);
                            SimpleProductOrderingList.this.totalComandat = totalOnSales;
                        } else {
                            SimpleProductOrderingList.this.message.setText("Puncte insuficiente");
                            new Thread(){

                                @Override
                                public void run() {
                                    try {
                                        Thread.sleep(2000L);
                                    }
                                    catch (InterruptedException interruptedException) {
                                        // empty catch block
                                    }
                                    SwingUtilities.invokeLater(new Runnable(){

                                        @Override
                                        public void run() {
                                            SimpleProductOrderingList.this.message.setText("");
                                        }
                                    });
                                }
                            }.start();
                        }
                    }

                    @Override
                    public void mouseReleased(MouseEvent e) {
                    }

                    @Override
                    public void mouseEntered(MouseEvent e) {
                    }

                    @Override
                    public void mouseExited(MouseEvent e) {
                    }
                });
            }
        };
        produsePanel.doStuff();
        String columnName = produsePanel.getJTable().getColumnName(1);
        produsePanel.getJTable().getColumn(columnName).setMaxWidth(100);
        this.add((Component)produsePanel, "grow");
        JTable preorderTable = new JTable(preorderTableModel);
        GuiUtils.updateJTableColumnSize(preorderTable, this.getPreOrderColumnSizeProvider());
        GuiUtils.updateJTableRowSize(preorderTable, VpConfig.getInstance().touchTableFontSize);
        TableColumnModel colModel = preorderTable.getColumnModel();
        colModel.getColumn(0).setMaxWidth(0);
        preorderTable.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
            }

            @Override
            public void mousePressed(MouseEvent e) {
                Point p;
                JTable t = (JTable)e.getSource();
                int selRow = t.rowAtPoint(p = e.getPoint());
                if (selRow == -1) {
                    return;
                }
                Sale s = (Sale)preorderTableModel.getAllSales().elementAt(selRow);
                s.setCantitateNoua(0.0);
                s.setCantitateMarcata(0.0);
                preorderTableModel.removeTempSale(s, selRow);
                preorderTableModel.fireTableDataChanged();
                Vector allSales = preorderTableModel.getAllSales();
                Double totalOnSales = RestLogic.getInstance().getTotalOnSales(allSales);
                SimpleProductOrderingList.this.totalLabel.setText("TOTAL : " + totalOnSales);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }
        });
        JScrollPane preorderScroll = new JScrollPane(preorderTable);
        preorderScroll.setMinimumSize(preferredSize);
        GuiUtils.setScrollSize(preorderScroll, 30);
        this.add((Component)preorderScroll, "wrap,grow");
        this.message = new JLabel("", 2);
        Font font = new Font(null, 0, 20);
        this.message.setFont(font);
        this.message.setForeground(Color.red);
        this.add((Component)this.message, "growx");
        this.totalLabel = new JLabel("TOTAL", 4);
        this.totalLabel.setFont(font);
        this.totalLabel.setForeground(Color.red);
        this.add((Component)this.totalLabel, "growx, wrap");
        JButton ok = new JButton("<html><center>COMANDA<br>&nbsp;</center></html>");
        ok.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Hashtable<Sectie, Vector<Sale>> nonEmptySectii = new Hashtable<Sectie, Vector<Sale>>();
                for (Sale sale : preorderTableModel.getAllSales()) {
                    int idProduct = sale.getIdProduct();
                    Product product = NomeclaturaLogic.getInstance().getProductById(idProduct);
                    Sectie c2 = NomeclaturaLogic.getInstance().getSectieByCategoryId(product.getIdCategorie());
                    Vector<Sale> tempSales = (Vector<Sale>)nonEmptySectii.get(c2);
                    if (tempSales == null) {
                        tempSales = new Vector<Sale>();
                    }
                    tempSales.add(sale);
                    nonEmptySectii.put(c2, tempSales);
                }
                for (Sectie sectie : nonEmptySectii.keySet()) {
                    Vector s1 = (Vector)nonEmptySectii.get(sectie);
                    RestLogic.getInstance().productsSold(s1, SimpleProductOrderingList.this.order, SimpleProductOrderingList.this._table, sectie, false, null);
                    SimpleProductOrderingList.this.comandaFinalizata = true;
                }
                SimpleProductOrderingList.this.parentDialog.dispose();
            }
        });
        this.add((Component)ok, "grow");
        JButton renunta = new JButton("<html><center>Renunta<br>&nbsp;</center></html>");
        renunta.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (SimpleProductOrderingList.this.order != null) {
                    RestLogic.getInstance().deleteOrderCommit(SimpleProductOrderingList.this.order.getId());
                }
                SimpleProductOrderingList.this.parentDialog.dispose();
            }
        });
        this.add((Component)renunta, "grow, span 2");
    }

    public boolean isComandaFinalizata() {
        return this.comandaFinalizata;
    }

    protected ColumnSizeProvider getPreOrderColumnSizeProvider() {
        ColumnSizeProvider preorderColumnSize = new ColumnSizeProvider(){

            @Override
            public int getColumnSize(int column) {
                switch (column) {
                    case 1: {
                        return 7;
                    }
                }
                return 1;
            }
        };
        return preorderColumnSize;
    }

    public double getTotalComandat() {
        return this.totalComandat;
    }
}

