/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.restaurant.modules.hotelanvelope;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.util.Date;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import mseries.Calendar.MDateSelectorConstraints;
import mseries.Calendar.MDefaultPullDownConstraints;
import mseries.ui.MDateEntryField;
import ro.atreides.clienti.ClientLogic;
import ro.atreides.clienti.gui.ClientEditDialog;
import ro.atreides.clienti.gui.ClientEditPanelProvider;
import ro.atreides.clienti.gui.PersFizicaAddEditPanel;
import ro.atreides.clienti.gui.PersJuridicaAddEditPanel;
import ro.atreides.nomenclatura.Categorie;
import ro.atreides.nomenclatura.NomeclaturaLogic;
import ro.atreides.nomenclatura.Product;
import ro.atreides.nomenclatura.Sectie;
import ro.atreides.promo.PriceWrapper;
import ro.atreides.promo.Promotion;
import ro.atreides.promo.PromotionLogic;
import ro.atreides.promo.PromotionPriceProviderImpl;
import ro.atreides.restaurant.logic.RestLogic;
import ro.atreides.restaurant.modules.hotelanvelope.Anvelopa;
import ro.atreides.restaurant.modules.hotelanvelope.AnvelopaEntry;
import ro.atreides.restaurant.modules.hotelanvelope.FisaState;
import ro.atreides.restaurant.modules.hotelanvelope.FisePanelView;
import ro.atreides.restaurant.modules.hotelanvelope.HaAddModelPanel;
import ro.atreides.restaurant.modules.hotelanvelope.HaLogic;
import ro.atreides.restaurant.modules.hotelanvelope.HotelAnvelopePanel;
import ro.atreides.restaurant.modules.hotelanvelope.ModelAnv;
import ro.atreides.restaurant.modules.hotelanvelope.PozitiaPeMasina;
import ro.atreides.stocks.StockLogic;
import ro.atreides.utils.CleanupRequired;
import ro.atreides.utils.Client;
import ro.atreides.utils.DateUtils;
import ro.atreides.utils.EventListener;
import ro.atreides.utils.Formatters;
import ro.atreides.utils.ReflectedJPanel;
import ro.atreides.utils.Utils;
import ro.atreides.utils.config.Config;
import ro.atreides.utils.gui.ComboUtils;
import ro.atreides.utils.gui.GuiUtils;
import ro.atreides.utils.gui.Validators;
import ro.atreides.utils.gui.dialogs.DialogUtils;
import ro.atreides.utils.gui.table.AbstractTM;
import ro.atreides.utils.gui.table.TmInterface;
import ro.atreides.utils.gui.xcombo.FilterableComboBoxModel;
import ro.atreides.utils.gui.xcombo.XComboBox;
import ro.atreides.utils.multilang.LangRoAll;

public class EditFisaPanel
extends ReflectedJPanel
implements CleanupRequired {
    private JComboBox pozitiaPeMasina;
    private JComboBox tarif;
    private JComboBox promotie;
    private XComboBox clienti;
    private XComboBox model;
    private MDateEntryField data;
    private MDateEntryField termen;
    private JTextField nrAuto;
    private JTextField nrKm;
    private JTextField codBare;
    private JTextField uzura;
    private JTextField observatii;
    private JTextField latime;
    private JTextField inaltime;
    private JTextField diametru;
    private JTextField dot;
    private JTextField time;
    private JTextField pozitiaInDepozit;
    private JTextField detaliiJanta;
    private FilterableComboBoxModel clientsComboModel;
    private FilterableComboBoxModel modelsComboModel;
    private JTable anvelopeTable;
    private AbstractTM anvelopeTm;
    private JButton temporar;
    private JButton avansCuBonFiscal;
    private JButton avansCuFactura;
    private JButton finalizareCuBonFiscal;
    private JButton finalizareCuFactura;
    private JButton tiparesteContract;
    private JButton renunta;
    private JButton depozitare;
    private JButton clientNou;
    private JButton codBareNou;
    private JButton modelNou;
    private JButton printEticheta;
    private JButton adaugaLaLista;
    private JButton ataseazaContract;
    private JButton tiparesteRestituire;
    private JButton ataseazaRestituire;
    private JButton veziContract;
    private JButton veziRestituire;
    private JButton intermediaraCuBonFiscal;
    private JButton intermediaraCuFactura;
    private HotelAnvelopePanel parent;
    private JCheckBox janta;
    private JLabel totalDePlataPerLuna;
    private JLabel totalDiscountPerLuna;
    private JLabel totalValoarePerLuna;
    private FisePanelView fisaToEdit = null;
    private double t1;
    private double t2;
    private double t3;

    public EditFisaPanel(HotelAnvelopePanel parent) {
        this.parent = parent;
        this.display();
    }

    private JPanel buildAnvelopeTable() {
        EditFisaPanel panel = this;
        JPanel result = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 1;
        c.anchor = 10;
        c.insets = new Insets(2, 2, 2, 2);
        c.gridx = 0;
        c.gridy = 0;
        this.anvelopeTm = new AbstractTM(new String[]{"Model", "Poz depozit", "Poz pe masina", "Uzura", "Obs"}, Utils.getStringClass(6), new TmInterface(){

            @Override
            public Object getValueAt(int rowIndex, int columnIndex, Vector data) {
                AnvelopaEntry ae = (AnvelopaEntry)data.elementAt(rowIndex);
                switch (columnIndex) {
                    case 0: {
                        return ae.getModel();
                    }
                    case 1: {
                        return ae.getPozitiaInDepozit();
                    }
                    case 2: {
                        return ae.getPozitiaPeMasina();
                    }
                    case 3: {
                        return ae.getUzura() + "";
                    }
                    case 4: {
                        return ae.getObservatii();
                    }
                }
                return "";
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return columnIndex == 1 && (EditFisaPanel.this.fisaToEdit == null || EditFisaPanel.this.fisaToEdit.getIdStatus() < FisaState.DEPOZITATA.getState());
            }

            @Override
            public void setValueAt(Object aValue, int rowIndex, int columnIndex, Vector data) {
                if (columnIndex == 1 && (EditFisaPanel.this.fisaToEdit == null || EditFisaPanel.this.fisaToEdit.getIdStatus() < FisaState.DEPOZITATA.getState())) {
                    AnvelopaEntry ae = (AnvelopaEntry)data.elementAt(rowIndex);
                    ae.setPozitiaInDepozit((String)aValue);
                }
            }
        });
        this.anvelopeTable = new JTable(this.anvelopeTm);
        this.anvelopeTable.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }

            @Override
            public void mousePressed(MouseEvent e) {
                JTable source = (JTable)e.getSource();
                final int selRow = source.rowAtPoint(e.getPoint());
                int modifiers = e.getModifiers();
                if ((modifiers & 0x10) > 0) {
                    return;
                }
                final JPopupMenu popup = new JPopupMenu();
                JMenuItem modifica = new JMenuItem(LangRoAll.modifica);
                modifica.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        popup.setVisible(false);
                        AnvelopaEntry ae = (AnvelopaEntry)EditFisaPanel.this.anvelopeTm.getObjectAt(selRow);
                        EditFisaPanel.this.completeAllAnvelopaFields(ae);
                        EditFisaPanel.this.eraseEntry(selRow);
                        EditFisaPanel.this.updatePretPeLuna();
                    }
                });
                JMenuItem sterge = new JMenuItem(LangRoAll.sterge);
                sterge.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        popup.setVisible(false);
                        if (DialogUtils.confirmDialog(EditFisaPanel.this.parent, "Doriti sa stergeti aceasta linie", LangRoAll.confirmare)) {
                            EditFisaPanel.this.eraseEntry(selRow);
                            EditFisaPanel.this.updatePretPeLuna();
                        }
                    }
                });
                if (EditFisaPanel.this.fisaToEdit == null || EditFisaPanel.this.fisaToEdit.getIdStatus() == FisaState.TEMPORAR.getState()) {
                    popup.add(modifica);
                    popup.add(sterge);
                }
                popup.setInvoker(EditFisaPanel.this.anvelopeTable);
                popup.show(e.getComponent(), e.getX(), e.getY());
            }

            @Override
            public void mouseReleased(MouseEvent e) {
            }
        });
        JScrollPane preorderScroll = new JScrollPane(this.anvelopeTable);
        c.weighty = 1.0;
        c.weightx = 1.0;
        result.add((Component)preorderScroll, c);
        return result;
    }

    private void eraseEntry(int selRow) {
        this.anvelopeTm.getData().removeElementAt(selRow);
        this.anvelopeTm.fireTableDataChanged();
    }

    private void completeAnvelopaFields(AnvelopaEntry ae) {
        if (ae == null) {
            this.codBare.setText("");
            this.latime.setText("");
            this.inaltime.setText("");
            this.diametru.setText("");
            this.model.setSelectedItem(null);
            this.uzura.setText("");
            this.dot.setText("");
            this.observatii.setText("");
        } else {
            this.inaltime.setText(Utils.getString2Decimals(ae.getInaltime()));
            this.latime.setText(Utils.getString2Decimals(ae.getLatime()));
            this.diametru.setText(Utils.getString2Decimals(ae.getDiametru()));
            this.uzura.setText(Utils.getString2Decimals(ae.getUzura()));
            this.dot.setText(ae.getDot());
            ModelAnv m = HaLogic.getInstance().getModelByCodBare(ae.getCodBare());
            this.model.setSelectedItem(m);
            this.codBare.setText(ae.getCodBare());
            this.observatii.setText(ae.getObservatii());
        }
    }

    private void completeIstoricFields(AnvelopaEntry ae) {
        if (ae == null) {
            this.janta.setSelected(false);
            this.detaliiJanta.setText("");
            this.detaliiJanta.setEnabled(false);
            this.pozitiaInDepozit.setText("");
            this.pozitiaPeMasina.setSelectedIndex(0);
            this.promotie.setSelectedIndex(0);
        } else {
            if (ae.isJanta()) {
                this.detaliiJanta.setText(ae.getDetaliiJanta());
                this.janta.setSelected(true);
                this.detaliiJanta.setEnabled(true);
            } else {
                this.detaliiJanta.setEnabled(false);
                this.detaliiJanta.setText("");
            }
            Product p = NomeclaturaLogic.getInstance().getProductById(ae.getIdProduct());
            this.tarif.setSelectedItem(p);
            this.pozitiaInDepozit.setText(ae.getPozitiaInDepozit());
            String s = ae.getPozitiaPeMasina();
            this.pozitiaPeMasina.setSelectedItem((Object)PozitiaPeMasina.valueByString(s));
            int idPromo = ae.getIdPromotie();
            if (idPromo > 0) {
                Promotion pr = PromotionLogic.getInstance().getPromotionById(idPromo);
                this.promotie.setSelectedItem(pr);
            } else {
                this.promotie.setSelectedIndex(0);
            }
        }
    }

    private void completeAllAnvelopaFields(AnvelopaEntry ae) {
        this.completeAnvelopaFields(ae);
        this.completeIstoricFields(ae);
    }

    private void completeClientFields(FisePanelView toEdit) {
        if (toEdit != null) {
            this.nrAuto.setText("" + toEdit.getAuto());
            this.nrKm.setText(toEdit.getNrKm() + "");
            int idClient = toEdit.getIdClient();
            Client c = ClientLogic.getInstance().getClientById(idClient);
            this.clienti.setSelectedItem(c);
            Timestamp t = toEdit.getData();
            this.data.setValue((Date)t);
            this.time.setText(Formatters.TIME_FORMAT.format(t));
        } else {
            Date d = new Date();
            this.data.setValue(d);
            this.time.setText(Formatters.TIME_FORMAT.format(d));
            this.clienti.setSelectedItem(null);
            this.nrAuto.setText("");
            this.nrKm.setText("");
        }
    }

    public void setFisaToEdit(FisePanelView toEdit) {
        this.fisaToEdit = toEdit;
        this.completeClientFields(toEdit);
        if (toEdit == null) {
            this.anvelopeTm.refresh(new Vector());
            this.anvelopeTm.fireTableDataChanged();
            this.setButtonsStatus(FisaState.TEMPORAR);
        } else {
            Vector fise = HaLogic.getInstance().getAnvelopeEntriesForFisa(toEdit.getIdFisa());
            this.anvelopeTm.refresh(fise);
            this.anvelopeTm.fireTableDataChanged();
            this.setButtonsStatus(FisaState.valueByInt(toEdit.getIdStatus()));
        }
        this.updatePretPeLuna();
    }

    private void enableClientPanel(boolean status) {
        this.clienti.setEnabled(status);
        this.clientNou.setEnabled(status);
        this.nrAuto.setEnabled(status);
        this.nrKm.setEnabled(status);
        this.data.setEnabled(status);
        this.time.setEnabled(status);
    }

    private void enableDetaliiAnvelopaPanel(boolean status) {
        this.codBare.setEnabled(status);
        this.codBareNou.setEnabled(status);
        this.model.setEnabled(status);
        this.modelNou.setEnabled(status);
        this.latime.setEnabled(status);
        this.inaltime.setEnabled(status);
        this.diametru.setEnabled(status);
        this.uzura.setEnabled(status);
        this.dot.setEnabled(status);
        this.pozitiaInDepozit.setEnabled(status);
        this.pozitiaPeMasina.setEnabled(status);
        this.observatii.setEnabled(status);
        this.tarif.setEnabled(status);
        this.janta.setEnabled(status);
        this.printEticheta.setEnabled(status);
    }

    private void setButtonsStatus(FisaState status) {
        this.temporar.setEnabled(false);
        this.tiparesteContract.setEnabled(false);
        this.ataseazaContract.setEnabled(false);
        this.veziContract.setEnabled(false);
        this.avansCuBonFiscal.setEnabled(false);
        this.avansCuFactura.setEnabled(false);
        this.depozitare.setEnabled(false);
        this.tiparesteRestituire.setEnabled(false);
        this.ataseazaRestituire.setEnabled(false);
        this.veziRestituire.setEnabled(false);
        this.finalizareCuBonFiscal.setEnabled(false);
        this.finalizareCuFactura.setEnabled(false);
        this.intermediaraCuBonFiscal.setEnabled(false);
        this.intermediaraCuFactura.setEnabled(false);
        this.adaugaLaLista.setEnabled(false);
        this.enableClientPanel(false);
        this.enableDetaliiAnvelopaPanel(false);
        switch (status) {
            case TEMPORAR: {
                this.temporar.setEnabled(true);
                this.avansCuBonFiscal.setEnabled(true);
                this.avansCuFactura.setEnabled(true);
                this.adaugaLaLista.setEnabled(true);
                this.enableClientPanel(true);
                this.enableDetaliiAnvelopaPanel(true);
                break;
            }
            case PLATIT_AVANS: {
                this.temporar.setEnabled(true);
                this.tiparesteContract.setEnabled(true);
                break;
            }
            case CONTRACT_PRINTED: {
                this.ataseazaContract.setEnabled(true);
                this.veziContract.setEnabled(true);
                this.depozitare.setEnabled(true);
                this.temporar.setEnabled(true);
                break;
            }
            case DEPOZITATA: {
                this.veziContract.setEnabled(true);
                this.ataseazaContract.setEnabled(true);
                this.intermediaraCuBonFiscal.setEnabled(true);
                this.intermediaraCuFactura.setEnabled(true);
                this.finalizareCuBonFiscal.setEnabled(true);
                this.finalizareCuFactura.setEnabled(true);
                break;
            }
            case PLATITA_INTEGRAL: {
                this.tiparesteRestituire.setEnabled(true);
                this.veziContract.setEnabled(true);
                this.ataseazaContract.setEnabled(true);
                break;
            }
            case RESTITUIRE_PRINTED: {
                this.veziContract.setEnabled(true);
                this.veziRestituire.setEnabled(true);
                this.ataseazaContract.setEnabled(true);
                this.ataseazaRestituire.setEnabled(true);
                break;
            }
        }
    }

    private JPanel buildAnvelopaPanel() {
        final EditFisaPanel panel = this;
        JPanel result = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 1;
        c.anchor = 10;
        c.insets = new Insets(2, 2, 2, 2);
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 0.0;
        result.add((Component)new JLabel(LangRoAll.codBare), c);
        ++c.gridx;
        c.gridwidth = 5;
        this.codBare = new JTextField(20);
        this.codBare.addKeyListener(new KeyListener(){

            @Override
            public void keyPressed(KeyEvent e) {
            }

            @Override
            public void keyReleased(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    String cod = EditFisaPanel.this.codBare.getText();
                    ModelAnv m = HaLogic.getInstance().getModelByCodBare(cod);
                    if (m != null) {
                        EditFisaPanel.this.model.setSelectedItem(m);
                    } else {
                        EditFisaPanel.this.model.setSelectedItem(null);
                    }
                    Anvelopa ae = HaLogic.getInstance().getAnvelopaByCodBare(cod);
                    if (ae != null) {
                        EditFisaPanel.this.inaltime.setText(Utils.getString2Decimals(ae.getInaltime()));
                        EditFisaPanel.this.latime.setText(Utils.getString2Decimals(ae.getLatime()));
                        EditFisaPanel.this.diametru.setText(Utils.getString2Decimals(ae.getDiametru()));
                        EditFisaPanel.this.dot.setText(ae.getDot());
                        EditFisaPanel.this.uzura.requestFocus();
                    } else {
                        EditFisaPanel.this.inaltime.setText("");
                        EditFisaPanel.this.latime.setText("");
                        EditFisaPanel.this.diametru.setText("");
                        EditFisaPanel.this.dot.setText("");
                    }
                }
            }

            @Override
            public void keyTyped(KeyEvent e) {
            }
        });
        result.add((Component)this.codBare, c);
        c.gridx += 5;
        c.weightx = 0.0;
        c.gridwidth = 1;
        this.codBareNou = new JButton("+");
        this.codBareNou.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                int code = HaLogic.getInstance().generateNextCodIntern();
                EditFisaPanel.this.codBare.setText("" + code);
                EditFisaPanel.this.inaltime.setText("");
                EditFisaPanel.this.latime.setText("");
                EditFisaPanel.this.diametru.setText("");
                EditFisaPanel.this.dot.setText("");
            }
        });
        result.add((Component)this.codBareNou, c);
        c.gridwidth = 1;
        c.weightx = 0.0;
        ++c.gridx;
        result.add((Component)new JLabel("Model"), c);
        ++c.gridx;
        c.weightx = 1.0;
        c.gridwidth = 4;
        this.modelsComboModel = new FilterableComboBoxModel(HaLogic.getInstance().getModeleAnvelope());
        this.model = new XComboBox(this.modelsComboModel, true);
        this.model.setPrototypeDisplayValue("111111111111111111111111111111111");
        this.model.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
                EditFisaPanel.this.clienti.selectAllText();
            }

            @Override
            public void focusLost(FocusEvent e) {
            }
        });
        result.add((Component)this.model, c);
        c.gridwidth = 1;
        c.gridx += 4;
        c.weightx = 0.0;
        this.modelNou = new JButton("+");
        this.modelNou.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                HaAddModelPanel haModel = new HaAddModelPanel();
                JDialog dialog = DialogUtils.getJDialogOKButton(haModel, GuiUtils.currentFrame, "Introduceti modelul", 2.0);
                dialog.setVisible(true);
                String prod = haModel.getProducator();
                String model1 = haModel.getProfil();
                String indicePresiune = "0";
                if (Validators.correctString(haModel.getIndice())) {
                    indicePresiune = haModel.getIndice();
                }
                String getIndiceViteza = haModel.getIndiceViteza();
                if (Validators.correctString(prod) && Validators.correctString(model1)) {
                    HaLogic.getInstance().addModel(getIndiceViteza, prod, model1, indicePresiune);
                    EditFisaPanel.this.model.setSelectedItem(null);
                }
            }
        });
        result.add((Component)this.modelNou, c);
        ++c.gridy;
        c.gridx = 0;
        c.weightx = 0.0;
        result.add((Component)new JLabel("Dimensiunea"), c);
        ++c.gridx;
        c.weightx = 0.1;
        this.latime = new JTextField(3);
        result.add((Component)this.latime, c);
        c.weightx = 0.0;
        ++c.gridx;
        result.add((Component)new JLabel("/"), c);
        ++c.gridx;
        c.weightx = 0.1;
        c.gridwidth = 2;
        this.inaltime = new JTextField(3);
        result.add((Component)this.inaltime, c);
        c.weightx = 0.0;
        c.gridx += 2;
        c.gridwidth = 1;
        result.add((Component)new JLabel("/"), c);
        ++c.gridx;
        c.weightx = 0.1;
        this.diametru = new JTextField(3);
        result.add((Component)this.diametru, c);
        ++c.gridx;
        c.weightx = 0.0;
        result.add((Component)new JLabel("Uzura"), c);
        ++c.gridx;
        c.weightx = 0.1;
        this.uzura = new JTextField(3);
        result.add((Component)this.uzura, c);
        ++c.gridx;
        c.weightx = 0.0;
        result.add((Component)new JLabel("DOT"), c);
        ++c.gridx;
        c.weightx = 0.1;
        this.dot = new JTextField(8);
        result.add((Component)this.dot, c);
        c.gridwidth = 1;
        ++c.gridx;
        result.add((Component)new JLabel("Poz depozit"), c);
        ++c.gridx;
        this.pozitiaInDepozit = new JTextField(10);
        result.add((Component)this.pozitiaInDepozit, c);
        ++c.gridy;
        c.gridx = 0;
        result.add((Component)new JLabel("Poz masina"), c);
        ++c.gridx;
        c.gridwidth = 6;
        this.pozitiaPeMasina = new JComboBox();
        result.add((Component)this.pozitiaPeMasina, c);
        c.gridx += 6;
        result.add((Component)new JLabel("Obs"), c);
        ++c.gridx;
        c.gridwidth = 5;
        c.weightx = 1.0;
        this.observatii = new JTextField(30);
        result.add((Component)this.observatii, c);
        ++c.gridy;
        c.gridx = 0;
        c.weightx = 0.0;
        result.add((Component)new JLabel("Tarif"), c);
        ++c.gridx;
        c.weightx = 1.0;
        c.gridwidth = 3;
        this.tarif = new JComboBox();
        result.add((Component)this.tarif, c);
        c.gridx += 3;
        c.gridwidth = 1;
        c.weightx = 0.0;
        result.add((Component)new JLabel(LangRoAll.promotie), c);
        ++c.gridx;
        c.weightx = 0.0;
        c.gridwidth = 2;
        this.promotie = new JComboBox();
        result.add((Component)this.promotie, c);
        c.gridx += 2;
        c.gridwidth = 1;
        c.weightx = 0.0;
        this.janta = new JCheckBox("Janta");
        this.janta.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                EditFisaPanel.this.detaliiJanta.setEnabled(EditFisaPanel.this.janta.isSelected());
                EditFisaPanel.this.detaliiJanta.setText("");
            }
        });
        result.add((Component)this.janta, c);
        ++c.gridx;
        c.gridwidth = 3;
        this.detaliiJanta = new JTextField(30);
        c.weightx = 1.0;
        result.add((Component)this.detaliiJanta, c);
        this.detaliiJanta.setEnabled(false);
        c.gridwidth = 1;
        c.weightx = 0.0;
        c.gridx += 3;
        this.printEticheta = new JButton("Eticheta");
        this.printEticheta.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                Client c = (Client)EditFisaPanel.this.clienti.getSelectedItem();
                if (c != null) {
                    HaLogic.getInstance().printEticheta(EditFisaPanel.this.nrAuto.getText(), c.toString(), EditFisaPanel.this.codBare.getText(), EditFisaPanel.this.pozitiaPeMasina.getSelectedItem().toString(), EditFisaPanel.this.pozitiaInDepozit.getText(), EditFisaPanel.this.observatii.getText(), EditFisaPanel.this.janta.isSelected() ? EditFisaPanel.this.detaliiJanta.getText() : "");
                }
            }
        });
        result.add((Component)this.printEticheta, c);
        ++c.gridx;
        this.adaugaLaLista = new JButton(LangRoAll.adauga);
        this.adaugaLaLista.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                AnvelopaEntry ae = new AnvelopaEntry();
                Object o = EditFisaPanel.this.tarif.getSelectedItem();
                Product product = (Product)o;
                ae.setIdProduct(product.getId());
                ae.setDot(EditFisaPanel.this.dot.getText());
                ae.setObservatii(EditFisaPanel.this.observatii.getText());
                ae.setPozitiaInDepozit(EditFisaPanel.this.pozitiaInDepozit.getText());
                ae.setPozitiaPeMasina(EditFisaPanel.this.pozitiaPeMasina.getSelectedItem().toString());
                String d1 = EditFisaPanel.this.latime.getText();
                if (!Validators.correctDouble(d1)) {
                    DialogUtils.errorDialog(panel, "Latimea trebuie sa fie un numar", LangRoAll.nuPotContinua);
                    EditFisaPanel.this.latime.setText("");
                    EditFisaPanel.this.latime.requestFocus();
                    return;
                }
                ae.setLatime(Utils.parseDouble(d1));
                d1 = EditFisaPanel.this.inaltime.getText();
                if (!Validators.correctDouble(d1)) {
                    DialogUtils.errorDialog(panel, "Inaltimea trebuie sa fie un numar", LangRoAll.nuPotContinua);
                    EditFisaPanel.this.inaltime.setText("");
                    EditFisaPanel.this.inaltime.requestFocus();
                    return;
                }
                ae.setInaltime(Utils.parseDouble(d1));
                d1 = EditFisaPanel.this.diametru.getText();
                if (!Validators.correctDouble(d1)) {
                    DialogUtils.errorDialog(panel, " Diametrul trebuie sa fie un numar", LangRoAll.nuPotContinua);
                    EditFisaPanel.this.diametru.setText("");
                    EditFisaPanel.this.diametru.requestFocus();
                    return;
                }
                ae.setDiametru(Utils.parseDouble(d1));
                ModelAnv m = (ModelAnv)EditFisaPanel.this.model.getSelectedItem();
                if (m == null) {
                    DialogUtils.errorDialog(panel, "Alegeti un model de anvelopa", LangRoAll.nuPotContinua);
                    return;
                }
                ae.setIdModel(m.getId());
                ae.setModel(m.getLabel());
                d1 = EditFisaPanel.this.uzura.getText();
                if (!Validators.correctDouble(d1)) {
                    DialogUtils.errorDialog(panel, "Uzura trebuie sa fie un numar", LangRoAll.nuPotContinua);
                    EditFisaPanel.this.uzura.setText("");
                    EditFisaPanel.this.uzura.requestFocus();
                    return;
                }
                ae.setUzura(Utils.parseDouble(d1));
                if (!Validators.correctString(EditFisaPanel.this.codBare.getText())) {
                    DialogUtils.errorDialog(panel, "Cod bare necompletat", LangRoAll.nuPotContinua);
                    EditFisaPanel.this.codBare.requestFocus();
                }
                ae.setCodBare(EditFisaPanel.this.codBare.getText());
                ae.setJanta(EditFisaPanel.this.janta.isSelected());
                ae.setDetaliiJanta(EditFisaPanel.this.detaliiJanta.getText());
                double price = RestLogic.getInstance().getPriceForProductCommit(product.getId());
                double discount = 0.0;
                if (ComboUtils.anythingButAllSelected(EditFisaPanel.this.promotie)) {
                    Promotion promo = (Promotion)EditFisaPanel.this.promotie.getSelectedItem();
                    Categorie cat = NomeclaturaLogic.getInstance().getCategoryById(product.getIdCategorie());
                    Sectie sec = NomeclaturaLogic.getInstance().getSectieById(cat.getSectie());
                    PromotionPriceProviderImpl priceProvider = new PromotionPriceProviderImpl();
                    PriceWrapper pw = priceProvider.getPriceForProduct(product.getId(), cat.getId(), sec.getId(), promo.getId(), price, System.currentTimeMillis(), 0.0, true);
                    price = pw.getPrice();
                    discount = pw.getDiffPret();
                    ae.setIdPromotie(promo.getId());
                }
                ae.setPret(price);
                ae.setDiscount(discount);
                int idAnvelopa = HaLogic.getInstance().updateAnvelopaInDb(ae.getCodBare(), ae.getIdModel(), ae.getLatime(), ae.getInaltime(), ae.getDiametru(), ae.getDot());
                ae.setIdAnvelopa(idAnvelopa);
                EditFisaPanel.this.anvelopeTm.getData().add(ae);
                EditFisaPanel.this.anvelopeTm.fireTableDataChanged();
                EditFisaPanel.this.updatePretPeLuna();
                EditFisaPanel.this.completeAllAnvelopaFields(null);
            }
        });
        result.add((Component)this.adaugaLaLista, c);
        result.setBorder(new TitledBorder("Detalii anvelopa"));
        return result;
    }

    private void updatePretPeLuna() {
        this.t1 = 0.0;
        this.t2 = 0.0;
        for (int i = 0; i < this.anvelopeTm.getData().size(); ++i) {
            AnvelopaEntry ae = (AnvelopaEntry)this.anvelopeTm.getData().elementAt(i);
            int idProduct = ae.getIdProduct();
            if (idProduct <= 0) continue;
            double price = ae.getPret();
            this.t1 += price;
            double discount = ae.getDiscount();
            this.t2 += discount;
        }
        this.t3 = this.t1 + this.t2;
        this.totalValoarePerLuna.setText(Utils.getString2Decimals(this.t3) + " LEI");
        this.totalDiscountPerLuna.setText(Utils.getString2Decimals(this.t2) + " LEI");
        this.totalDePlataPerLuna.setText(Utils.getString2Decimals(this.t1) + " LEI");
    }

    private JPanel buildClientPanel() {
        EditFisaPanel panel = this;
        JPanel result = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 1;
        c.anchor = 10;
        c.insets = new Insets(2, 2, 2, 2);
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 0.0;
        result.add((Component)new JLabel(LangRoAll.client), c);
        ++c.gridx;
        c.weightx = 1.0;
        c.gridwidth = 7;
        this.clientsComboModel = new FilterableComboBoxModel(ClientLogic.getInstance().getAllClientsSorted());
        this.clienti = new XComboBox(this.clientsComboModel, true);
        this.clienti.setPrototypeDisplayValue("111111111111111111111111111111111");
        this.clienti.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
                EditFisaPanel.this.clienti.selectAllText();
            }

            @Override
            public void focusLost(FocusEvent e) {
            }
        });
        result.add((Component)this.clienti, c);
        c.gridx += 7;
        c.weightx = 0.0;
        c.gridwidth = 1;
        this.clientNou = new JButton("+");
        this.clientNou.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                boolean pf = DialogUtils.confirmDialog(EditFisaPanel.this.parent, LangRoAll.adaugamPersFizica, LangRoAll.persFizicaJuridica);
                ClientEditPanelProvider provider = new ClientEditPanelProvider(){

                    @Override
                    public PersFizicaAddEditPanel getPfPanel() {
                        return new PersFizicaAddEditPanel();
                    }

                    @Override
                    public PersJuridicaAddEditPanel getPjPanel() {
                        return new PersJuridicaAddEditPanel();
                    }
                };
                ClientEditDialog cDia = new ClientEditDialog(GuiUtils.currentFrame, ClientLogic.getInstance(), null, !pf, provider);
            }
        });
        result.add((Component)this.clientNou, c);
        ++c.gridy;
        c.gridx = 0;
        result.add((Component)new JLabel("Nr auto"), c);
        ++c.gridx;
        c.weightx = 1.0;
        this.nrAuto = new JTextField(12);
        result.add((Component)this.nrAuto, c);
        ++c.gridx;
        c.weightx = 0.0;
        result.add((Component)new JLabel("Nr km"), c);
        ++c.gridx;
        c.weightx = 1.0;
        this.nrKm = new JTextField(8);
        result.add((Component)this.nrKm, c);
        ++c.gridx;
        c.weightx = 0.0;
        result.add((Component)new JLabel("Termen depozitare"), c);
        ++c.gridx;
        c.weightx = 1.0;
        this.termen = new MDateEntryField((DateFormat)Formatters.SHORT_DATE_FORMAT_RO);
        this.termen.setValue(new Date());
        this.termen.setEditable(true);
        MDefaultPullDownConstraints c1 = new MDefaultPullDownConstraints();
        c1.firstDay = 2;
        c1.changerStyle = 2;
        this.termen.setConstraints((MDateSelectorConstraints)c1);
        this.termen.setToolTipText("Termen depozitare");
        this.termen.setMinimum(DateUtils.getStartOfCentury());
        this.termen.setShowTodayButton(true);
        result.add((Component)this.termen, c);
        ++c.gridx;
        c.weightx = 0.0;
        result.add((Component)new JLabel(LangRoAll.data), c);
        ++c.gridx;
        c.weightx = 1.0;
        this.data = new MDateEntryField((DateFormat)Formatters.SHORT_DATE_FORMAT_RO);
        this.data.setValue(new Date());
        this.data.setEditable(true);
        c1 = new MDefaultPullDownConstraints();
        c1.firstDay = 2;
        c1.changerStyle = 2;
        this.data.setConstraints((MDateSelectorConstraints)c1);
        this.data.setToolTipText(LangRoAll.data);
        this.data.setMinimum(DateUtils.getStartOfCentury());
        this.data.setShowTodayButton(true);
        result.add((Component)this.data, c);
        ++c.gridx;
        c.weightx = 0.0;
        this.time = new JTextField(6);
        this.time.setText("00:00");
        result.add((Component)this.time, c);
        result.setBorder(new TitledBorder("Detaliii fisa"));
        return result;
    }

    private void display() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 1;
        c.anchor = 10;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.gridwidth = 2;
        c.insets = new Insets(2, 2, 2, 2);
        c.gridx = 0;
        c.gridy = 0;
        this.add((Component)this.buildClientPanel(), c);
        ++c.gridy;
        c.gridx = 0;
        this.add((Component)this.buildAnvelopaPanel(), c);
        ++c.gridy;
        c.gridx = 0;
        c.weightx = 1.0;
        c.weighty = 1.0;
        this.add((Component)this.buildAnvelopeTable(), c);
        ++c.gridy;
        c.gridx = 0;
        c.weighty = 0.0;
        c.weightx = 0.0;
        c.gridwidth = 1;
        this.add((Component)this.buildTotalsPanel(), c);
        ++c.gridx;
        c.weightx = 1.0;
        c.gridwidth = 1;
        this.add((Component)this.buildButtonsPanel(), c);
    }

    @Override
    public void doStuff() {
        ClientLogic clientLogic = ClientLogic.getInstance();
        clientLogic.addListener(new EventListener(){

            @Override
            public String getName() {
                return "EditFisaPanel_persJuridice";
            }

            @Override
            public void dataChanged() {
                EditFisaPanel.this.clientsComboModel.refresh(ClientLogic.getInstance().getAllClientsSorted());
            }
        }, 42);
        clientLogic.addListener(new EventListener(){

            @Override
            public String getName() {
                return "EditFisaPanel_persFizice";
            }

            @Override
            public void dataChanged() {
                EditFisaPanel.this.clientsComboModel.refresh(ClientLogic.getInstance().getAllClientsSorted());
            }
        }, 41);
        this.clientsComboModel.refresh(ClientLogic.getInstance().getAllClientsSorted());
        HaLogic.getInstance().addListener(new EventListener(){

            @Override
            public String getName() {
                return "EditFisaPanel_modele";
            }

            @Override
            public void dataChanged() {
                EditFisaPanel.this.modelsComboModel.refresh(HaLogic.getInstance().getModeleAnvelope());
            }
        }, 901);
        for (PozitiaPeMasina p1 : PozitiaPeMasina.values()) {
            this.pozitiaPeMasina.addItem(p1);
        }
        for (Object p : HaLogic.getInstance().getTarifeDepozitare()) {
            this.tarif.addItem(p);
        }
        ComboUtils.replaceItemsForCombo(this.promotie, PromotionLogic.getInstance().getFidelitatePromotions());
        this.setFisaToEdit(null);
    }

    private JPanel buildTotalsPanel() {
        JPanel result = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 1;
        c.anchor = 10;
        c.insets = new Insets(2, 2, 2, 2);
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.gridx = 0;
        c.gridy = 0;
        result.add((Component)new JLabel("Valoare pe luna"), c);
        ++c.gridx;
        this.totalValoarePerLuna = new JLabel();
        result.add((Component)this.totalValoarePerLuna, c);
        ++c.gridy;
        c.gridx = 0;
        result.add((Component)new JLabel("Discount pe luna"), c);
        ++c.gridx;
        this.totalDiscountPerLuna = new JLabel();
        result.add((Component)this.totalDiscountPerLuna, c);
        ++c.gridy;
        c.gridx = 0;
        result.add((Component)new JLabel("De plata pe luna"), c);
        ++c.gridx;
        this.totalDePlataPerLuna = new JLabel();
        result.add((Component)this.totalDePlataPerLuna, c);
        result.setBorder(new TitledBorder(LangRoAll.total));
        return result;
    }

    private JPanel buildButtonsPanel() {
        final EditFisaPanel panel = this;
        JPanel result = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 1;
        c.anchor = 10;
        c.insets = new Insets(2, 2, 2, 2);
        c.weightx = 1.0;
        c.gridx = 0;
        c.gridy = 0;
        this.temporar = new JButton("Temporar");
        this.temporar.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                Date start = DateUtils.setTimeToDate(panel, EditFisaPanel.this.data, EditFisaPanel.this.time);
                if (start == null) {
                    return;
                }
                Date stop = DateUtils.setTimeToDate(panel, EditFisaPanel.this.termen, "23:59");
                if (stop == null) {
                    return;
                }
                Client c = (Client)EditFisaPanel.this.clienti.getSelectedItem();
                if (c == null) {
                    DialogUtils.errorDialog(panel, "Alegeti clientul", LangRoAll.nuPotContinua);
                    return;
                }
                String nr = EditFisaPanel.this.nrAuto.getText();
                String km = EditFisaPanel.this.nrKm.getText();
                if (!Validators.correctString(nr)) {
                    DialogUtils.errorDialog(panel, "Completati nr auto", LangRoAll.nuPotContinua);
                    EditFisaPanel.this.nrAuto.requestFocus();
                    return;
                }
                if (!Validators.correctInteger(km)) {
                    DialogUtils.errorDialog(panel, "Nr km trebuie sa fie un numar", LangRoAll.nuPotContinua);
                    EditFisaPanel.this.nrKm.setText("");
                    EditFisaPanel.this.nrKm.requestFocus();
                    return;
                }
                if (EditFisaPanel.this.fisaToEdit == null) {
                    HaLogic.getInstance().addFisa(c.getId(), nr, Integer.parseInt(km), new Timestamp(start.getTime()), EditFisaPanel.this.anvelopeTm.getData(), new Timestamp(stop.getTime()));
                } else {
                    HaLogic.getInstance().updateFisa(EditFisaPanel.this.fisaToEdit.getIdFisa(), c.getId(), nr, Integer.parseInt(km), new Timestamp(start.getTime()), EditFisaPanel.this.anvelopeTm.getData(), new Timestamp(stop.getTime()));
                }
                EditFisaPanel.this.setFisaToEdit(null);
            }
        });
        result.add((Component)this.temporar, c);
        ++c.gridx;
        this.avansCuBonFiscal = new JButton("Avans cu bon fiscal");
        this.avansCuBonFiscal.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                if (EditFisaPanel.this.fisaToEdit != null) {
                    String s = "";
                    while (!Validators.correctInteger(s)) {
                        s = DialogUtils.inputDialog(panel, "2", "Numar de luni platite in avans");
                    }
                    int nrLuni = Integer.parseInt(s);
                    if (nrLuni <= 0) {
                        DialogUtils.errorDialog(panel, "Valoare incorecta", LangRoAll.nuPotContinua);
                        return;
                    }
                    double total = (double)nrLuni * EditFisaPanel.this.t1;
                    if (!DialogUtils.confirmDialog(panel, "De plata: " + Utils.getString2Decimals(total) + ". Confirmati", LangRoAll.confirmare)) {
                        DialogUtils.errorDialog(panel, "Operatie anulata", LangRoAll.nuPotContinua);
                        return;
                    }
                    boolean bonPrinted = HaLogic.getInstance().plataCuBonFiscal(nrLuni, EditFisaPanel.this.anvelopeTm.getData(), EditFisaPanel.this.fisaToEdit.getIdClient(), panel, EditFisaPanel.this.fisaToEdit.getNrLuniPlatite(), EditFisaPanel.this.fisaToEdit.getIdFisa());
                    if (bonPrinted) {
                        EditFisaPanel.this.updateStatus(FisaState.PLATIT_AVANS);
                    }
                } else {
                    DialogUtils.errorDialog(panel, "Fisa nesalvata", LangRoAll.nuPotContinua);
                }
            }
        });
        result.add((Component)this.avansCuBonFiscal, c);
        ++c.gridx;
        this.avansCuFactura = new JButton("Avans cu factura");
        this.avansCuFactura.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                if (EditFisaPanel.this.fisaToEdit != null) {
                    String s = "";
                    while (!Validators.correctInteger(s)) {
                        s = DialogUtils.inputDialog(panel, "2", "Numar de luni platite in avans");
                    }
                    int nrLuni = Integer.parseInt(s);
                    if (nrLuni <= 0) {
                        DialogUtils.errorDialog(panel, "Valoare incorecta", LangRoAll.nuPotContinua);
                        return;
                    }
                    double total = (double)nrLuni * EditFisaPanel.this.t1;
                    if (!DialogUtils.confirmDialog(panel, "De plata: " + Utils.getString2Decimals(total) + ". Confirmati", LangRoAll.confirmare)) {
                        DialogUtils.errorDialog(panel, "Operatie anulata", LangRoAll.nuPotContinua);
                        return;
                    }
                    String numarTipizat = "";
                    while (Config.getInstance().getBoolean("facturareRequestNrTipizat") && !Validators.correctString(numarTipizat)) {
                        numarTipizat = DialogUtils.inputDialog(panel, "", "Introduceti numar tipizat");
                    }
                    boolean bonPrinted = HaLogic.getInstance().plataCuFactura(nrLuni, EditFisaPanel.this.anvelopeTm.getData(), (Client)EditFisaPanel.this.clienti.getSelectedItem(), panel, EditFisaPanel.this.fisaToEdit.getNrLuniPlatite(), EditFisaPanel.this.fisaToEdit.getIdFisa(), EditFisaPanel.this.t1, numarTipizat, "", "", StockLogic.COMANDA_TYPE.EFECTUAT);
                    if (bonPrinted) {
                        EditFisaPanel.this.updateStatus(FisaState.PLATIT_AVANS);
                    }
                } else {
                    DialogUtils.errorDialog(panel, "Fisa nesalvata", LangRoAll.nuPotContinua);
                }
            }
        });
        result.add((Component)this.avansCuFactura, c);
        ++c.gridx;
        this.tiparesteContract = new JButton("Tipareste contract");
        this.tiparesteContract.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                boolean ok = HaLogic.getInstance().tiparesteContract(EditFisaPanel.this.fisaToEdit.getIdClient(), EditFisaPanel.this.fisaToEdit.getIdFisa(), EditFisaPanel.this.fisaToEdit.getData(), EditFisaPanel.this.anvelopeTm.getData(), "", panel, EditFisaPanel.this.fisaToEdit.getAuto(), EditFisaPanel.this.fisaToEdit.getNrKm(), EditFisaPanel.this.t3, EditFisaPanel.this.fisaToEdit.getAchitat(), EditFisaPanel.this.fisaToEdit.getTermen(), EditFisaPanel.this.t2, EditFisaPanel.this.t1);
                if (ok) {
                    EditFisaPanel.this.updateStatus(FisaState.CONTRACT_PRINTED);
                }
            }
        });
        result.add((Component)this.tiparesteContract, c);
        ++c.gridx;
        this.ataseazaContract = new JButton("Ataseaza contract");
        this.ataseazaContract.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
            }
        });
        result.add((Component)this.ataseazaContract, c);
        ++c.gridy;
        c.gridx = 0;
        this.veziContract = new JButton("Vezi contract");
        this.veziContract.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
            }
        });
        result.add((Component)this.veziContract, c);
        ++c.gridx;
        this.depozitare = new JButton("Depozitare");
        this.depozitare.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                EditFisaPanel.this.updateStatus(FisaState.DEPOZITATA);
            }
        });
        result.add((Component)this.depozitare, c);
        ++c.gridx;
        this.intermediaraCuBonFiscal = new JButton("Plata cu bon fiscal");
        this.intermediaraCuBonFiscal.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
            }
        });
        result.add((Component)this.intermediaraCuBonFiscal, c);
        ++c.gridx;
        this.intermediaraCuFactura = new JButton("Plata cu factura");
        result.add((Component)this.intermediaraCuFactura, c);
        ++c.gridx;
        this.finalizareCuBonFiscal = new JButton("Finalizare cu bon fiscal");
        this.finalizareCuBonFiscal.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                EditFisaPanel.this.updateStatus(FisaState.PLATITA_INTEGRAL);
            }
        });
        result.add((Component)this.finalizareCuBonFiscal, c);
        ++c.gridy;
        c.gridx = 0;
        this.finalizareCuFactura = new JButton("Finalizare cu factura");
        this.finalizareCuFactura.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                EditFisaPanel.this.updateStatus(FisaState.PLATITA_INTEGRAL);
            }
        });
        result.add((Component)this.finalizareCuFactura, c);
        ++c.gridx;
        this.tiparesteRestituire = new JButton("Tipareste restituire");
        this.tiparesteRestituire.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                EditFisaPanel.this.updateStatus(FisaState.RESTITUIRE_PRINTED);
            }
        });
        result.add((Component)this.tiparesteRestituire, c);
        ++c.gridx;
        this.ataseazaRestituire = new JButton("Ataseaza restituire");
        result.add((Component)this.ataseazaRestituire, c);
        ++c.gridx;
        this.veziRestituire = new JButton("Vezi restituire");
        result.add((Component)this.veziRestituire, c);
        ++c.gridx;
        this.renunta = new JButton(LangRoAll.renunta);
        this.renunta.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                if (EditFisaPanel.this.fisaToEdit != null) {
                    EditFisaPanel.this.setFisaToEdit(null);
                    EditFisaPanel.this.parent.backToList();
                } else {
                    EditFisaPanel.this.setFisaToEdit(null);
                }
            }
        });
        result.add((Component)this.renunta, c);
        result.setBorder(new TitledBorder(LangRoAll.actiuni));
        return result;
    }

    private void updateStatus(FisaState newStatus) {
        if (this.fisaToEdit != null) {
            HaLogic.getInstance().setFisaStatus(this.fisaToEdit.getIdFisa(), newStatus);
            this.fisaToEdit.setIdStatus(newStatus.getState());
            this.setButtonsStatus(newStatus);
        }
    }

    @Override
    public void cleanup() {
    }
}

