/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.restaurant.modules.hotelanvelope;

import java.awt.Component;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Date;
import java.util.Hashtable;
import java.util.Vector;
import ro.atreides.clienti.BiCi;
import ro.atreides.clienti.ClientLogic;
import ro.atreides.clienti.ClientPersFizica;
import ro.atreides.clienti.ClientPersJuridica;
import ro.atreides.facturi.FacturiLogic;
import ro.atreides.nomenclatura.Categorie;
import ro.atreides.nomenclatura.NomeclaturaLogic;
import ro.atreides.nomenclatura.Product;
import ro.atreides.nomenclatura.Sectie;
import ro.atreides.print.PrintLogic;
import ro.atreides.restaurant.VpConfig;
import ro.atreides.restaurant.base.Sale;
import ro.atreides.restaurant.base.Table;
import ro.atreides.restaurant.logic.RestLogic;
import ro.atreides.restaurant.modules.hotelanvelope.Anvelopa;
import ro.atreides.restaurant.modules.hotelanvelope.AnvelopaEntry;
import ro.atreides.restaurant.modules.hotelanvelope.FisaState;
import ro.atreides.restaurant.modules.hotelanvelope.FisePanelView;
import ro.atreides.restaurant.modules.hotelanvelope.HaDao;
import ro.atreides.restaurant.modules.hotelanvelope.ModelAnv;
import ro.atreides.stocks.StockLogic;
import ro.atreides.users.User;
import ro.atreides.users.UsersLogic;
import ro.atreides.utils.Client;
import ro.atreides.utils.Constants;
import ro.atreides.utils.DateUtils;
import ro.atreides.utils.EventGenerator;
import ro.atreides.utils.FileUtils;
import ro.atreides.utils.Formatters;
import ro.atreides.utils.Logger;
import ro.atreides.utils.Order;
import ro.atreides.utils.Utils;
import ro.atreides.utils.config.Config;
import ro.atreides.utils.db.ConnectionPool;
import ro.atreides.utils.db.ConnectionWrapper;
import ro.atreides.utils.facturi.FacturaItemView;
import ro.atreides.utils.gui.Validators;
import ro.atreides.utils.gui.dialogs.DialogUtils;
import ro.atreides.utils.multilang.LangRoAll;
import ro.atreides.utils.plati.Plata;
import ro.atreides.utils.plati.TipPlata;
import ro.atreides.utils.plati.TipPlataProvider;
import ro.atreides.utils.tva.Tva;
import ro.atreides.utils.tva.TvaLogic;

public class HaLogic
extends EventGenerator {
    private static HaLogic instance;
    private ConnectionPool pool = ConnectionPool.getInstance();

    private synchronized HaDao getDao() {
        ConnectionWrapper connection = this.pool.requestConnection();
        HaDao dao = null;
        while (dao == null) {
            dao = (HaDao)this.pool.getDao(HaDao.class, connection);
            if (dao != null) continue;
            this.pool.buildDao(HaDao.class.getName(), connection);
        }
        return dao;
    }

    private HaLogic() {
    }

    public static synchronized HaLogic getInstance() {
        if (instance == null) {
            instance = new HaLogic();
        }
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector getFise(Hashtable criteria) {
        Vector fise = new Vector();
        try {
            String nrAuto;
            Integer idClient = (Integer)criteria.get(Constants.CLIENT_KEY);
            Integer status = (Integer)criteria.get(Constants.STATUS_CONTRACT_KEY);
            Timestamp start = new Timestamp(((Date)criteria.get(Constants.START_KEY)).getTime());
            Timestamp stop = new Timestamp(((Date)criteria.get(Constants.STOP_KEY)).getTime());
            Integer numar = (Integer)criteria.get("Numar fisa");
            if (numar == null) {
                numar = -1;
            }
            if ((nrAuto = (String)criteria.get("Numar auto")) == null) {
                nrAuto = "";
            }
            fise = this.getDao().getFise(numar, status, idClient, nrAuto, start, stop);
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            Vector status = new Vector();
            return status;
        }
        finally {
            try {
                this.pool.commit();
            }
            catch (SQLException e) {
                Logger.logException(this, (Exception)e);
            }
            this.pool.releaseConnection();
        }
        try {
            for (int i = 0; i < fise.size(); ++i) {
                FisePanelView fisePanelView = (FisePanelView)fise.elementAt(i);
                Client c = ClientLogic.getInstance().getClientByIdNoCommit(fisePanelView.getIdClient());
                fisePanelView.setClient(c.toString());
                fisePanelView.setDataS(Formatters.DATE_FORMAT_RO.format(fisePanelView.getData()));
                fisePanelView.setStatus(FisaState.valueByInt(fisePanelView.getIdStatus()).getNume());
            }
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
        }
        finally {
            try {
                this.pool.commit();
            }
            catch (SQLException e) {
                Logger.logException(this, (Exception)e);
            }
            this.pool.releaseConnection();
        }
        return fise;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector getModeleAnvelope() {
        try {
            Vector vector = this.getDao().getModele();
            return vector;
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            try {
                this.pool.rollBack();
            }
            catch (SQLException e1) {
                Logger.logException(this, (Exception)e1);
            }
            Vector vector = new Vector();
            return vector;
        }
        finally {
            try {
                this.pool.commit();
            }
            catch (SQLException e) {
                Logger.logException(this, (Exception)e);
            }
            this.pool.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addModel(String prod, String profil, String indicePresiune, String indiceViteza) {
        try {
            this.getDao().addModel(prod, profil, indicePresiune, indiceViteza);
            this.pool.commit();
            this.notifyListeners(901);
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            try {
                this.pool.rollBack();
            }
            catch (SQLException e1) {
                Logger.logException(this, (Exception)e1);
            }
        }
        finally {
            this.pool.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int updateAnvelopaInDb(String codBare, int idModel, double latime, double inaltime, double diametru, String dot) {
        try {
            int idAnvelopa = this.getDao().getIdAnvelopaByCodBare(codBare);
            if (idAnvelopa <= 0) {
                this.getDao().addAnvelopa(codBare, idModel, latime, inaltime, diametru, dot);
                idAnvelopa = this.pool.getIdentityLocal();
            } else {
                this.getDao().updateAnvelopa(idAnvelopa, codBare, idModel, latime, inaltime, diametru, dot);
            }
            this.pool.commit();
            int n = idAnvelopa;
            return n;
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            try {
                this.pool.rollBack();
            }
            catch (SQLException e1) {
                Logger.logException(this, (Exception)e1);
            }
            int n = -1;
            return n;
        }
        finally {
            this.pool.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ModelAnv getModelByIdAnvelopa(int id) {
        try {
            ModelAnv modelAnv = this.getModelByIdAnvelopaNoCommit(id);
            return modelAnv;
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            ModelAnv modelAnv = null;
            return modelAnv;
        }
        finally {
            try {
                this.pool.commit();
            }
            catch (SQLException e) {
                Logger.logException(this, (Exception)e);
            }
            this.pool.releaseConnection();
        }
    }

    public ModelAnv getModelByIdAnvelopaNoCommit(int id) throws SQLException {
        return this.getDao().getModelByIdAnvelopa(id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ModelAnv getModelByCodBare(String codBare) {
        try {
            int id = this.getDao().getIdAnvelopaByCodBare(codBare);
            if (id > 0) {
                ModelAnv modelAnv = this.getModelByIdAnvelopaNoCommit(id);
                return modelAnv;
            }
            ModelAnv modelAnv = null;
            return modelAnv;
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            ModelAnv modelAnv = null;
            return modelAnv;
        }
        finally {
            try {
                this.pool.commit();
            }
            catch (SQLException e) {
                Logger.logException(this, (Exception)e);
            }
            this.pool.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Anvelopa getAnvelopaByCodBare(String codBare) {
        try {
            int id = this.getDao().getIdAnvelopaByCodBare(codBare);
            if (id > 0) {
                Anvelopa anvelopa = this.getDao().getCaracteristiciAnvelopaById(id);
                return anvelopa;
            }
            Anvelopa anvelopa = null;
            return anvelopa;
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            Anvelopa anvelopa = null;
            return anvelopa;
        }
        finally {
            try {
                this.pool.commit();
            }
            catch (SQLException e) {
                Logger.logException(this, (Exception)e);
            }
            this.pool.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addFisa(int idClient, String nrAuto, int nrKm, Timestamp data, Vector items, Timestamp termen) {
        try {
            this.getDao().addFIsa(idClient, nrAuto, data, nrKm, termen);
            int idFisa = this.pool.getIdentityLocal();
            for (int i = 0; i < items.size(); ++i) {
                AnvelopaEntry anvelopaEntry = (AnvelopaEntry)items.elementAt(i);
                this.getDao().addIstoricAnv(anvelopaEntry.getIdAnvelopa(), anvelopaEntry.getUzura(), anvelopaEntry.getObservatii(), idFisa, anvelopaEntry.getPozitiaInDepozit(), anvelopaEntry.getPozitiaPeMasina(), anvelopaEntry.getIdProduct(), anvelopaEntry.isJanta(), anvelopaEntry.getDetaliiJanta(), anvelopaEntry.getPret(), anvelopaEntry.getDiscount(), anvelopaEntry.getIdPromotie());
            }
            this.pool.commit();
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            try {
                this.pool.rollBack();
            }
            catch (SQLException e1) {
                Logger.logException(this, (Exception)e1);
            }
        }
        finally {
            this.pool.releaseConnection();
        }
    }

    public boolean plataCuFactura(double nrLuni, Vector items, Client client, Component panel, double nrLuniVechi, int idFisa, double totalPeLuna, String numarTipizat, String emitent, String cnp, StockLogic.COMANDA_TYPE comandaType) {
        String seria = Config.getInstance().getString("depozitareSerieFactura", "");
        int idAgent = -1;
        Vector<FacturaItemView> facturaItems = new Vector<FacturaItemView>();
        Date dataFacturii = new Date();
        Date scadenta = new Date();
        if (client instanceof ClientPersJuridica) {
            ClientPersJuridica cpj = (ClientPersJuridica)client;
            int zile = cpj.getNrZileScadenta();
            scadenta = DateUtils.addDaysToDate(dataFacturii, zile);
            idAgent = cpj.getIdAgent();
        }
        double valoare = 0.0;
        double tva = 0.0;
        double totalGeneral = 0.0;
        int numar = FacturiLogic.getInstance().getLastNrFactura(seria) + 1;
        for (int i = 0; i < items.size(); ++i) {
            AnvelopaEntry anvelopaEntry = (AnvelopaEntry)items.elementAt(i);
            int idProduct = anvelopaEntry.getIdProduct();
            double pret = RestLogic.getInstance().getPriceForProductCommit(idProduct);
            Product p = NomeclaturaLogic.getInstance().getProductById(idProduct);
            Categorie c = NomeclaturaLogic.getInstance().getCategoryById(p.getIdCategorie());
            Tva t = TvaLogic.getInstance().getTvaById(c.getIdTva());
            double cota = t.getCota();
            double pretFaraTva = pret / (1.0 + cota);
            double total1 = pret * nrLuni;
            double valoare1 = total1 / (1.0 + cota);
            double tva1 = total1 - valoare1;
            valoare += valoare1;
            totalGeneral += total1;
            tva += tva1;
            String um = FacturiLogic.getInstance().getUmForProduct(idProduct);
            FacturaItemView fi = new FacturaItemView(-1, nrLuni, -1, idProduct, "", pretFaraTva, p.getName(), um, valoare1, tva1, pret, total1, -1.0, -1.0, -1.0, -1.0, -1.0, -1.0, "");
            facturaItems.add(fi);
        }
        int idSocietateaNoastra = -1;
        return FacturiLogic.getInstance().adaugaFacturaOdtBg(client, facturaItems, numar, seria, new Timestamp(dataFacturii.getTime()), valoare, tva, totalGeneral, new Timestamp(scadenta.getTime()), "", "", "", emitent, cnp, numarTipizat, idAgent, "", "", "", "", "FACTURA", 2, "template_factura_openoffice.odt", false, "0", null, -1, idSocietateaNoastra, null, "", "", "", comandaType, "", "");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean plataCuBonFiscal(double nrLuni, Vector items, int idClient, Component panel, double nrLuniVechi, int idFisa) {
        Table table = RestLogic.getInstance().getFirstFreeTable(new Vector());
        Vector<User> waiters = UsersLogic.getInstance().getUsersInGroup("group_fo_users");
        if (waiters.size() < 1) {
            DialogUtils.errorDialog(panel, "Adaugati cel putin un operator", LangRoAll.nuPotContinua);
            return false;
        }
        User u = waiters.get(0);
        int idUser = u.getId();
        TipPlata tipPlata2 = TipPlataProvider.getInstance().getDefaultTipPlataCommit();
        try {
            Order o = RestLogic.getInstance().newOrderNoCommit(table.getId(), idUser, false);
            o.setIdClient(idClient);
            long now = System.currentTimeMillis();
            double total = 0.0;
            for (int i = 0; i < items.size(); ++i) {
                Product p;
                AnvelopaEntry anvelopaEntry = (AnvelopaEntry)items.elementAt(i);
                int idProdus = anvelopaEntry.getIdProduct();
                if (idProdus <= 0 || (p = NomeclaturaLogic.getInstance().getProductById(idProdus)) == null) continue;
                double pretUnita = RestLogic.getInstance().getPriceForProductCommit(idProdus);
                String product = p.getNumeCasa();
                if (!Validators.correctString(product)) {
                    product = p.getName();
                }
                Sale s = RestLogic.getInstance().buildSale(p, 0.0, nrLuni, "", o.getId(), -1, -1, -1, -1, now, 0);
                s.setPpuOriginal(pretUnita);
                s.setPrice(pretUnita);
                total += pretUnita * nrLuni;
                RestLogic.getInstance().addSaleNoCommit(s, o.getUser());
            }
            if (tipPlata2 != null) {
                Plata plata = new Plata(tipPlata2.getId(), total, tipPlata2.getEcrMapping(), tipPlata2.getLabel(), "", 0);
                RestLogic.getInstance().addPlataToOrder(o, plata);
            }
            RestLogic.getInstance().laPlataOrder(o, table, null);
            RestLogic.getInstance().printBonFiscalSeparat(o, true);
            RestLogic.getInstance().closeOrderNoCommit(o, null);
            this.getDao().setNrLuniPlatiteForFisa(idFisa, nrLuniVechi + nrLuni);
            this.pool.commit();
            boolean bl = true;
            return bl;
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            try {
                this.pool.rollBack();
            }
            catch (SQLException e1) {
                Logger.logException(this, (Exception)e1);
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.pool.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateFisa(int idFisa, int idClient, String nrAuto, int nrKm, Timestamp data, Vector items, Timestamp termen) {
        try {
            this.getDao().updateFisa(idFisa, idClient, nrAuto, data, nrKm, termen);
            this.getDao().deleteIstoricForFisa(idFisa);
            for (int i = 0; i < items.size(); ++i) {
                AnvelopaEntry anvelopaEntry = (AnvelopaEntry)items.elementAt(i);
                int idAnvelopa = anvelopaEntry.getIdAnvelopa();
                this.getDao().addIstoricAnv(idAnvelopa, anvelopaEntry.getUzura(), anvelopaEntry.getObservatii(), idFisa, anvelopaEntry.getPozitiaInDepozit(), anvelopaEntry.getPozitiaPeMasina(), anvelopaEntry.getIdProduct(), anvelopaEntry.isJanta(), anvelopaEntry.getDetaliiJanta(), anvelopaEntry.getPret(), anvelopaEntry.getDiscount(), anvelopaEntry.getIdPromotie());
            }
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            try {
                this.pool.rollBack();
            }
            catch (SQLException e1) {
                Logger.logException(this, (Exception)e1);
            }
        }
        finally {
            try {
                this.pool.commit();
            }
            catch (SQLException e) {
                Logger.logException(this, (Exception)e);
            }
        }
    }

    public void updateFinanciareForFisa(int idFisa, double pretPerLuna, int nrLuniPlatite) throws SQLException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int generateNextCodIntern() {
        try {
            int lastNr = this.getDao().getLastUsedIdForAnvelope();
            int n = lastNr + 1;
            return n;
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            try {
                this.pool.rollBack();
            }
            catch (SQLException e1) {
                Logger.logException(this, (Exception)e1);
            }
            int n = 1;
            return n;
        }
        finally {
            try {
                this.pool.commit();
            }
            catch (SQLException e) {
                Logger.logException(this, (Exception)e);
            }
            this.pool.releaseConnection();
        }
    }

    public void printEticheta(String nrAuto, String numeClient, String codBare, String pozitia, String zonaDepozit, String observatii, String detaliiJanta) {
        try {
            String recipesFile = "conf" + File.separator + "A5Eticheta.txt";
            String recipes = FileUtils.readFileToString(recipesFile);
            recipes = recipes.replaceAll("%%numar_auto%%", nrAuto);
            recipes = recipes.replaceAll("%%nume_client%%", numeClient);
            recipes = recipes.replaceAll("%%cod_bare%%", codBare);
            recipes = recipes.replaceAll("%%pozitia_pe_masina%%", pozitia);
            recipes = recipes.replaceAll("%%zona_depozit%%", zonaDepozit);
            recipes = recipes.replaceAll("%%observatii%%", observatii);
            recipes = recipes.replaceAll("%%detalii_janta%%", detaliiJanta);
            String filename = FileUtils.getTempDir() + File.separator + "eticheta.fo";
            FileWriter fw = new FileWriter(filename);
            fw.write(recipes);
            fw.close();
            PrintLogic.getInstance().printPdf(filename, 1);
        }
        catch (IOException e) {
            Logger.logException(this, (Exception)e);
        }
    }

    public Vector getTarifeDepozitare() {
        Vector result = new Vector();
        String sectieDepozit = VpConfig.getInstance().depozitareSectieTarife;
        Sectie sectie = NomeclaturaLogic.getInstance().getSectieByName(sectieDepozit);
        if (sectie != null) {
            result.addAll(NomeclaturaLogic.getInstance().getProductsForSectie(sectie));
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector getAnvelopeEntriesForFisa(int idFisa) {
        try {
            Vector vector = this.getDao().getAnvelopeEntriesForFisa(idFisa);
            return vector;
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            Vector vector = new Vector();
            return vector;
        }
        finally {
            try {
                this.pool.commit();
            }
            catch (SQLException e) {
                Logger.logException(this, (Exception)e);
            }
            this.pool.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFisaStatus(int idFisa, FisaState newStatus) {
        try {
            this.getDao().setFisaStatus(idFisa, newStatus.getState());
            this.pool.commit();
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            try {
                this.pool.rollBack();
            }
            catch (SQLException e1) {
                Logger.logException(this, (Exception)e1);
            }
        }
        finally {
            this.pool.releaseConnection();
        }
    }

    public boolean tiparesteContract(int idClient, int nr, Date data, Vector anvelope, String observatii, Component panel, String nrAuto, int nrKm, double valoareDepozitare, double avans, Date termen, double discount, double dePlata) {
        String templateFile = FileUtils.getCurrentDir() + File.separator + "conf" + File.separator + "template_contract_depozitare.odt";
        String outputFile = FileUtils.getTempDir() + File.separator + "contract_depozitare.odt";
        Hashtable<String, Object> mapping = new Hashtable<String, Object>();
        mapping.put("nr", nr);
        mapping.put("data", Formatters.DATE_FORMAT_RO.format(data));
        mapping.put("termen", Formatters.DATE_FORMAT_RO.format(termen));
        mapping.put("nrAuto", nrAuto);
        mapping.put("nrKm", nrKm);
        mapping.put("pret", Utils.getString2Decimals(valoareDepozitare));
        mapping.put("avans", Utils.getString2Decimals(avans));
        mapping.put("discount", Utils.getString2Decimals(discount));
        mapping.put("dePlata", Utils.getString2Decimals(dePlata));
        Client c = ClientLogic.getInstance().getClientById(idClient);
        mapping.put("cumparator", c.toString());
        if (c instanceof ClientPersFizica) {
            ClientPersFizica cpf = (ClientPersFizica)c;
            mapping.put("j", "CNP");
            int idBuletin = cpf.getIdBuletin();
            BiCi bi = ClientLogic.getInstance().getBiCiById(idBuletin);
            if (bi != null) {
                mapping.put("cui", bi.getCnp());
            } else {
                mapping.put("cui", "");
            }
            mapping.put("sediu", cpf.getAddress1());
            mapping.put("telefon", cpf.getTelefoane(","));
        } else {
            ClientPersJuridica cpj = (ClientPersJuridica)c;
            mapping.put("j", cpj.getJ());
            mapping.put("cui", cpj.getCui());
            mapping.put("sediu", cpj.getAddress1());
            mapping.put("telefon", cpj.getTelefoane(","));
        }
        StringBuffer tabel = new StringBuffer();
        for (int i = 0; i < anvelope.size(); ++i) {
            AnvelopaEntry ae = (AnvelopaEntry)anvelope.elementAt(i);
            ModelAnv model = this.getModelByIdAnvelopa(ae.getIdAnvelopa());
            tabel.append(i + 1 + ": ");
            tabel.append(model.getProducator() + " ");
            tabel.append(model.getProfil() + " ");
            tabel.append(Utils.getString2Decimals(ae.getLatime()));
            tabel.append('/');
            tabel.append(Utils.getString2Decimals(ae.getInaltime()));
            tabel.append('/');
            tabel.append(Utils.getString2Decimals(ae.getDiametru()) + "; ");
            tabel.append("Indici: " + model.getIndicePresiune() + "/" + model.getIndiceViteza() + "; ");
            tabel.append("DOT: " + ae.getDot() + "; ");
            tabel.append("Uzura: " + Utils.getString2Decimals(ae.getUzura()) + "; ");
            tabel.append("Observatii: " + ae.getObservatii() + "; ");
            if (ae.isJanta()) {
                tabel.append("Detalii Janta: " + ae.getDetaliiJanta());
            } else {
                tabel.append("Fara janta");
            }
            tabel.append("\n");
        }
        mapping.put("anvelope", tabel.toString());
        mapping.put("observatii", observatii);
        String generatedFile = PrintLogic.getInstance().generateOdtDocument(templateFile, mapping, outputFile);
        boolean ok = PrintLogic.getInstance().printFacturaOpenOffice(generatedFile, "printer_items_reports");
        return ok;
    }
}

