/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.restaurant.modules.keyssonorom;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import ro.atreides.clienti.BiCi;
import ro.atreides.clienti.ClientLogic;
import ro.atreides.clienti.ClientPersFizica;
import ro.atreides.restaurant.modules.keyssonorom.PersFizicaTextField;
import ro.atreides.restaurant.modules.keyssonorom.PersFizicaTextFieldActionListener;
import ro.atreides.utils.Client;
import ro.atreides.utils.multilang.LangRoAll;

public class PacientSelectPanel
extends JPanel {
    private PersFizicaTextField pacienti;
    private Client selectedClient;
    private int selected = -1;
    private boolean mustAdd = false;
    private boolean mustEdit = false;
    private JTextField cnp;
    private JDialog dialog;

    public void setDialog(JDialog dialog) {
        this.dialog = dialog;
    }

    private void updateClient(ClientPersFizica c) {
        if (c != null) {
            int idBuletin = c.getIdBuletin();
            if (idBuletin > 0) {
                BiCi bici = ClientLogic.getInstance().getBiCiById(idBuletin);
                this.cnp.setText("CNP:" + bici.getCnp());
            } else {
                this.cnp.setText("Adresa:" + c.getAddress1());
            }
        } else {
            this.cnp.setText("");
        }
    }

    public int getSelected() {
        return this.selected;
    }

    public boolean isMustAdd() {
        return this.mustAdd;
    }

    public boolean isMustEdit() {
        return this.mustEdit;
    }

    public Client getSelectedClient() {
        return this.selectedClient;
    }

    public PacientSelectPanel() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 1;
        c.insets = new Insets(2, 2, 2, 2);
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.gridheight = 1;
        c.gridwidth = 1;
        c.anchor = 10;
        JButton newClient = new JButton("Pacient nou");
        JButton ok = new JButton("OK");
        JButton modifica = new JButton("Modifica");
        c.gridx = 0;
        c.gridy = 0;
        this.add((Component)new JLabel(LangRoAll.pacient), c);
        ++c.gridx;
        this.pacienti = new PersFizicaTextField(50);
        this.add((Component)this.pacienti, c);
        ++c.gridy;
        c.gridx = 0;
        this.add((Component)new JLabel("Detalii"), c);
        ++c.gridx;
        this.cnp = new JTextField(10);
        this.cnp.setFocusable(false);
        this.add((Component)this.cnp, c);
        this.pacienti.addListener(new PersFizicaTextFieldActionListener(){

            @Override
            public void selected(ClientPersFizica cpf) {
                if (cpf != null) {
                    PacientSelectPanel.this.updateClient(cpf);
                }
            }
        });
        ++c.gridy;
        c.gridx = 0;
        this.add((Component)ok, c);
        ok.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                ClientPersFizica cpf = PacientSelectPanel.this.pacienti.getSelected();
                if (cpf != null) {
                    PacientSelectPanel.this.selected = cpf.getId();
                    PacientSelectPanel.this.selectedClient = cpf;
                }
                if (PacientSelectPanel.this.dialog != null) {
                    PacientSelectPanel.this.dialog.dispose();
                }
            }
        });
        ++c.gridx;
        this.add((Component)modifica, c);
        modifica.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                ClientPersFizica cpf = PacientSelectPanel.this.pacienti.getSelected();
                if (cpf != null) {
                    PacientSelectPanel.this.selected = cpf.getId();
                    PacientSelectPanel.this.selectedClient = cpf;
                    PacientSelectPanel.this.mustEdit = true;
                }
                if (PacientSelectPanel.this.dialog != null) {
                    PacientSelectPanel.this.dialog.dispose();
                }
            }
        });
        ++c.gridx;
        this.add((Component)newClient, c);
        newClient.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                PacientSelectPanel.this.selected = -1;
                PacientSelectPanel.this.mustAdd = true;
                if (PacientSelectPanel.this.dialog != null) {
                    PacientSelectPanel.this.dialog.dispose();
                }
            }
        });
        this.cnp.requestFocus();
    }
}

