/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.restaurant.modules.memshareintegration;

import eu.memshare.export.main.MemshareClient;
import eu.memshare.filetransfer.FileTransferStatusListener;
import java.io.File;
import java.io.FileNotFoundException;
import java.net.URISyntaxException;
import java.text.SimpleDateFormat;
import java.util.Date;
import ro.atreides.restaurant.modules.memshareintegration.ExportType;
import ro.atreides.restaurant.modules.memshareintegration.MemshareNode;
import ro.atreides.utils.Formatters;

public class ExportClient {
    private static ExportClient ourInstance = null;
    private String serverIp = null;
    private static boolean connected = false;
    private static String levelOneTitle;
    private static String levelTwoTitle;

    public static ExportClient getInstance() {
        return ourInstance;
    }

    public static ExportClient getFirstInstance(String serverIp, String memshareAcc, String memsharePass, String ownerAcc) {
        System.setProperty("javax.net.ssl.trustStore", "mySrvKeystore");
        System.setProperty("javax.net.ssl.trustStorePassword", "123456");
        System.setProperty("javax.net.ssl.keyStore", "mySrvKeystore");
        System.setProperty("javax.net.ssl.keyStorePassword", "123456");
        try {
            Boolean aBoolean = MemshareClient.getInstance().loginAndConnect(serverIp, memshareAcc, memsharePass, ownerAcc);
            System.out.println("Conexiune la memshare : " + aBoolean);
            connected = aBoolean;
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
        }
        ourInstance = new ExportClient();
        return ourInstance;
    }

    public static boolean isConnected() {
        return connected;
    }

    private ExportClient() {
    }

    public static void setLevelOneTitle(String levelOneTitle) {
        ExportClient.levelOneTitle = levelOneTitle;
    }

    public static void setLevelTwoTitle(String levelTwoTitle) {
        ExportClient.levelTwoTitle = levelTwoTitle;
    }

    public Long exportNodeFactura(MemshareNode mem, ExportType exportType) {
        Date todayDate = new Date();
        SimpleDateFormat yearFormat = new SimpleDateFormat("yyyy");
        SimpleDateFormat monthYearFormat = new SimpleDateFormat("MMMM yyyy");
        SimpleDateFormat yearMonthDayFormat = Formatters.DATE_FORMAT;
        Long levelOneId = MemshareClient.getInstance().saveMemshareNode(null, levelOneTitle);
        Long levelTwoId = MemshareClient.getInstance().saveMemshareNode(levelOneId, levelTwoTitle);
        String operationTitle = exportType.getTitle();
        Long tipOperatieId = MemshareClient.getInstance().saveMemshareNode(levelTwoId, operationTitle);
        String yearKey = yearFormat.format(todayDate);
        Long yearId = MemshareClient.getInstance().saveMemshareNode(tipOperatieId, yearKey);
        String thisMonthKey = monthYearFormat.format(todayDate);
        Long monthId = MemshareClient.getInstance().saveMemshareNode(yearId, thisMonthKey);
        String todayKey = yearMonthDayFormat.format(todayDate);
        Long todayId = MemshareClient.getInstance().saveMemshareNode(monthId, todayKey);
        Long frunzaId = MemshareClient.getInstance().saveMemshareNode(todayId, mem.getTitle());
        System.out.println("Id nod = " + frunzaId);
        MemshareClient.getInstance().saveMemshareDescription(frunzaId, mem.getDescription());
        return frunzaId;
    }

    public Boolean exportFile(Long idNode, File file, FileTransferStatusListener listener) {
        Boolean result = false;
        try {
            result = MemshareClient.getInstance().saveMemshareFile(idNode, file, listener);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        return result;
    }
}

