/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.restaurant.modules.nativeonline.db;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Vector;
import ro.atreides.ecr_online_native.database.ProductData;
import ro.atreides.utils.Utils;
import ro.atreides.utils.db.DaoInterface;

public class NativeOnlineDao
implements DaoInterface {
    private Connection connection;
    private PreparedStatement getProductsById;
    private PreparedStatement getProductsByCodBare;

    public Connection getConnection() {
        return this.connection;
    }

    public NativeOnlineDao(Connection connection) throws SQLException {
        this.connection = connection;
        this.buildPreparedStatements();
    }

    @Override
    public void buildPreparedStatements() throws SQLException {
        String s = "select products.id as id_product, cod_bare, products.label as product_name, subcategories.cod_departament, subcategories.id as grupa, tva.casa_marcat as cod_tva from products inner join subcategories on products.id_subcategory = subcategories.id inner join tva on subcategories.id_tva = tva.id where products.status = 1";
        this.getProductsById = this.connection.prepareStatement(s + " and (products.id = ? or ? = " + -1 + ")");
        this.getProductsByCodBare = this.connection.prepareStatement(s + " and products.cod_bare = ?");
    }

    private ProductData getProductDataFromRs(ResultSet rs) throws SQLException {
        String pName = rs.getString("product_name").toUpperCase();
        pName = Utils.getStringMaxSize(18, pName, Character.valueOf(' '), false);
        ProductData pd = new ProductData(rs.getString("cod_bare"), pName, "-1", "3000", rs.getString("cod_departament"), rs.getString("grupa"), rs.getString("cod_tva"), 3000.0);
        pd.setProductId(rs.getInt("id_product"));
        return pd;
    }

    public Vector getProducts(int idProduct) throws SQLException {
        Vector<ProductData> result = new Vector<ProductData>();
        this.getProductsById.setInt(1, idProduct);
        this.getProductsById.setInt(2, idProduct);
        ResultSet rs = this.getProductsById.executeQuery();
        while (rs.next()) {
            ProductData pd = this.getProductDataFromRs(rs);
            result.add(pd);
        }
        rs.close();
        return result;
    }

    public ProductData getProductByCodBare(String codBare) throws SQLException {
        ProductData result = null;
        this.getProductsByCodBare.setString(1, codBare);
        ResultSet rs = this.getProductsByCodBare.executeQuery();
        if (rs.next()) {
            result = this.getProductDataFromRs(rs);
        }
        rs.close();
        return result;
    }
}

