/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.restaurant.modules.pda5;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.util.Hashtable;
import java.util.Vector;
import ro.atreides.nomenclatura.NomeclaturaLogic;
import ro.atreides.nomenclatura.Product;
import ro.atreides.nomenclatura.Sectie;
import ro.atreides.restaurant.VpConfig;
import ro.atreides.restaurant.base.OrdineServire;
import ro.atreides.restaurant.base.ScreenSaleInterface;
import ro.atreides.restaurant.base.Table;
import ro.atreides.restaurant.logic.LocationsFilter;
import ro.atreides.restaurant.logic.RestLogic;
import ro.atreides.restaurant.logic.TablesFilter;
import ro.atreides.users.User;
import ro.atreides.users.UsersLogic;
import ro.atreides.utils.FileUtils;
import ro.atreides.utils.Logger;
import ro.atreides.utils.Order;
import ro.atreides.utils.TextUtils;
import ro.atreides.utils.Utils;
import ro.atreides.utils.gui.Validators;
import ro.atreides.utils.messaging.Message;
import ro.atreides.utils.messaging.Messenger;
import ro.deversoft.android.foodpda.beans.BonMarcaj;
import ro.deversoft.android.foodpda.beans.Sale;
import ro.deversoft.android.foodpda.beans.TableStatus;
import ro.deversoft.android.foodpda.messages.AbstractMessage;
import ro.deversoft.android.foodpda.messages.IncasatMessage;
import ro.deversoft.android.foodpda.messages.IncasatReply;
import ro.deversoft.android.foodpda.messages.LoginMessage;
import ro.deversoft.android.foodpda.messages.LoginReply;
import ro.deversoft.android.foodpda.messages.MarcajMessage;
import ro.deversoft.android.foodpda.messages.MarcajReply;
import ro.deversoft.android.foodpda.messages.NotaMessage;
import ro.deversoft.android.foodpda.messages.NotaReply;
import ro.deversoft.android.foodpda.messages.NotificationsAcknoledgedMessage;
import ro.deversoft.android.foodpda.messages.NotificationsAcknoledgedReply;
import ro.deversoft.android.foodpda.messages.PingMessage;
import ro.deversoft.android.foodpda.messages.PingReply;
import ro.deversoft.android.foodpda.messages.ReadDataMessage;
import ro.deversoft.android.foodpda.messages.ReadDataReply;
import ro.deversoft.android.foodpda.messages.ReadNotificationsMessage;
import ro.deversoft.android.foodpda.messages.ReadNotificationsReply;
import ro.deversoft.android.foodpda.messages.RefreshTableMessage;
import ro.deversoft.android.foodpda.messages.RefreshTableReply;

public class Pda5ServerConnection
extends Thread {
    private Socket s;
    private ObjectOutputStream outS;
    private ObjectInputStream inputS;
    private int readTimeout = 30000;
    private String remoteIp;
    private TablesFilter tablesFilter;
    private LocationsFilter locationsFilter;

    public Pda5ServerConnection(Socket s, TablesFilter tablesFilter, LocationsFilter locationsFilter) {
        this.s = s;
        this.tablesFilter = tablesFilter;
        this.locationsFilter = locationsFilter;
        try {
            InetAddress sa = s.getInetAddress();
            this.remoteIp = sa.getHostAddress();
            Logger.logInfo(this, "New connection started by : " + this.remoteIp);
            OutputStream os = s.getOutputStream();
            this.outS = new ObjectOutputStream(os);
            this.outS.flush();
            InputStream ins = s.getInputStream();
            this.inputS = new ObjectInputStream(ins);
            this.setName(this.getClass().getName());
            this.start();
        }
        catch (IOException e) {
            Logger.logError((Object)this, e);
        }
    }

    @Override
    public void run() {
        while (true) {
            try {
                while (true) {
                    AbstractMessage reply;
                    AbstractMessage log;
                    AbstractMessage reply2;
                    AbstractMessage message = (AbstractMessage)this.inputS.readObject();
                    Logger.logDebug(this, "PDA5: Received message from " + this.remoteIp + " : " + message.getClass().getName() + " " + message.toString());
                    if (message instanceof ReadDataMessage) {
                        String xmlFile = RestLogic.getInstance().exportProductsToPOS(this.tablesFilter, this.locationsFilter);
                        String content = FileUtils.readFileToString(xmlFile);
                        reply2 = new ReadDataReply(content);
                        this.outS.writeObject(reply2);
                        this.outS.flush();
                    }
                    if (message instanceof ReadNotificationsMessage) {
                        ReadNotificationsMessage rd = (ReadNotificationsMessage)message;
                        Vector messages = Messenger.getInstance().getMessages("pda_" + rd.getIdUser());
                        messages = Utils.getDistinct(messages);
                        StringBuffer sb = new StringBuffer();
                        for (int i = 0; i < messages.size(); ++i) {
                            Message mess = (Message)messages.elementAt(i);
                            sb.append(mess.getText());
                            if (i >= messages.size() - 1) continue;
                            sb.append(',');
                        }
                        ReadNotificationsReply reply3 = new ReadNotificationsReply(sb.toString());
                        this.outS.writeObject(reply3);
                        this.outS.flush();
                    }
                    if (message instanceof RefreshTableMessage) {
                        Vector<TableStatus> tables = new Vector<TableStatus>();
                        Vector<Table> allTables = RestLogic.getInstance().getTables();
                        for (Table t1 : allTables) {
                            if (!this.tablesFilter.acceptTable(t1)) continue;
                            Order o1 = RestLogic.getInstance().getOpenOrderAtTable(t1);
                            int idWaiter = -1;
                            String waiterName = "";
                            int status = -1;
                            if (o1 != null) {
                                idWaiter = o1.getUser();
                                status = o1.getStatus();
                                waiterName = UsersLogic.getInstance().getUserById(idWaiter).getLogin();
                                waiterName = TextUtils.escapeForXML(waiterName);
                            }
                            TableStatus ts = new TableStatus(idWaiter, t1.getId(), waiterName, status);
                            tables.add(ts);
                        }
                        reply2 = new RefreshTableReply(tables);
                        this.outS.writeObject(reply2);
                        this.outS.flush();
                    }
                    if (message instanceof NotificationsAcknoledgedMessage) {
                        NotificationsAcknoledgedMessage nam = (NotificationsAcknoledgedMessage)message;
                        Messenger.getInstance().deleteMessagesByChannel("pda_" + nam.getIdUser());
                        NotificationsAcknoledgedReply reply4 = new NotificationsAcknoledgedReply();
                        this.outS.writeObject(reply4);
                        this.outS.flush();
                    }
                    if (message instanceof LoginMessage) {
                        log = (LoginMessage)message;
                        Logger.logDebug(this, "Received login request : " + ((LoginMessage)log).getUser() + " with password : ****");
                        User userFO = UsersLogic.getInstance().verifyWaiterLogin(((LoginMessage)log).getUser(), ((LoginMessage)log).getPassword());
                        Logger.logDebug(this, "Found user : " + userFO);
                        int idUser = -1;
                        boolean isSuperUser = false;
                        if (userFO != null) {
                            idUser = userFO.getId();
                            if (VpConfig.getInstance().allowSuperUserOnPDA && UsersLogic.getInstance().isUserInGroup(idUser, "group_bo_users")) {
                                isSuperUser = true;
                            }
                        }
                        reply = new LoginReply(idUser, isSuperUser);
                        if (idUser > 0) {
                            Vector<User> allUsers = UsersLogic.getInstance().getUsersInGroup("group_fo_users");
                            for (User user : allUsers) {
                                ((LoginReply)reply).addUser(user.getLogin(), user.getId());
                            }
                        }
                        Logger.logDebug(this, "LoginReply idWaiter: " + ((LoginReply)reply).getIdWaiter());
                        this.outS.writeObject(reply);
                        this.outS.flush();
                    }
                    if (message instanceof NotaMessage) {
                        NotaMessage notaMessage = (NotaMessage)message;
                        int idTable = notaMessage.getIdTable();
                        Table t = RestLogic.getInstance().getTableById(idTable);
                        Order o = RestLogic.getInstance().getOpenOrderAtTable(t);
                        reply = null;
                        if (o != null) {
                            User u = UsersLogic.getInstance().getUserById(o.getUser());
                            if (o.getUser() == notaMessage.getIdUser()) {
                                RestLogic.getInstance().laPlataOrder(o, t, null);
                                reply = new NotaReply(true, u.getLogin(), idTable, o.getStatus(), o.getUser());
                            } else {
                                reply = new NotaReply(false, "Masa deschisa pe alt ospatar (" + u.getLogin() + ").");
                            }
                        } else {
                            reply = new NotaReply(false, "Nici o nota deschisa la masa ceruta.");
                        }
                        this.outS.writeObject(reply);
                        this.outS.flush();
                    }
                    if (message instanceof IncasatMessage) {
                        IncasatMessage incasatMessage = (IncasatMessage)message;
                        int idTable = incasatMessage.getIdTable();
                        Table t = RestLogic.getInstance().getTableById(idTable);
                        Order o = RestLogic.getInstance().getOpenOrderAtTable(t);
                        reply = null;
                        if (o != null && o.getUser() == incasatMessage.getIdUser()) {
                            if (o.isLaPlata()) {
                                if (incasatMessage.isFisc() && VpConfig.getInstance().printFiscalFromPda) {
                                    RestLogic.getInstance().printBonFiscalSeparat(o, true);
                                }
                                RestLogic.getInstance().closeOrder(o);
                                reply = new IncasatReply(true, -1, t.getId());
                            } else {
                                reply = new IncasatReply(false, "Emiteti nota de plata intai.");
                            }
                        } else if (o != null) {
                            User u = UsersLogic.getInstance().getUserById(o.getUser());
                            String err = "Masa deschisa pe alt ospatar (" + u.getLogin() + ")";
                            reply = new IncasatReply(false, err);
                        } else {
                            reply = new IncasatReply(true, -1, t.getId());
                        }
                        this.outS.writeObject(reply);
                        this.outS.flush();
                    }
                    if (message instanceof MarcajMessage) {
                        log = (MarcajMessage)message;
                        BonMarcaj bm = ((MarcajMessage)log).getBonMarcaj();
                        User loggedInUser = UsersLogic.getInstance().getUserById(bm.getIdOspatar());
                        if (bm.getSales().size() > 0) {
                            Logger.logDebug(this, "User: " + loggedInUser.getLogin() + " BonMarcaj: " + ((MarcajMessage)log).toString());
                        }
                        Table t = RestLogic.getInstance().getTableById(bm.getIdMasa());
                        Order o = RestLogic.getInstance().getOpenOrderAtTable(t);
                        MarcajReply mreply = null;
                        if (o != null && o.getUser() != bm.getIdOspatar()) {
                            User u = UsersLogic.getInstance().getUserById(o.getUser());
                            String err = "Masa deschisa pe alt ospatar (" + u.getLogin() + ")";
                            mreply = new MarcajReply(false, err);
                            Logger.logDebug(this, err);
                        } else {
                            if (o == null) {
                                o = RestLogic.getInstance().newOrder(bm.getIdMasa(), bm.getIdOspatar());
                            }
                            if (o == null) {
                                String s = "Nu am putut deschide order la masa " + bm.getIdMasa() + " pt ospatarul : " + bm.getIdOspatar();
                                Logger.logDebug(this, s);
                                mreply = new MarcajReply(false, s);
                            } else {
                                this.marcaj(bm.getSales(), o, t);
                                int maxPlatou = 0;
                                Vector<Sale> newSales = new Vector<Sale>();
                                if (o != null) {
                                    Vector<ro.atreides.restaurant.base.Sale> sales = RestLogic.getInstance().getSales(o.getId(), true, -1, new ScreenSaleInterface());
                                    for (int i = 0; i < sales.size(); ++i) {
                                        OrdineServire os;
                                        Vector<OrdineServire> osv;
                                        ro.atreides.restaurant.base.Sale o1 = sales.elementAt(i);
                                        if (o1.getCantitateMarcata() <= 0.0) continue;
                                        String servire = "";
                                        int idServire = o1.getIdServire();
                                        if (idServire > 0 && (osv = RestLogic.getInstance().getOrdineServire(o1.getIdServire())).size() > 0 && (os = osv.get(0)) != null && Validators.correctString(os.getServire())) {
                                            servire = os.getServire();
                                        }
                                        Sale s = new Sale(o1.getIdProduct(), o1.getProductName(), (float)o1.getPrice(), (float)o1.getCantitateMarcata(), o1.getIdPlatou(), o1.getIdServire(), servire);
                                        String prep = o1.getModPreparare();
                                        if (Validators.correctString(prep)) {
                                            s.setPreparare(prep);
                                        }
                                        if (o1.getIdPlatou() > maxPlatou) {
                                            maxPlatou = o1.getIdPlatou();
                                        }
                                        newSales.add(s);
                                    }
                                }
                                mreply = new MarcajReply(true, newSales, maxPlatou, t.getId(), o.getStatus(), loggedInUser.getId(), loggedInUser.getLogin());
                            }
                        }
                        this.outS.writeObject(mreply);
                        this.outS.flush();
                    }
                    if (!(message instanceof PingMessage)) continue;
                    this.outS.writeObject(new PingReply());
                    this.outS.flush();
                }
            }
            catch (SocketTimeoutException e) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {
                    continue;
                }
            }
            catch (SocketException e) {
            }
            catch (EOFException e) {
            }
            catch (IOException e) {
                Logger.logError((Object)this, e);
            }
            catch (Throwable th) {
                Logger.logError((Object)this, th);
                continue;
            }
            break;
        }
        Logger.logInfo(this, "Closing connection with : " + this.remoteIp);
        if (this.inputS != null) {
            try {
                this.inputS.close();
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        if (this.outS != null) {
            try {
                this.outS.close();
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        if (this.s != null) {
            try {
                this.s.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        Logger.logInfo(this, "CLOSED connection with : " + this.remoteIp + " . Normal exit");
    }

    private void marcaj(Vector<Sale> presales, Order o, Table t) {
        if (presales.size() < 1 || o.isLaPlata()) {
            return;
        }
        Hashtable nonEmptySectii = new Hashtable();
        for (Sale sale : presales) {
            int idProduct = sale.getIdProduct();
            Product product = NomeclaturaLogic.getInstance().getProductById(idProduct);
            Sectie c2 = NomeclaturaLogic.getInstance().getSectieByCategoryId(product.getIdCategorie());
            Vector<ro.atreides.restaurant.base.Sale> tempSales = (Vector<ro.atreides.restaurant.base.Sale>)nonEmptySectii.get(c2);
            if (tempSales == null) {
                tempSales = new Vector<ro.atreides.restaurant.base.Sale>();
            }
            double q = sale.getCantitateNoua();
            int idPlatou = sale.getIdPlatou();
            String preparare = sale.getPreparare();
            if (q > 0.0) {
                long now = System.currentTimeMillis();
                String numeSectiePrefix = "";
                double price = sale.getPret();
                ro.atreides.restaurant.base.Sale ts = RestLogic.getInstance().buildSale(product, 0.0, q, preparare, -1, idPlatou, -1, -1, sale.getIdServire(), now, price, numeSectiePrefix, 0);
                tempSales.add(ts);
            }
            if (tempSales.size() <= 0) continue;
            nonEmptySectii.put(c2, tempSales);
        }
        int i = 1;
        int max = new Vector(nonEmptySectii.keySet()).size();
        for (Sectie sectie : nonEmptySectii.keySet()) {
            Vector sales = (Vector)nonEmptySectii.get(sectie);
            boolean cutter = i == max;
            RestLogic.getInstance().productsSold(sales, o, t, sectie, false, null, cutter);
            ++i;
        }
    }
}

