/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.restaurant.modules.rezervari;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.io.File;
import java.io.IOException;
import java.util.Comparator;
import java.util.Date;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import jxl.write.Label;
import jxl.write.WritableCell;
import jxl.write.WritableSheet;
import jxl.write.WriteException;
import jxl.write.biff.RowsExceededException;
import ro.atreides.print.PrintLogic;
import ro.atreides.restaurant.modules.rezervari.CazariReportBean;
import ro.atreides.restaurant.modules.rezervari.RezervariLogic;
import ro.atreides.utils.Constants;
import ro.atreides.utils.Formatters;
import ro.atreides.utils.Logger;
import ro.atreides.utils.Utils;
import ro.atreides.utils.excel.ExcelProcessor;
import ro.atreides.utils.excel.ExcelUtils;
import ro.atreides.utils.gui.ReportInterface;
import ro.atreides.utils.gui.Validators;
import ro.atreides.utils.gui.table.AbstractTM;
import ro.atreides.utils.gui.table.TmInterface;
import ro.atreides.utils.multilang.LangRoAll;
import ro.atreides.utils.reports.AbstractReportPanel;

public class CazariReport
extends AbstractReportPanel {
    private ReportInterface pdfReportInterface;
    private Hashtable printCriteria = new Hashtable();
    private static final String[] columns = new String[]{"Nume", "Act", "Adresa", "Perioada", "Camera", "Tarif"};
    private static final Class[] types = new Class[]{String.class, String.class, String.class, String.class, String.class};
    private JTextField cameraField;
    private JTextField adresaField;
    private JTextField numeField;

    @Override
    public Hashtable buildCriteria(Date startDate, Date stopDate) {
        Hashtable<String, Object> result = new Hashtable<String, Object>();
        String camera = this.cameraField.getText();
        if (Validators.correctString(camera)) {
            result.put("Camera", camera);
            this.printCriteria.put("Camera", camera);
        } else {
            this.printCriteria.remove("Camera");
        }
        String nume = this.numeField.getText();
        if (Validators.correctString(nume)) {
            result.put("Nume", nume);
            this.printCriteria.put("Nume", nume);
        } else {
            this.printCriteria.remove("Nume");
        }
        String adresa = this.adresaField.getText();
        if (Validators.correctString(adresa)) {
            result.put("Adresa", adresa);
            this.printCriteria.put("Adresa", adresa);
        } else {
            this.printCriteria.remove("Adresa");
        }
        result.put(Constants.START_KEY, startDate);
        result.put(Constants.STOP_KEY, stopDate);
        this.printCriteria.put(LangRoAll.start, Formatters.DATE_AND_TIME_AND_SECONDS_HUMAN_FORMAT.format(startDate));
        this.printCriteria.put(LangRoAll.stop, Formatters.DATE_AND_TIME_AND_SECONDS_HUMAN_FORMAT.format(stopDate));
        return result;
    }

    @Override
    public void printReport() {
        PrintLogic.getInstance().printReport(this, this.pdfReportInterface, null, this.data);
    }

    @Override
    public void printPreview() {
        String pdfFile = PrintLogic.getInstance().buildReportPdfText(this.data, this.pdfReportInterface);
        PrintLogic.getInstance().printPreview(pdfFile);
    }

    @Override
    public Vector getResult(Hashtable criteria) {
        return RezervariLogic.getInstance().getRaportCazari(criteria);
    }

    @Override
    public void writeExcel(File reportFile) {
        try {
            ExcelUtils.writeExcel(reportFile, this.data, new ExcelProcessor(){

                @Override
                public void processLine(Object o, WritableSheet sheet, int row) {
                    CazariReportBean se = (CazariReportBean)o;
                    try {
                        Label label = new Label(0, row, se.getNume());
                        sheet.addCell((WritableCell)label);
                        label = new Label(1, row, se.getAct());
                        sheet.addCell((WritableCell)label);
                        label = new Label(2, row, se.getAdresa());
                        sheet.addCell((WritableCell)label);
                        sheet.addCell((WritableCell)new Label(3, row, se.getPerioada()));
                        sheet.addCell((WritableCell)new Label(4, row, se.getCamera()));
                        sheet.addCell((WritableCell)new Label(5, row, Utils.getString2Decimals(se.getTarif())));
                    }
                    catch (RowsExceededException e) {
                        Logger.logException(this, (Exception)((Object)e));
                    }
                    catch (WriteException e) {
                        Logger.logException(this, (Exception)((Object)e));
                    }
                }

                @Override
                public String[] getColumns() {
                    return columns;
                }

                @Override
                public String getSheetName() {
                    return CazariReport.this.getName();
                }

                @Override
                public int buildHeader(WritableSheet sheet, int startRow) {
                    return 0;
                }

                @Override
                public void buildTotal(WritableSheet sheet, int row, int firstTableRow, int lastTableRow) {
                }
            }, this.printCriteria);
        }
        catch (WriteException e) {
            Logger.logException(this, (Exception)((Object)e));
        }
        catch (IOException e) {
            Logger.logException(this, (Exception)e);
        }
    }

    @Override
    public String getName() {
        return "Istoric";
    }

    @Override
    public AbstractTM buildTableModel() {
        this.tm = new AbstractTM(columns, types, new TmInterface(){

            @Override
            public void setValueAt(Object aValue, int rowIndex, int columnIndex, Vector data) {
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return false;
            }

            @Override
            public Object getValueAt(int rowIndex, int columnIndex, Vector data) {
                CazariReportBean se = (CazariReportBean)data.elementAt(rowIndex);
                if (se == null) {
                    return null;
                }
                switch (columnIndex) {
                    case 0: {
                        return se.getNume();
                    }
                    case 1: {
                        return se.getAct();
                    }
                    case 2: {
                        return se.getAdresa();
                    }
                    case 3: {
                        return se.getPerioada();
                    }
                    case 4: {
                        return se.getCamera();
                    }
                    case 5: {
                        return Utils.getString2Decimals(se.getTarif());
                    }
                }
                return null;
            }
        });
        return this.tm;
    }

    @Override
    public JPanel buildTotalPanel() {
        return null;
    }

    @Override
    public JPanel buildCustomParamsPanel() {
        JPanel result = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.insets = new Insets(2, 2, 2, 2);
        c.gridheight = 1;
        c.gridwidth = 1;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.anchor = 17;
        c.fill = 2;
        c.gridy = 0;
        c.gridx = 0;
        c.weightx = 0.0;
        result.add((Component)new JLabel("Camera"), c);
        ++c.gridx;
        c.weightx = 1.0;
        this.cameraField = new JTextField(20);
        result.add((Component)this.cameraField, c);
        ++c.gridy;
        c.gridx = 0;
        c.weightx = 0.0;
        result.add((Component)new JLabel("Nume"), c);
        ++c.gridx;
        c.weightx = 1.0;
        this.numeField = new JTextField(20);
        result.add((Component)this.numeField, c);
        ++c.gridy;
        c.gridx = 0;
        c.weightx = 0.0;
        result.add((Component)new JLabel("Adresa"), c);
        ++c.gridx;
        c.weightx = 1.0;
        this.adresaField = new JTextField(20);
        result.add((Component)this.adresaField, c);
        return result;
    }

    @Override
    public void refreshTotalPanel() {
    }

    @Override
    public void doStuff() {
        this.pdfReportInterface = new ReportInterface(){

            @Override
            public int getColumnCount() {
                return columns.length;
            }

            @Override
            public int getColumnSize(int column) {
                switch (column) {
                    case 0: {
                        return 2;
                    }
                    case 1: {
                        return 1;
                    }
                    case 2: {
                        return 2;
                    }
                    case 3: {
                        return 2;
                    }
                    case 4: {
                        return 2;
                    }
                    case 5: {
                        return 1;
                    }
                }
                return 1;
            }

            @Override
            public String getColumnName(int column) {
                return columns[column];
            }

            @Override
            public String getTotal(int column) {
                switch (column) {
                    case 0: {
                        return LangRoAll.total;
                    }
                    case 1: {
                        return "";
                    }
                    case 2: {
                        return "";
                    }
                    case 3: {
                        return "";
                    }
                    case 4: {
                        return CazariReport.this.data.size() + "";
                    }
                }
                return null;
            }

            @Override
            public String getReportTitle() {
                return CazariReport.this.getName();
            }

            @Override
            public Hashtable getCriteria() {
                return CazariReport.this.printCriteria;
            }

            @Override
            public boolean isLandscape() {
                return true;
            }

            @Override
            public String getCellContent(Object row, int column) {
                CazariReportBean se = (CazariReportBean)row;
                if (se == null) {
                    return null;
                }
                switch (column) {
                    case 0: {
                        return se.getNume();
                    }
                    case 1: {
                        return se.getAct();
                    }
                    case 2: {
                        return se.getAdresa();
                    }
                    case 3: {
                        return se.getPerioada();
                    }
                    case 4: {
                        return se.getCamera();
                    }
                    case 5: {
                        return Utils.getString2Decimals(se.getTarif());
                    }
                }
                return null;
            }
        };
    }

    @Override
    public Comparator getComparatorForColumn(int columnIndex) {
        return null;
    }
}

