/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.restaurant.modules.rezervari;

import java.awt.Color;
import java.awt.Component;
import java.sql.Timestamp;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import ro.atreides.restaurant.modules.rezervari.ListaCamereCell;
import ro.atreides.restaurant.modules.rezervari.ListaCamereView;
import ro.atreides.restaurant.modules.rezervari.RezervariLogic;
import ro.atreides.utils.Client;
import ro.atreides.utils.Formatters;
import ro.atreides.utils.gui.Validators;
import ro.atreides.utils.gui.table.AbstractTM;

public class ListaCamereCellRenderer
extends DefaultTableCellRenderer {
    private AbstractTM model;

    public ListaCamereCellRenderer(AbstractTM model) {
        this.model = model;
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        ListaCamereView line = (ListaCamereView)this.model.getData().elementAt(row);
        if (column > 0 && column < this.model.getColumnCount() - 1) {
            ListaCamereCell cell = line.getData().elementAt(column - 4);
            this.setBackground(cell.getBackground());
            this.setForeground(cell.getForeground());
            Timestamp start = cell.getStart();
            String s1 = "-";
            if (start != null) {
                s1 = Formatters.DATE_AND_TIME_FORMAT.format(start);
            }
            String s2 = "-";
            Timestamp stop = cell.getStop();
            if (stop != null) {
                s2 = Formatters.DATE_AND_TIME_FORMAT.format(stop);
            }
            String client = "-";
            Client c = cell.getClient();
            if (c != null) {
                client = c.toString();
            }
            String dateContact = "-";
            if (c != null) {
                dateContact = c.getDateContact("<br><li>");
            }
            String text = "";
            if (cell.getIdCalendar() > 0) {
                text = "<html>Camera: " + line.getLabel() + "<br>Id: " + cell.getIdCalendar() + "<br>Client: " + client + "<br>" + "Sex: " + RezervariLogic.getInstance().getLongStringForSex(cell.getSex()) + "<br>" + "Start: " + s1 + "<br>" + "Stop: " + s2 + "<br>" + "Date contact: " + dateContact;
                String detaliiRezervare = cell.getInfo().getDetaliiRezervare();
                if (Validators.correctString(detaliiRezervare)) {
                    text = text + "<br>Detalii: " + detaliiRezervare;
                }
                text = text + "</html>";
            } else {
                text = "<html>Camera: " + line.getLabel() + "</html>";
            }
            this.setToolTipText(text);
        } else if (line.isSelected()) {
            this.setBackground(Color.BLACK);
            this.setForeground(Color.WHITE);
        } else {
            this.setBackground(Color.WHITE);
            this.setForeground(Color.BLACK);
        }
        return this;
    }
}

