/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.restaurant.modules.rezervari;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.io.IOException;
import java.sql.Timestamp;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import jxl.write.Label;
import jxl.write.WritableCell;
import jxl.write.WritableSheet;
import jxl.write.WriteException;
import jxl.write.biff.RowsExceededException;
import ro.atreides.clienti.ClientLogic;
import ro.atreides.restaurant.VpConfig;
import ro.atreides.restaurant.base.Table;
import ro.atreides.restaurant.gui.hotel.EditRezervarePanel;
import ro.atreides.restaurant.gui.hotel.HotelCamerePanel;
import ro.atreides.restaurant.gui.hotel.HotelOrder;
import ro.atreides.restaurant.gui.touch2.TouchMain2;
import ro.atreides.restaurant.logic.RestLogic;
import ro.atreides.restaurant.modules.rezervari.Column;
import ro.atreides.restaurant.modules.rezervari.HotelGroup;
import ro.atreides.restaurant.modules.rezervari.ListaCamereCell;
import ro.atreides.restaurant.modules.rezervari.ListaCamereCellRenderer;
import ro.atreides.restaurant.modules.rezervari.ListaCamereView;
import ro.atreides.restaurant.modules.rezervari.RezervareBean;
import ro.atreides.restaurant.modules.rezervari.RezervariLogic;
import ro.atreides.restaurant.modules.rezervari.RezervariMeseView;
import ro.atreides.restaurant.modules.rezervari.RezervariPanel;
import ro.atreides.users.User;
import ro.atreides.users.UsersLogic;
import ro.atreides.utils.CleanupRequired;
import ro.atreides.utils.Client;
import ro.atreides.utils.Constants;
import ro.atreides.utils.DateUtils;
import ro.atreides.utils.EventListener;
import ro.atreides.utils.FloatUtils;
import ro.atreides.utils.Formatters;
import ro.atreides.utils.Location;
import ro.atreides.utils.Logger;
import ro.atreides.utils.Order;
import ro.atreides.utils.Utils;
import ro.atreides.utils.excel.ExcelProcessor;
import ro.atreides.utils.excel.ExcelUtils;
import ro.atreides.utils.gui.ComboUtils;
import ro.atreides.utils.gui.DateSelectorInterface;
import ro.atreides.utils.gui.GuiUtils;
import ro.atreides.utils.gui.Legenda;
import ro.atreides.utils.gui.PeriodOnlyNoTimeDateSelector;
import ro.atreides.utils.gui.dialogs.DialogUtils;
import ro.atreides.utils.gui.table.AbstractTM;
import ro.atreides.utils.gui.table.ColumnSizeProvider;
import ro.atreides.utils.gui.table.TmInterface;
import ro.atreides.utils.gui.xcombo.FilterableComboBoxModel;
import ro.atreides.utils.gui.xcombo.XComboBox;
import ro.atreides.utils.multilang.LangRoAll;
import ro.atreides.utils.reports.AbstractReportPanel;

public class ListaRezervariPanel
extends AbstractReportPanel
implements CleanupRequired {
    private JComboBox locatii;
    private JComboBox status;
    private JComboBox grup;
    private XComboBox clienti;
    private RestLogic logic;
    private Hashtable printCriteria = new Hashtable();
    private static String[] columns = new String[]{" "};
    private static Class[] types = new Class[]{String.class};
    private static final String ocupareTableColumnName = "Ocupare %";
    private static final String murdaraTableColumnName = "Murdara";
    private static final String defectaTableColumnName = "Defecta";
    private static final String cameraColumnName = "Camera";
    private JLabel total;
    private FilterableComboBoxModel clientsComboModel;
    private JComponent parent;
    private Vector intervals;
    private RezervariPanel mainPanel;
    public static final int intervalStartPosition = 4;
    private static Comparator label_sorter = new Comparator(){

        public int compare(Object o1, Object o2) {
            ListaCamereView lcv1 = (ListaCamereView)o1;
            ListaCamereView lcv2 = (ListaCamereView)o2;
            return lcv1.getLabel().compareToIgnoreCase(lcv2.getLabel());
        }
    };
    private static Comparator ocupare_sorter = new Comparator(){

        public int compare(Object o1, Object o2) {
            ListaCamereView lcv1 = (ListaCamereView)o1;
            ListaCamereView lcv2 = (ListaCamereView)o2;
            double c1 = lcv1.getGradOcupareInPerioada();
            double c2 = lcv2.getGradOcupareInPerioada();
            return (int)(c1 - c2);
        }
    };
    private static Comparator defecta_sorter = new Comparator(){

        public int compare(Object o1, Object o2) {
            ListaCamereView lcv1 = (ListaCamereView)o1;
            ListaCamereView lcv2 = (ListaCamereView)o2;
            boolean c1 = lcv1.isDefecta();
            boolean c2 = lcv2.isDefecta();
            if (c1 && c2 || !c1 && !c2) {
                return 0;
            }
            if (c1) {
                return -1;
            }
            return 1;
        }
    };
    private static Comparator murdara_sorter = new Comparator(){

        public int compare(Object o1, Object o2) {
            ListaCamereView lcv1 = (ListaCamereView)o1;
            ListaCamereView lcv2 = (ListaCamereView)o2;
            boolean c1 = lcv1.isMurdara();
            boolean c2 = lcv2.isMurdara();
            if (c1 && c2 || !c1 && !c2) {
                return 0;
            }
            if (c1) {
                return -1;
            }
            return 1;
        }
    };

    public ListaRezervariPanel(JComponent parent, RezervariPanel mainPanel) {
        this.logic = RestLogic.getInstance();
        this.parent = parent;
        this.mainPanel = mainPanel;
    }

    @Override
    public Hashtable buildCriteria(Date startDate, Date stopDate) {
        Hashtable<String, Object> result = new Hashtable<String, Object>();
        startDate = DateUtils.setTimeToDate(startDate, 12, 0, 0, 0);
        stopDate = DateUtils.setTimeToDate(stopDate, 11, 59, 59, 999);
        result.put(Constants.START_KEY, startDate);
        result.put(Constants.STOP_KEY, stopDate);
        this.printCriteria.put(LangRoAll.start, Formatters.DATE_AND_TIME_AND_SECONDS_HUMAN_FORMAT.format(startDate));
        this.printCriteria.put(LangRoAll.stop, Formatters.DATE_AND_TIME_AND_SECONDS_HUMAN_FORMAT.format(stopDate));
        Object locatie = this.locatii.getSelectedItem();
        if (locatie instanceof Location) {
            result.put(Constants.LOCATIE_KEY, locatie);
            this.printCriteria.put(Constants.LOCATIE_KEY, locatie);
        } else {
            this.printCriteria.remove(Constants.LOCATIE_KEY);
        }
        Object c = this.clienti.getSelectedItem();
        if (c instanceof Client) {
            result.put(Constants.CLIENT_KEY, c);
            this.printCriteria.put(Constants.CLIENT_KEY, c);
        } else {
            this.printCriteria.remove(Constants.CLIENT_KEY);
        }
        if (ComboUtils.anythingButAllSelected(this.grup)) {
            HotelGroup hg = (HotelGroup)this.grup.getSelectedItem();
            result.put(Constants.GROUP_KEY, hg.getIdGrup());
            this.printCriteria.put(Constants.GROUP_KEY, hg);
        } else {
            this.printCriteria.remove(Constants.GROUP_KEY);
        }
        if (ComboUtils.anythingButAllSelected(this.status)) {
            int newStatus = 1;
            String stat = (String)this.status.getSelectedItem();
            if (stat.equalsIgnoreCase("Cazari")) {
                newStatus = 4;
            } else if (stat.equalsIgnoreCase("Rezervari")) {
                newStatus = 2;
            } else if (stat.equalsIgnoreCase("Sosiri")) {
                newStatus = 3;
            } else if (stat.equalsIgnoreCase("Checkout")) {
                newStatus = 5;
            } else if (stat.equalsIgnoreCase("Istoric")) {
                newStatus = 6;
            }
            result.put(RezervariLogic.STATUS_KEY, newStatus);
            this.printCriteria.put(RezervariLogic.STATUS_KEY, stat);
        } else {
            this.printCriteria.remove(RezervariLogic.STATUS_KEY);
        }
        return result;
    }

    @Override
    public void printReport() {
        DialogUtils.errorDialog(GuiUtils.currentFrame, LangRoAll.functieNeimplementata, LangRoAll.nuPotContinua);
    }

    @Override
    public void printPreview() {
        DialogUtils.errorDialog(GuiUtils.currentFrame, LangRoAll.functieNeimplementata, LangRoAll.nuPotContinua);
    }

    @Override
    public Vector<ListaCamereView> getResult(Hashtable criteria) {
        Date start = (Date)criteria.get(Constants.START_KEY);
        Date stop = (Date)criteria.get(Constants.STOP_KEY);
        this.intervals = RezervariLogic.getRezervariIntervals(start, stop);
        columns = new String[this.intervals.size() + 4 + 1];
        ListaRezervariPanel.columns[0] = cameraColumnName;
        ListaRezervariPanel.columns[1] = defectaTableColumnName;
        ListaRezervariPanel.columns[2] = murdaraTableColumnName;
        ListaRezervariPanel.columns[3] = ocupareTableColumnName;
        ListaRezervariPanel.columns[ListaRezervariPanel.columns.length - 1] = cameraColumnName;
        types = Utils.getStringClass(columns.length);
        ListaRezervariPanel.types[1] = Boolean.class;
        ListaRezervariPanel.types[2] = Boolean.class;
        ListaRezervariPanel.types[3] = Double.class;
        Vector<ListaCamereView> result = RezervariLogic.getInstance().getListaCamere(criteria, this.intervals, start, stop);
        Hashtable<Integer, Integer> nrCamereLiberePerDay = new Hashtable<Integer, Integer>();
        for (ListaCamereView lcv : result) {
            for (int i = 0; i < this.intervals.size(); ++i) {
                ListaCamereCell lcc = lcv.getData().get(i);
                int s = lcc.getStatus();
                if (s != 1) continue;
                Integer nrCamereLibereForCurrentDay = (Integer)nrCamereLiberePerDay.get(i);
                if (nrCamereLibereForCurrentDay == null) {
                    nrCamereLibereForCurrentDay = new Integer(0);
                }
                Integer n = nrCamereLibereForCurrentDay;
                Integer n2 = nrCamereLibereForCurrentDay = Integer.valueOf(nrCamereLibereForCurrentDay + 1);
                nrCamereLiberePerDay.put(i, nrCamereLibereForCurrentDay);
            }
        }
        for (int i = 0; i < this.intervals.size(); ++i) {
            Column column = (Column)this.intervals.elementAt(i);
            Integer integer = (Integer)nrCamereLiberePerDay.get(i);
            if (integer == null) {
                integer = 0;
            }
            ListaRezervariPanel.columns[i + 4] = column.getLabel() + "(" + integer + ")";
        }
        this.replaceTableModel();
        Dimension preferredSize = this.table.getSize();
        preferredSize.setSize(2000, 1024);
        this.table.setPreferredSize(preferredSize);
        this.updateJTableColumns(this.table, new ListaCamereCellRenderer(this.tm));
        this.addMouseListeners();
        return result;
    }

    private void updateJTableColumns(JTable unu, DefaultTableCellRenderer renderer) {
        TableColumnModel colModel = unu.getColumnModel();
        Enumeration<TableColumn> enum1 = colModel.getColumns();
        while (enum1.hasMoreElements()) {
            TableColumn column = enum1.nextElement();
            if (column.getHeaderValue().equals(defectaTableColumnName) || column.getHeaderValue().equals(murdaraTableColumnName) || column.getHeaderValue().equals(ocupareTableColumnName)) continue;
            column.setCellRenderer(renderer);
        }
        GuiUtils.updateJTableColumnSize(unu, new ColumnSizeProvider(){

            @Override
            public int getColumnSize(int column) {
                switch (column) {
                    case 0: {
                        return 6;
                    }
                    case 1: {
                        return 2;
                    }
                    case 2: {
                        return 2;
                    }
                    case 3: {
                        return 4;
                    }
                }
                if (column == columns.length - 1) {
                    return 6;
                }
                return 3;
            }
        });
    }

    @Override
    public void writeExcel(File reportFile) {
        Date now = new Date();
        RezervariLogic.getInstance();
        final Date startZiHoteliera = RezervariLogic.getStartZiHoteliera(now);
        RezervariLogic.getInstance();
        final Date endZiHoteliera = RezervariLogic.getEndZiHoteliera(now);
        try {
            ExcelUtils.writeExcel(reportFile, this.data, new ExcelProcessor(){

                @Override
                public void processLine(Object o, WritableSheet sheet, int row) {
                    ListaCamereView lcv = (ListaCamereView)o;
                    try {
                        boolean doSmth = false;
                        if (lcv.isDefecta() || lcv.isMurdara()) {
                            doSmth = true;
                        }
                        Vector<ListaCamereCell> datas = lcv.getData();
                        ListaCamereCell cellForToday = null;
                        for (ListaCamereCell cell : datas) {
                            if (cell.getStatus() == 1 || !cell.getStart().before(endZiHoteliera) || !cell.getStop().after(startZiHoteliera)) continue;
                            cellForToday = cell;
                            break;
                        }
                        if (cellForToday != null) {
                            doSmth = true;
                        }
                        if (!doSmth) {
                            return;
                        }
                        int column = 0;
                        sheet.addCell((WritableCell)new Label(column++, row, lcv.getLabel()));
                        sheet.addCell((WritableCell)new Label(column++, row, lcv.isMurdara() ? ListaRezervariPanel.murdaraTableColumnName : " "));
                        sheet.addCell((WritableCell)new Label(column++, row, lcv.isDefecta() ? ListaRezervariPanel.defectaTableColumnName : " "));
                        if (cellForToday != null) {
                            if (cellForToday.getStatus() != 1) {
                                String status = cellForToday.getStatusString();
                                sheet.addCell((WritableCell)new Label(column++, row, status));
                                RezervareBean info = cellForToday.getInfo();
                                Timestamp iesire = info.getStop();
                                sheet.addCell((WritableCell)new Label(column++, row, Formatters.DATE_AND_TIME_FORMAT.format(iesire)));
                            } else {
                                sheet.addCell((WritableCell)new Label(column++, row, " "));
                                sheet.addCell((WritableCell)new Label(column++, row, " "));
                            }
                        } else {
                            sheet.addCell((WritableCell)new Label(column++, row, " "));
                            sheet.addCell((WritableCell)new Label(column++, row, " "));
                        }
                        sheet.addCell((WritableCell)new Label(column++, row, Utils.getStringXDecimals(lcv.getGradOcupareInPerioada(), 0)));
                    }
                    catch (RowsExceededException e) {
                        Logger.logException(this, (Exception)((Object)e));
                    }
                    catch (WriteException e) {
                        Logger.logException(this, (Exception)((Object)e));
                    }
                }

                @Override
                public String[] getColumns() {
                    return new String[]{ListaRezervariPanel.cameraColumnName, ListaRezervariPanel.murdaraTableColumnName, ListaRezervariPanel.defectaTableColumnName, "Status", "Iesire", "Ocup % in perioada raportata"};
                }

                @Override
                public String getSheetName() {
                    return ListaRezervariPanel.this.getName();
                }

                @Override
                public int buildHeader(WritableSheet sheet, int startRow) {
                    return 0;
                }

                @Override
                public void buildTotal(WritableSheet sheet, int row, int firstTableRow, int lastTableRow) {
                }
            }, this.printCriteria);
        }
        catch (WriteException e) {
            Logger.logException(this, (Exception)((Object)e));
        }
        catch (IOException e) {
            Logger.logException(this, (Exception)e);
        }
    }

    @Override
    public String getName() {
        return "Filtru";
    }

    @Override
    public AbstractTM buildTableModel() {
        this.tm = new AbstractTM(columns, types, new TmInterface(){

            @Override
            public Object getValueAt(int rowIndex, int columnIndex, Vector data) {
                ListaCamereView lcv = (ListaCamereView)data.elementAt(rowIndex);
                switch (columnIndex) {
                    case 0: {
                        if (lcv.isBold()) {
                            return "<html><strong>" + lcv.getLabel() + "</strong></html>";
                        }
                        return lcv.getLabel();
                    }
                    case 1: {
                        return new Boolean(lcv.isDefecta());
                    }
                    case 2: {
                        return new Boolean(lcv.isMurdara());
                    }
                    case 3: {
                        return FloatUtils.roundDoubleUp(lcv.getGradOcupareInPerioada(), 0);
                    }
                }
                if (columnIndex == columns.length - 1) {
                    return lcv.getLabel();
                }
                Vector<ListaCamereCell> datas = lcv.getData();
                ListaCamereCell cel = datas.get(columnIndex - 4);
                return "<html><font size = \"+1\">" + cel.getText() + "</font></html>";
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return columnIndex == 1 || columnIndex == 2;
            }

            @Override
            public void setValueAt(Object aValue, int rowIndex, int columnIndex, Vector data) {
                ListaCamereView lcv = (ListaCamereView)data.elementAt(rowIndex);
                switch (columnIndex) {
                    case 1: {
                        boolean defectaAcum = (Boolean)aValue;
                        lcv.setDefecta(defectaAcum);
                        RestLogic.getInstance().setCameraDefecta(lcv.getIdCamera(), defectaAcum);
                        ListaRezervariPanel.this.tm.fireTableCellUpdated(rowIndex, columnIndex);
                        break;
                    }
                    case 2: {
                        boolean murdaraAcum = (Boolean)aValue;
                        lcv.setMurdara(murdaraAcum);
                        RestLogic.getInstance().setCameraMurdara(lcv.getIdCamera(), murdaraAcum);
                        ListaRezervariPanel.this.tm.fireTableCellUpdated(rowIndex, columnIndex);
                        break;
                    }
                }
            }
        });
        return this.tm;
    }

    @Override
    public JPanel buildTotalPanel() {
        JPanel result = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.insets = new Insets(2, 2, 2, 2);
        c.gridheight = 1;
        c.gridwidth = 1;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.anchor = 10;
        c.fill = 2;
        c.gridy = 0;
        c.gridx = 0;
        this.total = new JLabel("");
        result.add((Component)this.total, c);
        final ListaRezervariPanel panel = this;
        ++c.gridx;
        JButton raportHotelierTuraInCurs = new JButton("Raport tura in curs");
        raportHotelierTuraInCurs.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                User receptioner = UsersLogic.getInstance().requestReceptionerLogin(GuiUtils.currentFrame, true, true);
                if (receptioner == null) {
                    DialogUtils.errorDialog(panel, LangRoAll.utilizatorSauParolaIncorecta, LangRoAll.nuPotContinua);
                    return;
                }
                RezervariLogic.getInstance().inchidereTuraHoteliera(receptioner, false);
            }
        });
        result.add((Component)raportHotelierTuraInCurs, c);
        ++c.gridx;
        JButton rezervare = new JButton("Rezervare noua");
        rezervare.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                Vector<ListaCamereView> selection = ListaRezervariPanel.this.getSelection();
                if (selection != null && selection.size() > 0) {
                    Date d1 = new Date();
                    Date d2 = DateUtils.advanceOneDay(d1);
                    ListaRezervariPanel.this.addRezervation(selection, d1, d2);
                } else {
                    DialogUtils.errorDialog(panel, "Selectati cel putin o camera", LangRoAll.nuPotContinua);
                }
            }
        });
        result.add((Component)rezervare, c);
        if (VpConfig.getInstance().hotelShowInchidereZiHotelieraButton) {
            ++c.gridx;
            JButton inchidereZi = new JButton("Adauga cazari");
            inchidereZi.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ev) {
                    if (DialogUtils.confirmDialog(ListaRezervariPanel.this.parent, "Adaugam produsul cazare pentru toate camerele ocupate", LangRoAll.confirmare)) {
                        boolean ok = RezervariLogic.getInstance().addProductsForZiHoteliera(ListaRezervariPanel.this.parent, VpConfig.getInstance().hotelAddProductAtInchidereZiHoteliera);
                        if (!ok) {
                            DialogUtils.errorDialog(ListaRezervariPanel.this.parent, "Reparati erorile afisate", LangRoAll.nuPotContinua);
                        } else {
                            DialogUtils.okDialog(ListaRezervariPanel.this.parent, LangRoAll.operatieExecutata, LangRoAll.succes);
                        }
                    }
                }
            });
            result.add((Component)inchidereZi, c);
        }
        ++c.gridx;
        JButton listaMasa = new JButton("Lista servicii");
        listaMasa.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                if (DialogUtils.confirmDialog(ListaRezervariPanel.this.parent, "Tiparim lista servicii", LangRoAll.confirmare)) {
                    RezervariLogic.getInstance().printListaServicii(ListaRezervariPanel.this.parent);
                }
            }
        });
        result.add((Component)listaMasa, c);
        if (VpConfig.getInstance().hotelShowInchidereZiHotelieraButton) {
            ++c.gridx;
            JButton inchidereTuraHoteliera = new JButton("Inchidere tura hoteliera");
            inchidereTuraHoteliera.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (DialogUtils.confirmDialog(ListaRezervariPanel.this.parent, "Inchidem tura hoteliera ", LangRoAll.confirmare)) {
                        User receptioner = UsersLogic.getInstance().requestReceptionerLogin(GuiUtils.currentFrame, true, true);
                        if (receptioner == null) {
                            DialogUtils.errorDialog(panel, LangRoAll.utilizatorSauParolaIncorecta, LangRoAll.nuPotContinua);
                            return;
                        }
                        RezervariLogic.getInstance().inchidereTuraHoteliera(receptioner, true);
                    }
                }
            });
            result.add(inchidereTuraHoteliera);
        }
        return result;
    }

    public void editRezervation(Vector<ListaCamereView> selection, ListaCamereCell cel) {
        EditRezervarePanel adEditRezervarePanel = new EditRezervarePanel(this.mainPanel.getLoggedInUser());
        JDialog dialog = DialogUtils.getJDialog(adEditRezervarePanel, GuiUtils.currentFrame, "Modifica rezervare", 1.2);
        adEditRezervarePanel.setParent(dialog);
        adEditRezervarePanel.doStuff();
        adEditRezervarePanel.setToEdit(selection, cel);
        dialog.pack();
        dialog.setVisible(true);
        this.raport();
    }

    public void editCazare(ListaCamereView selection, ListaCamereCell cel) {
        HotelCamerePanel main = new HotelCamerePanel();
        HotelOrder orderPanel = new HotelOrder(RestLogic.getInstance(), main, VpConfig.getInstance(), TouchMain2.sectii);
        int idTable = selection.getIdCamera();
        Table t = RestLogic.getInstance().getTableById(idTable);
        Order order = RezervariLogic.getInstance().getOpenOrderAtTable(t);
        User u = this.mainPanel.getLoggedInUser();
        if (u == null) {
            DialogUtils.errorDialog(this.parent, LangRoAll.neautentificat, LangRoAll.nuPotContinua);
            return;
        }
        orderPanel.setTable(t, u, order);
        JDialog dialog = DialogUtils.getJDialog(orderPanel, GuiUtils.currentFrame, "Modifica Cazare", 1.5);
        dialog.pack();
        dialog.setVisible(true);
        this.raport();
    }

    public void checkIn(ListaCamereView selection, ListaCamereCell cel) {
        RezervareBean rb;
        HotelCamerePanel main = new HotelCamerePanel();
        HotelOrder orderPanel = new HotelOrder(RestLogic.getInstance(), main, VpConfig.getInstance(), TouchMain2.sectii);
        int idTable = selection.getIdCamera();
        Table t = RestLogic.getInstance().getTableById(idTable);
        Order order = RezervariLogic.getInstance().getOpenOrderAtTable(t);
        User u = this.mainPanel.getLoggedInUser();
        if (u == null) {
            DialogUtils.errorDialog(this.parent, LangRoAll.neautentificat, LangRoAll.nuPotContinua);
            return;
        }
        if (order != null && (rb = RezervariLogic.getInstance().getCurrentRezervareForOrder(order.getId(), idTable)).getIdCalendar() != cel.getIdCalendar()) {
            DialogUtils.errorDialog(this.parent, "Exista deja o cazare pe camera " + selection.getLabel() + ". Faceti CheckOut intai", LangRoAll.nuPotContinua);
            return;
        }
        orderPanel.setTable(t, u, order);
        orderPanel.setToEdit(cel);
        JDialog dialog = DialogUtils.getJDialog(orderPanel, GuiUtils.currentFrame, "Checkin", 1.1);
        dialog.pack();
        dialog.setVisible(true);
        this.raport();
    }

    public void addRezervation(Vector selection, Date start, Date stop) {
        EditRezervarePanel adEditRezervarePanel = new EditRezervarePanel(this.mainPanel.getLoggedInUser());
        JDialog dialog = DialogUtils.getJDialog(adEditRezervarePanel, GuiUtils.currentFrame, "Rezervare noua", 1.5);
        adEditRezervarePanel.setParent(dialog);
        adEditRezervarePanel.doStuff();
        adEditRezervarePanel.newRezervation(selection, start, stop);
        dialog.pack();
        dialog.setVisible(true);
        this.raport();
    }

    @Override
    public JPanel buildCustomParamsPanel() {
        JPanel result = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.insets = new Insets(2, 2, 2, 2);
        c.gridheight = 1;
        c.gridwidth = 1;
        c.weightx = 0.0;
        c.weighty = 1.0;
        c.anchor = 17;
        c.fill = 0;
        c.gridx = 0;
        c.gridy = 0;
        c.gridheight = 3;
        Legenda l = new Legenda(new String[]{"Libera", "Rezervari", "Sosiri", "Cazari", "Checkout", "Istoric"}, new Color[]{Color.WHITE, Color.BLUE, Color.GREEN, Color.ORANGE, Color.RED, Color.LIGHT_GRAY}, 2);
        result.add((Component)l, c);
        c.anchor = 10;
        c.fill = 2;
        c.gridheight = 1;
        c.gridy = 0;
        c.gridx = 1;
        result.add((Component)new JLabel(LangRoAll.locatie), c);
        c.weightx = 1.0;
        ++c.gridx;
        this.locatii = new JComboBox();
        result.add((Component)this.locatii, c);
        c.gridx = 1;
        ++c.gridy;
        c.weightx = 0.0;
        result.add((Component)new JLabel(LangRoAll.client), c);
        ++c.gridx;
        c.weightx = 1.0;
        this.clientsComboModel = new FilterableComboBoxModel(ClientLogic.getInstance().getAllClientsSorted());
        this.clienti = new XComboBox(this.clientsComboModel, true);
        this.clienti.setPrototypeDisplayValue("111111111111111111111111111111111");
        this.clienti.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
                ListaRezervariPanel.this.clienti.selectAllText();
            }

            @Override
            public void focusLost(FocusEvent e) {
            }
        });
        result.add((Component)this.clienti, c);
        c.gridx = 1;
        ++c.gridy;
        c.weightx = 0.0;
        result.add((Component)new JLabel(LangRoAll.status), c);
        ++c.gridx;
        c.weightx = 1.0;
        this.status = new JComboBox();
        result.add((Component)this.status, c);
        c.gridx = 1;
        ++c.gridy;
        c.weightx = 0.0;
        result.add((Component)new JLabel(LangRoAll.grup), c);
        ++c.gridx;
        c.weightx = 1.0;
        this.grup = new JComboBox();
        result.add((Component)this.grup, c);
        return result;
    }

    public Vector<ListaCamereView> getSelection() {
        Vector<ListaCamereView> result = new Vector<ListaCamereView>();
        if (this.data != null) {
            for (ListaCamereView lcv : this.data) {
                if (!lcv.isSelected()) continue;
                result.add(lcv);
            }
        }
        return result;
    }

    @Override
    public void refreshTotalPanel() {
        int selLocuri = 0;
        int selCamere = 0;
        int totLocuri = 0;
        int totCamere = 0;
        for (ListaCamereView lcv : this.data) {
            if (lcv.isSelected()) {
                selLocuri += lcv.getLocuri();
                ++selCamere;
            }
            totLocuri += lcv.getLocuri();
            ++totCamere;
        }
        this.total.setText("Camere: " + selCamere + " / " + totCamere + " ; Locuri: " + selLocuri + " / " + totLocuri);
    }

    private void addMouseListeners() {
        this.table.addMouseListener(new MouseListener(){
            boolean dragging = false;
            int dragStartRow;
            int dragStartColumn;
            ListaCamereView dragStartLCV;
            ListaCamereView dragStopLCV;
            ListaCamereCell dragStartLCC;
            ListaCamereCell dragStopLCC;
            Date dragStartDate;
            Date dragStopDate;

            @Override
            public void mouseClicked(MouseEvent e) {
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }

            @Override
            public void mousePressed(MouseEvent e) {
                Point p;
                JTable t = (JTable)e.getSource();
                int selRow = t.rowAtPoint(p = e.getPoint());
                if (selRow == -1) {
                    return;
                }
                int columnIndex = t.columnAtPoint(p);
                int modifiers = e.getModifiers();
                if (!(columnIndex != 0 && columnIndex != columns.length - 1 || (modifiers & 8) <= 0 && (modifiers & 4) <= 0)) {
                    ListaCamereView nv;
                    nv.setSelected(!(nv = (ListaCamereView)ListaRezervariPanel.this.tm.getObjectAt(selRow)).isSelected());
                    ListaRezervariPanel.this.refreshTotalPanel();
                    ListaRezervariPanel.this.tm.fireTableRowsUpdated(selRow, selRow);
                } else if (columnIndex >= 4 && columnIndex < columns.length - 1 && ((modifiers & 8) > 0 || (modifiers & 4) > 0)) {
                    final JPopupMenu popup = new JPopupMenu();
                    final ListaCamereView lcv = (ListaCamereView)ListaRezervariPanel.this.data.elementAt(selRow);
                    Vector<ListaCamereCell> datas = lcv.getData();
                    final ListaCamereCell cel = datas.get(columnIndex - 4);
                    if (cel.getStatus() == 1) {
                        return;
                    }
                    if (cel.getStatus() == 2 || cel.getStatus() == 3) {
                        JMenuItem editRezervare = new JMenuItem("Modifica rezervare");
                        popup.add(editRezervare);
                        editRezervare.addActionListener(new ActionListener(){

                            @Override
                            public void actionPerformed(ActionEvent e) {
                                popup.setVisible(false);
                                Vector<ListaCamereView> selection = new Vector<ListaCamereView>();
                                selection.add(lcv);
                                if (selection != null && selection.size() > 0) {
                                    ListaRezervariPanel.this.editRezervation(selection, cel);
                                }
                            }
                        });
                        JMenuItem checkin = new JMenuItem("Check In");
                        popup.add(checkin);
                        checkin.addActionListener(new ActionListener(){

                            @Override
                            public void actionPerformed(ActionEvent e) {
                                popup.setVisible(false);
                                Vector<ListaCamereView> selection = new Vector<ListaCamereView>();
                                selection.add(lcv);
                                ListaRezervariPanel.this.checkIn(lcv, cel);
                            }
                        });
                    }
                    if (cel.getStatus() == 5 || cel.getStatus() == 4) {
                        JMenuItem editCazare = new JMenuItem("Modifica cazare");
                        popup.add(editCazare);
                        editCazare.addActionListener(new ActionListener(){

                            @Override
                            public void actionPerformed(ActionEvent e) {
                                popup.setVisible(false);
                                Vector<ListaCamereView> selection = new Vector<ListaCamereView>();
                                selection.add(lcv);
                                ListaRezervariPanel.this.editCazare(lcv, cel);
                            }
                        });
                    }
                    if (cel.getStatus() == 2 || cel.getStatus() == 3 || VpConfig.getInstance().allowStergereRezervareCuAvans && cel.getStatus() == 3 || VpConfig.getInstance().allowStergereRezervareCuCazare && cel.getStatus() == 4) {
                        JMenuItem sterge = new JMenuItem(LangRoAll.sterge);
                        popup.add(sterge);
                        sterge.addActionListener(new ActionListener(){

                            @Override
                            public void actionPerformed(ActionEvent e) {
                                popup.setVisible(false);
                                if (DialogUtils.confirmDialog(GuiUtils.currentFrame, "Stergem aceasta rezervare", LangRoAll.confirmare)) {
                                    User supervizor = null;
                                    boolean passwordRequested = VpConfig.getInstance().passwordForStergereRezervare;
                                    if (passwordRequested) {
                                        supervizor = UsersLogic.getInstance().requestAdminLogin(GuiUtils.currentFrame, true, true);
                                    }
                                    if (supervizor != null || !passwordRequested) {
                                        RezervariLogic.getInstance().stergeRezervare(cel.getIdCalendar(), supervizor, lcv, cel);
                                        ListaRezervariPanel.this.raport();
                                    } else {
                                        DialogUtils.errorDialog(GuiUtils.currentFrame, "Utilizator sau parola incorecte", LangRoAll.nuPotContinua);
                                    }
                                }
                            }
                        });
                    }
                    popup.setInvoker(ListaRezervariPanel.this.table);
                    popup.show(e.getComponent(), e.getX(), e.getY());
                } else if (columnIndex >= 4 && columnIndex < columns.length - 1 && (modifiers & 0x10) > 0) {
                    System.out.println("Mouse pressed drag rowIndex: " + selRow + " columnIndex: " + columnIndex);
                    this.dragStartRow = selRow;
                    this.dragStartColumn = columnIndex;
                    this.dragging = true;
                    ListaCamereView lcv = (ListaCamereView)ListaRezervariPanel.this.data.elementAt(selRow);
                    Vector<ListaCamereCell> datas = lcv.getData();
                    ListaCamereCell cel = datas.get(columnIndex - 4);
                    this.dragStartLCV = lcv;
                    this.dragStartLCC = cel;
                    Column column = (Column)ListaRezervariPanel.this.intervals.get(columnIndex - 4);
                    this.dragStartDate = column.getStart();
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                Point p;
                JTable t = (JTable)e.getSource();
                int selRow = t.rowAtPoint(p = e.getPoint());
                if (selRow == -1) {
                    return;
                }
                int columnIndex = t.columnAtPoint(p);
                int modifiers = e.getModifiers();
                if (columnIndex >= 4 && columnIndex < columns.length - 1 && (modifiers & 0x10) > 0) {
                    System.out.println("Mouse released drop rowIndex: " + selRow + " columnIndex: " + columnIndex);
                    if (this.dragging) {
                        ListaCamereView lcv = (ListaCamereView)ListaRezervariPanel.this.data.elementAt(selRow);
                        Vector<ListaCamereCell> datas = lcv.getData();
                        ListaCamereCell cel = datas.get(columnIndex - 4);
                        this.dragStopLCV = lcv;
                        this.dragStopLCC = cel;
                        Column column = (Column)ListaRezervariPanel.this.intervals.get(columnIndex - 4);
                        this.dragStopDate = column.getStop();
                        ListaRezervariPanel.this.dragAndDrop(this.dragStartLCC, this.dragStartLCV, this.dragStopLCC, this.dragStopLCV, this.dragStartDate, this.dragStopDate);
                        this.dragging = false;
                        this.dragStartLCC = null;
                        this.dragStartLCV = null;
                        this.dragStopLCC = null;
                        this.dragStopLCV = null;
                        this.dragStartDate = null;
                        this.dragStopDate = null;
                    }
                }
            }
        });
    }

    private void dragAndDrop(ListaCamereCell startDragLCC, ListaCamereView startDragLCV, ListaCamereCell stopDragLCC, ListaCamereView stopDragLCV, Date start, Date stop) {
        if (startDragLCV == stopDragLCV && startDragLCC.getStatus() == 1) {
            Vector<ListaCamereView> selection = new Vector<ListaCamereView>();
            selection.add(startDragLCV);
            this.addRezervation(selection, start, stop);
            return;
        }
        int idCalendar = startDragLCC.getIdCalendar();
        Vector<RezervariMeseView> mesePersoane = RezervariLogic.getInstance().getRezervariMeseViews(idCalendar);
        Vector<ListaCamereView> selection = new Vector<ListaCamereView>();
        Vector<Table> camere = RezervariLogic.getInstance().getCamere(selection);
        selection.add(stopDragLCV);
        switch (startDragLCC.getStatus()) {
            case 2: 
            case 3: {
                Timestamp newStart = new Timestamp(stop.getTime());
                newStart = new Timestamp(DateUtils.addDaysToDate(newStart, -1).getTime());
                Timestamp oldStop = startDragLCC.getStop();
                Timestamp oldStart = startDragLCC.getStart();
                Timestamp newStop = new Timestamp(newStart.getTime() + (oldStop.getTime() - oldStart.getTime()));
                String verifica = RezervariLogic.getInstance().verificaRezervari(camere, newStart, newStop, idCalendar, "<br><li>");
                if (verifica != null) {
                    DialogUtils.htmlOKDialog(this.parent, verifica, LangRoAll.nuPotContinua);
                    return;
                }
                RezervareBean info = startDragLCC.getInfo();
                RezervariLogic.getInstance().modificareRezervare(idCalendar, newStart, newStop, startDragLCC.getClient().getId(), startDragLCC.getIdProduct(), startDragLCC.getIdPromotion(), mesePersoane, false, -1, stopDragLCV.getIdCamera(), false, startDragLCC.getSex(), info.getIdOrder(), info.getIdAgentie(), info.getNumarPersoane(), info.getTarif(), info.getIdGrup(), info.getDetaliiRezervare(), info.getAvans());
                this.raport();
            }
        }
        switch (startDragLCC.getStatus()) {
            case 4: 
            case 5: {
                int i;
                ListaCamereCell firstStartLcc;
                if (startDragLCV != stopDragLCV) break;
                Vector<ListaCamereCell> startData = startDragLCV.getData();
                ListaCamereCell lastStartLcc = firstStartLcc = startData.get(0);
                for (i = 0; i < startData.size(); ++i) {
                    ListaCamereCell listaCamereCell = startData.elementAt(i);
                    if (listaCamereCell.getIdCalendar() != idCalendar) continue;
                    firstStartLcc = listaCamereCell;
                    break;
                }
                ListaCamereCell bk = null;
                while (i < startData.size()) {
                    ListaCamereCell listaCamereCell = startData.elementAt(i);
                    if (listaCamereCell.getIdCalendar() != idCalendar) {
                        lastStartLcc = bk;
                        break;
                    }
                    bk = listaCamereCell;
                    ++i;
                }
                if (lastStartLcc == startDragLCC) {
                    Timestamp t1 = lastStartLcc.getStop();
                    if (!t1.before(stop)) break;
                    Timestamp newStop = new Timestamp(stop.getTime() - 1L);
                    String verifica = RezervariLogic.getInstance().verificaRezervari(camere, startDragLCC.getStart(), newStop, idCalendar, "<br><li>");
                    if (verifica != null) {
                        DialogUtils.htmlOKDialog(this.parent, verifica, LangRoAll.nuPotContinua);
                        return;
                    }
                    RezervareBean info = startDragLCC.getInfo();
                    RezervariLogic.getInstance().modificareRezervare(idCalendar, startDragLCC.getStart(), newStop, startDragLCC.getClient().getId(), startDragLCC.getIdProduct(), startDragLCC.getIdPromotion(), mesePersoane, false, -1, stopDragLCV.getIdCamera(), false, startDragLCC.getSex(), info.getIdOrder(), info.getIdAgentie(), info.getNumarPersoane(), info.getTarif(), info.getIdGrup(), info.getDetaliiRezervare(), info.getAvans());
                    this.raport();
                    break;
                }
                System.out.println("drag nothing to do 2");
            }
        }
    }

    @Override
    public void doStuff() {
        Date d = new Date();
        Date d1 = DateUtils.setTimeToDate(d, 12, 0, 0, 0);
        d1 = DateUtils.addDaysToDate(d1, -3);
        Date d2 = DateUtils.addDaysToDate(d1, 14);
        this.dateSelector.setStartDate(d1);
        this.dateSelector.setStopDate(d2);
        this.dateSelector.selectPeriod();
        ComboUtils.replaceItemsForCombo(this.locatii, (Collection)this.logic.getLocations(2), true);
        ClientLogic clientLogic = ClientLogic.getInstance();
        clientLogic.addListener(new EventListener(){

            @Override
            public String getName() {
                return "FiltruMese_persJuridice";
            }

            @Override
            public void dataChanged() {
                ListaRezervariPanel.this.clientsComboModel.refresh(ClientLogic.getInstance().getAllClientsSorted());
            }
        }, 42);
        clientLogic.addListener(new EventListener(){

            @Override
            public String getName() {
                return "FiltruMese_persFizice";
            }

            @Override
            public void dataChanged() {
                ListaRezervariPanel.this.clientsComboModel.refresh(ClientLogic.getInstance().getAllClientsSorted());
            }
        }, 41);
        this.clientsComboModel.refresh(ClientLogic.getInstance().getAllClientsSorted());
        this.setFocusable(true);
        this.customParamsPanel.setFocusCycleRoot(true);
        this.status.addItem("All");
        this.status.addItem("Rezervari");
        this.status.addItem("Sosiri");
        this.status.addItem("Checkout");
        this.status.addItem("Cazari");
        this.status.addItem("Istoric");
        ComboUtils.replaceItemsForCombo(this.grup, RezervariLogic.getInstance().getAllActiveGroups());
        RezervariLogic.getInstance().addListener(new EventListener(){

            @Override
            public void dataChanged() {
                ComboUtils.replaceItemsForCombo(ListaRezervariPanel.this.grup, RezervariLogic.getInstance().getAllActiveGroups());
            }

            @Override
            public String getName() {
                return "ListaRezervari_groups";
            }
        }, 1101);
    }

    @Override
    public Comparator getComparatorForColumn(final int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return label_sorter;
            }
            case 1: {
                return defecta_sorter;
            }
            case 2: {
                return murdara_sorter;
            }
            case 3: {
                return ocupare_sorter;
            }
        }
        if (columnIndex == columns.length - 1) {
            return label_sorter;
        }
        return new Comparator(){

            public int compare(Object o1, Object o2) {
                ListaCamereView lcv1 = (ListaCamereView)o1;
                ListaCamereView lcv2 = (ListaCamereView)o2;
                ListaCamereCell lcc1 = lcv1.getData().get(columnIndex - 4);
                ListaCamereCell lcc2 = lcv2.getData().get(columnIndex - 4);
                return lcc1.getStatusString().compareToIgnoreCase(lcc2.getStatusString());
            }
        };
    }

    @Override
    public void cleanup() {
    }

    @Override
    public DateSelectorInterface getDateSelector() {
        return new PeriodOnlyNoTimeDateSelector();
    }
}

